echo off
cls
goto start
:usage
echo .=================================================================
echo .===== inc.bat -- Invoke InContext Work Environment Manager  =====
echo .=====                                                       =====
echo .===== usage:                                                =====
echo .=====        inc [ -nm ] [ -nd ] [ -u initials ] [ dir ]    =====
echo .=====                                                       =====
echo .===== where:                                                =====
echo .=====        -nm   ignore mouse driver                      =====
echo .=====        -nd   suppress full initial disk logging       =====
echo .=====        -u    select user by (three) initials          =====
echo .=====                 (requires prior setup)                =====
echo .=====        dir   InContext installation directory         =====
echo .=====                                                       =====
echo .===== examples:                                             =====
echo .=====        inc                                            =====
echo .=====        inc -nd c:\myplace                             =====
echo .=====        inc -u mar d:\incontxt                         =====
echo .=====                                                       =====
echo .=== Copyright 1991 Rams' Island Software All Rights Reserved ====
echo .== 1991 Rams' Island Software, 8 Grand Place, Newtown CT 06470 ==
echo .=================================================================
echo .
echo .
goto done

rem ----- Check arguments -------------------------------------------
:start
if %1. == help.      goto usage
if %1. == .          goto default
goto do_inc

rem ----- If invoked without arguments, verify default --------------
rem -----   installation (i.e., in c:\incontxt         --------------
:default
if not exist c:\incontxt\errmsg.dat goto nosuch

rem ===== Invoke InContext Work Environment Manager =================   
:do_inc
incontxt %1 %2 %3 %4

rem ----- Check returned error code ---------------------------------
if errorlevel 99 goto error99
if errorlevel 98 goto error98
if errorlevel 9 goto error9
if errorlevel 2 goto error2
if errorlevel 1 goto error1

rem ===== Handle "unload" to invoke application =====================   
rem =====                                                       =====
rem =====   InContext uses a simple batch file "trick" to allow =====
rem =====   it to completely unload itself before executing an  =====
rem =====   application.  This is rarely necessary, because     =====
rem =====   almost all applications can run "under" InContext.  =====
rem =====   When an application needs ALL available memory,     =====
rem =====   though, it can be invoked with a procedure that     =====
rem =====   includes an "!unload" command (see User Guide for   =====
rem =====   details).  When that is done, InContext will write  =====
rem =====   a batch file and then terminate.  The batch file    =====
rem =====   you're NOW reading detects the presence of that     =====
rem =====   other batch file, invokes it, and then re-invokes   =====
rem =====   InContext.                                          =====
rem =====                                                       =====
rem =====   If you don't use "unload", this batch file need not =====
rem =====   be changed.  If you use the default location for    =====
rem =====   the InContext installation directory (c:\incontxt)  =====
rem =====   and for the temporary batch file (c:\temp.bat) that =====
rem =====   InContext writes out, then this batch file should   =====
rem =====   execute an "unload" correctly.  Otherwise, you will =====
rem =====   need to make appropriate adjustments to the next    =====
rem =====   five lines (not counting "rem" comment lines).      =====

rem ----- The next three lines must correctly reference the  --------
rem ----- temporary batch file written by InContext.  The    --------
rem ----- pathname of that file is set in Misc Options Exec. --------
if not exist c:\temp.bat goto done
call c:\temp.bat
del c:\temp.bat

rem ----- The following two lines are necessary only if you do   ----
rem ----- not have the incontxt.exe executable in your DOS path. ----
rem ----- They are needed in order to restore the current        ----
rem ----- working directory to the location of that file so that ----
rem ----- it can be executed.                                    ----
c:
cd \incontxt
goto do_inc

rem ===== Error Displays ============================================   
:error1
echo .
echo .
echo .
echo Incontext was unable to continue because the swap file could not
echo be read upon return from a subprogram.  Press any key and InContext
echo will restart.
pause
goto do_inc

:error2
echo .
echo .
echo .
echo InContext was unable to continue because the swap file was deleted
echo while executing a sub-program.  Press any key and Incontext will
echo restart.
pause
goto do_inc

:error9
echo .
echo .
echo .
echo InContext was unable to continue because of an error in attempting
echo to read the swap file back from EMS memory after returning from a
echo subprogram.  You may be attempting to execute an ill-behaved EMS
echo program.  It is suggested that you select the InContext option that
echo disables its use of EMS memory for a swap file.  Press any key and
echo InContext will restart.
pause
goto do_inc

:error98
echo .
echo .
echo .
echo InContext has incurred a memory allocation error.  While this may be
echo caused by an internal program bug, it is much more likely that the
echo user has selected options which exceed the amount of memory available.
echo You may minimize memory usage by:
echo    (1) not attempting to use the internal editor on extremely large
echo        files.  Under "More Options Misc", set the "Limit editor to
echo        files under (Kbytes)" option to a reasonably small value.
echo        The internal editor is really intended only for use on relatively
echo        small files (up to perhaps 32-64K).
echo    (2) not logging all directories in all drives.  If you have many
echo        disk drives, or a single drive with a very large number of
echo        files and/or directories, you may need to use "Misc Options Disk"
echo        to log one or more drives only "As Needed".  You may also find it
echo        helpful to invoke InContext with the command "inc -nd", until you
echo        get your options set the way you want them.
echo .
echo If you wish to prevent InContext from restarting, press Control-Break
echo now.  Press any other key and InContext will restart.
pause
goto do_inc

:error99
echo .
echo .
echo .
echo InContext has incurred a fatal error.  The nature of the error is
echo displayed just above.  If you are unable to determine and correct
echo the cause of this error, please contact Rams' Island Software for
echo assistance.  If you wish to prevent InContext from restarting, press
echo Control-Break now.  Press any other key and InContext will restart.
pause
goto do_inc

:nosuch
echo .
echo .
echo .
echo You have invoked inc.bat with no arguments.  When inc.bat is used
echo with no arguments, it assumes that you have installed InContext in
echo the default directory (c:\incontxt).  However, inc.bat cannot find
echo an InContext installation in that directory.  Perhaps you have
echo chosen to install InContext in a different directory.  In that case,
echo you need to specify the directory on the command line.  For example,
echo if you installed the package in the directory D:\MYPLACE, you should
echo invoke InContext with the command
echo      inc d:\myplace
echo .
echo If, after reading this message, you still can't see how to proceed,
echo it is suggested that you read the "Quick Start" section of the User
echo Guide, in the file INCONTXT.DOC.
echo .
echo .
echo .
goto done

rem ===== Exit to DOS ===============================================   
:done
