{ INICVT.PAS - Convert from old to new SURFMODL INI file format. }
program INICVT;

{$I DEFINES.INC}
{$M 5000, 0, 0}     { Leave memory for EXEC call }

uses dos,
     crt,
     SHAREDEC,
     SURFGRAF;

{ Global variables }
var   Filemask: text80;                    { mask for naming data files }
      Inifile: text80;                     { name of INI file }
      Xeye, Yeye, Zeye: real;              { coords of eye }
      Xfocal, Yfocal, Zfocal: real;        { coords of focal point }
      Magnify: real;                       { magnification factor }
      Viewtype: integer;                   { code for viewing type: }
                                           { 0=perspective, 1=XY, 2=XZ, 3=YZ }
      XYadjust: real;                      { factor for screen width }
      Fileread: boolean;                   { flag first file read }
      Nmatl: integer;                      { number of materials }
      Nsurf: word;                         { # surfaces }
      Nnodes: word;                        { # nodes }
      Nlite: integer;                      { # light sources }
      Interpolate: boolean;                { flag for Gouraud interpolation }
      Epsilon: real;                       { Gouraud interpolation range }
      Shadowing: boolean;                  { flag shadowing option }
      Showaxes: integer;                   { code to show (0) no axes; (1) }
                                           { axis directions; (2) full axes }
      Xaxislen,Yaxislen,Zaxislen: real;    { lengths of axes }
      Axiscolor: integer;                  { color to draw axes }
      Nwindow: integer;                    { # graphics windows on screen }
      ShowAllBorders: integer;             { code to (1) show surface borders}
                                           { in shaded plots or (0) not }
      Ini_ok: boolean;                     { was the INI file OK? }
      Lastplot: integer;
      R1, R2, R3: array[1..MAXMATL] of real;
        { material reflectivity constants }
      Color: array[1..MAXMATL] of integer;
        { material color number }
      Ambient: array[1..MAXMATL] of real;
        { ambient light intensity for each material }
      Xlite, Ylite, Zlite: array[1..MAXLITE] of real;
        { coords of light sources }
      Intensity: array[1..MAXLITE] of real;
        { light source intensities }

{$define INICVT}
{$I INITIAL.INC}
{$I CHKCMMD.INC}
{$I INREAL.INC}
{$I READINI.INC}
{$I WRITECFG.INC}

{ CVTINI: This procedure does the actual conversion.  Since the old and
  new file names are really the same, we will copy the old file.INI
  to file.OLD and then create the new one as file.INI.
}
procedure CVTINI (Datafile: string);
var Oldini: text80;       { file.OLD }
    Cmmd: text80;         { command to system }

begin

  { First we read the old INI file, and store in global vbls. }
  readini (Datafile);

  if (not Ini_ok) then begin
    writeln ('ERROR reading ', Inifile);
    exit;
  end;

  { Copy file.INI to file.OLD.
    Invoke a secondary command processor to use the DOS COPY command:
  }
  Oldini := Filemask + '.OLD';
  Cmmd := '/C COPY ' + Inifile + ' ' + Oldini;
  exec ( getenv ('COMSPEC'), Cmmd);

  writecfg;

  writeln ('Conversion successful.');
  writeln (Inifile, ' has been modified.');
  writeln ('The old copy is now stored in ', Filemask, '.OLD');

end; { CVTINI }

begin { main }

  { Process cmmd-line parms }
  if (Paramcount <> 1) then begin
    writeln ('usage: INICVT filename');
    writeln ('  where filename is the name of the old .INI file to convert.');
    writeln ('INICVT will convert a .INI file from the old SURFMODL format');
    writeln ('to the new format (symbolic commands).');
    halt(1);
  end;

  Ini_ok := TRUE;
  initial;

  cvtini (Paramstr(1));

end. { main }
