procedure BORDER (Surf: word; Mat: integer);

{ Draw the border of surface #Surf in color Color }
var Vert:   integer;                 { vertex # being plotted }
    Node1:  word;                    { first node of line }
    Node2:  word;                    { second node of line }
    Color1, Color2: integer;         { 2 colors that bracket the shade }
    Shade:  real;

begin
{$ifdef BIGMEM}
with ptrd^ do with ptre^ do with ptrh^ do with ptri^ do
begin
{$endif}
  Shade := 1.0;
  findcolors (Mat, Color[Mat], Shade, Color1, Color2);
  for Vert := 1 to Nvert[Surf]-1 do begin
    Node1 := Konnec (Surf, Vert);
    Node2 := Konnec (Surf, Vert+1);
    gdraw (round(Xtran[Node1]), round(Ytran[Node1]),
          round(Xtran[Node2]), round(Ytran[Node2]), Color1);
  end;

  { One last draw to close the polygon }
  Node1 := Konnec (Surf, Nvert[Surf]);
  Node2 := Konnec (Surf, 1);
  gdraw (round(Xtran[Node1]), round(Ytran[Node1]),
        round(Xtran[Node2]), round(Ytran[Node2]), Color1);
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure BORDER }
