{ Memory allocation functions for SURFMODL }

{$ifdef BIGMEM}

function ALLOC_NODES: boolean;
{ Allocate sufficient memory for Nnodes nodes, return TRUE if OK or
  FALSE if out of memory.
}

begin

  ALLOC_NODES := TRUE;
  if (Nnodes > MAXNODES) then begin
    { Not enough memory, get more.  First free up the old arrays if they
      were already allocated.
    }
    if (MAXNODES > 0) then begin
      freemem (ptra, MAXNODES * sizeof(real));
      freemem (ptrb, MAXNODES * sizeof(real));
      freemem (ptrc, MAXNODES * sizeof(real));
      freemem (ptrd, MAXNODES * sizeof(real));
      freemem (ptre, MAXNODES * sizeof(real));
      freemem (ptrf, MAXNODES * sizeof(real));
      freemem (ptrj, MAXNODES * sizeof(real));
      freemem (ptrl, MAXNODES * sizeof(integer));
    end;

    { KVC 11/09/91 No longer need to check for available memory before
      the getmem() call, since HeapErrorTrap now stops the Error 203's.
    }
    getmem (ptra, Nnodes * sizeof(real));
    getmem (ptrb, Nnodes * sizeof(real));
    getmem (ptrc, Nnodes * sizeof(real));
    getmem (ptrd, Nnodes * sizeof(real));
    getmem (ptre, Nnodes * sizeof(real));
    getmem (ptrf, Nnodes * sizeof(real));
    getmem (ptrj, Nnodes * sizeof(real));
    getmem (ptrl, Nnodes * sizeof(integer));

    if (ptra = NIL) or (ptrb = NIL) or (ptrc = NIL) or (ptrd = NIL) or
       (ptre = NIL) or (ptrf = NIL) or (ptrj = NIL) or (ptrl = NIL) then begin
      { Error - out of memory }
      ALLOC_NODES := FALSE;
      MAXNODES := 0;
      if (ptra <> NIL) then
        freemem (ptra, Nnodes * sizeof(real));
      if (ptrb <> NIL) then
        freemem (ptrb, Nnodes * sizeof(real));
      if (ptrc <> NIL) then
        freemem (ptrc, Nnodes * sizeof(real));
      if (ptrd <> NIL) then
        freemem (ptrd, Nnodes * sizeof(real));
      if (ptre <> NIL) then
        freemem (ptre, Nnodes * sizeof(real));
      if (ptrf <> NIL) then
        freemem (ptrf, Nnodes * sizeof(real));
      if (ptrj <> NIL) then
        freemem (ptrj, Nnodes * sizeof(real));
      if (ptrl <> NIL) then
        freemem (ptrl, Nnodes * sizeof(integer));
    end else
      MAXNODES := Nnodes;
  end; { if Nnodes > MAXNODES }
end; { function ALLOC_NODES }


function ALLOC_SURFS: boolean;
{ Allocate sufficient memory for Nsurf surfaces, return TRUE if OK or
  FALSE if out of memory.
}

begin

  ALLOC_SURFS := TRUE;
  if (Nsurf > MAXSURF) or (Nsurf * Maxvert > MAXCONNECT) then begin
    { Not enough memory, get more.  First free up the old arrays if they
      were already allocated.
    }
    if (MAXCONNECT > 0) then
      freemem (ptrg, MAXCONNECT * sizeof(integer));
    if (MAXSURF > 0) then begin
      freemem (ptrh, MAXSURF * sizeof(integer));
      freemem (ptri, MAXSURF * sizeof(integer));
      freemem (ptrk, MAXSURF * sizeof(real));
      freemem (ptrm, MAXSURF * sizeof(real));
      freemem (ptrn, MAXSURF * sizeof(real));
    end;

    getmem (ptrg, Nsurf * Maxvert * sizeof(integer));
    getmem (ptrh, Nsurf * sizeof(integer));
    getmem (ptri, Nsurf * sizeof(integer));
    getmem (ptrk, Nsurf * sizeof(real));
    getmem (ptrm, Nsurf * sizeof(real));
    getmem (ptrn, Nsurf * sizeof(real));

    if (ptrg = NIL) or (ptrh = NIL) or (ptri = NIL) or (ptrk = NIL) or
       (ptrm = NIL) or (ptrn = NIL) then begin
      { Error - out of memory }
      ALLOC_SURFS := FALSE;
      MAXSURF := 0;
      MAXCONNECT := 0;
      if (ptrg <> NIL) then
        freemem (ptrg, Nsurf * Maxvert * sizeof(integer));
      if (ptrh <> NIL) then
        freemem (ptrh, Nsurf * sizeof(integer));
      if (ptri <> NIL) then
        freemem (ptri, Nsurf * sizeof(integer));
      if (ptrk <> NIL) then
        freemem (ptrk, Nsurf * sizeof(real));
      if (ptrm <> NIL) then
        freemem (ptrm, Nsurf * sizeof(real));
      if (ptrn <> NIL) then
        freemem (ptrn, Nsurf * sizeof(real));
    end else begin
      MAXSURF := Nsurf;
      MAXCONNECT := Nsurf * Maxvert;
    end;
  end; { if Nsurf > MAXSURF... }
end; { function ALLOC_SURFS }

{$endif} { BIGMEM }
