#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>

#include "allegro.h"
#include "midifile.h"
#include "lmuse.h"

/* extern lmuse.c*/
extern long trackcumtime[];
extern long trackprevcumtime[];
extern unsigned char trackflags[];
extern MIDINOTELIST * tracklist[];
extern MIDINOTELIST * tracklastnode[];
extern MIDINOTELIST * tracknextnode[];

extern unsigned char trackchannel[];

extern long maxcumtime;
extern long tempo;
extern char playrulefilename[];
extern BITMAP * pointup;

int dump_screen();
MIDINOTELIST * findmynoteoff(MIDINOTELIST * me,long * dur);

int do_stopmidifile();
int showprocessstatus(char *message);
void timertempo(long tempo);

extern volatile long int_t1;


/*-----------------------*/
MIDINOTELIST *next_node;

long next_event_time;

int next_track;
void set_patch(int channel, int prog)
{
   unsigned char msg[2] = { PRG_CHG+channel, prog };
   midi_out(msg, 2);
}

void set_pan(int channel, int pan)
{
   unsigned char msg[3] = { CNTRL_CHG+channel, 10, pan };
   midi_out(msg, 3);
}

void send_note_on(int channel, int pitch, int vel)
{
   unsigned char msg[3] = { NOTEON+channel, pitch, vel };
   midi_out(msg, 3);
}

void send_note_off(int channel, int pitch)
{
   unsigned char msg[3] = { NOTEOFF+channel, pitch, 0 };
   midi_out(msg, 3);
}

void all_notes_off(int channel){
   unsigned char msg[3]={0xB0+channel,123,0};
   midi_out(msg,3);
}

void play_chan_event(MIDICHANEVENT e){

     unsigned char stat=e.status&0xF0;
     unsigned char channel=e.status&0x0F;
     unsigned char data1=e.data1;
     unsigned char data2=e.data2;

     if (stat==NOTEON){
                 send_note_on(channel, data1, data2);

     }
     else if (stat==NOTEOFF)
                 send_note_off(channel, data1);
     else if(stat==PRG_CHG)
                   set_patch(channel,data1);

}
long lasttimertime;
long timertime;
long pausetime;

void init_trackplay(){
        int tracknumber;
        long testtime;

        for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++)
            all_notes_off(trackchannel[tracknumber]);

        for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
            if(trackflags[tracknumber]&ACTIVE){
               if(tracklist[tracknumber]==NULL)
                    trackflags[tracknumber]&=~ACTIVE;
               else
                    tracknextnode[tracknumber]=tracklist[tracknumber];
               trackcumtime[tracknumber]=0L;
               trackprevcumtime[tracknumber]=0L;

               set_pan(trackchannel[tracknumber],67);
            }
        }

        /*find the first event to play*/
        for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
          if(trackflags[tracknumber]&ACTIVE){
        
               next_event_time=tracklist[tracknumber]->m.t;/*just say track 0, event 1 comes first*/
               next_track=tracknumber;
               break;
           }
        }

        next_node=tracknextnode[next_track];
        /*then look at each track to find an event even earlier*/
        for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
          if(trackflags[tracknumber]&ACTIVE){
              testtime=tracknextnode[tracknumber]->m.t;
              if (testtime < next_event_time){
                 next_event_time=testtime;
                 next_track=tracknumber;
                 next_node=tracknextnode[next_track];
              }
          }
        }

        int_t1=0L;


        next_event_time=next_node->m.t;
}


char tbuf[32];
int track_proc(int msg,DIALOG *d, int c);
int savemidi_proc(int msg, DIALOG *d, int c);
int playbutton_proc(int msg,DIALOG *d, int c);
int pausebutton_proc(int msg,DIALOG *d, int c);
int playhelpbutton_proc(int msg, DIALOG *d, int c);
int playdialogsettempo(void *dp3, int d2);

int metro_proc(int msg,DIALOG *d, int c);
int dummy_proc(int msg,DIALOG *d, int c);
#define TRACKTLX 20
#define TRACKTLY 100
#define TRACKBRX 640-TRACKTLX
#define TRACKBRY TRACKTLY+256


/*   (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)   (key) (flags)  (d1)  (d2)  (dp) */
DIALOG play_dialog[] =
{

   { d_shadow_box_proc, 0,    0,   639,  479,  255,  PLAYBG,  0,    0,      0,   0,    NULL},


   /* tempo */
   { d_text_proc,       400,  40,   30,   10,   255,  PLAYBG, 0,    0,      0,   0,    tbuf },
   { d_slider_proc,     220,  20,   200,  15,   255,  PLAYBG,'t',  0,      400,  0,   NULL, playdialogsettempo},
   { d_text_proc,       290,  5,   20,   30,   255,  PLAYBG, 0,    0,      0,   0,    "&Tempo" },
   /* track box */
   { track_proc,TRACKTLX,TRACKTLY,TRACKBRX-TRACKTLX,TRACKBRY-TRACKTLY,0, TRACKBG, 0,    0,0,    0,    NULL },
   { metro_proc,TRACKTLX,TRACKBRY,TRACKBRX-TRACKTLX,8,0, 255, 0,    0,0,    0,    NULL },
   /* buttons */
   { savemidi_proc,     20,    430,  80,  18,  255,  0,    's',     D_EXIT, 0,    0,    "&Save Midi" },
   { playbutton_proc,   180,   430,  50,   18,  255,  0,    'p',     D_EXIT, 0,    0,    "&Play" },
   { pausebutton_proc,  240,   430,  50,   18,  255,  0,    'u',     0,      0,    0,    "Pa&use" },
   { playhelpbutton_proc,   550,   430,  50,   18,  255,  0,    'h',     D_EXIT, 0,    0,    "&Help"},
   { d_button_proc,     300,   430,  50,   18,  255,  0,    'n',     D_EXIT, 0,    0,    "&New" },
   { d_button_proc,     420,   430,  50,   18,  255,  0,    'x',     D_EXIT, 0,    0,    "E&xit" },
#if defined (SCREENDUMPS)
   {d_keyboard_proc,    0,     0,    0,    0,    0,   0,   'd'-'a'+1,0,      0,    0,    dump_screen},
#endif
   { d_text_proc,       540,    5,    100,  10,  255,  PLAYBG,0,      0,      0,    0,    playrulefilename },
   { NULL,               0,     0,    0,    0,   0,    0,    0,      0,      0,    0,    NULL }
};

#define PLAYMETRO 5
#define PLAYDGTEMPOSLIDER  2
#define PLAYDGTEMPOTEXT  1
#define PLAYPAUSEBUTTON 8

int newtime;
inline int timetox(long t){
    return (TRACKTLX+(TRACKBRX-TRACKTLX)*t/maxcumtime);

}
int metro_proc(int msg,DIALOG *d, int c __attribute__ ((unused)) ){
    int mx,my,omx,omy;
    int timerx;
    int tracknumber;
    int cur_track;
    MIDINOTELIST *cur_node;
    long testtime;
    MIDICHANEVENT m;
    int status;
    switch(msg){
         case MSG_DRAW:
              rectfill(screen, d->x, d->y, d->x+d->w, d->y+d->h, d->bg);


             break;
         case MSG_GOTMOUSE:
              set_mouse_sprite(pointup);
              break;
         case MSG_LOSTMOUSE:
              set_mouse_sprite(NULL);
              break;

         case MSG_IDLE:
             if(newtime){
               show_mouse(NULL);
               if(next_node==NULL|| (timertime>maxcumtime)){
                   if(lasttimertime<maxcumtime)
                       line(screen,timetox(lasttimertime),d->y,timetox(lasttimertime),d->y+d->h,d->bg);
                   line(screen,timetox(maxcumtime),d->y,timetox(maxcumtime),d->y+d->h,d->fg);
               
               }
               else{

                   line(screen,timetox(lasttimertime),d->y,timetox(lasttimertime),d->y+d->h,d->bg);
                   line(screen,timetox(timertime),d->y,timetox(timertime),d->y+d->h,d->fg);

               }
               show_mouse(screen);
               lasttimertime=timertime;
               newtime=0;
             }
             break;
         case MSG_CLICK:
              mx=mouse_x;my=mouse_y;
              omx=mx;omy=my;
              timerx=timetox(lasttimertime);

              show_mouse(NULL);
              line(screen,timerx,d->y,timerx,d->y+d->h,d->bg);
              show_mouse(screen);

              for (tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
                      all_notes_off(trackchannel[tracknumber]);
              }
              while(mouse_b&1){
                      mx=mouse_x;my=mouse_y;
                      if((omx!=mx || omy!=my)&&(mx<=TRACKBRX&&mx>=TRACKTLX) ){
                          show_mouse(NULL);
                          if(omx<=TRACKBRX&&omx>=TRACKTLX)
                                line(screen,omx,d->y,omx,d->y+d->h,d->bg);
                          line(screen,mx,d->y,mx,d->y+d->h,d->fg);
               
                          show_mouse(screen);
                      }
                      omx=mx;omy=my;

               }
               if(my>TRACKTLY&&my<TRACKBRY+40){
                         timertime=(mx-TRACKTLX)*maxcumtime/(TRACKBRX-TRACKTLX);
                         if(timertime<=0){
                                init_trackplay();
                                timertime=0;
                                lasttimertime=timertime;
                                return D_O_K;
                         }
                         if(timertime<next_event_time){
                             init_trackplay();
                         }
                         while(timertime>=next_event_time&&next_node!=NULL){
                               cur_track=next_track;
                               cur_node=next_node;

                               m=cur_node->m;

                               status=(m.status& 0xF0);//|trackchannel[cur_track];
                               if(status==PRG_CHG)
                                     play_chan_event(m);

                               trackcumtime[cur_track]+=m.t;
                               tracknextnode[cur_track]=cur_node->next;

                               /* just say next event is next one on the current track...*/
                               next_node=cur_node->next;
                               if(next_node!=NULL){

                                  next_event_time=trackcumtime[cur_track]+next_node->m.t;
                                  next_track=cur_track;
                               }
                               /*... then look for one that should come earlier*/
                               for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
                                   if(trackflags[tracknumber]&ACTIVE && tracknextnode[tracknumber]!=NULL){
                                       if(tracknumber!=cur_track){
                                          testtime=tracknextnode[tracknumber]->m.t+trackcumtime[tracknumber] ;
                                          if (testtime<next_event_time || next_node==NULL){
                                             next_event_time=testtime;
                                             next_track=tracknumber;
                                             next_node=tracknextnode[tracknumber];
                                          }
                                       }
                                   }
                               }

                         }

               }

               lasttimertime=timertime;
               pausetime=timertime;
               newtime=1;
               show_mouse(NULL);
               rectfill(screen, d->x, d->y, d->x+d->w, d->y+d->h, d->bg);
               show_mouse(screen);
               int_t1=timertime;

               break;

    }
    return D_O_K;
}
int dummy_proc(int msg,DIALOG *d, int c){
        if(msg==MSG_DRAW){

             return D_O_K;
        }
        return(d_box_proc(msg,d,c));


}


int playpaused=0;


int playbutton_proc(int msg,DIALOG *d, int c){
    int ret;
    ret=d_button_proc(msg,d,c);
    if(ret==D_CLOSE){
            init_trackplay();
            playpaused=0;
            newtime=1;
            play_dialog[PLAYPAUSEBUTTON].flags&=~D_SELECTED;
            pausebutton_proc(MSG_DRAW,&play_dialog[PLAYPAUSEBUTTON],0);

            return D_O_K;
    }

    return ret;

}
int pausebutton_proc(int msg,DIALOG *d, int c){
    int ret,tracknumber;

    if(msg==MSG_CLICK||msg==MSG_KEY){
            if(playpaused){
                  playpaused=0;
                  int_t1=pausetime;
            }
            else{
                 pausetime=int_t1;
                 playpaused=1;
                 for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
                    all_notes_off(trackchannel[tracknumber]);
                 }
            }
    }
    if(msg==MSG_START)
         d->flags &= ~D_SELECTED;
    ret=d_button_proc(msg,d,c);
    return ret;

}

int track_proc(int msg,DIALOG *d, int c __attribute ((unused))){
   int tracknumber;
   long testtime;
   long cumtime;
   long mydur;
   int cur_track;
   int cur_color=0;
   DIALOG *dmetro=&play_dialog[PLAYMETRO];
   MIDINOTELIST *cur_node,*mynoteoff;
   MIDICHANEVENT m;


   switch (msg) {
      case MSG_START:

           init_trackplay();
           lasttimertime=0L;
           newtime=1;
           playpaused=0;

           play_dialog[PLAYDGTEMPOSLIDER].d2=tempo-10;
           itoa(tempo,tbuf,10);
           for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++)
                    set_patch(trackchannel[tracknumber],0);
           set_mouse_sprite(NULL);
           break;
      case MSG_END:
           for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
                all_notes_off(trackchannel[tracknumber]);
           }
           set_mouse_sprite(NULL);
           showprocessstatus("");
           break;
      case MSG_IDLE:
           {
                if(next_node==NULL){

                          return D_O_K;
                }
                if(playpaused) return D_O_K;
                timertime=int_t1;
                if(timertime>=next_event_time){
                  cur_track=next_track;
                  cur_node=next_node;

                  m=cur_node->m;

                  m.status=(m.status& 0xF0)|trackchannel[cur_track];


                  play_chan_event(m);

                  trackcumtime[cur_track]+=m.t;
                  tracknextnode[cur_track]=cur_node->next;

                  /* just say next event is next one on the current track...*/
                  next_node=cur_node->next;
                  if(next_node!=NULL)
                      next_event_time=trackcumtime[cur_track]+next_node->m.t;
                  else next_event_time=maxcumtime;
                  next_track=cur_track;
                  /*... then look for one that should come earlier*/
                  for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
                    if(trackflags[tracknumber]&ACTIVE && tracknextnode[tracknumber]!=NULL){
                       if(tracknumber!=cur_track){
                           testtime=tracknextnode[tracknumber]->m.t+trackcumtime[tracknumber] ;
                           if (testtime<next_event_time || next_node==NULL){
                             next_event_time=testtime;
                             next_track=tracknumber;
                             next_node=tracknextnode[tracknumber];
                           }
                       }
                    }
                  }
                  newtime=1;
                }

           }

           break;
      case MSG_DRAW:
           rect(screen,TRACKTLX-2,TRACKTLY-2,TRACKBRX+2,TRACKBRY+dmetro->h+2,2);
           rectfill(screen,TRACKTLX,TRACKTLY,TRACKBRX,TRACKBRY,d->bg);
           for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
                cur_node=tracklist[tracknumber];
                cumtime=0L;
                while(cur_node!=NULL){
                     m=cur_node->m;
                     cumtime += m.t;
                     if( (m.status&0xF0)==NOTEON){
                        mynoteoff=findmynoteoff(cur_node,&mydur);
                        if(mynoteoff==NULL)
                           putpixel(screen,TRACKTLX+(TRACKBRX-TRACKTLX)*cumtime/maxcumtime,TRACKBRY-2*m.data1,cur_color);
                        else
                           line(screen,TRACKTLX+(TRACKBRX-TRACKTLX)*cumtime/maxcumtime,TRACKBRY-2*m.data1,TRACKTLX+(TRACKBRX-TRACKTLX)*(cumtime+mydur)/maxcumtime,TRACKBRY-2*m.data1,cur_color);
                     }
                     else if( (m.status&0xF0)==PRG_CHG){
                         cur_color=m.data1;
                         if(cur_color>=d->bg)
                            cur_color++;

                     }
                     cur_node=cur_node->next;
                }
           }
           break;
      case MSG_CLICK:

           break;
   }

   return D_O_K;
}



int playdialogsettempo(void *dp3 __attribute__ ((unused)), int d2){
        long holdtimer=int_t1;
        DIALOG * dtext=&play_dialog[PLAYDGTEMPOTEXT];
        play_dialog[PLAYDGTEMPOSLIDER].d2=tempo-10;
        tempo=(long)d2+10;
        itoa(tempo,tbuf,10);


        timertempo(tempo);
        show_mouse(NULL);
        rectfill(screen,dtext->x,dtext->y, dtext->x + dtext->w,dtext->y + dtext->h,dtext->bg);

        d_text_proc(MSG_DRAW,dtext,0);
        show_mouse(screen);
        int_t1=holdtimer;

        return D_O_K;
}

