;RM82TS8,16,24,32,40,4810/21/90
; 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.model medium, BASIC
.code

;============================================================================
; DECLARE SUB VIDINFO (MODE%, ROW%, COLUMN%, CURPAGE%, PAGESIZE%)
; CALL VIDINFO(MODE%, ROW%, COLUMN%, CURPAGE%, PAGESIZE%)
; Purpose:
;       Returns information about current video display status.
;       Mode%     = current video mode using BIOS format
;       Row%      = number of rows currently being displayed
;       Cols%     = width of display in columns
;       Curpage%  = currently active page
;       Pagesize% = size of current page in bytes, default is 4kb
;                   for an 80 * 25 display.
; Note:
;       PAGESIZE% on many HERC clones will be incorrect and reflect the
; information of the HERC display in HALF mode or 16kb size.
; Routine will store correct Row% length in BIOS ram for CGA, HERC & MONO
;============================================================================

EVEN
VIDINFO Proc FAR BASIC  \
MODE:Ptr, ROW:Ptr, COLUMN:Ptr, CURPAGE:Ptr, PAGESIZE:Ptr

	Xor     AX,AX                   ; clear AX
	Mov     ES,AX                   ; set ES to BIOS ram
	Mov     BX,MODE                 ; get address of Mode
	Mov     AL,Byte Ptr ES:[0449h]  ; read MODE from BIOS ram
	Mov     [BX],AX                 ; store value
	Mov     BX,ROW                  ; get address of Row
	Xor     AH,AH                   ; clear high byte
	Mov     AL,Byte Ptr ES:[0484h]  ; read ROW from BIOS ram
	Or      AL,AL                   ; zero? (HERC, CGA & MONO give 0)
	JNZ     @f                      ; nope, so skip ahead (EGA or above)
	Mov     AX,24                   ; load default value - 1
	Mov     Byte Ptr ES:[0484h],AL  ; store it BIOS ram to save time next
					; time
@@:
	Inc     AX                      ; raise value to 1 biased number
	Mov     [BX],AX                 ; store value
	Mov     BX,COLUMN               ; get address of Column
	Mov     AX,ES:[044Ah]           ; read COLUMN from BIOS ram
	Mov     [BX],AX                 ; store value
	Mov     BX,CURPAGE              ; get address of Current Page
	Xor     AH,AH                   ; clear high byte
	Mov     AL,Byte Ptr ES:[0462h]  ; read CURPAGE from BIOS ram
	Mov     [BX],AX                 ; store result
	Mov     BX,PAGESIZE             ; get address of PAGESIZE
	Mov     AX,ES:[044Ch]           ; get size of video page
	Mov     [BX],AX                 ; store result
	RET                             ; MASM does cleanup
VIDINFO ENDP
END
