'=============== DATE/TIME FUNCTIONS ==========================================
DECLARE FUNCTION DayOfWeek% (AnyDate$) 'MM-DD-YYYY 1980-2107 0=su..6=sa
DECLARE FUNCTION DayStr$ (BYVAL WeekDay%) '0=Sunday ... 6=Saturday
DECLARE FUNCTION DayWeek% (BYVAL Mon%, BYVAL Day%, BYVAL Year%)
DECLARE FUNCTION EventDone% ()  'use this with the EventSet subroutine
DECLARE FUNCTION LongDate$ (Date2Byte$) 'ret MM-DD-YYYY (1980 to 2107)
DECLARE FUNCTION LongTime$(TwoByte$)
DECLARE FUNCTION MonthStr$ (BYVAL MonthVal%) '1=January ... 12=December
DECLARE FUNCTION SetDate% (BYVAL Mon%, BYVAL Day%, BYVAL Year%) '-1=err
DECLARE FUNCTION SetTime% (BYVAL Hrs%, BYVAL Min%, BYVAL Sec%, _
                           BYVAL HSec%) '-1=err  O=o.k.
DECLARE FUNCTION ShortDate$ (AnyDate$) 'in MM-DD-YYYY (1980 to 2107)
DECLARE FUNCTION ShortTime$ (Time24$)  'Time24$ in 00:00 to 23:59 form
DECLARE FUNCTION Snooze% (BYVAL TickVal%)
DECLARE FUNCTION TickTime$ (BYVAL TickVal&)
DECLARE FUNCTION TimerRead& (BYVAL TimerNumber%) 'O to 15
DECLARE FUNCTION TmrRd& (SEG Tmr&)
DECLARE FUNCTION Timr&()
DECLARE FUNCTION WeekDay% (Mon%, Day%, Year%) 'do NOT use BYVAL keyword

DECLARE SUB EventSet  (BYVAL Microseconds&)
DECLARE SUB EventWait (BYVAL Microseconds&)
DECLARE SUB GetDate (SEG Mon%, SEG Day%, SEG Year%, SEG DWeek%)
DECLARE SUB GetTime (SEG Hrs%, SEG Min%, SEG Sec%,  SEG HSec%)
DECLARE SUB Hibernate (BYVAL TickVal%)
DECLARE SUB TimerReset (BYVAL TimerNumber%) 'O to 15
DECLARE SUB TmrRst (SEG Tmr&)
'==============================================================================


'=============== DOS FILE (HANDLE-BASED) FUNCTIONS ============================
DECLARE FUNCTION DOSFAttr% (FileName$)
DECLARE FUNCTION DOSFPtr& (BYVAL Handle%)
DECLARE FUNCTION DOSFSize& (BYVAL Handle%)
DECLARE FUNCTION DOSRtnErr% ()

DECLARE SUB DOSClose (BYVAL Handle%)
DECLARE SUB DOSDel (FileName$)
DECLARE SUB DOSFAttrSet (FileName$, BYVAL AttributeByte%)
DECLARE SUB DOSFDateGet (BYVAL Handle%, SEG Mon%, SEG Day%, SEG Year%, _
                         SEG Hr%, SEG Min%, SEG Sec%)
DECLARE SUB DOSFDateSet (BYVAL Handle%, BYVAL Mon%, BYVAL Day%, BYVAL Year%, _
                         BYVAL Hr%, BYVAL Min%, BYVAL Sec%)
DECLARE SUB DOSFPtrMove (BYVAL Handle%, BYVAL PtrMovement&)
DECLARE SUB DOSFPtrSet (BYVAL Handle%, BYVAL NewPtr&)
DECLARE SUB DOSOpen (FileName$,BYVAL ReadWrite%,BYVAL InitPtr%,SEG Handle%)
DECLARE SUB DOSRdMem (BYVAL Handle%, BYVAL MSeg%, BYVAL MPtr%, BYVAL NBytes%) 
DECLARE SUB DOSRdStr (BYVAL Handle%, Text$, BYVAL NBytes%)
DECLARE SUB DOSRdVar (BYVAL Handle%, SEG TypeVar as Any, BYVAL NBytes%)
DECLARE SUB DOSWrtMem (BYVAL Handle%, BYVAL MSeg%, BYVAL MPtr%, BYVAL NBytes%) 
DECLARE SUB DOSWrtStr (BYVAL Handle%, Text$)
DECLARE SUB DOSWrtVar (BYVAL Handle%, SEG TypeVar as Any, BYVAL NBytes%)
'==============================================================================


'=============== FILE/DIRECTORY FUNCTIONS =====================================
DECLARE FUNCTION CurrentDir$ ()
DECLARE FUNCTION DirExist%  (FileName$)
DECLARE FUNCTION DriveDir$ (BYVAL Drive%) '0=current 1=A: 2=B: etc.
DECLARE FUNCTION FileExist% (FileName$)
DECLARE FUNCTION FindFile$ (BYVAL InitSrch%, Search$, BYVAL AttrMask%)
DECLARE FUNCTION StartUpDir$  ()
DECLARE FUNCTION StartUpExec$ ()

DECLARE SUB ChgDir (NewDir$)
DECLARE SUB FileToMem (BYVAL FileNum%, BYVAL MemSeg%, _
                       BYVAL MemAdr%,  BYVAL NumBytes%)
DECLARE SUB FileToVar (BYVAL FileNum%, SEG Var, BYVAL VarSize%)
DECLARE SUB FindFileS (BYVAL InitSrch%, Search$, BYVAL AttrMask%, _
                       SEG TypeVar as ANY)
 'DECLARE SUB FindFileS (BYVAL InitSrch%, Search$, BYVAL AttrMask%, _
 '                       BYVAL SegAdr%, BYVAL PtrAdr%)
 'alternate form puts 2O-byte string at segmented address SegAdr%:PtrAdr%
DECLARE SUB MemToFile (BYVAL FileNum%, BYVAL MemSeg%, _
                       BYVAL MemAdr%,  BYVAL NumBytes%)
DECLARE SUB VarToFile (BYVAL FileNum%, SEG Var, BYVAL VarSize%)
'==============================================================================



'=============== JOYSTICK FUNCTIONS ===========================================
DECLARE FUNCTION JoyStkAX% ()
DECLARE FUNCTION JoyStkAY% ()
DECLARE FUNCTION JoyStkAFire% ()
DECLARE FUNCTION JoyStkABase% ()
DECLARE FUNCTION JoyStkBX% ()
DECLARE FUNCTION JoyStkBY% ()
DECLARE FUNCTION JoyStkBFire% ()
DECLARE FUNCTION JoyStkBBase% ()
'==============================================================================



'=============== KEYBOARD FUNCTIONS ============================================
DECLARE FUNCTION CapsLock% ()
DECLARE FUNCTION GetKey% ()
DECLARE FUNCTION KeyAlt% ()
DECLARE FUNCTION KeyLAlt% ()
DECLARE FUNCTION KeyRAlt% ()
DECLARE FUNCTION KeyCtrl% ()
DECLARE FUNCTION KeyLCtrl% ()
DECLARE FUNCTION KeyRCtrl% ()
DECLARE FUNCTION KeyPending% ()
DECLARE FUNCTION KeyShift% ()
DECLARE FUNCTION KeyLShift% ()
DECLARE FUNCTION KeyRShift% ()
DECLARE FUNCTION NumLock% ()
DECLARE FUNCTION ScrollLock% ()
DECLARE FUNCTION WaitKey% ()

DECLARE SUB CapsLockOn  ()
DECLARE SUB CapsLockOff ()
DECLARE SUB NumLockOn  ()
DECLARE SUB NumLockOff ()
DECLARE SUB PressAnyKey ()
DECLARE SUB ScrollLockOn  ()
DECLARE SUB ScrollLockOff ()
DECLARE SUB SetTypematic ( BYVAL Rate%, BYVAL Delay% )
DECLARE SUB TypeAhead (Text$)
DECLARE SUB WaitSpecKey (BYVAL SpecKey%)
'==============================================================================



'=============== MEMORY FUNCTIONS =============================================
DECLARE FUNCTION BitGet% (BYVAL ArraySeg%, BYVAL Element%)
DECLARE FUNCTION DefSeg% ()
DECLARE FUNCTION EnvironSeg%()
DECLARE FUNCTION FindStrInMem%  (BYVAL MSeg%,BYVAL MPtr%, BYVAL NumBytes%,Txt$)
DECLARE FUNCTION FindStrInMem2% (BYVAL MSeg%,BYVAL MPtr1%,BYVAL MPtr2%,Txt$)
DECLARE FUNCTION GetMem% (BYVAL NumPara%)
DECLARE FUNCTION LowMem% (BYVAL MemAdr%)
DECLARE FUNCTION MemChkSum&(BYVAL MSeg%, BYVAL MPtr%, BYVAL NBytes%)
DECLARE FUNCTION MemCompare% (BYVAL Seg1%, BYVAL Adr1%, _
                              BYVAL Seg2%, BYVAL Adr2%, BYVAL Bytes%)
DECLARE FUNCTION PeekByte%  (BYVAL MemSeg%, BYVAL MemAdr%)
DECLARE FUNCTION PeekWord%  (BYVAL MemSeg%, BYVAL MemAdr%)
DECLARE FUNCTION PeekLong&  (BYVAL MemSeg%, BYVAL MemAdr%)
DECLARE FUNCTION PSPSeg%()
DECLARE FUNCTION ReadCMOS% (BYVAL CMOSAdr%)
DECLARE FUNCTION RelMem% (BYVAL SegAdr%) 'specify segment to release

DECLARE SUB BitSet (BYVAL ArraySeg%, BYVAL Element%, BYVAL Value%)
                                                    'where Value%=0 or 1
DECLARE SUB Encrypt (BYVAL MemSeg%, BYVAL MemPtr%, BYVAL NumBytes%, _
                     BYVAL XORByteVal%)
DECLARE SUB MemCCase (BYVAL MemSeg%, BYVAL MemPtr%, BYVAL NumBytes%)
DECLARE SUB MemCopy (BYVAL Seg1%, BYVAL Adr1%, _
                     BYVAL Seg2%, BYVAL Adr2%, BYVAL NBytes%)
'DECLARE SUB MemCopyB (BYVAL Seg1%, BYVAL Adr1%, _
'                      BYVAL Seg2%, BYVAL Adr2%, BYVAL NBytes%)
'            MemCopyB is an alternate name for MemCopy
DECLARE SUB MemCopyW (BYVAL Seg1%, BYVAL Adr1%, _
                      BYVAL Seg2%, BYVAL Adr2%, BYVAL NWords%)
DECLARE SUB MemCopyBtoW (BYVAL Seg1%, BYVAL Adr1%, _
                         BYVAL Seg2%, BYVAL Adr2%, _
                         BYVAL NBytes%, BYVAL Attribute%)
DECLARE SUB MemCopyWtoB (BYVAL Seg1%, BYVAL Adr1%, _
                         BYVAL Seg2%, BYVAL Adr2%, BYVAL NBytes%)
DECLARE SUB MemFillByte (BYVAL MemSeg%, BYVAL MemPtr%, _
                         BYVAL NumBytes%, BYVAL FillValue%)
DECLARE SUB MemFillWord (BYVAL MemSeg%, BYVAL MemPtr%, _
                         BYVAL NumWords%, BYVAL FillValue%)
DECLARE SUB MemLCase (BYVAL MemSeg%, BYVAL MemPtr%, BYVAL NumBytes%)
DECLARE SUB MemSwap (BYVAL Seg1%, BYVAL Adr1%, _
                     BYVAL Seg2%, BYVAL Adr2%, BYVAL Bytes%)
DECLARE SUB MemUCase (BYVAL MemSeg%, BYVAL MemPtr%, BYVAL NumBytes%)
DECLARE SUB MemXORByte (BYVAL MemSeg%, BYVAL MemPtr%, BYVAL NumBytes%, _
                        BYVAL XORByteVal%)
DECLARE SUB MemXORWord (BYVAL MemSeg%, BYVAL MemPtr%, BYVAL NumWords%, _
                        BYVAL XORWordVal%)
DECLARE SUB MinimizePtr( BYVAL OldSeg%, BYVAL OldPtr%, SEG NewSeg%, SEG NewPtr%)
DECLARE SUB PokeByte  (BYVAL MemSeg%, BYVAL MemAdr%, BYVAL Value%)
DECLARE SUB PokeWord  (BYVAL MemSeg%, BYVAL MemAdr%, BYVAL Value%)
DECLARE SUB PokeLong  (BYVAL MemSeg%, BYVAL MemAdr%, BYVAL Value&)
DECLARE SUB VarSegPtr (SEG Variable as ANY, SEG SegAdr%, SEG PtrAdr%)
DECLARE SUB WriteCMOS (BYVAL CMOSAdr%, BYVAL Value%) 'addr 0 to 9 only
'==============================================================================


'=============== MOUSE FUNCTIONS ==============================================
DECLARE FUNCTION MsBtn% ()
DECLARE FUNCTION MsCBtn% ()
DECLARE FUNCTION MsClickCount% (BYVAL WhichButton%)
DECLARE FUNCTION MsLBtn% ()
DECLARE FUNCTION MsRBtn% ()
DECLARE FUNCTION MsReset% ()
DECLARE FUNCTION MsWaitClick% (BYVAL ClickMask%)

DECLARE SUB MsGetCsrPos (BYVAL CsrType%, SEG Row%, SEG Column%)
DECLARE SUB MsGetSensPct (SEG XMicks%, SEG YMicks%, SEG DblSpdMicks%)
DECLARE SUB MsGrPtrShape (BYVAL HotSptLeft%, BYVAL HotSptTop%, _
                          BYVAL SegPtrBfr% , BYVAL OfsPtrBfr%)
DECLARE SUB MsHide ()
DECLARE SUB MsSetCsrPos (BYVAL CsrType%, BYVAL Row%, BYVAL Column%)
DECLARE SUB MsSetLimit (BYVAL CsrType%,BYVAL MinRow%, BYVAL MinColumn%,_
                                       BYVAL MaxRow%, BYVAL MaxColumn%)
DECLARE SUB MsSetSens (BYVAL XMicks%, BYVAL YMicks%, BYVAL DblSpdMicks%)
DECLARE SUB MsSetSensPct (BYVAL XMicks%, BYVAL YMicks%, BYVAL DblSpdMicks%)
DECLARE SUB MsShow ()
DECLARE SUB MsTxtPtrType (BYVAL SHPtr%, BYVAL ANDMask%, BYVAL XORMask%)
'==============================================================================



'=============== NUMERIC FUNCTIONS ============================================
DECLARE FUNCTION BCDtoDEC% (BYVAL BCDVal%)
DECLARE FUNCTION Caps% (BYVAL AsciiValue%)
DECLARE FUNCTION ChgBit% (BYVAL Value%, BYVAL BitPos%, BYVAL Oper%)
DECLARE FUNCTION DECtoBCD% (BYVAL DECVal%)
DECLARE FUNCTION HighWord% (BYVAL LongInt& )
DECLARE FUNCTION InBox% (BYVAL Row%,  BYVAL Column%, _
                         BYVAL Row1%, BYVAL Column1%,_
                         BYVAL Row2%, BYVAL Column2%)
DECLARE FUNCTION InRange% (BYVAL Test%, BYVAL LowVal%, BYVAL HighVal%)
DECLARE FUNCTION Larger%  (BYVAL Value1%, BYVAL Value2%)
DECLARE FUNCTION LargerL& (BYVAL Value1&, BYVAL Value2&)
DECLARE FUNCTION LowWord%  (BYVAL LongInt& )
DECLARE FUNCTION NoCaps% (BYVAL AsciiValue%)
DECLARE FUNCTION PowerOf2% (BYVAL Power%)  'Power%=0 to 15
DECLARE FUNCTION RandNum% (BYVAL MaxNum%)
DECLARE FUNCTION ShiftLeft%  (BYVAL Value%, BYVAL NumBits%)
DECLARE FUNCTION ShiftRight% (BYVAL Value%, BYVAL NumBits%)
DECLARE FUNCTION Smaller%  (BYVAL Value1%, BYVAL Value2%)
DECLARE FUNCTION SmallerL& (BYVAL Value1&, BYVAL Value2&)
DECLARE FUNCTION SwapBytes%  (BYVAL Value%)
DECLARE FUNCTION TestBit% (BYVAL Number%, BYVAL BitPosition%)
DECLARE FUNCTION UnsComp% (BYVAL Value1%, BYVAL Value2%)

DECLARE SUB SetInBox (SEG   Row%,  SEG   Column%, _
                      BYVAL Row1%, BYVAL Column1%, _
                      BYVAL Row2%, BYVAL Column2%)
DECLARE SUB SetInRange (SEG Var%, BYVAL LoVal%, BYVAL HiVal%)
'==============================================================================


'=============== SCREEN (ANSI) FUNCTIONS ======================================
DECLARE FUNCTION ANSIBgColor% ()
DECLARE FUNCTION ANSIFgColor% ()
DECLARE FUNCTION ANSIKey%     ()
DECLARE FUNCTION ANSIComStatus% (BYVAL ComPortNum%)

DECLARE SUB ANSICls ()
DECLARE SUB ANSIColor (BYVAL Foreground%, BYVAL Background%)
DECLARE SUB ANSIComInit(BYVAL ComPortNum%, BYVAL BaudRate%, _
                        BYVAL Parity%, BYVAL WordSize%, BYVAL StopBits%)
DECLARE SUB ANSICsrRest ()
DECLARE SUB ANSICsrSave ()
DECLARE SUB ANSIDelLine ()
DECLARE SUB ANSIDown (BYVAL NumRows%)
DECLARE SUB ANSIHandle (BYVAL Handle%)
DECLARE SUB ANSIHandleIn (BYVAL HandleIn%)
DECLARE SUB ANSIHandleOut (BYVAL HandleOut%)
DECLARE SUB ANSIHome ()
DECLARE SUB ANSILeft (BYVAL NumColumns%)
DECLARE SUB ANSILoc (BYVAL Row%, BYVAL Column%)
DECLARE SUB ANSIPrt (Text$)
DECLARE SUB ANSIPrtC (Text$)
DECLARE SUB ANSIPrtNum (BYVAL Number%)
DECLARE SUB ANSIRight (BYVAL NumColumns%)
DECLARE SUB ANSIUp (BYVAL NumRows%)
'==============================================================================


'=============== SCREEN FUNCTIONS =============================================
DECLARE FUNCTION ColorAttr%( BYVAL Foreground%, BYVAL Background%)
DECLARE FUNCTION ColorPDQ% ()
DECLARE FUNCTION ColorQB% ()
DECLARE FUNCTION MemToScreen%(BYVAL MSeg%, BYVAL MPtr%, BYVAL Row%, BYVAL Col%)
DECLARE FUNCTION ScreenLoad% (FileName$)
DECLARE FUNCTION ScreenSave% (FileName$)
DECLARE FUNCTION ScreenTicker% ( Message$, BYVAL Row%, _
                                 BYVAL StartColumn%, BYVAL EndColumn%, _
                                 BYVAL ColorAttrib%, BYVAL ExitKey%, _
                                 BYVAL Speed%)
DECLARE FUNCTION ScreenToMem%(BYVAL MSeg%, BYVAL MPtr%, _
                              BYVAL Row1%, BYVAL Col1%, _
                              BYVAL Row2%, BYVAL Col2%)
DECLARE FUNCTION VideoPtr%(BYVAL Row%, BYVAL Column%)
DECLARE FUNCTION VideoSeg%()
DECLARE FUNCTION VideoSegPDQ%()
DECLARE FUNCTION VideoSegQB%()

DECLARE SUB AttrColor (BYVAL Attr%, SEG Foreground%, SEG Background%)
DECLARE SUB Clrs (BYVAL Attr%)
DECLARE SUB Prnt (Text$, BYVAL Row%, BYVAL Col%, BYVAL Attr%)
DECLARE SUB PrntOver (Text$, BYVAL Row%, BYVAL Col%)
DECLARE SUB ScreenAOX (BYVAL Row1%, BYVAL Column1%, _
                       BYVAL Row2%, BYVAL Column2%, _
                       BYVAL ANDmask%, BYVAL ORmask%, BYVAL XORmask%)
DECLARE SUB ScreenBlink (BYVAL Row1%, BYVAL Column1%, _
                         BYVAL Row2%, BYVAL Column2%, _
                         BYVAL BlinkState%)
DECLARE SUB ScreenBold  (BYVAL Row1%, BYVAL Column1%, _
                         BYVAL Row2%, BYVAL Column2%, _
                         BYVAL BoldState%)
DECLARE SUB ScreenBox (BYVAL Row1%, BYVAL Column1%, _
                       BYVAL Row2%, BYVAL Column2%, _
                       BYVAL BoxType%, BYVAL Attr%)
DECLARE SUB ScreenFade (BYVAL Fade%,BYVAL MemSeg%) 'note use of BYVAL keyword
DECLARE SUB ScreenFill (BYVAL Row1%, BYVAL Column1%, _
                        BYVAL Row2%, BYVAL Column2%, _
                        BYVAL ASCIIChar%, BYVAL Attr%)
DECLARE SUB ScreenMarquee (BYVAL Row1%, BYVAL Column1%, _
                           BYVAL Row2%, BYVAL Column2%, BYVAL Attr%)
DECLARE SUB ScreenPrint ()
DECLARE SUB ScreenScroll (BYVAL Numlines%, _
                          BYVAL Row1%, BYVAL Column1%, _
                          BYVAL Row2%, BYVAL Column2%, BYVAL Attribute%)
DECLARE SUB ScreenString (Text$, BYVAL Row%, BYVAL Column%, BYVAL NumBytes%)
DECLARE SUB SetColorPDQ (BYVAL Attr%)
DECLARE SUB SetColorQB (BYVAL Attr%)
DECLARE SUB SetTextMode ()
DECLARE SUB SetVideoSeg (BYVAL NewVideoSeg%)
DECLARE SUB SetVideoSegPDQ (BYVAL NewVideoSeg%)
DECLARE SUB SetVideoSegQB (BYVAL NewVideoSeg%)
'==============================================================================


'=============== STRING FUNCTIONS =============================================
DECLARE FUNCTION AddCRLF$ (Text$)
DECLARE FUNCTION AppLink$ ()
DECLARE FUNCTION AscMid% (Text$, BYVAL Position%)
DECLARE FUNCTION Bin$ (BYVAL IntVal%)
DECLARE FUNCTION Center$ (Text$, BYVAL LineWidth%)
DECLARE FUNCTION ChainLink$ ()
DECLARE FUNCTION InstrFwd% (BYVAL StartAt%, SearchIn$, LookFor$)
DECLARE FUNCTION InstrRev% (BYVAL StartAt%, SearchIn$, LookFor$)
DECLARE FUNCTION IntStr$  (BYVAL IntVal%)  'convert to 2-byte string
DECLARE FUNCTION IStr$ (BYVAL IntVal%) 'same as LTRIM$(STR$(IntVal%))
DECLARE FUNCTION LJustify$ (Text$, BYVAL LineWidth%)
DECLARE FUNCTION LongStr$ (BYVAL LongVal&) 'convert to 4-byte string
DECLARE FUNCTION LStr$ (BYVAL LongVal&) 'same as LTRIM$(STR$(LongVal&))
DECLARE FUNCTION NoMid$ (Text$, BYVAL StartPos%, BYVAL NumChars%)
DECLARE FUNCTION NoSegm$ (Text$, BYVAL StartPos%, BYVAL EndPos%)
DECLARE FUNCTION NoSpace$ (Text$)
DECLARE FUNCTION Repeat$ (Text$, BYVAL NumTimes%)
DECLARE FUNCTION Reverse$(Text$)
DECLARE FUNCTION RJustify$ (Text$, BYVAL LineWidth%)
DECLARE FUNCTION Segm$ (Text$, BYVAL StartPos%, BYVAL EndPos%)
DECLARE FUNCTION StrChkSum&(Text$)
DECLARE FUNCTION StrInt%  ( IntVal$ ) 'forward order string(see IntStr)
DECLARE FUNCTION StrLong& ( IntVal$ ) 'forward order string(see LongStr)
DECLARE FUNCTION Trim$ (Text$)
DECLARE FUNCTION TrimLCase$ (Text$)
DECLARE FUNCTION TrimUCase$ (Text$)

DECLARE SUB ChgCase (Text$)
DECLARE SUB ChgMid (Text$, BYVAL Position%, BYVAL NewValue%)
DECLARE SUB LowerCase (Text$)
DECLARE SUB MemToString (Text$, BYVAL MemSeg%, BYVAL MemPtr%, BYVAL NumBytes%)
DECLARE SUB Replace (Text$, BYVAL OldChar%, BYVAL NewChar%)
DECLARE SUB SetChainLink (Link$)
DECLARE SUB SetAppLink (App$)
DECLARE SUB StringToMem (Text$, BYVAL MemSeg%, BYVAL MemPtr%, BYVAL NumBytes%)
DECLARE SUB UpperCase (Text$)
DECLARE SUB XORString (Text$, BYVAL XORValue%)
'==============================================================================


'=============== SYSTEM/MISCELLANEOUS FUNCTIONS ===============================
DECLARE FUNCTION DOSVersion% ()

DECLARE SUB ColdBoot ()
DECLARE SUB FormFeed
DECLARE SUB WarmBoot ()
'==============================================================================




