TITLE  'Draw a line EGA w/ color pattern - VIDEO SYSTEMS p.191'
NAME   DRAWLNP
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Draw a line in EGA\VGA with color pattern              |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call DRAWLNP(0,p$,0,0,639,0)                           |
;    stack:     +06 = y1                                                |
;                08 = x1                                                |
;                10 = y0                                                |
;                12 = x0                                                |
;                14 = string descriptor address                         |
;                16 = replacement type                                  |
;  returns:      none                                                   |
;     NOTE:      first byte of pattern is shift count offset per line   |
;     NOTE:      drawing is always done left to right (top to bottom)   |
;     NOTE:      Entry point FILLWINlnp called from FILLWINP            |
;     NOTE:      Entry point FILLAREAlnp called from FILLAREAP/FLUDAREAP|
;------------------------------------------------------------------------

PARMS           = 6
ARGaddtype      EQU [bp+16]
ARGdesc         EQU [bp+14]
ARGx0           EQU [bp+12]
ARGy0           EQU [bp+10]
ARGx1           EQU [bp+08]
ARGy1           EQU [bp+06]
ByteOffsetShift EQU 3

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

DrawLnP_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME  cs:DrawLnP_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  DrawLnP
DrawLnP         PROC    FAR

                push    bp
                mov     bp,sp
                push    bp
                push    ds
                push    si
                push    di

                cld
                sub     ax,ax
                mov     InFill,ax       ;flag not from a FILL
                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGdesc
                mov     ax,[bx]
                or      ax,ax
                jnz     LC00a
                jmp     Lexit1          ;must have length

LC00a:          mov     StrLen,ax
                mov     ax,[bx+2]
                mov     addrOff,ax
                mov     bx,ARGx0
                mov     ax,[bx]
                mov     x0,ax
                mov     bx,ARGy0
                mov     ax,[bx]
                mov     y0,ax
                mov     bx,ARGx1
                mov     ax,[bx]
                mov     x1,ax
                push    ax              ;save to update step
                mov     bx,ARGy1
                mov     ax,[bx]
                mov     y1,ax
                push    ax
                jmp     short LC00

                PUBLIC FILLWINlnp
FILLWINlnp      LABEL FAR
                PUBLIC FILLAREAlnp
FILLAREAlnp     LABEL FAR
                mov     InFill,1        ;flag so we can get out early
                                        ;x0,y0,x1,y1,RMW,StrLen,AddrOff set

                ;set up Graphics Controller Initial

LC00:           mov     dx,03CEh        ;dx = Graphics Controller
                mov     ah,0            ;doesn't matter
                xor     al,al           ;reg number
                out     dx,ax           ;update this register

                mov     ax,0F01h        ;ah = 0F (bit plane mask for enable\..
                out     dx,ax           ;al = reg number

                mov     ah,byte ptr RMWbits     ;bits 3 & 4 of ah = function
                mov     al,3            ;al = reg number
                out     dx,ax

                ;check for vertical line

                mov     si,bpl          ;increment for video buffer
                mov     cx,x1
                sub     cx,x0
                jz      VertLine10

                ;force x0 < x1

                jns     L01             ;jump if x1 > x0
                neg     cx              ;cx = x1 - x2
                mov     bx,x1           ;exchange x0 and x1
                xchg    bx,x0
                mov     x1,bx
                mov     bx,y1           ;exchange y0 and y1
                xchg    bx,y0
                mov     y1,bx

                ;calculate dy = abs(y1-y0)

L01:            mov     bx,y1
                sub     bx,y0           ;bx = y1 - y0
                jnz     L01a
                jmp     HorizLine10     ;jump if horizontal line (jz)

L01a:           jns     L03             ;jump if slope is positive

                neg     bx              ;bx = y0 - y1
                neg     si              ;negative increment for buff interleave

                ;select appropriate routine for slope of line

L03:            mov     VertIncr,si  ;save vertical increment
                mov     Routine,offset LoSlopeLine10
                cmp     bx,cx
                jle     L04             ;jump if dy <= dx (slope <=1)
                mov     Routine,offset HiSlopeLine10
                xchg    bx,cx           ;exchange dy and dx

                ;calculate initial decision variable and increments

L04:            shl     bx,1            ;bx= 2*dy
                mov     Incr1,bx        ;incr1 = 2*dy
                sub     bx,cx
                mov     si,bx           ;si = d = 2*dy-dx
                sub     bx,cx
                mov     Incr2,bx        ;incr2 = 2*(dy-dx)

                ;calculate first pixel address

                push    cx              ;preserve this register
                mov     ax,y0           ;ax = y
                mov     bx,x0           ;bx = x
                mov     cx,bpl
                call    PixelAddr       ;ah = bitmask
                                        ;es:bx -> buffer
                                        ;cl = # bits to shift left
                mov     di,bx           ;es:di -> buffer
                shl     ah,cl           ;ah = bit mask in proper position
                mov     bl,ah           ;ah,bl = bit mask
                mov     al,8            ;al = bit mask reg number

                pop     cx
                inc     cx              ;cx = pixels to draw

                jmp     Routine         ;jump to appropriate slope routine

                ;routine for vertical lines

VertLine10:     mov     ax,y0           ;ax = y0
                mov     bx,y1           ;bx = y1
                mov     cx,bx
                sub     cx,ax           ;cx = dy
                jge     L31             ;jump if dy >= 0

                neg     cx              ;force dy >=0
                mov     ax,bx           ;ax = y1

L31:            inc     cx              ;cx = # pixels to draw
                push    cx              ;preserve this register
                mov     bx,x0           ;bx = x0
                mov     cx,bpl
                call PixelAddr

                ;set up Graphics controller

                shl     ah,cl           ;ah = bit mask in proper position
                mov     al,8            ;bit mask reg number
                out     dx,ax

                pop     cx

                ;set up Graphics Controller for this pixel's color

L31a:           mov     bp,StrLen
                mov     gap,bp
                mov     bp,addrOff      ;can do since [bp] is off SS which=DS

L32:            push    ax              ;save pixel mask
                sub     ax,ax
                mov     ah,byte ptr [bp+0]  ;dot color to ah
                out     dx,ax           ;update this register
                pop     ax              ;get pixel mask

                or      es:[bx],al      ;set pixel
                add     bx,si           ;increment to next line
                inc     bp
                dec     gap             ;count down next dot pattern
                jz      L32n            ;done all in pattern?
                loop    L32
                jmp     Lexit
L32n:           loop    L31a            ;restore pixel color pattern to start
                jmp     Lexit

                ;routine for horizontal lines (slope = 0)

HorizLine10:    push    ds
                mov     ax,y0
                mov     bx,x0
                mov     cx,bpl
                call    PixelAddr

                mov     di,bx           ;es:di -> buffer
                mov     dh,ah           ;dh = unshifted bit mask for left byte
                not     dh
                shl     dh,cl           ;dh = reverse bit mask for first byte
                not     dh              ;dh = bit mask for first byte

                mov     cx,x1
                and     cl,7
                xor     cl,7            ;cl = number of bits to shift left

                mov     dl,0FFh         ;dl = unshifted bit mask for right byte
                shl     dl,cl           ;dl = bit mask for last byte

                ;determine byte offset of first and last pixel in the line

                mov     ax,x1           ;ax = x1
                mov     bx,x0           ;bx = x0

                mov     cl,ByteOffsetShift      ;number of bits to shift left
                                                ;convert pixels to bytes
                shr     ax,cl           ;ax = byte offset of x1
                shr     bx,cl           ;bx = byte offset of x0
                mov     cx,ax
                sub     cx,bx           ;cx = # bytes per line - 1

                ;get Graphics controller port address into DX

                mov     bx,dx           ;bh = bit mask for first byte
                                        ;bl = bit mask for last byte
                mov     dx,03CEh        ;dx = graphics controller port

                cmp     InFill,1        ;called from a fill
                je      HL11

                mov     bp,StrLen       ;set up line pattern for non-fill call
                mov     gap,bp
                mov     bp,addrOff      ;can do since [bp] is off SS which=DS
                jmp     short HL12

HL11:           push    dx              ;set up line pattern for fill call
                mov     bp,StrLen       ;bp=length of pattern string
                mov     ax,x0           ;ax=left pixel of line (get remainder)
                mov     si,FillShift
                or      si,si
                je      HL11a
                add     ax,si           ;alter pattern's pattern
                add     si,FillShiftOrg ;for next call
                mov     FillShift,si
HL11a:          sub     dx,dx
                div     bp              ;dx=ptr into pattern for this x0
                sub     bp,dx           ;bp=pixel patterns left in run
                mov     gap,bp          ;gap=pixel patterns left in run
                add     dx,addrOff      ;dx=addr of ptr into pattern
                mov     bp,dx           ;address pattern off ss:[bp+0]
                pop     dx

                ;make video buffer addressable through ds:di

HL12:           push    es
                pop     ds
                ASSUME ds:nothing
                mov     si,di           ;ds:si = video buffer

                ;set pixels in left byte of the line

                or      cx,cx           ;we have at most one byte
                jz      L41             ;which may be less than full

                or      bh,bh
                js      L43             ;jump if byte-aligned

                or      cx,cx
                jnz     L42             ;jump if more than one byte in the line

L41:            and     bl,bh           ;bl = bit mask for the line
                jmp     L45             ;one byte in line

L42:            push    cx              ;save main counter
                sub     cx,cx
                mov     al,bh           ;get first byte bit mask
L42a:           shr     al,1            ;shift til we hit the first 0 bit
                jnc     L42b            ;found a zero bit
                inc     cx
                jmp     short L42a
L42b:           jcxz    L42e            ;nah, won't happen
                dec     cx              ;we'll be starting with bit 0 set
                mov     bh,1            ;position to the first set bit
                shl     bh,cl           ;set the first left bit position
                inc     cx              ;reflect bits to shift again

L42c:           mov     al,8            ;bit mask reg #
                mov     ah,bh           ;bit mask
                out     dx,ax           ;update the graphics controller
                sub     ax,ax
                mov     ah,byte ptr [bp+0] ;dot color to ah
                out     dx,ax           ;update this register

                movsb                   ;do leftmost non-full-byte bits
                dec     si
                dec     di              ;not done with this byte yet
                shr     bh,1
                inc     bp
                dec     ss:gap
                cmp     ss:gap,0
                jnz     L42e
                mov     bp,ss:StrLen
                mov     ss:gap,bp
                mov     bp,ss:addrOff
L42e:           loop    L42c
                inc     si
                inc     di              ;now we are
                pop     cx              ;get back main counter
                dec     cx              ;one less byte to do
                jcxz    L43z            ;line has no more full bytes to do

L43:            push    cx              ;save main pixel counter
                mov     ah,10000000b    ;start with left pixel bit mask
                cmp     ss:gap,0
                jnz     L43b

L43a:           mov     bp,ss:StrLen
                mov     ss:gap,bp
                mov     bp,ss:addrOff

L43b:           mov     cx,8
L43c:           mov     al,8
                out     dx,ax           ;update bit mask register
                push    ax              ;save bitmask
                sub     ax,ax
                mov     ah,byte ptr [bp+0]  ;dot color to ah
                out     dx,ax           ;update this register

                movsb                   ;write to screen memory
                dec     si              ;need to do 8 pixels before
                dec     di              ; we inc these
                pop     ax              ;bit mask back
                shr     ah,1            ;next pixel
                inc     bp
                dec     ss:gap          ;count down next dot pattern
                jz      L43n            ;done all in pattern?
L43m:           loop    L43c
                inc     si
                inc     di              ;did 8 pixels
                pop     cx              ;main pixel counter
                jcxz    L44             ;not even a full byte?
                loop    L43             ;do next byte
                jmp     short L44       ;done

L43n:           mov     bp,ss:StrLen
                mov     ss:gap,bp
                mov     bp,ss:addrOff
                jmp     short L43m      ;restore pixel color pattern

                ;after a byte-aligned segment, check for bits left

L43z:           or      bl,bl           ;bits left in last byte?
                jnz     L44             ;yes
                pop     ds
                ASSUME ds:dgroup
                jmp     Lexit

                ;set pixels in last right byte of the line
                ;11110000

L44:            cmp     ss:gap,0
                jnz     L44aa

L44a:           mov     bp,ss:StrLen
                mov     ss:gap,bp
                mov     bp,ss:addrOff

L44aa:          sub     cx,cx
                mov     al,bl           ;get last byte bit mask
L44ab:          shl     al,1            ;shift til we hit the first 0 bit
                jnc     L44b            ;found a zero bit
                inc     cx
                jmp     short L44ab
L44b:           jcxz    L44e            ;nah, won't happen
                mov     bh,10000000b    ;position to bit 7

L44c:           mov     al,8            ;bit mask reg #
                mov     ah,bh           ;bit mask
                out     dx,ax           ;update the graphics controller
                sub     ax,ax
                mov     ah,byte ptr [bp+0] ;dot color to ah
                out     dx,ax           ;update this register

                movsb                   ;do last byte bits
                dec     si
                dec     di              ;not done with this byte yet
                shr     bh,1
                inc     bp
                dec     ss:gap
                cmp     ss:gap,0
                jnz     L44e
                mov     bp,ss:StrLen
                mov     ss:gap,bp
                mov     bp,ss:addrOff
L44e:           loop    L44c

                pop     ds
                ASSUME ds:dgroup
                jmp     Lexit

                ;set pixels in last (left) byte of the line
                ;00000011

L45:            cmp     ss:gap,0
                jnz     L45aa

L45a:           mov     bp,ss:StrLen
                mov     ss:gap,bp
                mov     bp,ss:addrOff

L45aa:          mov     bh,1
                sub     cx,cx
                mov     al,bl           ;get last byte bit mask
L45ab:          shr     al,1            ;shift til we hit the first 0 bit
                jnc     L45b            ;found a zero bit
                inc     cx
                jmp     short L45ab
L45b:           jcxz    L45f            ;00001100? handle trailing zeros
                dec     cx              ;we started with bit 0 set
                shl     bh,cl           ;set the first left bit position
                inc     cx              ;reflect bits to shift again

L45c:           mov     al,8            ;bit mask reg #
                mov     ah,bh           ;bit mask
                out     dx,ax           ;update the graphics controller
                sub     ax,ax
                mov     ah,byte ptr [bp+0] ;dot color to ah
                out     dx,ax           ;update this register

                movsb                   ;do last byte bits
                dec     si
                dec     di              ;not done with this byte yet
                shr     bh,1
                inc     bp
                dec     ss:gap
                cmp     ss:gap,0
                jnz     L45e
                mov     bp,ss:StrLen
                mov     ss:gap,bp
                mov     bp,ss:addrOff
L45e:           loop    L45c

                pop     ds
                ASSUME ds:dgroup
                jmp     Lexit

L45f:           shl     bh,1            ;bits bordered by off bits
                jmp     L45ab           ;00001100


                ;routine for dy >= dx (slope <= 1)
                        ;es:di -> video buffer
                        ;al = bit mask reg number
                        ;bl = bit mask for 1st pixel
                        ;cx = # pixels to draw
                        ;dx = graphics controller port addr
                        ;si = decision variable
LoSlopeLine10:

L10:            mov     bp,StrLen
                mov     gap,bp
                mov     bp,addrOff

L10a:           mov     ah,bl           ;ah = bit mask for next pixel
L11:            or      ah,bl           ;mask current pixel position
                ror     bl,1            ;rotate pixel value
                jnc     L11cont
                jmp     L14             ;jump if bit mask rotated to leftmost
                                        ; pixel position
                ;bit mask not shifted out

L11cont:        or      si,si           ;test sign of d
                jns     L12             ;jump if d >=0

                add     si,Incr1        ;d = d + incr1
                loop    L11

                push    bx              ;handle last byte
                sub     bx,bx
                mov     bh,10000000b
L11a:           test    ah,bh
                jz      L11d            ;check next

                xchg    ah,bh           ;bit mask to ah/ah to bh
                out     dx,ax           ;update bit mask reg

                push    ax
                sub     ax,ax
                mov     ah,byte ptr [bp+0] ;dot color to ah
                out     dx,ax
                pop     ax

                or      es:[di],al      ; bit planes

                inc     bp
                dec     gap
                cmp     gap,0
                jne     L11c
                mov     bp,StrLen
                mov     gap,bp
                mov     bp,addrOff

L11c:           xchg    bh,ah           ;bh back to bit mask single,ah full mask
L11d:           shr     bh,1            ;check all 8 bits
                jnc     L11a
                pop     bx              ;clean up stack
                jmp     Lexit

L12:            add     si,Incr2        ;d = d + incr2

                push    bx
                sub     bx,bx
                mov     bh,10000000b
L12a:           test    ah,bh
                jz      L12d            ;check next

                xchg    ah,bh           ;bit mask to ah/ah to bh
                out     dx,ax           ;update bit mask reg

                push    ax
                sub     ax,ax
                mov     ah,byte ptr [bp+0] ;dot color to ah
                out     dx,ax
                pop     ax

                or      es:[di],al      ; bit planes

                inc     bp
                dec     gap
                cmp     gap,0
                jne     L12c
                mov     bp,StrLen
                mov     gap,bp
                mov     bp,addrOff

L12c:           xchg    bh,ah           ;bh back to bit mask single,ah full mask
L12d:           shr     bh,1            ;check all 8 bits
                jnc     L12a
                pop     bx              ;get 'er back
                add     di,VertIncr     ;increment y
                dec     cx
                jz      L12x
                jmp     L10a
L12x:           jmp     Lexit

                ;bit mask shifted out

L14:            push    bx
                sub     bx,bx
                mov     bh,10000000b
L14a:           test    ah,bh
                jz      L14d            ;check next

                xchg    ah,bh           ;bit mask to ah/ah to bh
                out     dx,ax           ;update bit mask reg

                push    ax
                sub     ax,ax
                mov     ah,byte ptr [bp+0] ;dot color to ah
                out     dx,ax
                pop     ax

                or      es:[di],al      ; bit planes

                inc     bp
                dec     gap
                cmp     gap,0
                jne     L14c
                mov     bp,StrLen
                mov     gap,bp
                mov     bp,addrOff

L14c:           xchg    bh,ah           ;bh back to bit mask single,ah full mask
L14d:           shr     bh,1            ;check all 8 bits
                jnc     L14a

                pop     bx              ;get 'er back

                inc     di              ; increment x
                or      si,si           ;test sign of d
                jns     L15             ;jump if non-negative
                add     si,Incr1        ;d = d + incr1
                dec     cx
                jz      L14e
                jmp     L10a
L14e:           jmp     Lexit

L15:            add     si,Incr2        ;d = d + incr2
                add     di,VertIncr     ;vertical increment
                dec     cx
                jz      L15a
                jmp     L10a
L15a:           jmp     Lexit


                ;routine for dy > dx (slope > 1)
                        ;es:di -> video buffer
                        ;ah = bit mask for 1st pixel
                        ;al = bit mask reg number
                        ;cx = # pixels to draw
                        ;dx = graphics controller port addr
                        ;si = decision variable

HiSlopeLine10:  mov     bx,VertIncr     ;bx = y-increment
                mov     bp,StrLen
                mov     gap,bp
                mov     bp,addrOff

L21:            out     dx,ax           ;update bit mask reg
                                        ;1 pixel per row
                push    ax
                sub     ax,ax
                mov     ah,byte ptr [bp+0] ;dot color to ah
                out     dx,ax
                pop     ax

                or      es:[di],al      ;update bit mask planes

                inc     bp
                dec     gap
                cmp     gap,0
                jne     L21a
                mov     bp,StrLen
                mov     gap,bp
                mov     bp,addrOff

L21a:           add     di,bx
                or      si,si           ;test sign of d
                jns     L23             ;jump if d >= 0

                add     si,Incr1        ;d = d + incr1
                loop    L21
                jmp     short Lexit

L23:            add     si,Incr2        ;d = d + incr2
                ror     ah,1            ;rotate bit mask
                adc     di,0            ;increment di if when mask rotated to
                                        ; leftmost pixel position
                loop    L21

                ;restore default graphics controller state and return to caller

Lexit:          xor     ax,ax
                out     dx,ax           ;restore set\reset register

                inc     ax
                out     dx,ax           ;restore enable set\reset reg

                mov     al,3
                out     dx,ax           ;data rotate\function select reg

                mov     ax,0FF08h
                out     dx,ax           ;restore bit mask reg

                cmp     InFill,0
                je      Lexit0          ;we're a regular line draw pattern
                RET                     ;if either a window fill or area fill

Lexit0:         pop     ax              ;update for step
                mov     ss:y0,ax
                pop     ax
                mov     ss:x0,ax

Lexit1:         pop     di
                pop     si
                pop     ds
                pop     bp
                ASSUME ds:dgroup
                mov     sp,bp
                pop     bp
                RET     PARMS*2

DrawLnP         ENDP
DrawLnP_TEXT    ENDS
                END

