*--- PUBLIC DOMAIN SOFTWARE
*--- made by Branislav Stofko Trebisovska 21   821 01 Bratislava  Slovakia
*--- This source code for database compiler FORCE may bee freelly modified
*--- and after them translated with other compilers. Please remove my name,
*--- from source, if you make any modifications.
*--- I am not responsible for any damages made in with this code.
*---
#include fileio.hdr
#include string.hdr
#include system.hdr
*-------------------
PROCEDURE FORCE_MAIN
PARAMETERS CONST CHAR(127) Cmnd_line
*-------------------
VARDEF
  UINT		Blanks, Increment, Position_of_then, Line_counter, Line_length
  FILE		Input_handle, Output_handle
  CHAR(4)	Previous_line
  CHAR(8)	File_name
  CHAR(255)	Original_line, Upper_line
  LOGICAL       Structure_on, Second_line
ENDDEF
*--- this is the best solution (default)
Increment = 2
Structure_on = .F.
Previous_line = ""
*--- get file_name and increment from command line
Upper_line = UPPER(TRIM(Cmnd_line))
*--- determine if there is a INCREMENT switch
Blanks = AT("/I:",Upper_line)
IF Blanks > 0
  Increment = I_val(SUBSTR(Upper_line,Blanks+3,1))
ENDIF
*--- determine if there is a STRUCTURE switch
Blanks = AT("/S",Upper_line)
IF Blanks > 0
  Structure_on = .T.
ENDIF
*--- now get file_name from command line
*--- really max. 8 chars are copied because File_name has length 8 !!!
File_name = Upper_line
*--- strip out eventually extension
Blanks = AT(".",File_name)
IF Blanks > 0
  File_name = SUBSTR(File_name,1,Blanks-1)
ENDIF
*--- first character "/" ends the file name
Blanks = AT("/",File_name)
IF Blanks > 0
  File_name = SUBSTR(File_name,1,Blanks-1)
ENDIF
*--- I hope we have at end some name
IF File_name = ""
  ? " Quick BASIC source file reformatter       FREEWARE B.Stofko"
  ?
  ? " Syntax: QBF <filename> [options]"
  ?
  ? " Options: /I:n  use increment of n blanks for indent, default = 2"
  ?
  ? " Options: /S    generate comment lines before and after SUB or FUNCTION"
  ?
  ? " Output:        the same filename !!!"
  ?
ELSE
  *--- the name is defined, but I dont know if really exist
  IF EXIST(File_name+".BAS")
    IF F_open(Input_handle,File_name+".BAS",&F_read)
      *--- the same name but with extension .LST will be created
      IF F_open(Output_handle,File_name+".LST",&F_create)
        Blanks = 0
        Line_counter = 0
        *--- go thru whole input file
        DO WHILE .NOT. F_eof(Input_handle)
          IF F_getln(Input_handle,Original_line)
            *--- strip out spaces from begin and end of line
            Original_line = LTRIM(TRIM(Original_line))
            *--- convert to UPPER CASE characters
            Upper_line = UPPER(Original_line)
            *--- give my some signals
            IF Line_counter = 10
              ?? "X"
              Line_counter = 0
            ELSE
              Line_counter = Line_counter + 1
            ENDIF
            *--- END must be proccesed before output
            IF AT("END",Upper_line) = 1
              IF Blanks => Increment
                Blanks = Blanks - Increment
              ENDIF
            ENDIF
            *--- ELSE too , but after output of line go back please
            IF AT("ELSE",Upper_line) = 1
              IF Blanks => Increment
                Blanks = Blanks - Increment
              ENDIF
            ENDIF
            *--- NEXT must be proccesed before output
            IF AT("NEXT",Upper_line) = 1
              IF Blanks => Increment
                Blanks = Blanks - Increment
              ENDIF
            ENDIF
            *--- WEND must be proccesed before output
            IF AT("WEND",Upper_line) = 1
              IF Blanks => Increment
                Blanks = Blanks - Increment
              ENDIF
            ENDIF
            *--- LOOP must be proccesed before output
            IF AT("LOOP",Upper_line) = 1
              IF Blanks => Increment
                Blanks = Blanks - Increment
              ENDIF
            ENDIF
            Second_line = .F.
            *--- if STRUCTURE ON make first additionally line
            *--- before and after SUB or FUNCTION
            IF AT("SUB",Upper_line) = 1 .OR. AT("FUNCTION",Upper_line) = 1
              *--- but only if is this wanted too
              IF Structure_on
                Line_length = Blanks + LEN(Original_line) - 1
                *--- make no addionally line if there was before !!!
                *--- may be some peoples are reformating source code twice
                IF Previous_line <> "'---"
                  F_putln(Output_handle,"'"+REPLICATE("-",Line_length))
                  Second_line = .T.
                ENDIF
              ENDIF
            ENDIF
            *--- and this is all for this moment
            F_putln(Output_handle,REPLICATE(" ",Blanks)+Original_line)
            *--- only 4 character are really stored for next comparision
            Previous_line = Original_line
            *--- if STRUCTURE ON make second extra line after if wanted
            IF Second_line
              F_putln(Output_handle,"'"+REPLICATE("-",Line_length))
            ENDIF
            *--- set new position of next line after some words
            IF AT("TYPE",Upper_line) = 1
              Blanks = Blanks + Increment
            ENDIF
            IF AT("ELSE",Upper_line) = 1
              Blanks = Blanks + Increment
            ENDIF
            IF AT("SELECT",Upper_line) = 1
              Blanks = Blanks + Increment
            ENDIF
            IF AT("FOR",Upper_line) = 1
              Blanks = Blanks + Increment
            ENDIF
            IF AT("WHILE",Upper_line) = 1
              Blanks = Blanks + Increment
            ENDIF
            IF AT("DEF FN",Upper_line) = 1
              Blanks = Blanks + Increment
            ENDIF
            *--- for DO WHILE check DO and WHILE
            IF AT("DO",Upper_line) = 1 .AND. AT("WHILE",Upper_line) > 1
              Blanks = Blanks + Increment
            ENDIF
            *--- IF x = 1 THEN y = 1 dont needs some increments
            Position_of_then = LEN(Upper_line) - 3
            IF AT("IF",Upper_line) = 1 .AND. ;
               AT("THEN",Upper_line) = Position_of_then
              Blanks = Blanks + Increment
            ENDIF
          ELSE
            ?
            ?? "Sorry, read error has been detected"
          ENDIF
          *--- next line please
        ENDDO
        *--- close both files
        F_close(Output_handle)
      ENDIF
      F_close(Input_handle)
      ? " "
      *--- and now will be new file renamed to one one
      ERASE File_name + ".BAS"
      RENAME File_name + ".LST" TO File_name + ".BAS"
    ENDIF
  ELSE
    ? "Source file "
    ?? File_name
    ?? ".BAS not found !"
  ENDIF
ENDIF
ENDPRO






*--- xref: qbf.PRG      Vytvoreny 01.09.1995  Listing 1.9.1995      List   1

*                Blanks   11   25   26   27   30   31   37   38   39   42   43
                      *   44   65   83   84   84   89   90   90   95   96   96
                      *  101  102  102  107  108  108  117  126  135  135  138
                      *  138  141  141  144  144  147  147  151  151  156  156
*             Cmnd_line    8   23
*               F_close  165  167
*                 F_eof   68
*               F_getln   69
*                F_open   62   64
*               F_putln  120  126  131
*             File_name   14   35   37   39   39   42   44   44   46   61   62
                      *   64  172
*                 I_val   27
*             Increment   11   19   27   83   84   89   90   95   96  101  102
                      *  107  108  135  138  141  144  147  151  156
*          Input_handle   12   62   68   69  167
*          Line_counter   11   66   75   77   79   79
*           Line_length   11  117  120  131
*         Original_line   15   69   71   71   73  117  126  128
*         Output_handle   12   64  120  126  131  165
*      Position_of_then   11  154  155
*         Previous_line   13   21  119  128
*           Second_line   16  112  121  130
*          Structure_on   16   20   32  116
*            Upper_line   15   23   25   27   30   35   73   82   88   94  100
                      *  106  114  114  134  137  140  143  146  150  150  154
                      *  155  155
*               _create   64
*                 _read   62
