/* 
 * Resident segment for the Windows Property List Demo
 *
 * Written by Bill Hall
 * 3665 Benton Street, #66
 * Santa Clara, CA 95051
 *
 */

#define NOCOMM
#define NOKANJI
#define NOSOUND
#include <windows.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>

/* all global variables are declared in this module */
#define EXTERN
#include "walloc.h"

/* local function declaration */
BOOL FAR PASCAL AboutDlg(HWND hDlg, unsigned message, WORD wParam, LONG lParam);

/* Entry point for program */
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
		   LPSTR lpszCmdLine, int cmdShow)
{

    MSG msg;

  /* If initialization is not successful then exit */
    if (!InitProgram(hInstance,hPrevInstance, lpszCmdLine, cmdShow))
	return FALSE;

  /* Retrieve messages from Windows */
    while (GetMessage((LPMSG)&msg,NULL,0,0)) {
	TranslateMessage((LPMSG)&msg);
	DispatchMessage((LPMSG)&msg);
    }
    return msg.wParam;		/* exit program */
}

/* All messages are processed here */
long FAR PASCAL MainWndProc(register HWND hWnd, unsigned message,
			    WORD wParam, LONG lParam)
{

    MYDATA FAR *ptr;
    static unsigned count;
    FARPROC fp;

    switch(message) {

	case WM_CREATE:
	    WndCreate(hWnd);	/* create the list box display windows */
	    break;

	case WM_DESTROY:
	    FreeMem(hWnd);	/* free allocated memory and property list */
	    PostQuitMessage(0);
	    break;

	case WM_SIZE:		/* size the list box display windows */
	    if (wParam != SIZEICONIC) {
	        MoveWindow(hWndList,0,0,LOWORD(lParam),HIWORD(lParam) / 2,TRUE);
	        MoveWindow(hWndEnum, 0, HIWORD(lParam) / 2, LOWORD(lParam),
			   HIWORD(lParam) / 2, TRUE);
	    }
	    break;

	case WM_COMMAND:
	    switch(wParam) {
		case IDM_ABOUT:		/* show about box */
		    fp = MakeProcInstance(AboutDlg, hInst);
		    DialogBox(hInst, MAKEINTRESOURCE(DT_ABOUT), hWnd, fp);
		    FreeProcInstance(fp);
		    break;

	    /* allocate a chunk of data; if successful, 
	       copy in some information and display the result
	     */
		case IDM_ALLOC:
		    ptr = (MYDATA FAR *)AllocMem(hWnd, sizeof(MYDATA));
		    if (ptr) {
			wsprintf(ptr->data, "%s%u", (LPSTR)"Mydata", count++);
			UpdateList(hWnd);
		    }
		    break;

	    /* enumerate the current property list and display
	       it in a list box.  to keep the display from
	       flashing during update, turn off the redraw flag
	       before the update and restore it when done.
	     */
		case IDM_PROP:
		    SendDlgItemMessage(hWnd,IDD_ENUM,WM_SETREDRAW,FALSE,0L);
		    SendDlgItemMessage(hWnd,IDD_ENUM,LB_RESETCONTENT,0,0L);
		    fp = MakeProcInstance(EnumPropCallBack, hInst);
		    EnumProps(hWnd, fp);
		    FreeProcInstance(fp);
		    SendDlgItemMessage(hWnd,IDD_ENUM,WM_SETREDRAW,TRUE,0L);
		    InvalidateRect(hWndEnum, NULL, TRUE);
		    UpdateWindow(hWndEnum);
		    break;
	    }
	    break;

	default:
	    return ((long)DefWindowProc(hWnd,message,wParam,lParam));
	    break;
    }
    return(0L);
}

/* 
 * This function allows you to print debugging information
 * to a secondary monitor attached to a monochrome display
 * card, Hercules board, or equivalent.
 *
 * To use this function you must load the device driver OX.SYS
 * Do NOT run Windows with redirection to AUX.
 *
 * Use dbf just like printf.
 * Example dbf("function foo %d %s\r\n", myint, mystring);
 */
void FAR _cdecl dbs(const char *fmt, ...)
{
    char buf[255];

    va_list arg_ptr;

    va_start(arg_ptr, fmt);
    vsprintf(buf, fmt, arg_ptr);
    va_end(arg_ptr);

    OutputDebugString(buf);

}

/* show ego box */
BOOL FAR PASCAL AboutDlg(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{

    switch(message) {

	case WM_INITDIALOG:
	    break;

	case WM_COMMAND:
	    switch(wParam) {
		case IDOK:
		case IDCANCEL:
		    EndDialog(hDlg, TRUE);
		    break;

		default:
		    return FALSE;
	    }
	    break;

	default:
	    return FALSE;
    }
    return TRUE;
}
