{   Code for "TSR's Using Expanded Memory With Turbo Pascal"
                 by John J. Newlin
    Page 28, Volume 5.5, Programmer's Journal

DEMO.PAS
Copyright 1987 by John J. Newlin, 4060-228 Rosenda Court, San
Diego, CA 92122
}
{$I demo.var}
{$I-,K-,C-,V-,B-,F4}
(*  Expanded memory demonstration program
    Copyright 1987 by John J. Newlin
    All rights reserved                   *)

function emm_version : str4;
var x : integer;
    u,l : str4;
    r : regpack;
begin
  r.ah := $46;
  intr($67,r);
  x := r.al and $F0;
  x := x shr 4;
  str(x,u);
  x := r.al and $0F;
  str(x,l);
  emm_version := u + '.' + l;
end;

procedure emm_page_count(var total,allocated,free : integer);
var r : regpack;
begin
  r.ah := $42;
  intr($67,r);
  total := r.dx;
  free := r.bx;
  allocated := total - free;
end;

procedure save_cursor;
var r : regpack;
begin
  r.ah := 3;
  r.bh := 0;
  intr($10,r);
  cursor_size := r.cx;
  cursor_posit := r.dx;
end;

procedure restore_cursor;
var r : regpack;
begin
  r.cx := cursor_size;
  intr($10,r);
  r.ah := 2;
  r.dx := cursor_posit;
  intr($10,r);
  r.ah := $1A;
end;

procedure map_memory(logical,physical : integer);
var r : regpack;
begin
  r.ax := physical;
  r.ah := $44;
  r.bx := logical;
  r.dx := emm_handle;
  intr($67,r);
end;

procedure printline(var str : str255);
var i : integer;
    r : regpack;
begin
  str := str + #13 + #10;
  for i := 1 to ord(str[0]) do
    begin
      r.ah := 0;
      r.dx := 0;
      r.al := ord(str[i]);
      intr($17,r);
    end;
end;

procedure print(var str : str255);
var i : integer;
    r : regpack;
begin
  for i := 1 to ord(str[0]) do
  begin
    r.ah := 0;
    r.dx := 0;
    r.al := ord(str[i]);
    intr($17,r);
  end;
end;

function hex(n : integer) : str4;
begin
  hex := hex_char[hi(n) div 16] + hex_char[hi(n) mod 16] +
         hex_char[lo(n) div 16] + hex_char[lo(n) mod 16];
end;

procedure save_screen;
begin
  map_memory(3,5);
  move(mem[buffer_loc:0],main_buffer^,4000);
  map_memory(3,3);
end;

procedure restore_screen;
begin
  map_memory(3,5);
  move(main_buffer^,mem[buffer_loc:0],4000);
  map_memory(3,3);
end;

function number_of_emm_handles : integer;
var r : regpack;
begin
  r.ah := $4B;
  intr($67,r);
  number_of_emm_handles := r.bx;
end;

function pages_assigned_to_handle(handle : integer) : integer;
var r : regpack;
begin
  r.ah := $4C;
  r.dx := handle;
  intr($67,r);
  pages_assigned_to_handle := r.bx;
end;

procedure main_proc;
var r : regpack;
    k : char;
    total,used,free,handles,pages,x,y : integer;
begin
  x := 19;
  y := 8;
  emm_page_count(total,used,free);
  handles := number_of_emm_handles;
  pages := pages_assigned_to_handle(emm_handle);
  clrscr;
  gotoxy(x,y);
  write('The Expanded Memory Manager version is ',emm_version);
  gotoxy(x,wherey+2);
  write('   Expanded memory frame segment     ',hex(emm_seg),'H');
  gotoxy(x,wherey+1);
  write('   Expanded memory pages in system   ',total:5);
  gotoxy(x,wherey+1);
  write('   Expanded memory pages available   ',free:5);
  gotoxy(x,wherey+1);
  write('   Expanded memory pages in use      ',used:5);
  gotoxy(x,wherey+1);
  write('   Expanded memory pages used by DEMO',pages:5);
  gotoxy(x,wherey+1);
  write('   Expanded memory handles in use    ',handles:5);
  gotoxy(x,wherey+2);
  write('Press any key to continue.... ');
  read(kbd,k);
end;

procedure handler;
begin
Inline(
   $5D                   {                    pop bp}
  /$5D                   {                    pop bp}
  /$FA                   {                    cli}
  /$2E                   {                    cs:}
  /$8C/$1E/>SAVEDS       {                    mov word ptr [>saveds],ds}
  /$2E                   {                    cs:}
  /$8C/$06/>SAVEES       {                    mov word ptr [>savees],es}
  /$2E                   {                    cs:}
  /$8C/$16/>SAVESS       {                    mov word ptr [>savess],ss}
  /$2E                   {                    cs:}
  /$89/$26/>SAVESP       {                    mov word ptr [>savesp],sp}
  /$2E                   {                    cs:}
  /$8E/$1E/>DATASEG      {                    mov ds,word ptr [>dataseg]}
  /$2E                   {                    cs:}
  /$8E/$16/>STACKSEG     {                    mov ss,word ptr [>stackseg]}
  /$2E                   {                    cs:}
  /$8B/$26/>STACKPTR     {                    mov sp,word ptr [>stackptr]}
  /$FA                   {                    sti}
);
  save_cursor;
  save_screen;
  main_proc;
  restore_screen;
  restore_cursor;
Inline(
   $FA                   {                    cli}
  /$2E
  /$8E/$1E/>SAVEDS       {                    mov ds,word ptr[>saveds]}
  /$2E                   {                    cs:}
  /$8E/$06/>SAVEES       {                    mov es,word ptr[>savees]}
  /$2E                   {                    cs:}
  /$8E/$16/>SAVESS       {                    mov ss,word ptr[>savess]}
  /$2E                   {                    cs:}
  /$8B/$26/>SAVESP       {                    mov sp,word ptr[>savesp]}
  /$FB                   {                    sti}
  /$CB                   {                    return far}
);
end;

{All functions and procedures above this point will be moved to
EMS} 

procedure dummy;
begin
end;

var
  lastx,lasty,lastvar,xcode : integer;

procedure initialize;
var r : regpack;
begin
  r.ah := $0F;
  intr($10,r);
  color := r.al <> 7;
  r.ah := $03;
  intr($10,r);
  if color then buffer_loc := $B800 else buffer_loc := $B000;
end;

function emm_present : boolean;
var
  ems_str : array[1..8] of char;
begin
  ems_str := '        ';
  move(mem[vector[$67].segment:10],ems_str,8);
  emm_present := ems_str = 'EMMXXXX0';
end;

function emm_segment : integer;
var r : regpack;
begin
  r.ah := $41;
  intr($67,r);
  emm_segment := r.bx;
end;


function get_handle(var handle : integer) : boolean;
var r : regpack;
begin
  r.ah := $43;
  r.bx := 8;
  intr($67,r);
  if r.ah = 0 then
    begin
      handle := r.dx;
      get_handle := true;
    end
  else
    begin
      r.ah := $42;
      intr($67,r);
      handle := r.bx;
      get_handle := false;
    end;
end;

begin
  initialize;
  demo_main := ofs(handler);
  if not emm_present then
    begin
      writeln('Expanded memory driver not present - aborting!',^g,^g);
      halt;
    end
  else
    begin
      if not get_handle(emm_handle) then
        begin
          writeln;
          writeln('Insufficient memory pages available - aborting!',^g,^g);
          writeln('EM Manager reports ',emm_handle,' pages available.');
          halt;
        end;
      if emm_version <> '3.2' then
        begin
          writeln('Not EMS version 3.2 - found instead ',emm_version,
                   ' - aborting',^g,^g);
          halt;
        end;
      emm_seg := emm_segment;
      map_memory(0,0);
      map_memory(1,1);
      map_memory(2,2);
      map_memory(3,3);
      fillchar(mem[emm_seg:0],$FFFF,0);
      lasty := ofs(dummy);
      lastx := lasty shr 4;
      dataseg := emm_seg + lastx + 2;
      stackseg := emm_seg;
      stackptr := $BFFF;
      main_buffer := ptr(emm_seg,$C000);         {page 6}
      aux_buffer  := ptr(emm_seg,$D000);         {page 6}
      move(mem[cseg:0],mem[emm_seg:0],ofs(dummy));
      move(mem[dseg:0],mem[dataseg:0],ofs(lastvar));
    end;
end.

