PROCEDURE disp_i;
BEGIN
    GOTORC(4,41); WRITE('I'); CLREOL;
    lowvideo; WRITE('-      Input Device -> '); highvideo;
    IF input_device = keyboard THEN
        WRITE('Keyboard')
    ELSE
        WRITE('File')
    {END if}
END; {procedure disp_i}


PROCEDURE disp_r;
BEGIN
    GOTORC(5,41); CLREOL;
    IF input_device = text_file THEN BEGIN
        WRITE('R'); lowvideo; WRITE('-  FileName to Read -> '); highvideo;
        WRITE(in_fn)
    END
END; {procedure disp_r}


PROCEDURE disp_n;
BEGIN
    GOTORC(6,41); CLREOL;
    IF input_device = text_file THEN BEGIN
        WRITE('N'); lowvideo; WRITE('-  Number of Copies -> '); highvideo;
        WRITE(num_copies)
    END
END; {procedure disp_n}


PROCEDURE disp_o;
BEGIN
    GOTORC(7,41); WRITE('O'); CLREOL;
    lowvideo; WRITE('-     Output device -> '); highvideo;
    CASE output_device OF
        screen : WRITE('Screen');
     recd_file : WRITE('File');
        printr : WRITE('Printer')
    END {case}
END; {procedure disp_o}


PROCEDURE disp_s;
BEGIN
    GOTORC(8,41); CLREOL;
    IF given_width = 0 THEN BEGIN
        WRITE('S'); lowvideo; WRITE('-       Device Size -> '); highvideo;
        IF device_size = normal THEN
            WRITE('Normal')
        ELSE
            WRITE('Wide  ')
    END
END; {procedure disp_s}


PROCEDURE disp_y;
BEGIN
    GOTORC(9,41); CLREOL;
    IF output_device = printr THEN BEGIN
        WRITE('Y'); lowvideo; WRITE('-      Printer Type -> '); highvideo;
        CASE prt_type OF
            epson  : WRITE('Epson');
            ids    : WRITE('IDS');
            hp     : WRITE('HP');
            dumb   : WRITE('Dumb')
        END {case}
    END
END; {procedure disp_y}


PROCEDURE disp_p;
BEGIN
    GOTORC(10,41); CLREOL;
    IF (output_device = printr) AND (prt_type <> dumb) AND
       (block_type <> Bit) THEN BEGIN
        WRITE('P'); lowvideo; WRITE('-  Pitch chars/inch -> '); highvideo;
        CASE prt_cpi OF
            pica     : WRITE('Pica [10]');
            elite    : WRITE('Elite [12]');
            squeezed : WRITE('Squeezed [17]');
            tiny     : WRITE('Tiny [20]')
        END {case}
    END
END; {procedure disp_p}


PROCEDURE disp_l;
BEGIN
    GOTORC(11,41); CLREOL;
    IF (output_device = printr) AND (prt_type <> dumb) AND
       (block_type <> Bit)  THEN BEGIN
        WRITE('L'); lowvideo; WRITE('-        Lines/Inch -> '); highvideo;
        CASE prt_lpi OF
            six    : WRITE('Six');
            eight  : WRITE('Eight');
            ten    : WRITE('Ten');
            twelve : WRITE('Twelve')
        END {case}
    END
END; {procedure disp_l}


PROCEDURE disp_c;
BEGIN
    GOTORC(12,41); CLREOL;
    IF (output_device = printr) AND (prt_type <> dumb) THEN BEGIN
        WRITE('C'); lowvideo; WRITE('-    Color of Print -> '); highvideo;
        CASE prt_color OF
            black  : WRITE('Black');
            red    : WRITE('Red');
            green  : WRITE('Green');
            blue   : WRITE('Blue')
        END {case}
    END 
END; {procedure disp_c}


PROCEDURE disp_d;
BEGIN
    GOTORC(13,41); CLREOL;
    IF (block_type = bit) AND (prt_type <> dumb) THEN BEGIN
            WRITE('D'); lowvideo; WRITE('-  Graphics Density -> '); highvideo;
            CASE graphic_dens OF
                single  : WRITE('Single');
                double  : WRITE('Double');
                triple  : WRITE('Triple');
                quad    : WRITE('Quad')
            END {case}
    END
END; {procedure disp_d}


PROCEDURE disp_e;
BEGIN
    GOTORC(14,41); CLREOL;
    IF output_device = recd_file THEN BEGIN
        WRITE('E'); lowvideo; WRITE('-  rEcord Output in -> '); highvideo;
        WRITE(out_fn)
    END
END; {procedure disp_e}


PROCEDURE disp_t;
BEGIN
    GOTORC(4,1); WRITE('T'); CLREOL;
    lowvideo; WRITE('-         Sign type -> '); highvideo;
    IF sign_type = sign THEN
        WRITE('Sign')
    ELSE
        WRITE('Banner');
    disp_i
END; {procedure disp_t}


PROCEDURE disp_b;
BEGIN
    GOTORC(5,1); WRITE('B'); CLREOL;
    lowvideo; WRITE('- Block/Letter type -> '); highvideo;
    CASE block_type OF
        letter     : WRITE('Letters     ');
        block      : WRITE('Bk Char #',ORD(block_char):3);
        overstrike : WRITE('OverStrikeBk');
        bit        : WRITE('Graphic Bits')
    END; {case}
    disp_r
END; {procedure disp_b}


PROCEDURE disp_f;
BEGIN
    GOTORC(6,1); WRITE('F'); CLREOL;
    lowvideo; WRITE('-         Font File -> '); highvideo;
    WRITE(Font_Fn);
    disp_n
END; {procedure disp_f}


PROCEDURE disp_w;
BEGIN
    GOTORC(7,1); WRITE('W'); CLREOL;
    lowvideo; WRITE('-  Width Multiplier -> '); highvideo;
    WRITE(mult_w);
    disp_o
END; {procedure disp_w}


PROCEDURE disp_h;
BEGIN
    GOTORC(8,1); WRITE('H'); CLREOL;
    lowvideo; WRITE('- Height Multiplier -> '); highvideo;
    WRITE(mult_h);
    disp_s
END; {procedure disp_h}


PROCEDURE disp_v;
BEGIN
    GOTORC(9,1); CLREOL;
    IF block_type <> bit THEN BEGIN
        WRITE('V'); lowvideo; WRITE('-     Inverse Video -> '); highvideo;
        IF inv_video THEN
            WRITE('On, Inverse')
        ELSE
            WRITE('Off, Normal')
    END;
    disp_y
END; {procedure disp_v}


PROCEDURE disp_a;
BEGIN
    GOTORC(10,1); CLREOL;
    IF given_offset = 0 THEN BEGIN
        WRITE('A'); lowvideo; WRITE('-    Auto-Centering -> '); highvideo;
        IF centering THEN
            WRITE('Yes')
        ELSE
            WRITE('No ')
    END;
    disp_p
END; {procedure disp_a}


PROCEDURE disp_m;
BEGIN
    GOTORC(11,1); WRITE('M'); CLREOL;
    lowvideo; WRITE('- Given left margin -> '); highvideo;
    IF given_offset = 0 THEN
        WRITE('none defined')
    ELSE
        WRITE(given_offset);
    avail_space;
    disp_l
END; {procedure disp_m}


PROCEDURE disp_g;
BEGIN
    GOTORC(12,1); WRITE('G'); CLREOL;
    lowvideo; WRITE('-       Given Width -> '); highvideo;
    IF given_width = 0 THEN
        WRITE('not given')
    ELSE
        WRITE(given_width);
    disp_c
END; {procedure disp_g}


PROCEDURE disp_q;
BEGIN
    GOTORC(13,1); WRITE('Q'); CLREOL;
    lowvideo; WRITE('- Quit and Return back to OS'); highvideo;
    disp_d
END; {procedure disp_q}


PROCEDURE disp_x;
BEGIN
    GOTORC(14,1); WRITE('X,<cr>'); CLREOL;
    lowvideo; WRITE('- eXit Change Parm'); highvideo;
    disp_e
END; {procedure disp_x}


