/*
 *  USER.H - header file for the User library.
 *  Copyleft (l) Stanislav Sokolov, June 1998 and onwards
 *
 *  This library is subject to GNU General Library Public License ver. 2 of
 *  June 1991 and any later version. See COPYING.LIB for details.
 *
 *  You may freely use this function, provided due credits are given.
 *
 *  Contact the author by e-mail: stanislavs@hotmail.com
 *
 *  Internet:  http://members.tripod.com/~stanislavs/prog/prog.htm
 */

#ifndef __USER_H
#define __USER_H


// *** Box ***
#define B_NONE      0
#define B_SINGLE    1
#define B_DOUBLE    2
#define B_THICK     3
#define B_ALT       4
#define B_NORMAL    5
#define B_INVERSE   6
#define B_TRANSP    7

class Box{
	public:
		Box(void);
		~Box(void);
		void SetParams(const char* Title = NULL, int Style = B_SINGLE, int Zoom = B_NONE, int Shadow = B_TRANSP);
		void SetColor(int BFColor, int BBColor, int SFColor = DARKGRAY, int SBColor = BLACK);
		int Draw(int Top, int Left, int Height, int Width, int SaveBackGr, char AltBorder);
		int Drawn(void) {return IsDrawn;}
		int Erase(void);

	protected:
		int IsDrawn;

		int Top, Left;
		int Style;
		int  BFColor, BBColor, SFColor, SBColor;
		int Zoom, Shadow;
		const char *Title;

		char *Buffer;

		int absHeight, absWidth, SaveBackGr;
};


// *** Centre ***
int Centre(char Row, const char *Text, char StartCol = -1, char EndCol = -1);


// *** Clf ***
void clf(int ForeColor, int BackColor);


// *** InText ***
class GetTxt{
	public:
		char *InText(char *Text, int Length, int Row, int Col, int Width);

	protected:
		struct Txt{
			unsigned char Letter;
			Txt *Next;
			Txt *Prev;
		};

		void PrintStr(int Row, int Col, int CurCol, int Width, Txt *Pointer);
};


// *** RAlign ***
int RAlign(char Row, const char *Text, char Boundary = -1);


#endif