 REM Sicsub1.bas v7.0a r1.0 - Symbolic Instruction Code; module 2 of 3.
 REM The public domain DOS programming interpreter.

 ' get standard include declarations
 REM $INCLUDE: 'SIC.INC'

 REM Include file for BC 7.1 compiler:
 REM Remove remark from following lines:

Rem Declare Function FormatD$(byval a#, b$)
Rem Declare Function Now#()
Rem Declare Function Format$(x#, x$)

' beginning of the command/equation parser
SUB Enter.Equate
 ON LOCAL ERROR GOTO Equate.Error
 Allow.Extra = False
 Out2 = STRIM$(Out2)
 IF Out2 = Nul THEN
    EXIT SUB
 END IF
 Store.Input$ = Out2
 CALL Assignment
 IF Assign THEN
    EXIT SUB
 END IF
 Out2 = Store.Input$
 PName$ = UCASE$(Out2)
 FOR PNumber = 1 TO MaxStatements
    SName$ = Statements(PNumber)
    IF LEFT$(PName$, LEN(SName$)) = SName$ THEN
       IF LEN(PName$) > LEN(SName$) THEN
          IF RIGHT$(SName$, 1) <> "#" THEN
             Bad.Token = False
             Token.Form$ = MID$(PName$, LEN(SName$) + 1, 1)
             SELECT CASE Token.Form$
             CASE "(", "[", "{"
                Token = 2
             CASE "="
                IF RIGHT$(SName$, 1) = "$" THEN
                   Token = 1
                ELSE
                   Bad.Token = True
                END IF
             CASE " "
                Token = False
             CASE ELSE
                Bad.Token = True
             END SELECT
             IF Bad.Token THEN
                Strng = "<unknown statement>"
                ERROR 92
             END IF
          END IF
       END IF
       SELECT CASE PNumber
       CASE 1
	  ' Rem
       CASE 2
	  ' Endif
       CASE 3
	  ' End if
       CASE 4 ' stop
	  Program.Line = Max.Lines
       CASE 5
	  ' Rem
       CASE 6 ' mid$
          CALL Assign.Mid.String
       CASE 7 ' left$
          CALL Assign.Left.String
       CASE 8 ' right$
          CALL Assign.Right.String
       CASE 9 ' print #
          CALL Print.Expression.File
       CASE 10 ' dprint
          CALL Dprint.Expression
       CASE 11 ' lprint
          CALL Lprint.Expression
       CASE 12 ' sprint
          CALL Sprint.Expression
       CASE 13 ' uprint
          CALL Uprint.Expression
       CASE 14 ' input;
          CALL Input.Expression(1)
       CASE 15 ' forif
	  GOSUB Forif.Loop
       CASE 16 ' for
	  GOSUB Loop.Expression
       CASE 17 ' nextif
	  GOSUB Loopif.Terminate
       CASE 18 ' next
	  GOSUB Loop.Terminate
       CASE 19 ' continue for
	  GOSUB Continue.Forif
       CASE 20 ' continue forif
	  GOSUB Continue.For
       CASE 21 ' exit forif
	  GOSUB Exitif.For
       CASE 22 ' exit for
	  GOSUB Exit.For
       CASE 23
	  ' Do.Until
       CASE 24 ' loop while
	  GOSUB End.Do.While
       CASE 25 ' exit do
	  GOSUB Exit.Do
       CASE 26 ' continue do
	  GOSUB Continue.Do
       CASE 27 ' goto
	  GOSUB Branch.To
       CASE 28 ' gosub
	  GOSUB Gosub.Branch
       CASE 29 ' return
	  GOSUB Return.Branch
       CASE 30 ' do while
	  GOSUB Do.While
       CASE 31
	  ' Do
       CASE 32 ' off
	  Program.Line = Max.Lines
       CASE 33 ' if
	  GOSUB If.Branch
       CASE 34 ' elseif
	  GOSUB Else.Branch
       CASE 35 ' caseif else
	  GOSUB Selectif.End
       CASE 36 ' caseif
	  GOSUB Selectif.End
       CASE 37 ' select case
	  GOSUB Select.Case
       CASE 38
          ' End Selectif
       CASE 39 ' beep
	  BEEP
       CASE 40 ' sound
          CALL Sound.Speaker
       CASE 41 ' color
          CALL Change.Color
       CASE 42 ' locate
          CALL Locate.Cursor
       CASE 43 ' cls
          CALL CLS.Screen
       CASE 44 ' screen
          CALL Change.Screen
       CASE 45 ' width
          CALL Change.Width
       CASE 46 ' write #
          CALL Write.Expression.File
       CASE 47 ' line input;
          CALL Line.Input.Expression(1)
       CASE 48 ' line input #
          CALL Line.Input.Exp.File
       CASE 49 ' input #
          CALL Input.Expression.File
       CASE 50 ' wend
	  GOSUB End.While
       CASE 51 ' while
	  GOSUB Do.Wend
       CASE 52 ' continue while
	  GOSUB Continue.While
       CASE 53 ' exit while
	  GOSUB Exit.While
       CASE 54 ' else
	  GOSUB Else.Branch
       CASE 55 ' loop until
	  GOSUB End.Do.Until
       CASE 56 ' loopif
	  GOSUB Loopif.Start
       CASE 57 ' end loopif
	  GOSUB Endloop.If
       CASE 58 ' exit loopif
	  GOSUB Exitloop.If
       CASE 59 ' loop
	  GOSUB End.Do
       CASE 60 ' randmoize
          CALL Seed.Random
       CASE 61 ' poke
          CALL Poke.Value
       CASE 62 ' int86
          CALL Int86.Function
       CASE 63 ' def seg
          CALL Defseg.Function
       CASE 64 ' absolute
          CALL Absolute.Function
       CASE 65 ' out
          CALL Output.Port
       CASE 66 ' wait
          CALL Wait.Port
       CASE 67 ' sleep
          CALL Sleep.Second
       CASE 68 ' pause
          CALL Pause.Second
       CASE 69 ' selectif case
	  GOSUB Selectif.Case
       CASE 70
          ' End Select
       CASE 71 ' case else
	  GOSUB Select.End
       CASE 72 ' case
	  GOSUB Select.End
       CASE 73 ' continue loopif
	  GOSUB Continue.Loopif
       CASE 74 ' end
	  Program.Line = Max.Lines
       CASE 75 ' clear
	  Program.Line = Max.Lines
       CASE 76 ' system
	  Program.Line = Max.Lines
       CASE 77 ' swap
          CALL Swap.Data
       CASE 78 ' error
	  Out2 = MID$(Out2, 6)
	  Out2 = STRIM$(Out2)
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  ERROR CINT(Temp3#)
       CASE 79 ' on error goto
	  Out2 = MID$(Out2, 14)
	  Out2 = STRIM$(Out2)
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  ErrorType = CINT(Temp3#)
       CASE 80 ' on error resume previous
	  ErrorType = -1
       CASE 81 ' on error resume same
	  ErrorType = -2
       CASE 82 ' on error resume next
	  ErrorType = -3
       CASE 83 ' on error stop
	  ErrorType = False
       CASE 84 ' resume previous
	  Program.Line = ErrorLine - 1
	  DO
	     IF LEN(STRIM$(Program(Program.Line))) THEN
		Program.Line = Program.Line - 1
		EXIT DO
	     END IF
	     Program.Line = Program.Line - 1
	     IF Program.Line < 1 THEN
		Program.Line = Max.Lines
		EXIT DO
	     END IF
	  LOOP
       CASE 85 ' resume same
	  Program.Line = ErrorLine - 1
       CASE 86 ' resume next
	  Program.Line = ErrorLine + 1
	  DO
	     IF LEN(STRIM$(Program(Program.Line))) THEN
		Program.Line = Program.Line - 1
		EXIT DO
	     END IF
	     Program.Line = Program.Line + 1
	     IF Program.Line > Last.Line THEN
		EXIT DO
	     END IF
	  LOOP
       CASE 87 ' resume
	  Out2 = MID$(Out2, 7)
	  Out2 = STRIM$(Out2)
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Program.Line = CINT(Temp3#) - 1
       CASE 88 ' on x goto/gosub
	  GOSUB Multi.Branch
       CASE 89 ' date$=
          CALL Set.Date
       CASE 90 ' time$=
          CALL Set.Time
       CASE 91 ' chdrive
          CALL Change.Drive
       CASE 92 ' cd
          CALL CD.Directory(1)
       CASE 93 ' chdir
          CALL CD.Directory(2)
       CASE 94 ' md
          CALL MD.Directory(1)
       CASE 95 ' mkdir
          CALL MD.Directory(2)
       CASE 96 ' rd
          CALL RD.Directory(1)
       CASE 97 ' rmdir
          CALL RD.Directory(2)
       CASE 98 ' kill
          CALL Kill.File(1)
       CASE 99 ' delete
          CALL Kill.File(2)
       CASE 100 ' rename
          CALL Name.Expression(1)
       CASE 101 ' name
          CALL Name.Expression(2)
       CASE 102 ' shell
          CALL Shell.Program
       CASE 103 ' chain
          CALL Chain.Program
       CASE 104 ' let
          CALL Assign.Keyword
       CASE 105 ' close #
          CALL Close.File(1)
       CASE 106 ' open #
          CALL Open.File
       CASE 107 ' field #
          CALL Open.Field
       CASE 108 ' write
          CALL Write.Expression
       CASE 109 ' print
          CALL Print.Expression
       CASE 110 ' input
          CALL Input.Expression(2)
       CASE 111 ' line input
          CALL Line.Input.Expression(2)
       CASE 112 ' lset #
          CALL Field.Set(1)
       CASE 113 ' rset #
          CALL Field.Set(2)
       CASE 114 ' put #
          CALL Put.Record
       CASE 115 ' get #
          CALL Get.Record
       CASE 116 ' read #
          CALL Read.Record
       CASE 117
	  ' Data
       CASE 118 ' read
          CALL Read.Data
       CASE 119 ' restore
          CALL Restore.Data
       CASE 120 ' circle step
          CALL Draw.Circle.Step
       CASE 121 ' line step
          CALL Draw.Line.Step
       CASE 122 ' pset
          CALL Draw.Pixel
       CASE 123 ' preset
          CALL Draw.PixelX
       CASE 124 ' paint
          CALL Paint.Area
       CASE 125 ' draw
          CALL Draw.Expression
       CASE 126 ' play
          CALL Play.Expression
       CASE 127 ' get
          CALL Get.Graphics
       CASE 128 ' put
          CALL Put.Graphics
       CASE 129 ' bsave
          CALL BSave.Image
       CASE 130 ' bload
          CALL BLoad.Image
       CASE 131 ' view screen
          CALL View.Screen(1)
       CASE 132 ' view
          CALL View.Screen(2)
       CASE 133 ' window screen
          CALL Window.Screen(1)
       CASE 134 ' window
          CALL Window.Screen(2)
       CASE 135 ' circle
          CALL Draw.Circle
       CASE 136 ' line
          CALL Draw.Line
       CASE 137 ' close
          CALL Close.File(2)
       CASE 138 ' DEF FN
          CALL Define.Function
       END SELECT
       EXIT SUB
    END IF
 NEXT
 ERROR 91
Equate.Exit:
 EXIT SUB

Forif.Loop:
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 IF Strng = "," THEN
    IF Temp4# THEN
       Out2 = UCASE$(MID$(Out2, Token.Index))
       Out2 = STRIM$(Out2)
       Temp1$ = UCASE$(LEFT$(Out2, 1))
       IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
	  Element = ASC(Temp1$) - 64
	  Out2 = MID$(Out2, 2)
	  Out2 = STRIM$(Out2)
	  IF LEFT$(Out2, 1) = "=" THEN
	     Out2 = MID$(Out2, 2)
	     Out2 = STRIM$(Out2)
	     FinishFor = Dfalse
	     StepTo = 1#
	     ExceptStep = Dfalse
             ExceptStepIs = False
	     CALL Equate(StartFor#)
	     Variables(Element) = StartFor#
             IF ExceptStepIs THEN
                IF StartFor# = ExceptStep THEN
                   IF StartFor# = FinishFor THEN
                      GOTO Loopif.Ignore
                   ELSE
                      GOSUB Loopif.Ignore
                      Program.Line = Program.Line - 1
                      RETURN
                   END IF
                END IF
             END IF
	     IF StepTo > Dfalse THEN
		IF StartFor# > FinishFor THEN
		   GOTO Loopif.Ignore
		END IF
	     END IF
	     IF StepTo < Dfalse THEN
		IF StartFor# < FinishFor THEN
		   GOTO Loopif.Ignore
		END IF
	     END IF
	     RETURN
	  END IF
       END IF
    ELSE
       GOTO Loopif.Ignore
    END IF
    RETURN
 END IF
 ERROR 103
 RETURN

Loopif.Ignore:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbeddedif.Ignore
    IF Imbedded THEN
       GOTO Loopif.Ignore
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 6)) = "NEXTIF" THEN
       Program.Line = Count1
       RETURN
    END IF
 NEXT
 ERROR 103
 RETURN

Imbeddedif.Ignore:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 5)) <> "FORIF" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "FORIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 6)) = "NEXTIF" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 103
 RETURN

Loopif.Terminate:
 For.Loop = Program.Line
Nextif.For:
 FOR Count1 = Program.Line - 1 TO 1 STEP -1
    GOSUB Imbeddedif.For
    IF Imbedded THEN
       GOTO Nextif.For
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "FORIF" THEN
       Out2 = MID$(Temp1$, 6)
       Out2 = STRIM$(Out2)
       Token.Index = 1
       CALL Get.Token
       CALL Parse1(Temp4#)
       IF Strng = "," THEN
	  IF Temp4# THEN
             Out2 = UCASE$(MID$(Out2, Token.Index))
	     Out2 = STRIM$(Out2)
	     Temp1$ = UCASE$(LEFT$(Out2, 1))
	     IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
		Element = ASC(Temp1$) - 64
                Out2 = MID$(Out2, 2)
                Out2 = STRIM$(Out2)
                IF LEFT$(Out2, 1) = "=" THEN
                   Out2 = MID$(Out2, 2)
                   Out2 = STRIM$(Out2)
                   FinishFor = Dfalse
                   StepTo = 1#
                   ExceptStep = Dfalse
                   ExceptStepIs = False
                   CALL Equate(X#)
                   Variable# = Variables(Element)
                   Variable# = Variable# + StepTo
                   Variables(Element) = Variable#
                   IF ExceptStepIs THEN
                      IF Variable# = ExceptStep THEN
                         Program.Line = For.Loop - 1
                         RETURN
                      END IF
                   END IF
                   IF StepTo > Dfalse THEN
                      IF Variable# <= FinishFor THEN
                         Program.Line = Count1
                      ELSE
                         Program.Line = For.Loop
                      END IF
                      RETURN
                   ELSE
                      IF StepTo < Dfalse THEN
                         IF Variable# >= FinishFor THEN
                            Program.Line = Count1
                         ELSE
                            Program.Line = For.Loop
                         END IF
                         RETURN
                      END IF
                   END IF
                END IF
	     END IF
	  ELSE
	     Program.Line = Count1
	  END IF
	  RETURN
       END IF
       ERROR 103
       RETURN
    END IF
 NEXT
 ERROR 103
 RETURN

Imbeddedif.For:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 6)) <> "NEXTIF" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 > 1
    Count2 = Count2 - 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 6)) = "NEXTIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 5)) = "FORIF" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 103
 RETURN

Continue.Forif:
 Nested = 1
 Out2 = MID$(Out2, 15)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "FORIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 6)) = "NEXTIF" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1 - 1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 103
 RETURN

Exitif.For:
 Nested = 1
 Out2 = MID$(Out2, 11)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "FORIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 6)) = "NEXTIF" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 103
 RETURN

Loop.Expression:
 Out2 = MID$(Out2, 4)
 Out2 = STRIM$(Out2)
 Temp1$ = UCASE$(LEFT$(Out2, 1))
 IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
    Element = ASC(Temp1$) - 64
    Out2 = MID$(Out2, 2)
    Out2 = STRIM$(Out2)
    IF LEFT$(Out2, 1) = "=" THEN
       Out2 = MID$(Out2, 2)
       Out2 = STRIM$(Out2)
       FinishFor = Dfalse
       StepTo = 1#
       ExceptStep = Dfalse
       ExceptStepIs = False
       CALL Equate(StartFor#)
       Variables(Element) = StartFor#
       IF ExceptStepIs THEN
          IF StartFor# = ExceptStep THEN
             IF StartFor# = FinishFor THEN
                GOTO Loop.Ignore
             ELSE
                GOSUB Loop.Ignore
                Program.Line = Program.Line - 1
                RETURN
             END IF
	  END IF
       END IF
       IF StepTo > Dfalse THEN
	  IF StartFor# > FinishFor THEN
	     GOTO Loop.Ignore
	  END IF
       END IF
       IF StepTo < Dfalse THEN
	  IF StartFor# < FinishFor THEN
	     GOTO Loop.Ignore
	  END IF
       END IF
       RETURN
    END IF
 END IF
 ERROR 97
 RETURN

Loop.Ignore:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbedded.Ignore
    IF Imbedded THEN
       GOTO Loop.Ignore
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 4)) = "NEXT" THEN
       IF UCASE$(LEFT$(Temp1$, 6)) <> "NEXTIF" THEN
          Program.Line = Count1
          RETURN
       END IF
    END IF
 NEXT
 ERROR 97
 RETURN

Imbedded.Ignore:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 5)) <> "FORIF" THEN
    RETURN
 END IF
 IF UCASE$(LEFT$(Temp1$, 3)) <> "FOR" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 3)) = "FOR" THEN
       IF UCASE$(LEFT$(Temp1$, 5)) <> "FORIF" THEN
          Nested = Nested + 1
       END IF
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "NEXT" THEN
       IF UCASE$(LEFT$(Temp1$, 6)) <> "NEXTIF" THEN
          Nested = Nested - 1
       END IF
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 97
 RETURN

Loop.Terminate:
 For.Loop = Program.Line
Next.For:
 FOR Count1 = Program.Line - 1 TO 1 STEP -1
    GOSUB Imbedded.For
    IF Imbedded THEN
       GOTO Next.For
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 3)) = "FOR" THEN
       IF UCASE$(LEFT$(Temp1$, 5)) <> "FORIF" THEN
          Temp1$ = MID$(Temp1$, 4)
          Temp1$ = STRIM$(Temp1$)
          Temp2$ = UCASE$(LEFT$(Temp1$, 1))
          IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
             Element = ASC(Temp2$) - 64
             Out2 = MID$(Temp1$, 2)
             Out2 = STRIM$(Out2)
             IF LEFT$(Out2, 1) = "=" THEN
                Out2 = MID$(Out2, 2)
                Out2 = STRIM$(Out2)
                FinishFor = Dfalse
                StepTo = 1#
                ExceptStep = Dfalse
                ExceptStepIs = False
                CALL Equate(X#)
                Variable# = Variables(Element)
                Variable# = Variable# + StepTo
                Variables(Element) = Variable#
                IF ExceptStepIs THEN
                   IF Variable# = ExceptStep THEN
                      Program.Line = For.Loop - 1
                      RETURN
                   END IF
                END IF
                IF StepTo > Dfalse THEN
                   IF Variable# <= FinishFor THEN
                      Program.Line = Count1
                   ELSE
                      Program.Line = For.Loop
                   END IF
                   RETURN
                ELSE
                   IF StepTo < Dfalse THEN
                      IF Variable# >= FinishFor THEN
                         Program.Line = Count1
                      ELSE
                         Program.Line = For.Loop
                      END IF
                      RETURN
                   END IF
                END IF
             END IF
          END IF
       END IF
    END IF
 NEXT
 ERROR 97
 RETURN

Imbedded.For:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 6)) = "NEXTIF" THEN
    RETURN
 END IF
 IF UCASE$(LEFT$(Temp1$, 4)) <> "NEXT" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 > 1
    Count2 = Count2 - 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 4)) = "NEXT" THEN
       IF UCASE$(LEFT$(Temp1$, 6)) <> "NEXTIF" THEN
          Nested = Nested + 1
       END IF
    END IF
    IF UCASE$(LEFT$(Temp1$, 3)) = "FOR" THEN
       IF UCASE$(LEFT$(Temp1$, 5)) <> "FORIF" THEN
          Nested = Nested - 1
       END IF
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 97
 RETURN

Continue.For:
 Nested = 1
 Out2 = MID$(Out2, 13)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 3)) = "FOR" THEN
       IF UCASE$(LEFT$(Temp1$, 5)) <> "FORIF" THEN
          Nested = Nested + 1
       END IF
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "NEXT" THEN
       IF UCASE$(LEFT$(Temp1$, 6)) <> "NEXTIF" THEN
          Nested = Nested - 1
          IF Nested = False THEN
             Program.Line = Count1 - 1
             RETURN
          END IF
       END IF
    END IF
 NEXT
 ERROR 97
 RETURN

Exit.For:
 Nested = 1
 Out2 = MID$(Out2, 9)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 3)) = "FOR" THEN
       IF UCASE$(LEFT$(Temp1$, 5)) <> "FORIF" THEN
          Nested = Nested + 1
       END IF
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "NEXT" THEN
       IF UCASE$(LEFT$(Temp1$, 6)) <> "NEXTIF" THEN
          Nested = Nested - 1
          IF Nested = False THEN
             Program.Line = Count1
             RETURN
          END IF
       END IF
    END IF
 NEXT
 ERROR 97
 RETURN

End.Do.While:
 Out2 = MID$(Out2, 11)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 IF Temp3# = Dtrue THEN
    GOTO End.Do
 END IF
 RETURN
End.Do.Until:
 Out2 = MID$(Out2, 11)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 IF Temp3# = Dfalse THEN
    GOTO End.Do
 END IF
 RETURN
End.Do:
 Loop.Line = Program.Line
Next.Do:
 FOR Count1 = Program.Line - 1 TO 1 STEP -1
    GOSUB Imbedded.Loop
    IF Imbedded THEN
       GOTO Next.Do
    END IF
    Temp1$ = STRIM$(Program(Count1))
    IF UCASE$(LEFT$(Temp1$, 2)) = "DO" THEN
       IF UCASE$(LEFT$(Temp1$, 8)) = "DO WHILE" THEN
	  Out2 = MID$(Temp1$, 9)
	  Out2 = STRIM$(Out2)
	  CALL Equate(Temp3#)
	  IF Temp3# = Dfalse THEN
	     Program.Line = Loop.Line
	  ELSE
	     Program.Line = Count1
	  END IF
	  RETURN
       ELSE
	  IF UCASE$(LEFT$(Temp1$, 8)) = "DO UNTIL" THEN
	     Out2 = MID$(Temp1$, 9)
	     Out2 = STRIM$(Out2)
	     CALL Equate(Temp3#)
	     IF Temp3# <> Dfalse THEN
		Program.Line = Loop.Line
	     ELSE
		Program.Line = Count1
	     END IF
	     RETURN
	  ELSE
	     Program.Line = Count1
	     RETURN
	  END IF
       END IF
    END IF
 NEXT
 ERROR 98
 RETURN

Loopif.Start:
 Unless.Branch = False
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 IF Out2 = Nul THEN
    ERROR 104
 END IF
 CALL Equate(Temp3#)
 IF Temp3# THEN
    IF Unless.Branch = False THEN
       RETURN
    ELSE
       IF Unless.Value = Dfalse THEN
	  RETURN
       END IF
    END IF
 END IF
 Nested = 1
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 6)) = "LOOPIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 10)) = "END LOOPIF" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 104
 RETURN

Endloop.If:
 Loop.Line = Program.Line
Next.Ifdo:
 FOR Count1 = Program.Line - 1 TO 1 STEP -1
    GOSUB Imbedded.Loopif
    IF Imbedded THEN
       GOTO Next.Ifdo
    END IF
    Temp1$ = STRIM$(Program(Count1))
    IF UCASE$(LEFT$(Temp1$, 6)) = "LOOPIF" THEN
       Out2 = MID$(Temp1$, 7)
       Out2 = STRIM$(Out2)
       CALL Equate(Temp3#)
       IF Temp3# = Dfalse THEN
	  Program.Line = Loop.Line
       ELSE
	  Program.Line = Count1
       END IF
       RETURN
    END IF
 NEXT
 ERROR 104
 RETURN

Exitloop.If:
 Nested = 1
 Out2 = MID$(Out2, 12)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 6)) = "LOOPIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 10)) = "END LOOPIF" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 104
 RETURN

Imbedded.Loopif:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 10)) <> "END LOOPIF" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 > 1
    Count2 = Count2 - 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 10)) = "END LOOPIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 6)) = "LOOPIF" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 104
 RETURN

Continue.Loopif:
 Nested = 1
 Out2 = MID$(Out2, 16)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 6)) = "LOOPIF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 10)) = "END LOOPIF" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1 - 1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 104
 RETURN

Imbedded.Loop:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 6)) = "LOOPIF" THEN
    RETURN
 END IF
 IF UCASE$(LEFT$(Temp1$, 4)) <> "LOOP" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 > 1
    Count2 = Count2 - 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 4)) = "LOOP" THEN
       IF UCASE$(LEFT$(Temp1$, 6)) <> "LOOPIF" THEN
          Nested = Nested + 1
       END IF
    END IF
    IF UCASE$(LEFT$(Temp1$, 2)) = "DO" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 98
 RETURN

Continue.Do:
 Nested = 1
 Out2 = MID$(Out2, 12)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 2)) = "DO" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "LOOP" THEN
       IF UCASE$(LEFT$(Temp1$, 6)) <> "LOOPIF" THEN
          Nested = Nested - 1
          IF Nested = False THEN
             Program.Line = Count1 - 1
             RETURN
          END IF
       END IF
    END IF
 NEXT
 ERROR 98
 RETURN

Exit.Do:
 Nested = 1
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 2)) = "DO" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "LOOP" THEN
       IF UCASE$(LEFT$(Temp1$, 6)) <> "LOOPIF" THEN
          Nested = Nested - 1
          IF Nested = False THEN
             Program.Line = Count1
             RETURN
          END IF
       END IF
    END IF
 NEXT
 ERROR 98
 RETURN

Branch.To:
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 Branch.Loop = CINT(Temp3#)
 IF Branch.Loop > False AND Branch.Loop <= Last.Line THEN
    Temp1$ = STRIM$(Program(Branch.Loop))
    IF Temp1$ <> Nul THEN
       Program.Line = Branch.Loop - 1
       RETURN
    END IF
 END IF
 ERROR 99
 RETURN

Gosub.Branch:
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 Branch.Loop = CINT(Temp3#)
 IF Branch.Loop > False AND Branch.Loop <= Last.Line THEN
    Temp1$ = STRIM$(Program(Branch.Loop))
    IF Temp1$ <> Nul THEN
       Nested.Gosub = Nested.Gosub + 1
       IF Nested.Gosub = Max.Gosubs THEN
	  Max.Gosubs = Max.Gosubs + 10
	  REDIM PRESERVE GosubReturn(1 TO Max.Gosubs) AS INTEGER
       END IF
       GosubReturn(Nested.Gosub) = Program.Line
       Program.Line = Branch.Loop - 1
       RETURN
    END IF
 END IF
 ERROR 99
 RETURN

Return.Branch:
 IF Nested.Gosub > False THEN
    Program.Line = GosubReturn(Nested.Gosub)
    Nested.Gosub = Nested.Gosub - 1
    RETURN
 END IF
 ERROR 100
 RETURN

Do.While:
 Out2 = MID$(Out2, 9)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 IF Temp3# = Dfalse THEN
Do.Branch:
    FOR Count1 = Program.Line + 1 TO Last.Line
       GOSUB Imbedded.Do
       IF Imbedded THEN
	  GOTO Do.Branch
       END IF
       Temp1$ = Program(Count1)
       Temp1$ = STRIM$(Temp1$)
       IF UCASE$(LEFT$(Temp1$, 4)) = "LOOP" THEN
          IF UCASE$(LEFT$(Temp1$, 6)) <> "LOOPIF" THEN
             Program.Line = Count1
             RETURN
          END IF
       END IF
    NEXT
    ERROR 98
 END IF
 RETURN

Imbedded.Do:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 2)) <> "DO" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 2)) = "DO" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "LOOP" THEN
       IF UCASE$(LEFT$(Temp1$, 6)) <> "LOOPIF" THEN
          Nested = Nested - 1
       END IF
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 98
 RETURN

Multi.Branch:
 Out2 = MID$(Out2, 3)
 Out2 = STRIM$(Out2)
 Branch.Index = False
 Branch.Number = False
 Branch.Type = False
 Next.Branch = INSTR(UCASE$(Out2), "GOTO")
 IF Next.Branch THEN
    Branch.Type = 1
    OutX$ = MID$(Out2, Next.Branch + 4)
    Out2 = LEFT$(Out2, Next.Branch - 1)
 ELSE
    Next.Branch = INSTR(UCASE$(Out2), "GOSUB")
    IF Next.Branch THEN
       Branch.Type = 2
       OutX$ = MID$(Out2, Next.Branch + 5)
       Out2 = LEFT$(Out2, Next.Branch - 1)
    END IF
 END IF
 IF Branch.Type = False THEN
    ERROR 99
 END IF
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Branch.Index = CINT(Temp3#)
 IF Branch.Index <= False THEN
    EXIT SUB
 END IF
 IF Branch.Type = 1 THEN
    Token.Index = 1
    Out2 = OutX$
    CALL Get.Token
    CALL Parse1(Temp4#)
    FOR Index.Count = 1 TO Branch.Index - 1
       IF Strng <> "," THEN
          Temp4# = DFalse
          EXIT FOR
       END IF
       CALL Get.Token
       CALL Parse1(Temp4#)
    NEXT
    Branch.Number = CINT(Temp4#)
    IF Branch.Number = False THEN
       RETURN
    END IF
    IF Branch.Number > False AND Branch.Number <= Last.Line THEN
       Temp1$ = STRIM$(Program(Branch.Number))
       IF Temp1$ <> Nul THEN
          Program.Line = Branch.Number - 1
          RETURN
       END IF
    END IF
 ELSE
    IF Branch.Type = 2 THEN
       Token.Index = 1
       Out2 = OutX$
       CALL Get.Token
       CALL Parse1(Temp4#)
       FOR Index.Count = 1 TO Branch.Index - 1
          IF Strng <> "," THEN
             Temp4# = DFalse
             EXIT FOR
          END IF
          CALL Get.Token
          CALL Parse1(Temp4#)
       NEXT
       Branch.Number = CINT(Temp4#)
       IF Branch.Number = False THEN
          RETURN
       END IF
       IF Branch.Number > False AND Branch.Number <= Last.Line THEN
          Temp1$ = STRIM$(Program(Branch.Number))
          IF Temp1$ <> Nul THEN
             Nested.Gosub = Nested.Gosub + 1
             IF Nested.Gosub = Max.Gosubs THEN
                Max.Gosubs = Max.Gosubs + 10
                REDIM PRESERVE GosubReturn(1 TO Max.Gosubs) AS INTEGER
             END IF
             GosubReturn(Nested.Gosub) = Program.Line
             Program.Line = Branch.Number - 1
             RETURN
          END IF
       END IF
    END IF
 END IF
 ERROR 99
 RETURN

If.Branch:
 Unless.Branch = False
 Out2 = MID$(Out2, 3)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 IF Temp3# THEN
    IF Unless.Branch = False THEN
       RETURN
    ELSE
       IF Unless.Value = Dfalse THEN
	  RETURN
       END IF
    END IF
 END IF
Endif.Branch:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbedded.Endif
    IF Imbedded THEN
       GOTO Endif.Branch
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 6)) = "ELSEIF" THEN
       Program.Line = Count1
       Out2 = UCASE$(MID$(Temp1$, 5))
       GOTO If.Branch
       RETURN
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "ELSE" THEN
       Program.Line = Count1
       RETURN
    END IF
    IF UCASE$(LEFT$(Temp1$, 5)) = "ENDIF" OR UCASE$(LEFT$(Temp1$, 6)) = "END IF" THEN
       Program.Line = Count1
       RETURN
    END IF
 NEXT
 ERROR 99
 RETURN

Else.Branch:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbedded.Endif
    IF Imbedded THEN
       GOTO Else.Branch
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "ENDIF" OR UCASE$(LEFT$(Temp1$, 6)) = "END IF" THEN
       Program.Line = Count1
       RETURN
    END IF
 NEXT
 ERROR 99
 RETURN

Imbedded.Endif:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 2)) <> "IF" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 2)) = "IF" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 5)) = "ENDIF" OR UCASE$(LEFT$(Temp1$, 6)) = "END IF" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 99
 RETURN

Do.Wend:
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 CALL Equate(Temp3#)
 IF Temp3# = Dfalse THEN
While.Branch:
    FOR Count1 = Program.Line + 1 TO Last.Line
       GOSUB Imbedded.Wend
       IF Imbedded THEN
	  GOTO While.Branch
       END IF
       Temp1$ = Program(Count1)
       Temp1$ = STRIM$(Temp1$)
       IF UCASE$(LEFT$(Temp1$, 4)) = "WEND" THEN
	  Program.Line = Count1
	  RETURN
       END IF
    NEXT
    ERROR 98
 END IF
 RETURN

Imbedded.Wend:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 5)) <> "WHILE" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "WHILE" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "WEND" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 98
 RETURN

End.While:
 Loop.Line = Program.Line
Next.While:
 FOR Count1 = Program.Line - 1 TO 1 STEP -1
    GOSUB Imbedded.While
    IF Imbedded THEN
       GOTO Next.While
    END IF
    Temp1$ = STRIM$(Program(Count1))
    IF UCASE$(LEFT$(Temp1$, 5)) = "WHILE" THEN
       Out2 = MID$(Temp1$, 6)
       Out2 = STRIM$(Out2)
       CALL Equate(Temp3#)
       IF Temp3# = Dfalse THEN
	  Program.Line = Loop.Line
       ELSE
	  Program.Line = Count1
       END IF
       RETURN
    END IF
 NEXT
 ERROR 98
 RETURN

Imbedded.While:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 4)) <> "WEND" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 > 1
    Count2 = Count2 - 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 4)) = "WEND" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 5)) = "WHILE" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 98
 RETURN

Continue.While:
 Nested = 1
 Out2 = MID$(Out2, 15)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "WHILE" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "WEND" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1 - 1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 98
 RETURN

Exit.While:
 Nested = 1
 Out2 = MID$(Out2, 11)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Last.Token = False
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Temp3# > Dfalse AND Temp3# <= 255 THEN
       Nested = CINT(Temp3#)
    END IF
 END IF
 FOR Count1 = Program.Line + 1 TO Last.Line
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "WHILE" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 4)) = "WEND" THEN
       Nested = Nested - 1
       IF Nested = False THEN
	  Program.Line = Count1
	  RETURN
       END IF
    END IF
 NEXT
 ERROR 98
 RETURN

Select.End:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbedded.Select
    IF Imbedded THEN
       GOTO Select.End
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 12)) <> "END SELECTIF" THEN
       IF UCASE$(LEFT$(Temp1$, 10)) = "END SELECT" THEN
          Program.Line = Count1
          RETURN
       END IF
    END IF
 NEXT
 ERROR 102
 RETURN

Selectif.End:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbeddedif.Select
    IF Imbedded THEN
       GOTO Selectif.End
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 12)) = "END SELECTIF" THEN
       Program.Line = Count1
       RETURN
    END IF
 NEXT
 ERROR 105
 RETURN

Select.Case:
 Last.Token = False
 Out2 = MID$(Out2, 12)
 CALL Equate(Temp3#)
 IF Last.Token THEN
    CaseValue = Temp3#
 ELSE
    CaseStrng = Out3
 END IF
 Previous.Token = Last.Token
Next.Select.Case:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbedded.Select
    IF Imbedded THEN
       GOTO Next.Select.Case
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 12)) <> "END SELECTIF" THEN
       IF UCASE$(LEFT$(Temp1$, 10)) = "END SELECT" THEN
          Program.Line = Count1
          RETURN
       END IF
    END IF
    IF UCASE$(LEFT$(Temp1$, 9)) = "CASE ELSE" THEN
       Program.Line = Count1
       RETURN
    END IF
    IF UCASE$(LEFT$(Temp1$, 6)) <> "CASEIF" THEN
       IF UCASE$(LEFT$(Temp1$, 4)) = "CASE" THEN
          Out2 = MID$(Temp1$, 5)
          Out2 = STRIM$(Out2)
          Token.Index = 1
          DO
             IF Last.Token <> 1 THEN
                Last.Token = False
                CALL Get.Token
             END IF
             CALL Parse1(Temp4#)
             SELECT CASE Last.Token
             CASE -1
                IF CaseValue = Temp4# THEN
                   Program.Line = Count1
                   RETURN
                END IF
             CASE 0
                IF CaseStrng = Out3 THEN
                   Program.Line = Count1
                   RETURN
                END IF
             CASE 1
                IF ValueIs THEN
                   Program.Line = Count1
                   RETURN
                END IF
             CASE 2
                IF Previous.Token THEN
                   IF CaseValue >= CaseValue1 AND CaseValue <= CaseValue2 THEN
                      Program.Line = Count1
                      RETURN
                   END IF
                ELSE
                   IF CaseStrng >= CaseValueS1 AND CaseStrng <= CaseValueS2 THEN
                      Program.Line = Count1
                      RETURN
                   END IF
                END IF
             END SELECT
             IF Token.Index > LEN(Out2) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
 NEXT
 ERROR 102
 RETURN

Selectif.Case:
 Out2 = MID$(Out2, 14)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 IF Strng = "," THEN
    IF Temp4# THEN
       Out2 = UCASE$(MID$(Out2, Token.Index))
       Out2 = STRIM$(Out2)
       Last.Token = False
       CALL Equate(Temp3#)
       IF Last.Token THEN
	  CaseValue = Temp3#
       ELSE
	  CaseStrng = Out3
       END IF
       Previous.Token = Last.Token
Next.Selectif.Case:
       FOR Count1 = Program.Line + 1 TO Last.Line
	  GOSUB Imbeddedif.Select
	  IF Imbedded THEN
	     GOTO Next.Selectif.Case
	  END IF
	  Temp1$ = Program(Count1)
	  Temp1$ = STRIM$(Temp1$)
          IF UCASE$(LEFT$(Temp1$, 12)) = "END SELECTIF" THEN
	     Program.Line = Count1
	     RETURN
	  END IF
	  IF UCASE$(LEFT$(Temp1$, 11)) = "CASEIF ELSE" THEN
	     Program.Line = Count1
	     RETURN
	  END IF
	  IF UCASE$(LEFT$(Temp1$, 6)) = "CASEIF" THEN
	     Out2 = MID$(Temp1$, 7)
	     Out2 = STRIM$(Out2)
	     Token.Index = 1
	     DO
                IF Last.Token <> 1 THEN
                   Last.Token = False
                   CALL Get.Token
                END IF
		CALL Parse1(Temp4#)
		SELECT CASE Last.Token
		CASE -1
		   IF CaseValue = Temp4# THEN
		      Program.Line = Count1
		      RETURN
		   END IF
		CASE 0
		   IF CaseStrng = Out3 THEN
		      Program.Line = Count1
		      RETURN
		   END IF
		CASE 1
		   IF ValueIs THEN
		      Program.Line = Count1
		      RETURN
		   END IF
		CASE 2
		   IF Previous.Token THEN
		      IF CaseValue >= CaseValue1 AND CaseValue <= CaseValue2 THEN
			 Program.Line = Count1
			 RETURN
		      END IF
		   ELSE
		      IF CaseStrng >= CaseValueS1 AND CaseStrng <= CaseValueS2 THEN
			 Program.Line = Count1
			 RETURN
		      END IF
		   END IF
		END SELECT
		IF Token.Index > LEN(Out2) THEN
		   EXIT DO
		END IF
	     LOOP
	  END IF
       NEXT
    ELSE
       GOTO Selectif.Ignore
    END IF
    RETURN
 END IF
 ERROR 105
 RETURN

Selectif.Ignore:
 FOR Count1 = Program.Line + 1 TO Last.Line
    GOSUB Imbeddedselectif.Ignore
    IF Imbedded THEN
       GOTO Selectif.Ignore
    END IF
    Temp1$ = Program(Count1)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 12)) = "END SELECTIF" THEN
       Program.Line = Count1
       RETURN
    END IF
 NEXT
 ERROR 105
 RETURN

Imbeddedselectif.Ignore:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 13)) <> "SELECTIF CASE" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 5)) = "SELECTIF CASE" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 6)) = "END SELECTIF" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 105
 RETURN

Imbedded.Select:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 11)) <> "SELECT CASE" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 11)) = "SELECT CASE" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 12)) <> "END SELECTIF" THEN
       IF UCASE$(LEFT$(Temp1$, 10)) = "END SELECT" THEN
          Nested = Nested - 1
       END IF
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 102
 RETURN

Imbeddedif.Select:
 Imbedded = False
 Temp1$ = Program(Count1)
 Temp1$ = STRIM$(Temp1$)
 IF UCASE$(LEFT$(Temp1$, 13)) <> "SELECTIF CASE" THEN
    RETURN
 END IF
 Imbedded = True
 Nested = 1
 Count2 = Count1
 DO WHILE Count2 < Last.Line
    Count2 = Count2 + 1
    Temp1$ = Program(Count2)
    Temp1$ = STRIM$(Temp1$)
    IF UCASE$(LEFT$(Temp1$, 13)) = "SELECTIF CASE" THEN
       Nested = Nested + 1
    END IF
    IF UCASE$(LEFT$(Temp1$, 12)) = "END SELECTIF" THEN
       Nested = Nested - 1
    END IF
    IF Nested = False THEN
       Program.Line = Count2
       RETURN
    END IF
 LOOP
 ERROR 105
 RETURN

Equate.Error:
 ErrorLine = Program.Line
 ErrorValue = ERR
 SELECT CASE ErrorType
 CASE -1
    DO
       Program.Line = Program.Line - 1
       IF LEN(STRIM$(Program(Program.Line))) THEN
	  Program.Line = Program.Line - 1
	  RESUME Equate.Exit
       END IF
       IF Program.Line <= False THEN
	  EXIT DO
       END IF
    LOOP
 CASE -2
    Program.Line = Program.Line - 1
    RESUME Equate.Exit
 CASE -3
    DO
       Program.Line = Program.Line + 1
       IF LEN(STRIM$(Program(Program.Line))) THEN
	  Program.Line = Program.Line - 1
	  RESUME Equate.Exit
       END IF
       IF Program.Line >= Last.Line THEN
	  EXIT DO
       END IF
    LOOP
 CASE 0
    ' nul
 CASE IS > 0
    Program.Line = ErrorType
    IF LEN(STRIM$(Program(Program.Line))) THEN
       Program.Line = Program.Line - 1
       RESUME Equate.Exit
    END IF
 END SELECT
 PrinterLF = False
 Printing = False
 Program.Line = Max.Lines
 ErrorValue = ERR
 IF POS(0) > 1 THEN
    PRINT
 END IF
 IF LastScreen1 <> 0 THEN
    SCREEN 0, 1, 0, 0
 ELSE
    IF LastScreen2 <> 1 THEN
       SCREEN 0, 1, 0, 0
    ELSE
       IF LastScreen3 <> 0 OR LastScreen4 <> 0 THEN
          SCREEN 0, 1, 0, 0
       END IF
    END IF
 END IF
 Out2=Nul
 CALL Display.Error
 IF Program.Resume <= False THEN
    CALL Key.Prompt
 END IF
 RESUME Equate.Exit
 RETURN
END SUB

SUB Assign.Keyword
 Temp1$ = UCASE$(MID$(Out2, 4))
 Temp1$ = STRIM$(Temp1$)
 Out2 = MID$(Out2, 4)
 Out2 = STRIM$(Out2)
 IF LEFT$(Temp1$, 3) = "MID" THEN
    CALL Assign.Mid.String
    EXIT SUB
 END IF
 IF LEFT$(Temp1$, 4) = "LEFT" THEN
    CALL Assign.Left.String
    EXIT SUB
 END IF
 IF LEFT$(Temp1$, 5) = "RIGHT" THEN
    CALL Assign.Right.String
    EXIT SUB
 END IF
 CALL Assignment
END SUB

SUB Assignment
 Assign = False
 Temp1$ = UCASE$(LEFT$(Out2, 1))
 IF Temp1$="?" THEN
    Temp1$ = MID$(Out2,2)
    Temp2$ = LEFT$(Temp1$, 1)
    IF Temp2$ = "=" THEN
       Temp1$ = MID$(Temp1$, 2)
       Out2 = Temp1$
       CALL Equate(Temp4#)
       Assign = True
       EXIT SUB
    END IF
 END IF
 IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
    Variable = ASC(Temp1$) - 64
    Temp1$ = MID$(Out2, 2)
    Temp2$ = UCASE$(LEFT$(Temp1$, 1))
    IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
       Temp2$ = MID$(Out2, 3)
       Y$ = UCASE$(LEFT$(Temp2$, 1))
       IF Y$ >= "A" AND Y$ <= "Z" THEN
	  Y$ = MID$(Out2, 4)
	  Z$ = UCASE$(LEFT$(Y$, 1))
	  Z$ = STRIM$(Z$)
	  IF LEFT$(Z$, 1) = "=" THEN
	     Y$ = MID$(Y$, 2)
	     Y$ = STRIM$(Y$)
	     Z$ = UCASE$(LEFT$(Out2, 3))
	     CALL Assignment4(Y$, Z$)
	     IF Assign THEN
                CALL Assign.End
                EXIT SUB
	     END IF
	  END IF
       ELSE
	  IF Y$ = "=" THEN
	     Y$ = MID$(Out2, 4)
	     Y$ = STRIM$(Y$)
	     Z$ = UCASE$(LEFT$(Out2, 2))
	     CALL Assignment3(Y$, Z$)
	     IF Assign THEN
                CALL Assign.End
                EXIT SUB
	     END IF
	  END IF
       END IF
    END IF
    Temp1$ = STRIM$(Temp1$)
    CALL Assignment1(Temp1$, Variable)
    IF Assign THEN
       CALL Assign.End
       EXIT SUB
    END IF
    IF LEFT$(Temp1$, 1) = "$" THEN
       Temp1$ = MID$(Temp1$, 2)
       Temp1$ = STRIM$(Temp1$)
       IF LEFT$(Temp1$, 1) = "=" THEN
	  Out2 = MID$(Temp1$, 2)
	  Out2 = STRIM$(Out2)
          Token.Index = 1
          CALL Get.Token
          CALL Parse1(Temp3#)
          IF Last.Token = False THEN
             Strngs(Variable) = Out3
             Assign = True
             CALL Assign.End
             EXIT SUB
          END IF
       END IF
    END IF
    IF LEFT$(Temp1$, 1) = "(" THEN
       Out2 = MID$(Temp1$, 2)
       Out2 = STRIM$(Out2)
       Last.Token = False
       Token.Index = 1
       CALL Get.Token
       CALL Parse1(Temp3#)
       IF Last.Token = True THEN
          Element = CINT(Temp3#)
          Temp1$ = MID$(Out2, Token.Index)
          Temp1$ = STRIM$(Temp1$)
          CALL Assignment2(Temp1$, Variable, Element)
          IF Assign THEN
             CALL Assign.End
             EXIT SUB
          END IF
       END IF
    END IF
 END IF
END SUB

SUB Assign.End
 IF LEN(Strng) THEN
    CALL Parse1(X#)
    Strng = "<extra token>"
    ERROR 92
 END IF
END SUB

SUB Assign.Mid.String
 Out2 = MID$(Out2, 4)
 IF LEN(Out2) THEN
    Out2 = STRIM$(Out2)
    Out2 = MID$(Out2, 3)
    Temp1$ = UCASE$(LEFT$(Out2, 1))
    IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
       Variable = ASC(Temp1$) - 64
       IF MID$(Out2, 2, 1) = "$" THEN
	  Out2 = MID$(Out2, 4)
	  Last.Token = False
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Start = CINT(Temp3#)
          IF Strng = "," THEN
             CALL Get.Token
             CALL Parse1(Temp3#)
             Length = CINT(Temp3#)
             Out2 = MID$(Out2, Token.Index)
             Out2 = STRIM$(Out2)
             IF LEFT$(Out2, 1) = "=" THEN
                Out2 = MID$(Out2, 2)
                Out2 = STRIM$(Out2)
                Token.Index = 1
                CALL Get.Token
                CALL Parse1(Temp3#)
                IF Last.Token = False THEN
                   IF Strngs(Variable) = Nul THEN
                      IF Start = 1 THEN
                         IF LEN(Out3) = Length THEN
                            Strngs(Variable) = Out3
                            Call Assign.End
                            EXIT SUB
                         END IF
                      END IF
                      Strng = "<bad string>"
                      ERROR 92
                      EXIT SUB
                   END IF
                   MID$(Strngs(Variable), Start, Length) = Out3
                   Call Assign.End
                   EXIT SUB
                END IF
             END IF
	  END IF
       END IF
    END IF
 END IF
 Strng = "<bad string>"
 ERROR 92
END SUB

SUB Assign.Left.String
 Out2 = MID$(Out2, 5)
 IF LEN(Out2) THEN
    Out2 = STRIM$(Out2)
    Out2 = MID$(Out2, 3)
    Temp1$ = UCASE$(LEFT$(Out2, 1))
    IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
       Variable = ASC(Temp1$) - 64
       IF MID$(Out2, 2, 1) = "$" THEN
	  Out2 = MID$(Out2, 4)
	  Last.Token = False
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Start = CINT(Temp3#)
	  Out2 = MID$(Out2, Token.Index)
	  Out2 = STRIM$(Out2)
	  IF LEFT$(Out2, 1) = "=" THEN
	     Out2 = MID$(Out2, 2)
	     Out2 = STRIM$(Out2)
	     Token.Index = 1
	     CALL Get.Token
	     CALL Parse1(Temp3#)
             IF Last.Token = False THEN
                IF Strngs(Variable) = Nul THEN
                   IF LEN(Out3) = Start THEN
                      Strngs(Variable) = Out3
                      Call Assign.End
                      EXIT SUB
                   END IF
                   Strng = "<bad string>"
                   ERROR 92
                   EXIT SUB
                END IF
                MID$(Strngs(Variable), 1, Start) = Out3
                Call Assign.End
                EXIT SUB
             END IF
	  END IF
       END IF
    END IF
 END IF
 Strng = "<bad string>"
 ERROR 92
END SUB

SUB Assign.Right.String
 Out2 = MID$(Out2, 6)
 IF LEN(Out2) THEN
    Out2 = STRIM$(Out2)
    Out2 = MID$(Out2, 3)
    Temp1$ = UCASE$(LEFT$(Out2, 1))
    IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
       Variable = ASC(Temp1$) - 64
       IF MID$(Out2, 2, 1) = "$" THEN
	  Out2 = MID$(Out2, 4)
	  Last.Token = False
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Start = CINT(Temp3#)
	  Out2 = MID$(Out2, Token.Index)
	  Out2 = STRIM$(Out2)
	  IF LEFT$(Out2, 1) = "=" THEN
	     Out2 = MID$(Out2, 2)
	     Out2 = STRIM$(Out2)
	     Token.Index = 1
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     Length = LEN(Strngs(Variable)) - Start + 1
             IF Last.Token = False THEN
                IF Length > False THEN
                   MID$(Strngs(Variable), Length, Start) = Out3
                   Call Assign.End
                   EXIT SUB
                ELSE
                   IF Strngs(Variable) = Nul THEN
                      IF LEN(Out3) = Start THEN
                         Strngs(Variable) = Out3
                         Call Assign.End
                         EXIT SUB
                      END IF
                   END IF
                END IF
             END IF
	  END IF
       END IF
    END IF
 END IF
 Strng = "<bad string>"
 ERROR 92
END SUB

SUB Draw.Circle.Step
 Allow.Extra = True
 Xcoor1 = False
 Xcoor1.Set = False
 Ycoor1 = False
 Ycoor1.Set = False
 Radius = False
 Radius.Set = False
 Color.Code = False
 Color.Set = False
 Start.Circle = False
 Start.Set = False
 End.Circle = False
 End.Set = False
 Aspect = False
 Aspect.Set = False
 Out2 = MID$(Out2, 12)
 Out2 = STRIM$(Out2)
 Last.Token = False
 Out3 = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Last.Token THEN
    Xcoor1.Set = True
 END IF
 IF Strng = "," THEN
    Last.Token = False
    Out3 = Nul
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Last.Token THEN
       Ycoor1.Set = True
    END IF
    IF Strng = "," THEN
       Last.Token = False
       Out3 = Nul
       CALL Get.Token
       CALL Parse1(Temp3#)
       Radius = CINT(Temp3#)
       IF Last.Token THEN
	  Radius.Set = True
       END IF
       IF Strng = "," THEN
	  Last.Token = False
	  Out3 = Nul
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Color.Code = CINT(Temp3#)
	  IF Last.Token THEN
	     Color.Set = True
	  END IF
	  IF Strng = "," THEN
	     Last.Token = False
	     Out3 = Nul
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     Start.Circle = CINT(Temp3#)
	     IF Last.Token THEN
		Start.Set = True
	     END IF
	     IF Strng = "," THEN
		Last.Token = False
		Out3 = Nul
		CALL Get.Token
		CALL Parse1(Temp3#)
		End.Circle = CINT(Temp3#)
		IF Last.Token THEN
		   End.Set = True
		END IF
		IF Strng = "," THEN
		   Last.Token = False
		   Out3 = Nul
		   CALL Get.Token
		   CALL Parse1(Temp3#)
		   Aspect = CINT(Temp3#)
		   IF Last.Token THEN
		      Aspect.Set = True
		   END IF
		END IF
	     END IF
	  END IF
       END IF
       IF Xcoor1.Set AND Ycoor1.Set AND Radius.Set THEN
	  IF Start.Set AND End.Set THEN
	     IF Color.Set THEN
		IF Aspect.Set THEN
		   CIRCLE STEP(Xcoor1, Ycoor1), Radius, Color.Code, Start.Circle, End.Circle, Aspect%
		ELSE
		   CIRCLE STEP(Xcoor1, Ycoor1), Radius, Color.Code, Start.Circle, End.Circle
		END IF
	     ELSE
		IF Aspect.Set THEN
		   CIRCLE STEP(Xcoor1, Ycoor1), Radius, , Start.Circle, End.Circle, Aspect
		ELSE
		   CIRCLE STEP(Xcoor1, Ycoor1), Radius, , Start.Circle, End.Circle
		END IF
	     END IF
	  ELSE
	     IF Start.Set OR End.Set THEN
		ERROR 39
	     ELSE
		IF Color.Set THEN
		   IF Aspect.Set THEN
		      CIRCLE STEP(Xcoor1, Ycoor1), Radius, Color.Code, , , Aspect
		   ELSE
		      CIRCLE STEP(Xcoor1, Ycoor1), Radius, Color.Code
		   END IF
		ELSE
		   IF Aspect.Set THEN
		      CIRCLE STEP(Xcoor1, Ycoor1), Radius, , , , Aspect
		   ELSE
		      CIRCLE STEP(Xcoor1, Ycoor1), Radius
		   END IF
		END IF
	     END IF
	  END IF
          EXIT SUB
       END IF
    END IF
 END IF
 ERROR 39
END SUB

SUB Draw.Circle
 Allow.Extra = True
 Xcoor1 = False
 Xcoor1.Set = False
 Ycoor1 = False
 Ycoor1.Set = False
 Radius = False
 Radius.Set = False
 Color.Code = False
 Color.Set = False
 Start.Circle = False
 Start.Set = False
 End.Circle = False
 End.Set = False
 Aspect = False
 Aspect.Set = False
 Out2 = MID$(Out2, 12)
 Out2 = STRIM$(Out2)
 Last.Token = False
 Out3 = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Last.Token THEN
    Xcoor1.Set = True
 END IF
 IF Strng = "," THEN
    Last.Token = False
    Out3 = Nul
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Last.Token THEN
       Ycoor1.Set = True
    END IF
    IF Strng = "," THEN
       Last.Token = False
       Out3 = Nul
       CALL Get.Token
       CALL Parse1(Temp3#)
       Radius = CINT(Temp3#)
       IF Last.Token THEN
	  Radius.Set = True
       END IF
       IF Strng = "," THEN
	  Last.Token = False
	  Out3 = Nul
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Color.Code = CINT(Temp3#)
	  IF Last.Token THEN
	     Color.Set = True
	  END IF
	  IF Strng = "," THEN
	     Last.Token = False
	     Out3 = Nul
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     Start.Circle = CINT(Temp3#)
	     IF Last.Token THEN
		Start.Set = True
	     END IF
	     IF Strng = "," THEN
		Last.Token = False
		Out3 = Nul
		CALL Get.Token
		CALL Parse1(Temp3#)
		End.Circle = CINT(Temp3#)
		IF Last.Token THEN
		   End.Set = True
		END IF
		IF Strng = "," THEN
		   Last.Token = False
		   Out3 = Nul
		   CALL Get.Token
		   CALL Parse1(Temp3#)
		   Aspect = CINT(Temp3#)
		   IF Last.Token THEN
		      Aspect.Set = True
		   END IF
		END IF
	     END IF
	  END IF
       END IF
       IF Xcoor1.Set AND Ycoor1.Set AND Radius.Set THEN
	  IF Start.Set AND End.Set THEN
	     IF Color.Set THEN
		IF Aspect.Set THEN
		   CIRCLE (Xcoor1, Ycoor1), Radius, Color.Code, Start.Circle, End.Circle, Aspect%
		ELSE
		   CIRCLE (Xcoor1, Ycoor1), Radius, Color.Code, Start.Circle, End.Circle
		END IF
	     ELSE
		IF Aspect.Set THEN
		   CIRCLE (Xcoor1, Ycoor1), Radius, , Start.Circle, End.Circle, Aspect
		ELSE
		   CIRCLE (Xcoor1, Ycoor1), Radius, , Start.Circle, End.Circle
		END IF
	     END IF
	  ELSE
	     IF Start.Set OR End.Set THEN
		ERROR 39
	     ELSE
		IF Color.Set THEN
		   IF Aspect.Set THEN
		      CIRCLE (Xcoor1, Ycoor1), Radius, Color.Code, , , Aspect
		   ELSE
		      CIRCLE (Xcoor1, Ycoor1), Radius, Color.Code
		   END IF
		ELSE
		   IF Aspect.Set THEN
		      CIRCLE (Xcoor1, Ycoor1), Radius, , , , Aspect
		   ELSE
		      CIRCLE (Xcoor1, Ycoor1), Radius
		   END IF
		END IF
	     END IF
	  END IF
          EXIT SUB
       END IF
    END IF
 END IF
 ERROR 39
END SUB

SUB Draw.Line.Step
 Allow.Extra = True
 Xcoor1 = False
 Xcoor1.Set = False
 Ycoor1 = False
 Ycoor1.Set = False
 Xcoor2 = False
 Xcoor2.Set = False
 Ycoor2 = False
 Ycoor2.Set = False
 Color.Code = False
 Color.Set = False
 Box.Set = False
 Filled.Set = False
 Style = False
 Style.Set = False
 Step.Set = False
 Out2 = MID$(Out2, 10)
 Out2 = STRIM$(Out2)
 Last.Token = False
 Out3 = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Last.Token THEN
    Xcoor1.Set = True
 END IF
 IF Strng = "," THEN
    Last.Token = False
    Out3 = Nul
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Last.Token THEN
       Ycoor1.Set = True
    END IF
    IF Strng = "," THEN
       Temp1$ = MID$(Out2, Token.Index)
       Temp1$ = STRIM$(Temp1$)
       Temp1$ = UCASE$(Temp1$)
       IF LEFT$(Temp1$, 4) = "STEP" THEN
	  Step.Set = True
	  Token.Index = Token.Index + 4
	  DO UNTIL MID$(Out2, Token.Index, 1) = " "
	     IF Token.Index > LEN(Out2) THEN
		EXIT DO
	     END IF
	     Token.Index = Token.Index + 1
	  LOOP
       END IF
       Last.Token = False
       Out3 = Nul
       CALL Get.Token
       CALL Parse1(Temp3#)
       Xcoor2 = CINT(Temp3#)
       IF Last.Token THEN
	  Xcoor2.Set = True
       END IF
       IF Strng = "," THEN
	  Last.Token = False
	  Out3 = Nul
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Ycoor2 = CINT(Temp3#)
	  IF Last.Token THEN
	     Ycoor2.Set = True
	  END IF
	  IF Strng = "," THEN
	     Last.Token = False
	     Out3 = Nul
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     Color.Code = CINT(Temp3#)
	     IF Last.Token THEN
		Color.Set = True
	     END IF
	     IF Strng = "," THEN
		Temp1$ = MID$(Out2, Token.Index)
		Temp1$ = STRIM$(Temp1$)
		Temp1$ = UCASE$(Temp1$)
		IF LEFT$(Temp1$, 2) = "BF" OR LEFT$(Temp1$, 2) = "FB" THEN
		   Token.Index = Token.Index + 2
		   Box.Set = True
		   Filled.Set = True
		ELSE
		   IF LEFT$(Temp1$, 1) = "B" THEN
		      Token.Index = Token.Index + 1
		      Box.Set = True
		   ELSE
		      IF LEFT$(Temp1$, 1) = "F" THEN
			 Token.Index = Token.Index + 1
			 Filled.Set = True
		      END IF
		   END IF
		END IF
		IF Box.Set OR Filled.Set THEN
		   DO UNTIL MID$(Out2, Token.Index, 1) = " " OR MID$(Out2, Token.Index, 1) = ","
		      IF Token.Index > LEN(Out2) THEN
			 EXIT DO
		      END IF
		      Token.Index = Token.Index + 1
		   LOOP
		END IF
		CALL Get.Token
		CALL Parse1(Temp3#)
		IF Strng = "," THEN
		   Last.Token = False
		   Out3 = Nul
		   CALL Get.Token
		   CALL Parse1(Temp3#)
		   Style = CINT(Temp3#)
		   IF Last.Token THEN
		      Style.Set = True
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    END IF
    IF Xcoor1.Set = False OR Ycoor1.Set = False THEN
       ERROR 28
    END IF
    IF Xcoor2.Set = False OR Ycoor2.Set = False THEN
       ERROR 28
    END IF
    IF Step.Set = False THEN
       IF Box.Set AND Filled.Set THEN
	  IF Color.Set AND Style.Set THEN
	     LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, BF, Style
	  ELSE
	     IF Color.Set THEN
		LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, BF
	     ELSE
		IF Style.Set THEN
		   LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BF, Style
		ELSE
		   LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BF
		END IF
	     END IF
	  END IF
       ELSE
	  IF Box.Set THEN
	     IF Color.Set AND Style.Set THEN
		LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, B, Style
	     ELSE
		IF Color.Set THEN
		   LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, B
		ELSE
		   IF Style.Set THEN
		      LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , B, Style
		   ELSE
		      LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , B
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Filled.Set THEN
		ERROR 28
	     ELSE
		IF Color.Set AND Style.Set THEN
		   LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, , Style
		ELSE
		   IF Color.Set THEN
		      LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code
		   ELSE
		      IF Style.Set THEN
			 LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , , Style
		      ELSE
			 LINE STEP(Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
		      END IF
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    ELSE
       IF Box.Set AND Filled.Set THEN
	  IF Color.Set AND Style.Set THEN
	     LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, BF, Style
	  ELSE
	     IF Color.Set THEN
		LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, BF
	     ELSE
		IF Style.Set THEN
		   LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , BF, Style
		ELSE
		   LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , BF
		END IF
	     END IF
	  END IF
       ELSE
	  IF Box.Set THEN
	     IF Color.Set AND Style.Set THEN
		LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, B, Style
	     ELSE
		IF Color.Set THEN
		   LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, B
		ELSE
		   IF Style.Set THEN
		      LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , B, Style
		   ELSE
		      LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , B
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Filled.Set THEN
		ERROR 28
	     ELSE
		IF Color.Set AND Style.Set THEN
		   LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, , Style
		ELSE
		   IF Color.Set THEN
		      LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code
		   ELSE
		      IF Style.Set THEN
			 LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , , Style
		      ELSE
			 LINE STEP(Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2)
		      END IF
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    END IF
    EXIT SUB
 END IF
 ERROR 28
END SUB

SUB Draw.Line
 Allow.Extra = True
 Xcoor1 = False
 Xcoor1.Set = False
 Ycoor1 = False
 Ycoor1.Set = False
 Xcoor2 = False
 Xcoor2.Set = False
 Ycoor2 = False
 Ycoor2.Set = False
 Color.Code = False
 Color.Set = False
 Box.Set = False
 Filled.Set = False
 Style = False
 Style.Set = False
 Step.Set = False
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 Last.Token = False
 Out3 = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Last.Token THEN
    Xcoor1.Set = True
 END IF
 IF Strng = "," THEN
    Last.Token = False
    Out3 = Nul
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Last.Token THEN
       Ycoor1.Set = True
    END IF
    IF Strng = "," THEN
       Temp1$ = MID$(Out2, Token.Index)
       Temp1$ = STRIM$(Temp1$)
       Temp1$ = UCASE$(Temp1$)
       IF LEFT$(Temp1$, 4) = "STEP" THEN
	  Step.Set = True
	  Token.Index = Token.Index + 4
	  DO UNTIL MID$(Out2, Token.Index, 1) = " "
	     IF Token.Index > LEN(Out2) THEN
		EXIT DO
	     END IF
	     Token.Index = Token.Index + 1
	  LOOP
       END IF
       Last.Token = False
       Out3 = Nul
       CALL Get.Token
       CALL Parse1(Temp3#)
       Xcoor2 = CINT(Temp3#)
       IF Last.Token THEN
	  Xcoor2.Set = True
       END IF
       IF Strng = "," THEN
	  Last.Token = False
	  Out3 = Nul
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Ycoor2 = CINT(Temp3#)
	  IF Last.Token THEN
	     Ycoor2.Set = True
	  END IF
	  IF Strng = "," THEN
	     Last.Token = False
	     Out3 = Nul
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     Color.Code = CINT(Temp3#)
	     IF Last.Token THEN
		Color.Set = True
	     END IF
	     IF Strng = "," THEN
		Temp1$ = MID$(Out2, Token.Index)
		Temp1$ = STRIM$(Temp1$)
		Temp1$ = UCASE$(Temp1$)
		IF LEFT$(Temp1$, 2) = "BF" OR LEFT$(Temp1$, 2) = "FB" THEN
		   Token.Index = Token.Index + 2
		   Box.Set = True
		   Filled.Set = True
		ELSE
		   IF LEFT$(Temp1$, 1) = "B" THEN
		      Token.Index = Token.Index + 1
		      Box.Set = True
		   ELSE
		      IF LEFT$(Temp1$, 1) = "F" THEN
			 Token.Index = Token.Index + 1
			 Filled.Set = True
		      END IF
		   END IF
		END IF
		IF Box.Set OR Filled.Set THEN
		   DO UNTIL MID$(Out2, Token.Index, 1) = " " OR MID$(Out2, Token.Index, 1) = ","
		      IF Token.Index > LEN(Out2) THEN
			 EXIT DO
		      END IF
		      Token.Index = Token.Index + 1
		   LOOP
		END IF
		CALL Get.Token
		CALL Parse1(Temp3#)
		IF Strng = "," THEN
		   Last.Token = False
		   Out3 = Nul
		   CALL Get.Token
		   CALL Parse1(Temp3#)
		   Style = CINT(Temp3#)
		   IF Last.Token THEN
		      Style.Set = True
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    END IF
    IF Xcoor2.Set = False OR Ycoor2.Set = False THEN
       ERROR 28
    END IF
    IF Step.Set = False THEN
       IF Xcoor1.Set AND Ycoor1.Set THEN
	  IF Box.Set AND Filled.Set THEN
	     IF Color.Set AND Style.Set THEN
		LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, BF, Style
	     ELSE
		IF Color.Set THEN
		   LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, BF
		ELSE
		   IF Style.Set THEN
		      LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BF, Style
		   ELSE
		      LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , BF
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Box.Set THEN
		IF Color.Set AND Style.Set THEN
		   LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, B, Style
		ELSE
		   IF Color.Set THEN
		      LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, B
		   ELSE
		      IF Style.Set THEN
			 LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , B, Style
		      ELSE
			 LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , B
		      END IF
		   END IF
		END IF
	     ELSE
		IF Filled.Set THEN
		   ERROR 28
		ELSE
		   IF Color.Set AND Style.Set THEN
		      LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, , Style
		   ELSE
		      IF Color.Set THEN
			 LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code
		      ELSE
			 IF Style.Set THEN
			    LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , , Style
			 ELSE
			    LINE (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
			 END IF
		      END IF
		   END IF
		END IF
	     END IF
	  END IF
       ELSE
	  IF Box.Set AND Filled.Set THEN
	     IF Color.Set AND Style.Set THEN
		LINE -(Xcoor2, Ycoor2), Color.Code, BF, Style
	     ELSE
		IF Color.Set THEN
		   LINE -(Xcoor2, Ycoor2), Color.Code, BF
		ELSE
		   IF Style.Set THEN
		      LINE -(Xcoor2, Ycoor2), , BF, Style
		   ELSE
		      LINE -(Xcoor2, Ycoor2), , BF
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Box.Set THEN
		IF Color.Set AND Style.Set THEN
		   LINE -(Xcoor2, Ycoor2), Color.Code, B, Style
		ELSE
		   IF Color.Set THEN
		      LINE -(Xcoor2, Ycoor2), Color.Code, B
		   ELSE
		      IF Style.Set THEN
			 LINE -(Xcoor2, Ycoor2), , B, Style
		      ELSE
			 LINE -(Xcoor2, Ycoor2), , B
		      END IF
		   END IF
		END IF
	     ELSE
		IF Filled.Set THEN
		   ERROR 28
		ELSE
		   IF Color.Set AND Style.Set THEN
		      LINE -(Xcoor2, Ycoor2), Color.Code, , Style
		   ELSE
		      IF Color.Set THEN
			 LINE -(Xcoor2, Ycoor2), Color.Code
		      ELSE
			 IF Style.Set THEN
			    LINE -(Xcoor2, Ycoor2), , , Style
			 ELSE
			    LINE -(Xcoor2, Ycoor2)
			 END IF
		      END IF
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    ELSE
       IF Xcoor1.Set AND Ycoor1.Set THEN
	  IF Box.Set AND Filled.Set THEN
	     IF Color.Set AND Style.Set THEN
		LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, BF, Style
	     ELSE
		IF Color.Set THEN
		   LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, BF
		ELSE
		   IF Style.Set THEN
		      LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , BF, Style
		   ELSE
		      LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , BF
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Box.Set THEN
		IF Color.Set AND Style.Set THEN
		   LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, B, Style
		ELSE
		   IF Color.Set THEN
		      LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, B
		   ELSE
		      IF Style.Set THEN
			 LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , B, Style
		      ELSE
			 LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , B
		      END IF
		   END IF
		END IF
	     ELSE
		IF Filled.Set THEN
		   ERROR 28
		ELSE
		   IF Color.Set AND Style.Set THEN
		      LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code, , Style
		   ELSE
		      IF Color.Set THEN
			 LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), Color.Code
		      ELSE
			 IF Style.Set THEN
			    LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2), , , Style
			 ELSE
			    LINE (Xcoor1, Ycoor1)-STEP(Xcoor2, Ycoor2)
			 END IF
		      END IF
		   END IF
		END IF
	     END IF
	  END IF
       ELSE
	  IF Box.Set AND Filled.Set THEN
	     IF Color.Set AND Style.Set THEN
		LINE -STEP(Xcoor2, Ycoor2), Color.Code, BF, Style
	     ELSE
		IF Color.Set THEN
		   LINE -STEP(Xcoor2, Ycoor2), Color.Code, BF
		ELSE
		   IF Style.Set THEN
		      LINE -STEP(Xcoor2, Ycoor2), , BF, Style
		   ELSE
		      LINE -STEP(Xcoor2, Ycoor2), , BF
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Box.Set THEN
		IF Color.Set AND Style.Set THEN
		   LINE -STEP(Xcoor2, Ycoor2), Color.Code, B, Style
		ELSE
		   IF Color.Set THEN
		      LINE -STEP(Xcoor2, Ycoor2), Color.Code, B
		   ELSE
		      IF Style.Set THEN
			 LINE -STEP(Xcoor2, Ycoor2), , B, Style
		      ELSE
			 LINE -STEP(Xcoor2, Ycoor2), , B
		      END IF
		   END IF
		END IF
	     ELSE
		IF Filled.Set THEN
		   ERROR 28
		ELSE
		   IF Color.Set AND Style.Set THEN
		      LINE -STEP(Xcoor2, Ycoor2), Color.Code, , Style
		   ELSE
		      IF Color.Set THEN
			 LINE -STEP(Xcoor2, Ycoor2), Color.Code
		      ELSE
			 IF Style.Set THEN
			    LINE -STEP(Xcoor2, Ycoor2), , , Style
			 ELSE
			    LINE -STEP(Xcoor2, Ycoor2)
			 END IF
		      END IF
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    END IF
    EXIT SUB
 END IF
 ERROR 28
END SUB

SUB Get.Graphics
 SELECT CASE ScreenMode
 CASE 1
    Plane.Bits = 2
    Planes = 1
 CASE 2, 11
    Plane.Bits = 1
    Planes = 1
 CASE 7, 8, 9, 12
    Plane.Bits = 1
    Planes = 4
 CASE 10
    Plane.Bits = 1
    Planes = 2
 CASE 13
    Plane.Bits = 8
    Planes = 1
 CASE ELSE
    ERROR 49
 END SELECT
 Xcoor1 = False
 Ycoor1 = False
 Xcoor2 = False
 Ycoor2 = False
 Out2 = MID$(Out2, 4)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp3#)
       Xcoor2 = CINT(Temp3#)
       IF Strng = "," THEN
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Ycoor2 = CINT(Temp3#)
	  Array.Size = 4 + INT(((Xcoor2 - Xcoor1 + 1) * (Plane.Bits) + 7) / 8) * Planes * ((Ycoor2 - Ycoor1) + 1)
	  Elements = INT((Array.Size + 1) / 2)
	  REDIM Graphics.Screen(1 TO Elements) AS INTEGER
	  GET (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Graphics.Screen
          EXIT SUB
       END IF
    END IF
 END IF
 ERROR 49
END SUB

SUB Put.Graphics
 Xcoor1 = False
 Ycoor1 = False
 Out2 = MID$(Out2, 4)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Strng = "," THEN
       Temp1$ = MID$(Out2, Token.Index)
       Temp1$ = STRIM$(Temp1$)
       Temp1$ = UCASE$(Temp1$)
       IF LEFT$(Temp1$, 4) = "PSET" THEN
	  PUT (Xcoor1, Ycoor1), Graphics.Screen, PSET
          EXIT SUB
       ELSE
	  IF LEFT$(Temp1$, 6) = "PRESET" THEN
	     PUT (Xcoor1, Ycoor1), Graphics.Screen, PRESET
             EXIT SUB
	  ELSE
	     IF LEFT$(Temp1$, 3) = "AND" THEN
		PUT (Xcoor1, Ycoor1), Graphics.Screen, AND
                EXIT SUB
	     ELSE
		IF LEFT$(Temp1$, 2) = "OR" THEN
		   PUT (Xcoor1, Ycoor1), Graphics.Screen, OR
                   EXIT SUB
		ELSE
		   IF LEFT$(Temp1$, 3) = "XOR" THEN
		      PUT (Xcoor1, Ycoor1), Graphics.Screen, XOR
                      EXIT SUB
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    ELSE
       PUT (Xcoor1, Ycoor1), Graphics.Screen
       EXIT SUB
    END IF
 END IF
 ERROR 49
END SUB

SUB Window.Screen(Var)
 IF Var = 1 THEN
    Window.Type = True
    Out2 = MID$(Out2, 14)
    Out2 = STRIM$(Out2)
 ELSE
    Window.Type = False
    Out2 = MID$(Out2, 7)
    Out2 = STRIM$(Out2)
 END IF
 Xcoor1 = False
 Xcoor2 = False
 Ycoor1 = False
 Ycoor2 = False
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp3#)
       Xcoor2 = CINT(Temp3#)
       IF Strng = "," THEN
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Ycoor2 = CINT(Temp3#)
	  IF Window.Type THEN
	     WINDOW SCREEN (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
	  ELSE
	     WINDOW (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
	  END IF
          EXIT SUB
       END IF
    END IF
 END IF
 ERROR 78
END SUB

SUB View.Screen(Var)
 Allow.Extra = True
 IF Var = 1 THEN
    View.Type = True
    Out2 = MID$(Out2, 12)
    Out2 = STRIM$(Out2)
 ELSE
    View.Type = False
    Out2 = MID$(Out2, 5)
    Out2 = STRIM$(Out2)
 END IF
 Xcoor1 = False
 Xcoor2 = False
 Ycoor1 = False
 Ycoor2 = False
 Color.Code = False
 Color.Set = False
 Border.Color = False
 Border.Set = False
 Last.Token = False
 Out3 = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Strng = "," THEN
    Last.Token = False
    Out3 = Nul
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Strng = "," THEN
       Last.Token = False
       Out3 = Nul
       CALL Get.Token
       CALL Parse1(Temp3#)
       Xcoor2 = CINT(Temp3#)
       IF Strng = "," THEN
	  Last.Token = False
	  Out3 = Nul
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Ycoor2 = CINT(Temp3#)
	  IF Strng = "," THEN
	     Last.Token = False
	     Out3 = Nul
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     Color.Code = CINT(Temp3#)
	     IF Last.Token THEN
		Color.Set = True
	     END IF
	     IF Strng = "," THEN
		Last.Token = False
		Out3 = Nul
		CALL Get.Token
		CALL Parse1(Temp3#)
		Border.Color = CINT(Temp3#)
		IF Last.Token THEN
		   Border.Set = True
		END IF
	     END IF
	  END IF
	  IF View.Type THEN
	     IF Color.Set AND Border.Set THEN
		VIEW SCREEN (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, Border.Color
	     ELSE
		IF Color.Set THEN
		   VIEW SCREEN (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, Border.Color
		ELSE
		   IF Border.Set THEN
		      VIEW SCREEN (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , Border.Color
		   ELSE
		      VIEW SCREEN (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
		   END IF
		END IF
	     END IF
	  ELSE
	     IF Color.Set AND Border.Set THEN
		VIEW (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code, Border.Color
	     ELSE
		IF Color.Set THEN
		   VIEW (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), Color.Code
		ELSE
		   IF Border.Set THEN
		      VIEW (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2), , Border.Color
		   ELSE
		      VIEW (Xcoor1, Ycoor1)-(Xcoor2, Ycoor2)
		   END IF
		END IF
	     END IF
	  END IF
          EXIT SUB
       END IF
    END IF
 END IF
 ERROR 77
END SUB

SUB Paint.Area
 Allow.Extra = True
 Xcoor1 = False
 Xcoor1.Set = False
 Ycoor1 = False
 Ycoor1.Set = False
 Paint.Type = False
 Paint.Style$ = Nul
 Border.Color = False
 Border.Set = False
 BackGround.Style$ = Nul
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Last.Token = False
 Out3 = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Xcoor1 = CINT(Temp3#)
 IF Last.Token THEN
    Xcoor1.Set = True
 END IF
 IF Strng = "," THEN
    Last.Token = False
    Out3 = Nul
    CALL Get.Token
    CALL Parse1(Temp3#)
    Ycoor1 = CINT(Temp3#)
    IF Last.Token THEN
       Ycoor1.Set = True
    END IF
    IF Strng = "," THEN
       Last.Token = False
       Out3 = Nul
       CALL Get.Token
       CALL Parse1(Temp3#)
       IF Last.Token = False THEN
	  Paint.Type = True
	  Paint.Style$ = Out3
       ELSE
	  Paint.Type = CINT(Temp3#)
       END IF
       IF Strng = "," THEN
	  Last.Token = False
	  Out3 = Nul
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Border.Color = CINT(Temp3#)
	  IF Last.Token THEN
	     Border.Set = True
	  END IF
	  IF Strng = "," THEN
	     Last.Token = False
	     Out3 = Nul
	     CALL Get.Token
	     CALL Parse1(Temp3#)
	     BackGround.Style$ = Out3
	  END IF
       END IF
    END IF
    IF Xcoor1.Set AND Ycoor1.Set THEN
       IF Paint.Type = True THEN
	  IF Border.Set THEN
	     IF LEN(BackGround.Style$) THEN
		PAINT (Xcoor1, Ycoor1), Paint.Style$, Border.Color, BackGround.Style$
	     ELSE
		PAINT (Xcoor1, Ycoor1), Paint.Style$, Border.Color
	     END IF
	  ELSE
	     IF LEN(BackGround.Style$) THEN
		PAINT (Xcoor1, Ycoor1), Paint.Style$, , BackGround.Style$
	     ELSE
		PAINT (Xcoor1, Ycoor1), Paint.Style$
	     END IF
	  END IF
       ELSE
	  IF Paint.Type > False THEN
	     IF Border.Set THEN
		IF LEN(BackGround.Style$) THEN
		   ERROR 48
                   EXIT SUB
		ELSE
		   PAINT (Xcoor1, Ycoor1), Paint.Type, Border.Color
		END IF
	     ELSE
		IF LEN(BackGround.Style$) THEN
		   ERROR 48
                   EXIT SUB
		ELSE
		   PAINT (Xcoor1, Ycoor1), Paint.Type
		END IF
	     END IF
	  ELSE
	     IF Border.Set THEN
		IF LEN(BackGround.Style$) THEN
		   ERROR 48
                   EXIT SUB
		ELSE
		   PAINT (Xcoor1, Ycoor1), , Border.Color
		END IF
	     ELSE
		IF LEN(BackGround.Style$) THEN
		   ERROR 48
                   EXIT SUB
		ELSE
		   PAINT (Xcoor1, Ycoor1)
		END IF
	     END IF
	  END IF
       END IF
       EXIT SUB
    END IF
 END IF
 ERROR 48
END SUB

SUB Print.Expression
 Allow.Extra = True
 Printing = True
 Last.Token = False
 Out3 = Nul
 Out4 = Nul
 Temp# = False
 Token.Index = 1
 LineFeed = False
 IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
    LineFeed = True
 END IF
 Temp1$ = MID$(Out2, 6)
 Temp1$ = STRIM$(Temp1$)
 WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
    Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
    Temp1$ = STRIM$(Temp1$)
 WEND
 IF Temp1$ = Nul THEN
    Out2 = MID$(Out2, 6)
    Out2 = STRIM$(Out2)
    CALL Get.Token
    PRINT
    Printing = False
    EXIT SUB
 END IF
 PrinterLF = 1
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 DO
    Last.Token = False
    CALL Get.Token
    CALL Parse1(Temp3#)
    SELECT CASE Strng
    CASE ","
       IF Last.Token THEN
	  PRINT STR$(Temp3#),
       ELSE
	  PRINT Out3,
       END IF
    CASE ";"
       IF Last.Token THEN
          PRINT STR$(Temp3#);" ";
       ELSE
	  PRINT Out3;
       END IF
    CASE ELSE
       IF Strng = Nul THEN
          Token.Index = Token.Index - 1
          IF Last.Token THEN
             PRINT STR$(Temp3#);
          ELSE
             PRINT Out3;
          END IF
       ELSE
          ERROR 92
       END IF
    END SELECT
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 IF LineFeed = False THEN
    PRINT
 END IF
 PrinterLF = False
 Printing = False
END SUB

SUB Print.Expression.File
 Allow.Extra = True
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% <=0 OR File.Num%>255 THEN
    ERROR 126
    EXIT SUB
 END IF
 IF Strng = "," THEN
    Out2 = MID$(Out2, Token.Index)
    Out2 = STRIM$(Out2)
    Last.Token = False
    Out3 = Nul
    Out4 = Nul
    Temp# = False
    Token.Index = 1
    LineFeed = False
    IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
       LineFeed = True
    END IF
    Temp1$ = STRIM$(Out2)
    WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
       Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
       Temp1$ = STRIM$(Temp1$)
    WEND
    IF Temp1$ = Nul THEN
       PRINT #File.Num%, CHR$(13) + CHR$(10);
       EXIT SUB
    END IF
    DO
       Last.Token = False
       CALL Get.Token
       CALL Parse1(Temp3#)
       SELECT CASE Strng
       CASE ","
          IF Last.Token THEN
             PRINT #File.Num%, STR$(Temp3#),
          ELSE
             PRINT #File.Num%, Out3,
          END IF
       CASE ";"
          IF Last.Token THEN
             PRINT #File.Num%, STR$(Temp3#);" ";
          ELSE
             PRINT #File.Num%, Out3;
          END IF
       CASE ELSE
          IF Strng = Nul THEN
             Token.Index = Token.Index - 1
             IF Last.Token THEN
                PRINT #File.Num%, STR$(Temp3#);
             ELSE
                PRINT #File.Num%, Out3;
             END IF
          ELSE
             ERROR 92
          END IF
       END SELECT
       IF Token.Index > LEN(Out2) THEN
          EXIT DO
       END IF
    LOOP
    IF LineFeed = False THEN
       PRINT #File.Num%, CHR$(13); CHR$(10);
    END IF
    EXIT SUB
 END IF
 ERROR 32
END SUB

SUB Dprint.Expression
 Allow.Extra = True
 Printing = True
 Last.Token = False
 Out3 = Nul
 Out4 = Nul
 Temp# = False
 Token.Index = 1
 LineFeed = False
 IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
    LineFeed = True
 END IF
 Temp1$ = MID$(Out2, 7)
 Temp1$ = STRIM$(Temp1$)
 WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
    Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
    Temp1$ = STRIM$(Temp1$)
 WEND
 IF Temp1$ = Nul THEN
    Out2 = MID$(Out2, 7)
    Out2 = STRIM$(Out2)
    CALL Get.Token
    PRINT
    Printing = False
    EXIT SUB
 END IF
 PrinterLF = 1
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 DO
    Last.Token = False
    CALL Get.Token
    CALL Parse1(Temp3#)
    SELECT CASE Strng
    CASE ","
       PRINT FORMAT$(NOW, Out3),
    CASE ";"
       PRINT FORMAT$(NOW, Out3);" ";
    CASE ELSE
       IF Strng = Nul THEN
          Token.Index = Token.Index - 1
          PRINT FORMAT$(NOW, Out3);
       ELSE
          ERROR 92
       END IF
    END SELECT
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 IF LineFeed = False THEN
    PRINT
 END IF
 PrinterLF = False
 Printing = False
END SUB

SUB Lprint.Expression
 Allow.Extra = True
 Printing = True
 Last.Token = False
 Out3 = Nul
 Out4 = Nul
 Temp# = False
 Token.Index = 1
 LineFeed = False
 IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
    LineFeed = True
 END IF
 Temp1$ = MID$(Out2, 7)
 Temp1$ = STRIM$(Temp1$)
 WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
    Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
    Temp1$ = STRIM$(Temp1$)
 WEND
 IF Temp1$ = Nul THEN
    Out2 = MID$(Out2, 7)
    Out2 = STRIM$(Out2)
    CALL Get.Token
    LPRINT
    Printing = False
    EXIT SUB
 END IF
 PrinterLF = True
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 DO
    Last.Token = False
    CALL Get.Token
    CALL Parse1(Temp3#)
    SELECT CASE Strng
    CASE ","
       IF Last.Token THEN
	  LPRINT STR$(Temp3#),
       ELSE
	  LPRINT Out3,
       END IF
    CASE ";"
       IF Last.Token THEN
          LPRINT STR$(Temp3#);" ";
       ELSE
	  LPRINT Out3;
       END IF
    CASE ELSE
       IF Strng = Nul THEN
          Token.Index = Token.Index - 1
          IF Last.Token THEN
             LPRINT STR$(Temp3#);
          ELSE
             LPRINT Out3;
          END IF
       ELSE
          ERROR 92
       END IF
    END SELECT
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 IF LineFeed = False THEN
    LPRINT
 END IF
 PrinterLF = False
 Printing = False
END SUB

SUB Sprint.Expression
 Allow.Extra = True
 Printing = True
 Last.Token = False
 Out3 = Nul
 Out4 = Nul
 Temp# = False
 Token.Index = 1
 LineFeed = False
 IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
    LineFeed = True
 END IF
 Temp1$ = MID$(Out2, 7)
 Temp1$ = STRIM$(Temp1$)
 WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
    Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
    Temp1$ = STRIM$(Temp1$)
 WEND
 IF Temp1$ = Nul THEN
    Out2 = MID$(Out2, 7)
    Out2 = STRIM$(Out2)
    CALL Get.Token
    PRINT
    Printing = False
    EXIT SUB
 END IF
 PrinterLF = 1
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 DO
    Last.Token = False
    CALL Get.Token
    CALL Parse1(Temp3#)
    SELECT CASE Strng
    CASE ","
       IF Last.Token THEN
	  PRINT CHR$(Temp3#),
       ELSE
	  PRINT Out3,
       END IF
    CASE ";"
       IF Last.Token THEN
          PRINT CHR$(Temp3#);" ";
       ELSE
	  PRINT Out3;
       END IF
    CASE ELSE
       IF Strng = Nul THEN
          Token.Index = Token.Index - 1
          IF Last.Token THEN
             PRINT CHR$(Temp3#);
          ELSE
             PRINT Out3;
          END IF
       ELSE
          ERROR 92
       END IF
    END SELECT
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 IF LineFeed = False THEN
    PRINT
 END IF
 PrinterLF = False
 Printing = False
END SUB

SUB Uprint.Expression
 Allow.Extra = True
 Printing = True
 Last.Token = False
 Out3 = Nul
 Out4 = Nul
 Temp# = False
 Token.Index = 1
 LineFeed = False
 IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
    LineFeed = True
 END IF
 Temp1$ = MID$(Out2, 7)
 Temp1$ = STRIM$(Temp1$)
 WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
    Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
    Temp1$ = STRIM$(Temp1$)
 WEND
 IF Temp1$ = Nul THEN
    Out2 = MID$(Out2, 7)
    Out2 = STRIM$(Out2)
    CALL Get.Token
    PRINT
    Printing = False
    EXIT SUB
 END IF
 PrinterLF = 1
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 DO
    Last.Token = False
    CALL Get.Token
    CALL Get.Token
    CALL Parse1(Temp3#)
    Number# = Temp3#
    CALL Get.Token
    CALL Parse1(Temp3#)
    Strng = MID$(Out2, Token.Index, 1)
    Token.Index = Token.Index + 1
    SELECT CASE Strng
    CASE ","
       PRINT FORMAT$(Number#, Out3),
    CASE ";"
       PRINT FORMAT$(Number#, Out3);" ";
    CASE ELSE
       PRINT FORMAT$(Number#, Out3);
    END SELECT
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 IF LineFeed = False THEN
    PRINT
 END IF
 PrinterLF = False
 Printing = False
END SUB

SUB Line.Input.Expression(Var)
 IF Var = 1 THEN
    Add.Cursor = False
    Temp1$ = MID$(Out2, 12)
 ELSE
    Add.Cursor = True
    Temp1$ = MID$(Out2, 11)
 END IF
 Temp1$ = STRIM$(Temp1$)
 Token.Index = 1
 Out2 = Temp1$
 Last.Token = True
 Quotes = False
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    IF Quotes THEN
       IF Program.Resume <= False OR StdinPrompt THEN
          PRINT Out3;
       END IF
       Temp1$ = MID$(Out2, Token.Index)
    END IF
 END IF
 Temp1$ = STRIM$(Temp1$)
 Temp1$ = UCASE$(Temp1$)
 SELECT CASE LEN(Temp1$)
 CASE 1
    IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
       Variable = ASC(Temp1$) - 64
       LOCATE , , Visible
       Temp2$ = KeyboardLine$
       Variables(Variable) = VAL(Temp2$)
    END IF
 CASE 2
    IF MID$(Temp1$, 2, 1) = "$" THEN
       Temp1$ = LEFT$(Temp1$, 1)
       IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
          Variable = ASC(Temp1$) - 64
          LOCATE , , Visible
          Temp2$ = KeyboardLine$
          Strngs(Variable) = Temp2$
       END IF
    END IF
 CASE 3
    IF RIGHT$(Temp1$, 2) = "()" THEN
       Temp1$ = LEFT$(Temp1$, 1)
       IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
	  Variable = ASC(Temp1$) - 64
          LOCATE , , Visible
          Temp2$ = KeyboardLine$
          FOR Temp = 1 TO LEN(Temp2$)
             Arrays(Variable, Temp) = ASC(MID$(Temp2$, Temp, 1))
             IF Temp >= Max.Arrays THEN
		EXIT FOR
	     END IF
	  NEXT
       END IF
    END IF
 CASE ELSE
    Out2 = MID$(Temp1$, 2)
    Temp1$ = LEFT$(Temp1$, 1)
    IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
       Variable = ASC(Temp1$) - 64
       CALL Equate(Temp3#)
       Element = CINT(Temp3#)
       IF Element > False AND Element <= Max.Arrays THEN
          LOCATE , , Visible
          Temp2$ = KeyboardLine$
	  Arrays(Variable, Element) = VAL(Temp2$)
       ELSE
          ERROR 9
       END IF
    END IF
 END SELECT
 IF Add.Cursor THEN
    PRINT
 END IF
END SUB

SUB Line.Input.Exp.File
 Out2 = MID$(Out2, 13)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% <=0 OR File.Num%>255 THEN
    ERROR 126
    EXIT SUB
 END IF
 IF Strng = "," THEN
    Temp1$ = MID$(Out2, Token.Index)
    Temp1$ = STRIM$(Temp1$)
    Temp1$ = UCASE$(Temp1$)
    SELECT CASE LEN(Temp1$)
    CASE 1
       IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
          Variable = ASC(Temp1$) - 64
          LINE INPUT #File.Num%, Temp2$
          IF RIGHT$(Temp2$, 1) = CHR$(10) THEN
             Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
          END IF
          IF RIGHT$(Temp2$, 1) = CHR$(13) THEN
             Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
          END IF
          Variables(Variable) = VAL(Temp2$)
       END IF
    CASE 2
       IF MID$(Temp1$, 2, 1) = "$" THEN
          Temp1$ = LEFT$(Temp1$, 1)
          IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
             Variable = ASC(Temp1$) - 64
             LINE INPUT #File.Num%, Temp2$
             IF RIGHT$(Temp2$, 1) = CHR$(10) THEN
                Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
             END IF
             IF RIGHT$(Temp2$, 1) = CHR$(13) THEN
                Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
             END IF
             Strngs(Variable) = Temp2$
          END IF
       END IF
    CASE 3
       IF RIGHT$(Temp1$, 2) = "()" THEN
          Temp1$ = LEFT$(Temp1$, 1)
          IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
             Variable = ASC(Temp1$) - 64
             LINE INPUT #File.Num%, Temp2$
             IF RIGHT$(Temp2$, 1) = CHR$(10) THEN
                Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
             END IF
             IF RIGHT$(Temp2$, 1) = CHR$(13) THEN
                Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
             END IF
             FOR Temp = 1 TO LEN(Temp2$)
                Arrays(Variable, Temp) = ASC(MID$(Temp2$, Temp, 1))
                IF Temp >= Max.Arrays THEN
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
    CASE ELSE
       Out2 = MID$(Temp1$, 2)
       Temp1$ = LEFT$(Temp1$, 1)
       IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
          Variable = ASC(Temp1$) - 64
          CALL Equate(Temp3#)
          Element = CINT(Temp3#)
          IF Element > False AND Element <= Max.Arrays THEN
             LINE INPUT #File.Num%, Temp2$
             IF RIGHT$(Temp2$, 1) = CHR$(10) THEN
                Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
             END IF
             IF RIGHT$(Temp2$, 1) = CHR$(13) THEN
                Temp2$ = LEFT$(Temp2$, LEN(Temp2$) - 1)
             END IF
             Arrays(Variable, Element) = VAL(Temp2$)
          ELSE
             ERROR 9
          END IF
       END IF
    END SELECT
    EXIT SUB
 END IF
 ERROR 36
END SUB

SUB Input.Expression(Var)
 Allow.Extra = 1
 IF Var = 1 THEN
    Add.Cursor = False
    Temp1$ = MID$(Out2, 7)
 ELSE
    Add.Cursor = True
    Temp1$ = MID$(Out2, 6)
 END IF
 Temp1$ = STRIM$(Temp1$)
 Token.Index = 1
 Out2 = Temp1$
 Last.Token = True
 Quotes = False
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    IF Quotes THEN
       IF Strng = ";" THEN
          IF Program.Resume <= False OR StdinPrompt THEN
             PRINT Out3;
          END IF
       ELSE
          IF Strng = "," THEN
             IF Program.Resume <= False OR StdinPrompt THEN
                PRINT Out3; "?";
             END IF
          END IF
       END IF
       Out2 = MID$(Temp1$, Token.Index)
    ELSE
       Out2 = Temp1$
       IF Program.Resume <= False OR StdinPrompt THEN
          PRINT "?";
       END IF
    END IF
 ELSE
    Out2 = Temp1$
    IF Program.Resume <= False OR StdinPrompt THEN
       PRINT "?";
    END IF
 END IF
 LOCATE , , Visible
 User.Input$ = KeyboardLine$
 IF BreakIS THEN
    PRINT
    EXIT SUB
 END IF
 Stored.Input$ = User.Input$
 Stored.Token.Index = 1
 Stored.Out2$ = STRIM$(UCASE$(Out2))
 DO
    Token.Index = Stored.Token.Index
    Out2 = Stored.Out2$
    Last.Token = False
    CALL Get.Token
    Stored.Token.Index = Token.Index
    Stored.Out2$ = Out2
    Temp1$ = STRIM$(Strng)
    IF LEFT$(Temp1$, 1) >= "A" AND LEFT$(Temp1$, 1) <= "Z" THEN
       Variable = ASC(LEFT$(Temp1$, 1)) - 64
       Out2 = Stored.Input$
       Last.Token = False
       Token.Index = 1
       Temp3# = Dfalse
       DO
	  CALL Get.Token
          Last.Token.Type = Token
	  IF Token = 1 THEN
	     IF Strng = "," THEN
                Last.Token.Type = Prev.Token.Type
		Out3 = LEFT$(Out2, Token.Index - 2)
		EXIT DO
	     END IF
	  END IF
	  IF Token.Index > LEN(Out2) THEN
	     Out3 = Out2
	     EXIT DO
	  END IF
          Prev.Token.Type = Last.Token.Type
       LOOP
       Temp3# = VAL(Out3)
       IF Stored.Input$ = Nul THEN
          ERROR 136
       END IF
       Stored.Input$ = MID$(Out2, Token.Index)
       Token.Index = Stored.Token.Index
       Out2 = Stored.Out2$
       SELECT CASE LEN(Temp1$)
       CASE 1
	  IF MID$(Out2, Token.Index, 1) = "(" THEN
	     IF MID$(Out2, Token.Index + 1, 1) = ")" THEN
		CALL Get.Token
		CALL Get.Token
		Stored.Token.Index = Token.Index
		Stored.Out2$ = Out2
		FOR Element = 1 TO LEN(Out3)
		   Arrays(Variable, Element) = ASC(MID$(Out3, Element, 1))
                   IF Element >= Max.Arrays THEN
		      EXIT FOR
		   END IF
		NEXT
	     ELSE
		CALL Get.Token
		CALL Parse1(Temp4#)
		Stored.Token.Index = Token.Index
		Stored.Out2$ = Out2
		Element = CINT(Temp4#)
                IF Element > False AND Element <= Max.Arrays THEN
                   IF Last.Token.Type = 2 THEN
                      Arrays(Variable, Element) = Temp3#
                   ELSE
                      ERROR 135
                   END IF
                ELSE
                   ERROR 9
		END IF
	     END IF
	  ELSE
             IF Last.Token.Type = 2 THEN
                Variables(Variable) = Temp3#
             ELSE
                ERROR 135
             END IF
	  END IF
       CASE 2
	  IF MID$(Temp1$, 2, 1) = "$" THEN
	     Strngs(Variable) = Out3
          ELSE
             ERROR 134
	  END IF
       CASE ELSE
          ERROR 134
       END SELECT
    ELSE
       IF Temp1$ <> "," THEN
          ERROR 134
       END IF
    END IF
    IF Stored.Token.Index > LEN(Stored.Out2$) THEN
       EXIT DO
    END IF
 LOOP
 IF Stored.Input$ <> Nul THEN
    ERROR 137
 END IF
 IF Add.Cursor THEN
    PRINT
 END IF
END SUB

SUB Input.Expression.File
 Allow.Extra = 1
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% <=0 OR File.Num%>255 THEN
    ERROR 126
    EXIT SUB
 END IF
 IF Strng = "," THEN
    Out2 = MID$(Out2, Token.Index)
    Out2 = STRIM$(Out2)
    DO
       Last.Token = False
       Token.Index = 1
       CALL Get.Token
       IF Strng = "," THEN
          CALL Get.Token
       END IF
       Temp1$ = STRIM$(Strng)
       Temp1$ = UCASE$(Temp1$)
       IF LEFT$(Temp1$, 1) >= "A" AND LEFT$(Temp1$, 1) <= "Z" THEN
          Variable = ASC(LEFT$(Temp1$, 1)) - 64
          SELECT CASE LEN(Temp1$)
          CASE 1
             IF MID$(Out2, Token.Index, 1) = "(" THEN
                IF MID$(Out2, Token.Index + 1, 1) = ")" THEN
                   INPUT #FileNum%, Out3
                   FOR Element = 1 TO LEN(Out3)
                      Arrays(Variable, Element) = ASC(MID$(Out3, Element, 1))
                      IF Element >= Max.Arrays THEN
                         EXIT FOR
                      END IF
                   NEXT
                ELSE
                   CALL Get.Token
                   CALL Parse1(Temp4#)
                   Element = CINT(Temp4#)
                   INPUT #File.Num%, Temp3#
                   IF Element > False AND Element <= Max.Arrays THEN
                      Arrays(Variable, Element) = Temp3#
                   ELSE
                      ERROR 9
                   END IF
                END IF
             ELSE
                INPUT #File.Num, Temp3#
                Variables(Variable) = Temp3#
             END IF
          CASE 2
             IF MID$(Temp1$, 2, 1) = "$" THEN
                INPUT #File.Num%, Out3
                IF LEFT$(Out3, 1) = CHR$(34) THEN
                   Out3 = MID$(Out3, 2)
                END IF
                IF RIGHT$(Out3, 1) = CHR$(34) THEN
                   Out3 = LEFT$(Out3, LEN(Out3) - 1)
                END IF
                Strngs(Variable) = Out3
             ELSE
                ERROR 134
             END IF
          CASE ELSE
             ERROR 134
          END SELECT
       ELSE
          IF Temp1$ <> "," THEN
             ERROR 134
          END IF
       END IF
       IF Token.Index > LEN(Out2) THEN
          EXIT DO
       END IF
       Out2 = MID$(Out2, Token.Index)
    LOOP
    EXIT SUB
 END IF
 ERROR 34
END SUB

SUB Write.Expression
 Allow.Extra = True
 Printing = True
 Last.Token = False
 Out3 = Nul
 Out4 = Nul
 Token.Index = 1
 LineFeed = False
 IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
    LineFeed = True
 END IF
 Temp1$ = MID$(Out2, 6)
 Temp1$ = STRIM$(Temp1$)
 WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
    Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
    Temp1$ = STRIM$(Temp1$)
 WEND
 IF Temp1$ = Nul THEN
    Out2 = MID$(Out2, 6)
    Out2 = STRIM$(Out2)
    CALL Get.Token
    PRINT
    Printing = False
    EXIT SUB
 END IF
 PrinterLF = 1
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Position = False
 DO
    Last.Token = False
    CALL Get.Token
    CALL Parse1(Temp3#)
    SELECT CASE Strng
    CASE ",", ";"
       IF Position THEN
	  PRINT ",";
       END IF
       IF Last.Token THEN
	  PRINT STRIM$(STR$(Temp3#));
       ELSE
	  PRINT CHR$(34) + Out3 + CHR$(34);
       END IF
       Position = True
    CASE ELSE
       IF Position THEN
	  PRINT ",";
       END IF
       IF Strng = Nul THEN
          Token.Index = Token.Index - 1
          IF Last.Token THEN
             PRINT STRIM$(STR$(Temp3#));
          ELSE
             PRINT CHR$(34) + Out3 + CHR$(34);
          END IF
       ELSE
          ERROR 92
       END IF
       Position = True
    END SELECT
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
 IF LineFeed = False THEN
    PRINT
 END IF
 PrinterLF = False
 Printing = False
END SUB

SUB Write.Expression.File
 Allow.Extra = True
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% <=0 OR File.Num%>255 THEN
    ERROR 126
    EXIT SUB
 END IF
 IF Strng = "," THEN
    Out2 = MID$(Out2, Token.Index)
    Out2 = STRIM$(Out2)
    Last.Token = False
    Out3 = Nul
    Out4 = Nul
    Token.Index = 1
    LineFeed = False
    IF RIGHT$(Out2, 1) = ";" OR RIGHT$(Out2, 1) = "," THEN
       LineFeed = True
    END IF
    Temp1$ = STRIM$(Out2)
    WHILE RIGHT$(Temp1$, 1) = "," OR RIGHT$(Temp1$, 1) = ";"
       Temp1$ = LEFT$(Temp1$, LEN(Temp1$) - 1)
       Temp1$ = STRIM$(Temp1$)
    WEND
    IF Temp1$ = Nul THEN
       PRINT #File.Num%, CHR$(13) + CHR$(10);
       EXIT SUB
    END IF
    Position = False
    DO
       Last.Token = False
       CALL Get.Token
       CALL Parse1(Temp3#)
       SELECT CASE Strng
       CASE ",", ";"
          IF Position THEN
             PRINT #File.Num%, ",";
          END IF
          IF Last.Token THEN
             PRINT #File.Num%, STRIM$(STR$(Temp3#));
          ELSE
             PRINT #File.Num%, CHR$(34) + Out3 + CHR$(34);
          END IF
          Position = True
       CASE ELSE
          IF Position THEN
             PRINT #File.Num%, ",";
          END IF
          IF Strng = Nul THEN
             Token.Index = Token.Index - 1
             IF Last.Token THEN
                PRINT #File.Num%, STRIM$(STR$(Temp3#));
             ELSE
                PRINT #File.Num%, CHR$(34) + Out3 + CHR$(34);
             END IF
          ELSE
             ERROR 92
          END IF
          Position = True
       END SELECT
       IF Token.Index > LEN(Out2) THEN
          EXIT DO
       END IF
    LOOP
    IF LineFeed = False THEN
       PRINT #File.Num%, CHR$(13); CHR$(10);
    END IF
    EXIT SUB
 END IF
 ERROR 31
END SUB

SUB Change.Color
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 Foreground = CINT(Temp4#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    BackGround = CINT(Temp4#)
    COLOR Foreground, BackGround
    LastColor1 = Foreground
    LastColor2 = BackGround
    EXIT SUB
 END IF
 COLOR Foreground
 LastColor1 = Foreground
END SUB

SUB Change.Screen
 Allow.Extra = True
 ScreenColor = False
 Color.Set = False
 Active.Page = False
 Active.Set = False
 Visual.Page = False
 Visual.Set = False
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 ScreenMode = CINT(Temp4#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    ScreenColor = CINT(Temp4#)
    IF Last.Token THEN
       Color.Set = True
    END IF
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       Active.Page = CINT(Temp4#)
       IF Last.Token THEN
	  Active.Set = True
       END IF
       IF Strng = "," THEN
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  Visual.Page = CINT(Temp4#)
	  IF Last.Token THEN
	     Visual.Set = True
	  END IF
       END IF
    END IF
 END IF
 IF Color.Set AND Active.Set AND Visual.Set THEN
    SCREEN ScreenMode, ScreenColor, Active.Page, Visual.Page
    LastScreen1 = ScreenMode
    LastScreen2 = ScreenColor
    LastScreen3 = Active.Page
    LastScreen4 = Visual.Page
 ELSE
    IF Color.Set AND Active.Set THEN
       SCREEN ScreenMode, ScreenColor, Active.Page
       LastScreen1 = ScreenMode
       LastScreen2 = ScreenColor
       LastScreen3 = Active.Page
    ELSE
       IF Color.Set AND Visual.Set THEN
          SCREEN ScreenMode, ScreenColor, , Visual.Page
          LastScreen1 = ScreenMode
          LastScreen2 = ScreenColor
          LastScreen4 = Visual.Page
       ELSE
	  IF Active.Set AND Visual.Set THEN
             SCREEN ScreenMode, , Active.Page, Visual.Page
             LastScreen1 = ScreenMode
             LastScreen3 = Active.Page
             LastScreen4 = Visual.Page
	  ELSE
	     IF Color.Set THEN
                SCREEN ScreenMode, ScreenColor
                LastScreen1 = ScreenMode
                LastScreen2 = ScreenColor
	     ELSE
		IF Active.Set THEN
                   SCREEN ScreenMode, , Active.Page
                   LastScreen1 = ScreenMode
                   LastScreen3 = Active.Page
		ELSE
		   IF Visual.Set THEN
                      SCREEN ScreenMode, , , Visual.Page
                      LastScreen1 = ScreenMode
                      LastScreen4 = Visual.Page
		   ELSE
                      SCREEN ScreenMode
                      LastScreen1 = ScreenMode
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    END IF
 END IF
END SUB

SUB Change.Width
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 IF LEFT$(Out2, 1) = "#" THEN
    Out2 = MID$(Out2, 2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    FileNumber = CINT(Temp4#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       FileWidth = CINT(Temp4#)
       WIDTH #FileNumber, FileWidth
       EXIT SUB
    END IF
 ELSE
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token THEN
       ScreenWidth = CINT(Temp4#)
       IF Strng = "," THEN
          CALL Get.Token
          CALL Parse1(Temp4#)
          ScreenHeight = CINT(Temp4#)
          WIDTH ScreenWidth, ScreenHeight
          LastWidth1 = ScreenWidth
          LastWidth2 = ScreenHeight
          EXIT SUB
       END IF
    ELSE
       Device$ = Out3
       IF Strng = "," THEN
          CALL Get.Token
          CALL Parse1(Temp4#)
          DeviceWidth = CINT(Temp4#)
          IF UCASE$(Device$) = "LPRINT" THEN
             WIDTH LPRINT DeviceWidth
          ELSE
             WIDTH Device$, DeviceWidth
          END IF
          EXIT SUB
       END IF
    END IF
 END IF
 ERROR 146
END SUB

SUB Sound.Speaker
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 Tone = CINT(Temp4#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    Duration = CINT(Temp4#)
    SOUND Tone, Duration
    EXIT SUB
 END IF
 ERROR 147
END SUB

SUB Locate.Cursor
 Allow.Extra = True
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 Xcoor = CSRLIN
 Ycoor = POS(0)
 IF LEN(Out2) THEN
    Token.Index = 1
    IF MID$(Out2, Token.Index, 1) = "," THEN
       CALL Get.Token
    ELSE
       CALL Get.Token
       CALL Parse1(Temp4#)
       Xcoor = CINT(Temp4#)
    END IF
    IF Strng = "," THEN
       IF MID$(Out2, Token.Index, 1) = "," THEN
	  CALL Get.Token
       ELSE
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  Ycoor = CINT(Temp4#)
       END IF
       IF Strng = "," THEN
	  IF MID$(Out2, Token.Index, 1) = "," THEN
	     CALL Get.Token
	  ELSE
	     CALL Get.Token
	     CALL Parse1(Temp4#)
	     Visible = CINT(Temp4#)
	  END IF
	  IF Strng = "," THEN
	     CALL Get.Token
	     CALL Parse1(Temp4#)
	     StartScan = CINT(Temp4#)
	     EndScan = StartScan
	     IF Strng = "," THEN
		CALL Get.Token
		CALL Parse1(Temp4#)
		EndScan = CINT(Temp4#)
	     END IF
	     LOCATE Xcoor, Ycoor, Visible, StartScan, EndScan
             LastCursor1 = Visible
             LastCursor2 = StartScan
             LastCursor3 = EndScan
	     EXIT SUB
	  END IF
       END IF
    END IF
 END IF
 LOCATE Xcoor, Ycoor, Visible
 LastCursor1 = Visible
END SUB

SUB CLS.Screen
 Out2 = MID$(Out2, 4)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    CLS.Type = INT(VAL(Out2))
    SELECT CASE CLS.Type
    CASE 0
       CLS 0
       EXIT SUB
    CASE 1
       CLS 1
       EXIT SUB
    CASE 2
       CLS 2
       EXIT SUB
    CASE ELSE
       ERROR 2
       EXIT SUB
    END SELECT
 END IF
 CLS
END SUB

SUB BSave.Image
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Filename$ = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    Filename$ = Out3 + ".sc2"
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp3#)
       Offset = CINT(Temp3#)
       IF Strng = "," THEN
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Length = CINT(Temp3#)
	  BSAVE Filename$, Offset, Length
          EXIT SUB
       END IF
    END IF
 END IF
 ERROR 60
END SUB

SUB BLoad.Image
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Filename$ = Nul
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    Filename$ = Out3 + ".sc2"
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp3#)
       Offset = CINT(Temp3#)
       BLOAD Filename$, Offset
    ELSE
       BLOAD Filename$
    END IF
    EXIT SUB
 END IF
 ERROR 60
END SUB

SUB Draw.Pixel
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 X% = CINT(Temp3#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp3#)
    Y% = CINT(Temp3#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp3#)
       C% = CINT(Temp3#)
       PSET (X%, Y%), C%
       EXIT SUB
    ELSE
       PSET (X%, Y%)
       EXIT SUB
    END IF
 END IF
 ERROR 15
END SUB

SUB Draw.PixelX
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 X% = CINT(Temp3#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp3#)
    Y% = CINT(Temp3#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp3#)
       C% = CINT(Temp3#)
       PRESET (X%, Y%), C%
       EXIT SUB
    ELSE
       PRESET (X%, Y%)
       EXIT SUB
    END IF
 END IF
 ERROR 15
END SUB

SUB Draw.Expression
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    DRAW Out3
    EXIT SUB
 END IF
 ERROR 46
END SUB

SUB Play.Expression
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    PLAY Out3
    EXIT SUB
 END IF
 ERROR 47
END SUB

SUB Restore.Data
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = True THEN
    Line.Number% = CINT(Temp3#)
    IF Line.Number% >= 1 AND Line.Number% <= Last.Line THEN
       Out2 = Program(Line.Number%)
       Out2 = STRIM$(Out2)
       Out2 = UCASE$(Out2)
       IF LEFT$(Out2, 5) = "DATA " THEN
	  DataLine = Line.Number%
	  DataNumber = False
          EXIT SUB
       END IF
    END IF
 END IF
 ERROR 65
END SUB

SUB Read.Data
 Allow.Extra = 1
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 DO
    Last.Token = False
    CALL Get.Token
    Temp1$ = STRIM$(Strng)
    Temp1$ = UCASE$(Temp1$)
    IF LEFT$(Temp1$, 1) >= "A" AND LEFT$(Temp1$, 1) <= "Z" THEN
       Variable = ASC(LEFT$(Temp1$, 1)) - 64
       SELECT CASE LEN(Temp1$)
       CASE 1
	  IF MID$(Out2, Token.Index, 1) = "(" THEN
	     IF MID$(Out2, Token.Index + 1, 1) = ")" THEN
		CALL Get.Token
		CALL Get.Token
		CALL Read.Data.Element(More.Data)
		IF More.Data THEN
		   ERROR 66
		END IF
		IF Last.Token = False THEN
		   FOR Element = 1 TO LEN(Out3)
		      Arrays(Variable, Element) = ASC(MID$(Out3, Element, 1))
                      IF Element >= Max.Arrays THEN
			 EXIT FOR
		      END IF
		   NEXT
                ELSE
                   ERROR 135
		END IF
	     ELSE
		CALL Get.Token
		CALL Parse1(Temp4#)
		Element = CINT(Temp4#)
		CALL Read.Data.Element(More.Data)
		IF More.Data THEN
		   ERROR 66
		END IF
		IF Last.Token THEN
                   IF Element > False AND Element <= Max.Arrays THEN
		      Arrays(Variable, Element) = DataValue
                   ELSE
                      ERROR 9
		   END IF
                ELSE
                   ERROR 135
		END IF
	     END IF
	  ELSE
	     CALL Read.Data.Element(More.Data)
	     IF More.Data THEN
		ERROR 66
	     END IF
	     IF Last.Token THEN
		Variables(Variable) = DataValue
             ELSE
                ERROR 135
	     END IF
	  END IF
       CASE 2
	  IF MID$(Temp1$, 2, 1) = "$" THEN
	     CALL Read.Data.Element(More.Data)
	     IF More.Data THEN
		ERROR 66
	     END IF
	     IF Last.Token = False THEN
		Strngs(Variable) = Out3
             ELSE
                ERROR 135
	     END IF
          ELSE
             ERROR 134
	  END IF
       CASE ELSE
          ERROR 134
       END SELECT
    ELSE
       IF Temp1$ <> "," THEN
          ERROR 134
       END IF
    END IF
    IF Token.Index > LEN(Out2) THEN
       EXIT DO
    END IF
 LOOP
END SUB

SUB Read.Record
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Field.Read = False
 File.Num% = CINT(Temp3#)
 IF File.Num% <=0 OR File.Num%>255 THEN
    ERROR 126
    EXIT SUB
 END IF
 IF Strng = "," THEN
    Temp1$ = MID$(Out2, Token.Index)
    Temp1$ = STRIM$(Temp1$)
    Temp1$ = UCASE$(Temp1$)
    Temp2$ = LEFT$(Temp1$, 1)
    Temp1$ = MID$(Temp1$, 2)
    IF Temp1$ = "$" THEN
       IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
          Variable = ASC(Temp2$) - 64
          Out2 = Field.Array(File.Num%)
          Out2 = STRIM$(Out2)
          Out2 = UCASE$(Out2)
          Token.Index = 1
          Start% = 1
          DO
             CALL Get.Token
             CALL Parse1(Temp3#)
             Length% = CINT(Temp3#)
             FieldVariable = False
             IF Strng = "AS" THEN
                Out2 = MID$(Out2, Token.Index + 1)
                Out2 = STRIM$(Out2)
                IF LEFT$(Out2, 1) >= "A" AND LEFT$(Out2, 1) <= "Z" THEN
                   IF MID$(Out2, 2, 1) = "$" THEN
                      FieldVariable = ASC(LEFT$(Out2, 1)) - 64
                      Out2 = MID$(Out2, 4)
                   END IF
                END IF
                Token.Index = 1
             END IF
             IF Strng = "," THEN
                Out2 = MID$(Out2, Token.Index + 1)
                Token.Index = 1
             END IF
             IF FieldVariable = Variable THEN
                Field.Read = True
                Temp$ = MID$(File.Fields(File.Num%), Start%, Length%)
                Strngs(Variable) = Temp$
             END IF
             IF FieldVariable THEN
                Start% = Start% + Length%
             END IF
             IF Token.Index > LEN(Out2) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
 END IF
 IF Field.Read = False THEN
    ERROR 45
 END IF
END SUB

SUB Get.Record
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% <=0 OR File.Num%>255 THEN
    ERROR 126
    EXIT SUB
 END IF
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    Record.Number! = CSNG(Temp4#)
    IF Strng = "," THEN
       Temp1$ = MID$(Out2, Token.Index)
       Temp1$ = STRIM$(Temp1$)
       Temp1$ = UCASE$(Temp1$)
       Temp2$ = LEFT$(Temp1$, 1)
       Temp1$ = MID$(Temp1$, 2)
       IF LEFT$(Temp1$, 1) = "$" THEN
          IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
             Variable = ASC(Temp2$) - 64
             IF Record.Number! = 0! THEN
                GET #File.Num%, , Strngs(Variable)
             ELSE
                GET #File.Num%, Record.Number!, Strngs(Variable)
             END IF
             EXIT SUB
          END IF
       END IF
    ELSE
       GET #File.Num%, Record.Number!
       EXIT SUB
    END IF
 ELSE
    GET #File.Num%
    EXIT SUB
 END IF
 ERROR 44
END SUB

SUB Put.Record
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% <=0 OR File.Num%>255 THEN
    ERROR 126
    EXIT SUB
 END IF
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    Record.Number! = CSNG(Temp4#)
    IF Record.Number! > LOF(File.Num%) + 1 THEN
       ERROR 111
       EXIT SUB
    END IF
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       IF Last.Token = False THEN
          IF Record.Number! = 0! THEN
             PUT #File.Num%, , Out3
          ELSE
             PUT #File.Num%, Record.Number!, Out3
          END IF
       ELSE
          IF Record.Number! = 0! THEN
             PUT #File.Num%, , Temp4#
          ELSE
             PUT #File.Num%, Record.Number!, Temp4#
          END IF
       END IF
       EXIT SUB
    ELSE
       PUT #File.Num%, Record.Number!
       EXIT SUB
    END IF
 ELSE
    PUT #File.Num%
    EXIT SUB
 END IF
 ERROR 43
END SUB

SUB Field.Set(Var)
 IF Var = 1 THEN
    Field.Type = 1
 ELSE
    Field.Type = 2
 END IF
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 FieldSet = False
 File.Num% = CINT(Temp3#)
 IF File.Num% <=0 OR File.Num%>255 THEN
    ERROR 126
    EXIT SUB
 END IF
 IF Strng = "," THEN
    Temp1$ = MID$(Out2, Token.Index)
    Temp1$ = STRIM$(Temp1$)
    Temp1$ = UCASE$(Temp1$)
    Temp2$ = LEFT$(Temp1$, 1)
    Temp1$ = MID$(Temp1$, 2)
    IF LEFT$(Temp1$, 1) = "$" THEN
       Temp1$ = MID$(Temp1$, 2)
       Temp1$ = STRIM$(Temp1$)
       IF LEFT$(Temp1$, 1) = "," THEN
          IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
             Variable = ASC(Temp2$) - 64
             CALL Get.Token
             CALL Parse1(Temp4#)
             CALL Get.Token
             CALL Parse1(Temp4#)
             IF Last.Token = False THEN
                Field.Value$ = Out3
                Out2 = Field.Array(File.Num%)
                Out2 = STRIM$(Out2)
                Out2 = UCASE$(Out2)
                Token.Index = 1
                Start% = 1
                DO
                   CALL Get.Token
                   CALL Parse1(Temp3#)
                   Length% = CINT(Temp3#)
                   FieldVariable = False
                   IF Strng = "AS" THEN
                      Out2 = MID$(Out2, Token.Index + 1)
                      Out2 = STRIM$(Out2)
                      IF LEFT$(Out2, 1) >= "A" AND LEFT$(Out2, 1) <= "Z" THEN
                         IF MID$(Out2, 2, 1) = "$" THEN
                            FieldVariable = ASC(LEFT$(Out2, 1)) - 64
                            Out2 = MID$(Out2, 4)
                         END IF
                      END IF
                      Token.Index = 1
                   END IF
                   IF Strng = "," THEN
                      Out2 = MID$(Out2, Token.Index + 1)
                      Token.Index = 1
                   END IF
                   IF FieldVariable = Variable THEN
                      FieldSet = True
                      Temp$ = STRING$(Length%, CHR$(0))
                      IF Field.Type = 1 THEN
                         LSET Temp$ = Field.Value$
                      ELSE
                         RSET Temp$ = Field.Value$
                      END IF
                      MID$(File.Fields(File.Num%), Start%, Length%) = Temp$
                   END IF
                   IF FieldVariable THEN
                      Start% = Start% + Length%
                   END IF
                   IF Token.Index > LEN(Out2) THEN
                      EXIT DO
                   END IF
                LOOP
             END IF
          END IF
       END IF
    END IF
 END IF
 IF FieldSet = False THEN
    IF Field.Type = 1 THEN
       ERROR 41
    ELSE
       ERROR 42
    END IF
 END IF
END SUB

SUB Open.Field
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% <=0 OR File.Num%>255 THEN
    ERROR 126
    EXIT SUB
 END IF
 IF Strng = "," THEN
    Temp1$ = MID$(Out2, Token.Index)
    Temp1$ = STRIM$(Temp1$)
    Field.Array(File.Num%) = Temp1$
    EXIT SUB
 END IF
 ERROR 23
END SUB

SUB Open.File
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 File.Num% = CINT(Temp3#)
 IF File.Num% <=0 OR File.Num%>255 THEN
    ERROR 126
    EXIT SUB
 END IF
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    IF Last.Token = False THEN
       Program.File$ = Out3
       IF Strng = "," THEN
          CALL Get.Token
          CALL Parse1(Temp4#)
          IF Last.Token = False THEN
             Program.Type$ = Out3
             IF Strng = "," THEN
                CALL Get.Token
                CALL Parse1(Temp4#)
                Program.Length = CINT(Temp4#)
             ELSE
                Program.Length = 128
             END IF
             SELECT CASE UCASE$(Program.Type$)
             CASE "I"
                OPEN Program.File$ FOR INPUT SHARED AS #File.Num% LEN = Program.Length
             CASE "O"
                OPEN Program.File$ FOR OUTPUT SHARED AS #File.Num% LEN = Program.Length
             CASE "A"
                OPEN Program.File$ FOR APPEND SHARED AS #File.Num% LEN = Program.Length
             CASE "R"
                OPEN Program.File$ FOR RANDOM SHARED AS #File.Num% LEN = Program.Length
                File.Fields(File.Num%) = STRING$(Program.Length, CHR$(0))
                FIELD #File.Num%, Program.Length AS File.Fields(File.Num%)
             CASE "B"
                OPEN Program.File$ FOR BINARY SHARED AS #File.Num% LEN = Program.Length
                File.Fields(File.Num%) = STRING$(Program.Length, CHR$(0))
             CASE ELSE
                ERROR 21
             END SELECT
             EXIT SUB
          END IF
       END IF
    END IF
 END IF
 ERROR 21
END SUB

SUB Close.File(Var)
 IF Var=2 THEN
    CLOSE
    EXIT SUB
 END IF
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    File.Num% = CINT(Temp3#)
    IF File.Num% <=0 OR File.Num%>255 THEN
       ERROR 126
       EXIT SUB
    END IF
    CLOSE #File.Num%
    EXIT SUB
 END IF
 ERROR 22
END SUB

SUB Chain.Program
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    Program.File$ = Out3
    Start.Line = False
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       Start.Line = CINT(Temp4#) - 1
    END IF
    IF Program.File$ <> Nul THEN
       Program.File$ = STRIM$(Program.File$)
       Program.File$ = LCASE$(Program.File$)
       IF RIGHT$(Program.File$, 4) = ".sic" THEN
          Program.File$ = LEFT$(Program.File$, LEN(Program.File$) - 4)
       END IF
       Program.File$ = LEFT$(Program.File$, 8)
       Filename = Program.File$ + ".sic"
       IF DIR$(Filename) <> Nul THEN
          CHDRIVE CurrentDirectory
          CHDIR CurrentDirectory
          KILL Prepare.Filename
          CALL New.Program
          Program.Name = "<none>"
          CALL Read.Program
          Program.Name = Program.File$
          CALL Prepare.Program
          Nested.Gosub = False
          Max.Gosubs = 10
          Visible = 1
          REDIM GosubReturn(1 TO 10) AS INTEGER
          Program.Line = Start.Line
          CALL Count.Lines(Last.Line)
          EXIT SUB
       END IF
    END IF
 END IF
 ERROR 112
END SUB

SUB Shell.Program
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 DOS.Command$ = Nul
 IF LEN(Out2) THEN
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Last.Token = False THEN
       DOS.Command$ = Out3
    END IF
 END IF
 CALL Execute.Command(DOS.Command$)
 ' restore currently set segment
 IF InDEFSEG THEN
    DEF SEG = DEFSEGvalue
 END IF
END SUB

SUB Name.Expression(Var)
 IF Var = 1 THEN
    Out2 = MID$(Out2, 7)
 ELSE
    Out2 = MID$(Out2, 5)
 END IF
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    Program.File$ = Out3
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       IF Last.Token = False THEN
	  NAME Program.File$ AS Out3
          EXIT SUB
       END IF
    END IF
 END IF
 ERROR 113
END SUB

SUB Kill.File(Var)
 IF Var = 1 THEN
    Out2 = MID$(Out2, 5)
 ELSE
    Out2 = MID$(Out2, 7)
 END IF
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    KILL Out3
    EXIT SUB
 END IF
 ERROR 114
END SUB

SUB CD.Directory(Var)
 IF Var = 1 THEN
    Out2 = MID$(Out2, 3)
 ELSE
    Out2 = MID$(Out2, 6)
 END IF
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    CHDIR Out3
    EXIT SUB
 END IF
 ERROR 115
END SUB

SUB MD.Directory(Var)
 IF Var = 1 THEN
    Out2 = MID$(Out2, 3)
 ELSE
    Out2 = MID$(Out2, 6)
 END IF
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    MKDIR Out3
    EXIT SUB
 END IF
 ERROR 116
END SUB

SUB RD.Directory(Var)
 IF Var = 1 THEN
    Out2 = MID$(Out2, 3)
 ELSE
    Out2 = MID$(Out2, 6)
 END IF
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    RMDIR Out3
    EXIT SUB
 END IF
 ERROR 117
END SUB

SUB Set.Date
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 IF LEFT$(Out2, 1) = "=" THEN
    Out2 = MID$(Out2, 2)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Last.Token = False THEN
       DATE$ = Out3
       EXIT SUB
    END IF
 END IF
 ERROR 118
END SUB

SUB Set.Time
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 IF LEFT$(Out2, 1) = "=" THEN
    Out2 = MID$(Out2, 2)
    Out2 = STRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp3#)
    IF Last.Token = False THEN
       TIME$ = Out3
       EXIT SUB
    END IF
 END IF
 ERROR 119
END SUB

SUB Change.Drive
 Out2 = MID$(Out2, 8)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 IF Last.Token = False THEN
    CHDRIVE Out3
    EXIT SUB
 END IF
 ERROR 120
END SUB

SUB Swap.Data
 Temp1$ = MID$(Out2, 5)
 Temp1$ = STRIM$(Temp1$)
 Temp2$ = UCASE$(LEFT$(Temp1$, 1))
 IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
    Variable1 = ASC(Temp2$) - 64
    Temp1$ = MID$(Temp1$, 2)
    Temp1$ = STRIM$(Temp1$)
    IF LEFT$(Temp1$, 1) = "," THEN
       Temp1$ = MID$(Temp1$, 2)
       Temp1$ = STRIM$(Temp1$)
       Temp2$ = UCASE$(LEFT$(Temp1$, 1))
       IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
	  Variable2 = ASC(Temp2$) - 64
	  Temp1$ = MID$(Temp1$, 2)
	  Temp1$ = STRIM$(Temp1$)
	  IF Temp1$ = Nul THEN
	     SWAP Variables(Variable1), Variables(Variable2)
             EXIT SUB
	  ELSE
	     IF LEFT$(Temp1$, 1) = "(" THEN
		Out2 = MID$(Temp1$, 2)
		Out2 = STRIM$(Out2)
		Last.Token = False
		Token.Index = 1
		CALL Get.Token
		CALL Parse1(Temp3#)
		Element = CINT(Temp3#)
                IF Element > False AND Element <= Max.Arrays THEN
                   SWAP Variables(Variable1), Arrays(Variable2, Element)
                   EXIT SUB
                END IF
	     END IF
	  END IF
       END IF
    ELSE
       IF LEFT$(Temp1$, 1) = "(" THEN
	  Out2 = MID$(Temp1$, 2)
	  Out2 = STRIM$(Out2)
	  Last.Token = False
	  Token.Index = 1
	  CALL Get.Token
	  CALL Parse1(Temp3#)
	  Element1 = CINT(Temp3#)
	  Temp1$ = MID$(Out2, Token.Index)
	  Temp1$ = STRIM$(Temp1$)
	  IF LEFT$(Temp1$, 1) = "," THEN
	     Out2 = MID$(Temp1$, 2)
	     Out2 = UCASE$(Out2)
	     Temp1$ = MID$(Temp1$, 2)
	     Temp1$ = STRIM$(Temp1$)
	     Temp2$ = UCASE$(LEFT$(Temp1$, 1))
	     IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
		Variable2 = ASC(Temp2$) - 64
		Temp1$ = MID$(Temp1$, 2)
		Temp1$ = STRIM$(Temp1$)
		IF Temp1$ = Nul THEN
                   IF Element1 > False AND Element1 <= Max.Arrays THEN
                      SWAP Arrays(Variable1, Element1), Variables(Variable2)
                      EXIT SUB
                   END IF
		ELSE
		   IF LEFT$(Temp1$, 1) = "(" THEN
		      Out2 = MID$(Temp1$, 2)
		      Out2 = STRIM$(Out2)
		      Last.Token = False
		      Token.Index = 1
		      CALL Get.Token
		      CALL Parse1(Temp3#)
		      Element2 = CINT(Temp3#)
                      IF Element1 > False AND Element1 <= Max.Arrays THEN
                         IF Element2 > False AND Element2 <= Max.Arrays THEN
                            SWAP Arrays(Variable1, Element1), Arrays(Variable2, Element2)
                            EXIT SUB
                         END IF
                      END IF
		   END IF
		END IF
	     END IF
	  END IF
       ELSE
	  IF LEFT$(Temp1$, 1) = "$" THEN
	     Temp1$ = MID$(Temp1$, 2)
	     Temp1$ = STRIM$(Temp1$)
	     IF LEFT$(Temp1$, 1) = "," THEN
		Temp1$ = MID$(Temp1$, 2)
		Temp1$ = STRIM$(Temp1$)
		Temp2$ = UCASE$(LEFT$(Temp1$, 1))
		IF Temp2$ >= "A" AND Temp2$ <= "Z" THEN
		   Variable2 = ASC(Temp2$) - 64
		   Temp1$ = MID$(Temp1$, 2)
		   Temp1$ = STRIM$(Temp1$)
		   IF Temp1$ = "$" THEN
		      SWAP Strngs(Variable1), Strngs(Variable2)
                      EXIT SUB
		   END IF
		END IF
	     END IF
	  END IF
       END IF
    END IF
 END IF
 ERROR 110
END SUB

SUB Sleep.Second
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 SLEEP CSNG(Temp3#)
END SUB

SUB Pause.Second
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 Pause.Time! = CSNG(Temp3#)
 Time.Now! = TIMER
 DO
    ' calculate time elapsed
    Elapsed.Time! = TIMER - Time.Now!
    ' adjust for midnight
    IF Elapsed.Time! < 0! THEN
       Elapsed.Time! = Elapsed.Time! + 86400!
    END IF
    ' compare time elapsed
    IF Elapsed.Time! > Pause.Time! THEN
       EXIT DO
    END IF
    ' release time slice in tight loop
    CALL Release.Time(1)
 LOOP
END SUB

SUB Output.Port
 Out2 = MID$(Out2, 4)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 Port.Address = CINT(Temp4#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    Port.Byte = CINT(Temp4#)
    OUT Port.Address, Port.Byte
    EXIT SUB
 END IF
 ERROR 121
END SUB

SUB Wait.Port
 Allow.Extra = True
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp4#)
    Port.Address = CINT(Temp4#)
    IF Strng = "," THEN
       CALL Get.Token
       CALL Parse1(Temp4#)
       And.Value = CINT(Temp4#)
       Xor.Value = False
       IF Strng = "," THEN
	  CALL Get.Token
	  CALL Parse1(Temp4#)
	  Xor.Value = CINT(Temp4#)
       END IF
       WAIT Port.Address, And.Value, Xor.Value
       EXIT SUB
    END IF
 END IF
 ERROR 122
END SUB

SUB Int86.Function
 Out2 = MID$(Out2, 6)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token3
 CALL Get.Token
 CALL Parse1(Temp4#)
 CALL Get.Token4
 Int86.Value = CINT(Temp4#)
 InregsX.AX = INT(VAL("&H" + HEX$(AX)))
 InregsX.BX = INT(VAL("&H" + HEX$(BX)))
 InregsX.CX = INT(VAL("&H" + HEX$(CX)))
 InregsX.DX = INT(VAL("&H" + HEX$(DX)))
 InregsX.BP = INT(VAL("&H" + HEX$(BP)))
 InregsX.SI = INT(VAL("&H" + HEX$(SI)))
 InregsX.DI = INT(VAL("&H" + HEX$(DI)))
 InregsX.Flags = INT(VAL("&H" + HEX$(FL)))
 InregsX.DS = INT(VAL("&H" + HEX$(DS)))
 InregsX.ES = INT(VAL("&H" + HEX$(ES)))
 CALL InterruptX(Int86.Value, InregsX, OutregsX)
 IF OutregsX.AX < False THEN
    AX = CDBL(OutregsX.AX + 65536)
 ELSE
    AX = CDBL(OutregsX.AX)
 END IF
 IF OutregsX.BX < False THEN
    BX = CDBL(OutregsX.BX + 65536)
 ELSE
    BX = CDBL(OutregsX.BX)
 END IF
 IF OutregsX.CX < False THEN
    CX = CDBL(OutregsX.CX + 65536)
 ELSE
    CX = CDBL(OutregsX.CX)
 END IF
 IF OutregsX.DX < False THEN
    DX = CDBL(OutregsX.DX + 65536)
 ELSE
    DX = CDBL(OutregsX.DX)
 END IF
 IF OutregsX.BP < False THEN
    BP = CDBL(OutregsX.BP + 65536)
 ELSE
    BP = CDBL(OutregsX.BP)
 END IF
 IF OutregsX.SI < False THEN
    SI = CDBL(OutregsX.SI + 65536)
 ELSE
    SI = CDBL(OutregsX.SI)
 END IF
 IF OutregsX.DI < False THEN
    DI = CDBL(OutregsX.DI + 65536)
 ELSE
    DI = CDBL(OutregsX.DI)
 END IF
 IF OutregsX.Flags < False THEN
    FL = CDBL(OutregsX.Flags + 65536)
 ELSE
    FL = CDBL(OutregsX.Flags)
 END IF
 IF OutregsX.DS < False THEN
    DS = CDBL(OutregsX.DS + 65536)
 ELSE
    DS = CDBL(OutregsX.DS)
 END IF
 IF OutregsX.ES < False THEN
    ES = CDBL(OutregsX.ES + 65536)
 ELSE
    ES = CDBL(OutregsX.ES)
 END IF
END SUB

SUB Defseg.Function
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) = False THEN
    DEF SEG ' restore segment
    InDEFSEG = False ' reset segment flag
    EXIT SUB
 END IF
 Token.Index = 1
 CALL Get.Token3
 CALL Get.Token
 CALL Parse1(Temp4#)
 CALL Get.Token4
 IF Temp4#>=0# AND Temp4#<=65535# THEN
    DEF SEG = Temp4# ' set segment
    InDEFSEG = True ' set segment flag
    DEFSEGvalue = Temp4# ' store segment value
    EXIT SUB
 END IF
 ERROR 125
END SUB

SUB Absolute.Function
 Out2 = MID$(Out2, 9)
 Out2 = STRIM$(Out2)
 IF LEN(Out2) THEN
    Token.Index = 1
    CALL Get.Token3
    CALL Get.Token
    CALL Parse1(Temp4#)
    CALL Get.Token4
    CALL Absolute(CINT(Temp4#))
    EXIT SUB
 END IF
 ERROR 123
END SUB

SUB Poke.Value
 Out2 = MID$(Out2, 5)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp4#)
 Poke.Address = CINT(Temp4#)
 IF Strng = "," THEN
    CALL Get.Token
    CALL Parse1(Temp4#)
    Poke.Byte = CINT(Temp4#)
    POKE Poke.Address, Poke.Byte
    EXIT SUB
 END IF
 ERROR 124
END SUB

SUB Seed.Random
 Out2 = MID$(Out2, 10)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token
 CALL Parse1(Temp3#)
 RANDOMIZE CLNG(Temp3#)
END SUB

 ' def fn(x)=value
SUB Define.Function
 Out2 = MID$(Out2, 7)
 Out2 = STRIM$(Out2)
 Token.Index = 1
 CALL Get.Token3
 CALL Get.Token
 CALL Parse1(Temp4#)
 CALL Get.Token4
 Func% = CINT(Temp4#)
 IF Func% >= 1 AND Func% <= Max.Functions THEN
    Out2 = MID$(Out2, Token.Index)
    Out2 = LTRIM$(Out2)
    IF LEFT$(Out2, 1) = "=" THEN
       Out2 = MID$(Out2, 2)
       Definitions(Func%) = Out2
       EXIT SUB
    END IF
 END IF
 ERROR 144
END SUB
