//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVTABLE.H                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Tables support interface             |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

void __init_tables( void );

#ifndef _PVTABLE_H
#define _PVTABLE_H

#define MAX_TABLE_XL 1000
#define MAX_TABLE_YL 1000

#define whTABLE    1  //column is in the table
#define whMUTE     2  //column is muted
#ifdef TABLEINFO
#define whINFO     3  //column is in the 'details' window
#endif

#define atLEFT     0  //align column left
#define atRIGHT    1  //align column right

struct Ttable_data
{
  char *title;              //column title
  char width;               //column current width
  char min_width;           //column minimum width
  char max_width;           //column maximum width
  char depth;               //column depth (how deep subcolumns)
  char where;               //whTABLE, whINFO, whMUTE
  char align;               //atLEFT, atRIGHT
  Ttable_data *next;        //next table column in the same level
  Ttable_data *parent;      //parent column
  Ttable_data *nextc;       //next data column
  Ttable_data *nested;      //pointer to list of subitems
  Ttable_data *old_parent;  //used during composition
  Ttable_data *old_item;    //used during composition
};

class Ttable;

class Ttable_iterator: public Titem
{
  public:
    Ttable_data *data;
    uint &h_beg_print;
    uint &h_size;
    uint &h_count;
    uint &h_current;
    uint &v_beg_print;
    uint &v_count;
    uint &v_current;
    uint _h_beg_print;
    uint _h_size;
    uint _h_count;
    uint _h_current;
    uint _v_beg_print;
    uint _v_count;
    uint _v_current;
    uint hsel_org, vsel_org;
    Ttable_iterator( int _xl, int _yl );
    Ttable_iterator( int _xl, int _yl,
                     uint &hsize, uint &hbeg_print,
                     uint &hcount, uint &hcurrent,
                     uint &vbeg_print, uint &vcount, uint &vcurrent );
    virtual void redraw( void );
    virtual void fetch( char *buffer,
                        uint row, uint column,
                        uint width ) = 0;
    void set_title( char *title );
    virtual void left( void );
    virtual void right( void );
    virtual void up( void );
    virtual void down( void );
    virtual void top( void );
    virtual void bottom( void );
    virtual void at( uint i );
    virtual void update_commands( void );
    void pgup( void );
    void pgdn( void );

  protected:
    virtual void draw( void );
    virtual void get_focused( void );
    virtual void event_handler( Tevent &ev );
    virtual void drop( void *data );
};

class Tlist_iterator: public Ttable_iterator, public Tlb_list
{
  public:
    Tlist_iterator( int _xl, int _yl );
    Tlist_iterator( int _xl, int _yl, Tlb_list *_list );
};

class Ttable: public Titem
{
  public:
    Ttable_data *data;
    Ttable_data *first_col;
    int title_vtab;
    uint title_cols;
    uint title_rows;
    Ttable_iterator *iterator;
    Tvscroll_bar *vbar;
    Thscroll_bar *hbar;
    Ttable( Ttable_data *_data, Ttable_iterator *_iterator );
    virtual ~Ttable( void );
    virtual void resize( int _xl, int _yl );
#ifdef TABLEINFO
    virtual void redraw( void );
#endif
    uint col_width( Ttable_data *t );
    void get_title( uint col, uint row, char *r );
    void set_title_vtab( int _title_vtab );

  protected:
#ifdef TABLEINFO
    virtual void get_focused( void );
    virtual boolean release_focus( void );
#endif
    virtual void draw( void );
    virtual void event_handler( Tevent &ev );
#ifdef TABLEINFO
    virtual void drop( void *data );

  private:
    boolean dont_touch( Ttable_data *t );
#endif
};

#ifdef TABLEINFO
class Ttable_info: public Titem
{
  public:
    uint hbeg_print;
    uint hcount;
    uint vbeg_print;
    uint vcount;
    Ttable_info( void );
    virtual ~Ttable_info( void );

  protected:
    virtual void draw( void );
    virtual void event_handler( Tevent &ev );
    virtual void drop( void *data );
    void draw_item( Ttable_data *t );
};
#endif

#endif

#ifdef DECLARE_PVTABLE_H
  #define GLOBAL
#else
  #define GLOBAL extern
#endif
  #ifdef TABLEINFO
  GLOBAL Ttable_info *table_info;
  GLOBAL Ttable *current_table;
  #endif
#undef GLOBAL

void construct_table( char *title, Ttable_iterator *iterator ); //start of table
void dialog_table( char *title, Ttable_iterator *iterator ); //start of dialog table
void subdata( char *t ); //start of table subtitle
Ttable *endt( void ); //end of table/subtitle
Ttable_data *tdata( char *t, uint _min, uint _max ); //table column
void full_title( Ttable_data *t, char *result ); //return full title
void move_table_data( Ttable *table, Ttable_data *data, char where );

void _pure_table( void );        boolean __pure_table( void ); //prefix
void _tright( void );            boolean __tright( void );
