%{
/*\c
 * This little tool converts old style lx files to the new syntax.
 * Usually I try to avoid syntax changes; but in this case it seems
 * best to do the changes, since only a few people are using lx2l,
 * and the new version seems to be more clearly.
 *
 * Note: the old {@make_special}, {@make_char} and {@remake_special}
 * commands were introduced as only a few characters could be remapped; 
 * but now every character can be remapped, so the {@map}... seems
 * to be a better command. The {@@input <>} and {@@verbatim_input <>}
 * commands lost the second `@'; they are now written as {@input <>}
 * and {@verbatim_input <>} (only one @, as all other LX commands too).
 */

#define YY_MAIN 1
#define TELL printf("%s in Zeile %d\n",yytext,line);

int line=1;
%}

SP    [ \t]+
SPO   [ \t]*

%option 8bit noyywrap outfile="lx2l_old2new.c"
%%

\{@@verbatim_input{SP}\<[^ \t\n\"]+">}" |
\{@@input{SP}\<[^ \t\n\"]+">}"   TELL; fprintf(yyout,"{%s",yytext+2);
\{@make_special\}                TELL; fprintf(yyout,"{@map}");
\{@make_special[1-9]\}           TELL; fprintf(yyout,"{@map%c}",*(yytext+14));
\{@make_char\}                   TELL; fprintf(yyout,"{@unmap}");
\{@remake_special\}              TELL; fprintf(yyout,"{@remap}");
\{@remake_special[1-9]\}         TELL; fprintf(yyout,"{@remap%c}",*(yytext+16));
\{@lxx_mode{SP}[12din]\}         TELL; fprintf(yyout,"{@lxx_mode <%c>}",*(yytext+yyleng-2));

\{!@@verbatim_input{SP}\<[^ \t\n\"]+">}" |
\{!@@input{SP}\<[^ \t\n\"]+">}"  TELL; fprintf(yyout,"{!%s",yytext+3);
\{!@make_special\}               TELL; fprintf(yyout,"{!@map}");
\{!@make_special[1-9]\}          TELL; fprintf(yyout,"{!@map%c}",*(yytext+15));
\{!@make_char\}                  TELL; fprintf(yyout,"{!@unmap}");
\{!@remake_special\}             TELL; fprintf(yyout,"{!@remap}");
\{!@remake_special[1-9]\}        TELL; fprintf(yyout,"{!@remap%c}",*(yytext+17));
\{!@lxx_mode{SP}[12din]\}        TELL; fprintf(yyout,"{@lxx_mode <%c>}",*(yytext+yyleng-2));

\n ECHO; line++;
