/*  NUMB2.C:    Utility to number the lines in a file, 
                using the C "stream" file functions.
    Copyright (c) 1989 Ziff Communications Co.
    PC Magazine * Ray Duncan
*/

#include <stdio.h>
#include <string.h>

FILE *ifile;                        /* input file */    
FILE *ofile;                        /* output file */

char fbuff[256];                    /* file I/O buffer */
char iname[80];                     /* name of input file */
char oname[80];                     /* name of output file */

main(int argc, char *argv[])
{
    char *p;                        /* scratch pointer */
    int line = 1;                   /* line number */

    if(argc < 2)                    /* make sure filename present */
    {
        fprintf(stderr,"\nnumb2: missing filename\n");
        exit(1);
    }

    strcpy(iname, argv[1]);         /* get input filename */
    strcpy(oname, argv[1]);         /* build output filename */
    if(! (p = strchr(oname, '.')))  /* point to extension */
        p = strchr(oname, '\0');

    strcpy(p, ".$$$");              /* temp. name for new file */

    ifile = fopen(iname, "r");      /* open input file */
    ofile = fopen(oname, "w");      /* create output file */

    if((ifile == NULL) || (ofile == NULL))
    {
        fprintf(stderr,"\nnumb2: open or create error\n");
        exit(1);
    }

    while(fgets(fbuff, 256, ifile) != NULL)
    {                               /* read until end of file */
                                    /* write line number */
        fprintf(ofile, "%04d\t", line++);
        fputs(fbuff,ofile);         /* write line text */
    }

    fclose(ifile);                  /* close input file */
    fclose(ofile);                  /* close output file */

    strcpy(p, ".bak");              /* build .BAK filename */
    unlink(oname);                  /* delete previous .BAK file */
    rename(iname, oname);           /* make original file .BAK */
    strcpy(p, ".$$$");              /* give new file same name */
    rename(oname, iname);           /* as original file */
}
