{$P512,G512,D-,R+}
{ USAGE: e.g., "DIR | SUMDIR" or "DIR *.PAS | SUMDIR" }
PROGRAM SumDir;
VAR
  Line       : STRING[255]; {input line from directory    }
  Code       : Integer;     {error code for VAL procedure }
  FileLenStr : STRING[7];   {file-length part of Line     }
  FileLen,                  {file length as a number      }
  Sum        : Real;        {total of file lengths        }

BEGIN
  Sum := 0;
  WHILE NOT EoF DO
    BEGIN
      ReadLn(line);                       {Read a directory line}
      IF (Line[0] >= #22) AND (Line[1] <> ' ') THEN
        BEGIN
          FileLenStr := Copy(line, 15, 7);{Extract file length  }
          WHILE FileLenStr[1] = ' ' DO    {Strip leading blanks }
            Delete(FileLenStr, 1, 1);
          Val(FileLenStr, FileLen, Code); {Make it a number     }
          IF code = 0 THEN
            Sum := Sum+FileLen;           {Add it to the sum    }
          WriteLn(Line);
        END
      ELSE
        BEGIN
          IF Copy(line, 11, 7) = 'File(s)' THEN
            {this is the LAST line of the directory -- fix it}
            BEGIN
              WHILE Line[1] = ' ' DO      {Strip leading blanks }
                Delete(Line, 1, 1);
              Write(sum:10:0,' bytes in ');
            END;
          WriteLn(Line);
        END;
    END;
END.