;----------------------------------------------------------------------
; STRINGS3.ASM --- MASM String Package #3
; Copyright (c) 1988 Ziff Communications Co.
; PC Magazine * Ray Duncan * 12-13-88
;----------------------------------------------------------------------
_TEXT   segment word public 'CODE'
        extrn   strcmp:near     ; from STRINGS1
        extrn   strndx:near     ; from STRINGS1
        extrn   strupr:near     ; from STRINGS2
        assume  cs:_TEXT
;----------------------------------------------------------------------
; STRCMPI:      Case-insensitive string comparison 
;
; Call with:    DS:SI = address of string1
;               BX    = length of string1
;               ES:DI = address of string2
;               DX    = length of string2
;
; Returns:      Z     = True  if strings are equal
;               or
;               Z     = False if strings are not equal, and
;               S     = True  if string1 < string2
;               S     = False if string1 > string2
;
; Uses:         nothing
;----------------------------------------------------------------------
        public  strcmpi
strcmpi proc    near

        push    bx              ; save registers
        push    cx
        push    dx
        push    si              
        push    di
        push    ds
        push    es

        call    strupr2         ; translate both strings to upper case
        call    strcmp          ; compare upper-cased strings

        pop     es              ; restore registers
        pop     ds      
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        ret                     ; return S and Z flags 

strcmpi endp
;----------------------------------------------------------------------
; STRNDXI:      Case-insensitive string search 
;
; Call with:    DS:SI = pattern address
;               BX    = pattern length 
;               ES:DI = address of string to be searched
;               DX    = length of string to be searched
;
; Returns:      CY    = True if no match 
;               ES:DI = unchanged
;               or
;               CY    = False if match, and 
;               ES:DI = pointer to match for pattern
;                       string within searched string
;
; Uses:         nothing
;----------------------------------------------------------------------
        public  strndxi
strndxi proc    near

        push    ax              ; save registers
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        push    bp
        push    ds
        push    es

        call    strupr2         ; translate both strings to upper case
        push    di              ; save offset of dup string to be searched
        call    strndx          ; search upper-cased string
        jc      sndx3           ; jump, no match found

        pop     bx              ; match found, calculate neg.
        sub     bx,di           ; offset in duplicate string

        pop     es              ; restore registers and
        pop     ds              ; let ES:DI = offset of
        pop     bp              ; match in original string
        pop     di
        sub     di,bx
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        clc                     ; return Carry = False
        ret

sndx3:  pop     di              ; no match found, discard address of duplicate
        pop     es              ; restore registers
        pop     ds
        pop     bp
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret                     ; return Carry = True

strndxi endp
;----------------------------------------------------------------------
; STRUPR2:      Duplicate two strings and translate 
;               the duplicates to upper-case
;
; Call with:    DS:SI = string1 address
;               BX    = string1 length 
;               ES:DI = string2 address
;               DX    = string2 length
;
; Returns:      DS:SI = address of upper-cased string1 
;                       in temporary storage
;               BX    = string1 length
;               ES:DI = address of upper-cased string2
;                       in temporary storage
;               DX    = string2 length
;
; Uses:         nothing
;----------------------------------------------------------------------
strupr2 proc    near

        push    ds              ; save address and length
        push    si              ; of string1
        push    bx
        push    es              ; get address and length        
        push    di              ; of string2 for strdup
        push    dx
        pop     bx
        pop     si
        pop     ds

        call    strupr          ; dup string2 and translate to upper-case
        push    ds              ; save address and length
        push    si              ; of string2 copy
        push    bx
        pop     dx
        pop     di
        pop     es
        pop     bx              ; restore address and 
        pop     si              ; length of string1
        pop     ds

        call    strupr          ; dup string1 and translate to upper-case
        ret                     ; return to caller

strupr2 endp

_TEXT   ends
        end
