
{$R+,C-}
PROGRAM FileDateAndTime;

TYPE
  Str10 = STRING[10];
  Str2 = STRING[2];
  FlagType = (CarryFlag,     NoFlag0002,
              ParityFlag,    NoFlag0008,
              AuxCarryFlag,  NoFlag0020,
              ZeroFlag,      SignFlag,
              StepTrapFlag,  InterruptFlag,
              DirectionFlag, OverflowFlag,
              NoFlag1000,    NoFlag2000,
              NoFlag4000,    NoFlag8000);
  FlagSet = SET OF FlagType;
  RegisterType = RECORD CASE Byte OF
    0 : (AX, BX, CX, DX, BP, SI, DI, DS, ES, FLAGS : Integer);
    1 : (AL, AH, BL, BH, CL, CH, DL, DH : Byte);
    2 : (RegArray : ARRAY[1..9] OF Integer;
         FlagRegister : FlagSet);
                 END;
VAR
  Registers                      : RegisterType;
  FileDate, FileTime, FileYear   : Integer;
  FileMonth, FileDay, FileHour,
  FileMinute, FileSecond         : Byte;
  FileDateString, FileTimeString : Str10;
  AFile                          : FILE;

  PROCEDURE InterpretFileDateAndTime(VAR AnyFile; VAR FDate, FTime : Str10);
  CONST GetFileDateAndTime = $5700;
  VAR HandleNumber : Byte ABSOLUTE AnyFile;
    YearString : Str10;

    FUNCTION ZeroFill(InByte : Byte) : Str2;
    VAR ZF : Str2;
    BEGIN
      Str(InByte:2, ZF);
      IF ZF[1] = ' ' THEN ZF[1] := '0';
      ZeroFill := ZF;
    END;                      { Function ZeroFill }

  BEGIN
    WITH Registers DO
      BEGIN
        AX := GetFileDateAndTime;
        BX := HandleNumber;
        MsDos(Registers);
        IF CarryFlag IN FlagRegister THEN
          BEGIN
            FileDateString := 'Invalid';
            FileTimeString := 'Handle';
          END
        ELSE
          BEGIN
            FileDate := DX;
            FileTime := CX;
            FileYear := ((FileDate AND $FE00) SHR 9)+1980;
            FileMonth := (FileDate AND $01E0) SHR 5;
            FileDay := (FileDate AND $001F);
            FileHour := (FileTime AND $F800) SHR 11;
            FileMinute := (FileTime AND $07E0) SHR 5;
            FileSecond := (FileTime AND $001F);
            Str(FileYear:4, YearString);
            FDate := ZeroFill(FileMonth)+'/'+
            ZeroFill(FileDay)+'/'+
            YearString;
            FTime := ZeroFill(FileHour)+':'+
            ZeroFill(FileMinute)+':'+
            ZeroFill(FileSecond);
          END;
      END;
  END;                        { Procedure InterpretFileDateAndTime }

BEGIN
  Assign(AFile, 'FDT.PAS');
  {$I-} Reset(AFile);         {$I+}
  IF IOResult = 0 THEN
    BEGIN
      InterpretFileDateAndTime(AFile, FileDateString, FileTimeString);
      Close(AFile);
      WriteLn(FileDateString, '  ', FileTimeString);
    END
  ELSE
    WriteLn('Where''s FDT.PAS?');
END.
