
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <memory.h>
#include <sys/types.h>
#include <dirent.h>
#include <fcntl.h>
#include <utime.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <signal.h>
#include "wtouprot.h"

void Shutdown ();
void ProcessMessages ();

int ClientLogin ();
int readn ();
int writen ();

char	InBuff[4096];
char	OutBuff[4096];

char	ProgramName[256];

int		sockfd=0, newsockfd=0;

main (argc, argv)
int		argc;
char	*argv[];
{
	int		clilen, childpid;
	struct	sockaddr_in		cli_addr, serv_addr;
	struct	sigaction act,oact;

	strcpy (ProgramName, argv[0]);

	/* Open a TCP socket */

	if ((sockfd = socket (AF_INET, SOCK_STREAM, 0)) < 0)
	{
		printf ("%s: can't open stream socket\n", ProgramName);
		exit (-1);
	}

	printf ("%s: Opened socket - socket = %d\n", ProgramName, sockfd);

	/* Bind our local address so that the client can send to us */

	memset (&serv_addr, 0, sizeof(serv_addr));

	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	serv_addr.sin_port = htons (SERV_TCP_PORT);

	if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0)
	{
		printf ("%s: can't bind local address\n", ProgramName);
		exit (-1);
	}

	printf ("%s: Bind OK - port = %d\n", ProgramName, SERV_TCP_PORT);

	/* Listen for connections */

	if (listen (sockfd, 5))
		exit (0);

	for (;;)
	{
		clilen = sizeof(cli_addr);

		newsockfd = accept (sockfd, (struct sockaddr *)&cli_addr, &clilen);

		if (newsockfd < 0)
		{
			printf ("%s: Accept error\n", ProgramName);
			exit (0);
		}
		else
		{
			printf ("%s: Accepted connection - socket = %d\n", ProgramName, newsockfd);
		}
		if ((childpid = fork()) < 0)
		{
			printf ("%s: fork error\n");
			exit (0);
		}
		else if (childpid == 0)
		{
			/* Child process - talk with connected Windows client */

			ProcessMessages (newsockfd, ProgramName);
			close (newsockfd);
			exit (0);
		}
		else
		{
			/* Parent */

			printf ("%s: Child process running! - pid = %d\n", ProgramName, childpid);
		}
	}
}


/*
* Shutdown
*/
void Shutdown ()
{
	if (sockfd)
		close (sockfd);

	if (newsockfd)
		close (newsockfd);

	exit(0);
}


/*
* ProcessMessages
*/
void ProcessMessages (sockfd, pname)
int sockfd;
char *pname;
{
	unsigned short	usCommand;
	GENERIC		*pGen;
	int			iBytesRead, rc;

	pGen = (GENERIC *)InBuff;	

	printf ("%s|Child: Waiting for messages...socket = %d\n", pname, sockfd);

	while (iBytesRead = readn(sockfd, pGen, sizeof(GENERIC)))
	{
		if (iBytesRead == 0)
		{
			printf ("%s: Connection closed\n", pname);
			return;
		}

		/* First read the generic packet (above) and get the length */

		if (iBytesRead < sizeof(GENERIC))
		{
			printf ("%s error: First readn() = %d\n", pname, iBytesRead);
			exit (-1);
		}

		/* Swap generic packet */

		pGen->usType = ntohs (pGen->usType);
		pGen->usLen = ntohs (pGen->usLen);

		printf ("Got Generic, type = %d, reading len = %d\n", 
			pGen->usType, (int)(pGen->usLen - sizeof(GENERIC)));

		/* Now read the full packet */
		
		iBytesRead = readn (sockfd, &InBuff[sizeof(GENERIC)], 
			pGen->usLen - sizeof(GENERIC));

		if (iBytesRead < (pGen->usLen - sizeof(GENERIC)))
		{
			printf ("%s error: Second readn() = %d\n", pname, iBytesRead);
			exit (-1);
		}

		switch (pGen->usType)
		{
		case CLIENT_LOGIN:
			printf ("CLIENT_LOGIN\n");
			rc = ClientLogin (pGen, sockfd);
			break;
		default:
			printf ("%s Unknown Command:  %d\n", pGen->usType);
			break;
		}
	}
	printf ("%s|Child: Connection Closed - exiting...\n", pname);
}


/*
* ClientLogin
*/
int ClientLogin (pGen, sockfd)
GENERIC *pGen;
int sockfd;
{
	int	rc;
	LOGIN *pLogin = (LOGIN *)pGen;
	LOGIN_ACK	LoginAck;

	/* Swap values */

	pLogin->ulUserID = ntohl (pLogin->ulUserID);
	pLogin->ulFlags = ntohl (pLogin->ulFlags);

	/* Validate user and ACK */

	LoginAck.usType = htons(SERVER_LOGIN_ACK);
	LoginAck.usLen = htons(sizeof(LOGIN_ACK));
	LoginAck.ulUserID = htonl(pLogin->ulUserID);
	LoginAck.ulFlags = htonl (LOGIN_ACCEPTED);

	rc = writen (sockfd, (char *)&LoginAck, sizeof(LOGIN_ACK));

	return 0;
}


/*
*  Read "n" bytes from a stream socket 
*/
int readn (fd, ptr, nbytes)
int fd;
char *ptr;
int nbytes;
{
	int	nleft, nread;

	nleft = nbytes;

	while (nleft > 0)
	{
		nread = read (fd, ptr, nleft);

		if (nread < 0)
		{
            printf ("Connection Closed - Child Exiting:  read(), rc = %d\n", nread);
			exit (-1);
		}
		else if (nread == 0)
			break;		/* EOF */

		nleft -= nread;
		ptr += nread;
	}
	return (nbytes - nleft);	/* return >= 0 */
}


/*
*  Write "n" bytes to a stream socket 
*/
int writen (fd, ptr, nbytes)
int fd;
char *ptr;
int nbytes;
{
	int	nleft, nwritten;

	nleft = nbytes;

	while (nleft > 0)
	{
		nwritten = write (fd, ptr, nleft);

		if (nwritten <= 0)			/* error */
		{
			printf ("Connection Closed - Child Exiting:   write(), rc = %d\n", nwritten);
			exit (-1);
		}

		nleft -= nwritten;
		ptr += nwritten;
	}
	return (nbytes - nleft);
}










		




































