/* MCI REXX Sample #2 */
/* Sample REXX Script */
/* this script shows you how to create a simple CD */
/* player which plays a single track.              */

parse arg arg1
If (arg1='') Then
   do
   say 'No track given, using the default of 4'
   track = 4
   End
Else
  Do
  say 'Simple REXX CD Player'
  track = arg1
  End

TrackCmd = 'play cd from '
TrackCmd = TrackCmd track
StatusCmd = 'status cd length track '
StatusCmd = StatusCmd track
StatusCmd = StatusCmd ' wait'

address cmd     /* Send commands to OS/2 command processor.  */
signal on error /* When commands fail, call "error" routine. */

rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()

/* Open the CD */

rc = mciRxSendString("open cdaudio alias cd wait", 'Retst', '0', '0')
rc = mciRxSendString("status cd number of tracks wait", 'Retst', '0', '0')
If track > Retst then
    do
      say 'CD only has ' Retst ' tracks'
      mciRxSendString("close cd wait", 'Retst', '0', '0')
      exit 1
    End
rc = mciRxSendString("set cd time format tmsf wait", 'Retst', '0', '0')
rc = mciRxSendString(StatusCmd , 'Retst', '0', '0')
say 'Playing track #' track ' which is ' Retst 'long'
rc = mciRxSendString(TrackCmd, 'Retst', '0', '0')
rc = mciRxSendString("status cd current track wait", 'Retst', '0', '0')
do while RetSt < track + 1
  rc = mciRxSendString("status cd current track wait", 'Retst', '0', '0')
end

rc = mciRxSendString("close cd wait", 'Retst', '0', '0')
say 'Finished Simple REXX CD Player'
exit

error:
   say 'Error' ErrRC 'at line' sigl ', sourceline:' sourceline(sigl)
   say 'Terminating'
   mciRxSendString("close cd wait", 'Retst', '0', '0')
   mciRxExit()               /* Tell the DLL we're going away */
   exit ErrRC                /* exit, tell caller things went poorly */

halt:
/*
 * Close all device alias's, in case we previously killed
 * this batch file in the same process.
 */
   say 'Terminating'
  mciRxSendString("close cd wait", 'Retst', '0', '0')
exit

