//***************************************************************************
//
//	CHKDRIVE Version 1.2 (Updated 7/16/95)
//
//***************************************************************************

#include <stdio.h>
#include <direct.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>

void ScanDirectory (char *);
void ProcessFile (struct _find_t *);
unsigned long GetClusterSize (void);
int Convert (unsigned long, char *);

unsigned long bytecount = 0;
unsigned long filecount = 0;
unsigned long dircount = 0;
unsigned long overhang[6] = { 0, 0, 0, 0, 0, 0 };

int main (int argc, char *argv[])
{
    int drive, i;
    char directory[80];
	char buffer1[32], buffer2[32];
    float efficiency;
	unsigned long csize;

    // Save the current drive and directory
    drive = _getdrive ();
    _getcwd (directory, sizeof (directory));

    // Change drives if a drive letter was entered on the command line
    if (argc > 1) {
        if (_chdrive (toupper ((int) argv[1][0]) - 0x40) == -1) {
            printf ("Invalid drive specification\n");
            return 1;
        }
    }

    // Gather statistics for the drive
	csize = GetClusterSize ();
    ScanDirectory ("\\");

    // Display the results
	Convert (filecount, buffer1);
	Convert (dircount, buffer2);
    printf ("Scanned %s files in %s directories on drive %c:\n",
        buffer1, buffer2, _getdrive () + 0x40);

	Convert (bytecount, buffer1);
    printf ("Cumulative length of all files is %s bytes\n", buffer1);

	Convert (csize, buffer1);
	printf ("Cluster size is %s bytes (%luK)\n\n", buffer1, csize >> 10);

	if (bytecount) {
	    printf ("Cluster Size    Overhang (Bytes)    Efficiency\n");
	    printf ("============    ================    ==========\n");
    
	    for (i=0; i<6; i++) {
	        efficiency = ((float) (bytecount) / (float) (bytecount +
	            overhang[i])) * 100.0;

			strcpy (buffer2, csize == ((unsigned long) 2 << (10 + i)) ?
				"<--" : "");

			Convert (overhang[i], buffer1);
	        printf ("    %2.0dK         %14s       %6.1f%%  %s\n",
	            2 << i, buffer1, efficiency, buffer2);
	    }
	}

    // Restore the drive and directory, and then exit
    _chdrive (drive);
    _chdir (directory);
    return 0;
}

void ScanDirectory (char *directory)
{
    struct _find_t fileinfo;

    dircount++;
    _chdir (directory);

    if (_dos_findfirst ("*.*", _A_HIDDEN | _A_SYSTEM | _A_RDONLY,
        &fileinfo) == 0) {
        ProcessFile (&fileinfo);
        while (_dos_findnext (&fileinfo) == 0)
            ProcessFile (&fileinfo);
    }

    if (_dos_findfirst ("*.*", _A_SUBDIR | _A_HIDDEN | _A_SYSTEM | _A_RDONLY,
    	&fileinfo) == 0) {
        if ((fileinfo.attrib & _A_SUBDIR) && (fileinfo.name[0] != 0x2E))
            ScanDirectory (fileinfo.name);

        while (_dos_findnext (&fileinfo) == 0) {
            if ((fileinfo.attrib & _A_SUBDIR) && (fileinfo.name[0] != 0x2E))
                ScanDirectory (fileinfo.name);
        }
    }
    _chdir ("..");
}

void ProcessFile (struct _find_t *fileinfo)
{
    int i;
	unsigned long csize;

    filecount++;
    bytecount += fileinfo->size;

    for (i=0; i<6; i++) {
    	csize = (unsigned long) 2048 << i;
		overhang[i] += ((csize - (fileinfo->size % csize)) % csize);
    }
}

unsigned long GetClusterSize (void)
{
	unsigned char far *dpb;

	__asm {
		push	ds
		mov		ah,32h
		mov		dl,0
		int		21h
		mov		dx,ds
		pop		ds
		mov		word ptr dpb+2,dx
		mov		word ptr dpb,bx
	}
	return (unsigned long) 512 * (1 << dpb[0x05]);
}

int Convert (unsigned long num, char *buffer)
{
	int count, i;
	char temp[32];

	if (num == 0) {	// Special case (num == 0)
		buffer[0] = 0x30;
		buffer[1] = 0;
		return 1;
	}

	count = 0;
	temp[31] = 0;

	while (num > 0) {
		if (((count + 1) % 4) == 0)
			temp[30 - count++] = 0x2C;
		temp[30 - count++] = (char) (num % 10) + 0x30;
		num /= 10;
	}

	for (i=0; i<=count; i++)
		buffer[i] = temp[31 - count + i];

	return count;
}
