***********************************************************************
* FUNCTION SndPlaySound(cWave, cFlags)          FoxPro for Windows 2.6
* Calls the SndPlaySound Windows API. Pass the name of the sound to
* be played and flags that affect how the sound is played.  For more
* information see the Multimedia Programming Guide in the Windows SDK.
***********************************************************************
* Constants for SndPlaySound API
#DEFINE SND_SYNC  0           && Wait for sound to finish
#DEFINE SND_ASYNC 1           && Don't wait for sound to finish
#DEFINE SND_NODEFAULT 2       && Don't use default sound
#DEFINE SND_LOOP 8            && Play continuously
#DEFINE SND_NOSTOP 16         && Don't stop current sound

FUNCTION SndPlaySound
PARAMETER cWave, cFlags
SET LIBRARY TO SYS(2004)+"FOXTOOLS.FLL" ADDITIVE
Snd = REGFN("SndPlaySound","CI","I","MMSYSTEM")
nErr = CALLFN(Snd, cWave, cFlags)
RETURN nErr

***********************************************************************
* FUNCTION Fsounds                              FoxPro for Windows 2.6
* Plays the Windows sound passed in the parameter. To save memory and
* process time, the sound file names are hard coded in here instead of
* in a database.  Boolean plSounds must be .T. and made public for
* sounds to occur (plSounds lets user toggle on/off sound effects).
* Sample call: =fsounds("Error")
***********************************************************************
FUNCTION fsounds
PARAMETER lcType
IF !plSounds                  && If plSounds isn't .T., no sounds
   RETURN
ENDIF
IF EMPTY(lcType)
   lcType = "ding"            && Default sound is ding
ENDIF
lnError = .F.
lctype = UPPER(lcType)
*
*  Here's the hardcoded sounds.  All sounds are played
*  asynchronously.  If a sound file is not found you get a ding.
*
DO CASE
CASE lcType = "ALARM"
   lcId = "wcinact.wav"
CASE lcType = "ERROR"
   lcId = "ding.wav"
CASE lcType = "EXIT"
   lcId = "chimes.wav"
CASE lcType = "EXTRACT"
   lcId = "chord.wav"
CASE lcType = "LOADING"
   lcId = "chord.wav"
CASE lcType = "RUSURE"
   lcId = "chord.wav"
CASE lcType = "STARTUP"
   lcId = "ding.wav"
CASE lcType = "MESSAGES"
   lcId = "wcformes.wav"
OTHERWISE
   lcId = lcType+".wav"
ENDCASE
lnError=SndPlaySound(lcId, SND_ASYNC)
RETURN

