program test;
{$N+,E+}
{
   Sample program illustrating use of cross-platform DLLs
   Copyright (c) 1993 by Danny Thorpe

   This program can be compiled for Dos protected mode
   or Windows target, using Borland Pascal 7.0
}

uses {$ifdef Windows} Wincrt, {$ENDIF} winapi;


type
  TComplex = array[1..sizeof(Double)*2] of byte;

procedure Complex(var C: TComplex; R, I: Double); far; external 'complex' index 10;
function GetReal(var C: TComplex): Double; far; external 'complex' index 9;
function GetImaginary(var c: TComplex): Double; far; external 'complex' index 8;
procedure AddFloat(var C: TComplex; R, I: Double); far; external 'complex' index 7;
procedure Multiply(var A,B: TComplex); far; external 'complex' index 5;
function Norm(var C: TComplex): Double; far; external 'complex' index 4;
function MandelbrotPoint(var C: TComplex; LoopLimit: word): Word; far; external 'complex' index 3;
var
  X,W: TComplex;
  Step: Double;
  J: Integer;
begin
  Complex(X, 1.23, 4.56);
  writeln('real: ', GetReal(X));
  writeln('imaginary: ', GetImaginary(X));
  Complex(X, 0, -1);
  writeln('Norm of (0,-1) = ', Norm(X):0:0);
  Complex(X, 2, 0);
  writeln('Norm of (2,0) = ', Norm(X):0:0);
  Complex(X, 2, 1);
  writeln('Norm of (2,1) = ', Norm(X):0:0);
  Complex(W, 0, 1);
  Complex(X, 0, 1);
  Multiply(X,W);
  writeln('(0,1) * (0,1) = (',GetReal(X):0:0,',',GetImaginary(X):0:0,')');
  Complex(W, 0, -1);
  Complex(X, 0, -1);
  Multiply(X,W);
  writeln('(0,-1) * (0,-1) = (',GetReal(X):0:0,',',GetImaginary(X):0:0,')');
  Complex(W, 1, 2);
  Complex(X, 3, 4);
  Multiply(X,W);
  writeln('(1,2) * (3,4) = (',GetReal(X):0:0,',',GetImaginary(X):0:0,')');
  writeln;
  writeln('Press any key to continue...');
  readln;

  Complex(X, -1.5, 0.3);
  Step := 1.5 / 20;
  for J := 1 to 20 do
  begin
    writeln(GetReal(X):4:3,' ',MandelbrotPoint(X, 256));
    AddFloat(X,Step,0);
  end;
  writeln('Done!');
end.