/*---------------------------------------
   BOXPEN.C -- Custom DIB Pen Demo
               (c) Charles Petzold, 1994
  ---------------------------------------*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char szClass [] = "BoxPen" ;
char szTitle [] = "BoxPen: Custom DIB Pen Demo" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     static struct
          {
          BITMAPINFOHEADER bmih ;
          RGBQUAD          rgbq [2] ;
          BYTE             bBits [8] [4] ;
          }
          dib =  { sizeof (BITMAPINFOHEADER), 8, 8, 1, 1, 0, 0, 0, 0, 0, 0,

                   0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,

                   0xFF, 0x00, 0x00, 0x00,
                   0xFF, 0x00, 0x00, 0x00,
                   0xC3, 0x00, 0x00, 0x00,
                   0xC3, 0x00, 0x00, 0x00,
                   0xC3, 0x00, 0x00, 0x00,
                   0xC3, 0x00, 0x00, 0x00,
                   0xFF, 0x00, 0x00, 0x00,
                   0xFF, 0x00, 0x00, 0x00 } ;

     LOGBRUSH lb ;

     SetMapMode (hdc, MM_ANISOTROPIC) ;
     SetWindowExtEx (hdc, 100, 100, NULL) ;
     SetViewportExtEx (hdc, cxArea, cyArea, NULL) ;

     lb.lbStyle = BS_DIBPATTERN ;
     lb.lbColor = DIB_RGB_COLORS ;
     lb.lbHatch = (LONG) &dib ;

     SelectObject (hdc,
          ExtCreatePen (PS_GEOMETRIC | PS_SOLID, 25, &lb, 0, NULL)) ;

     Ellipse (hdc, 25, 25, 75, 75) ;

     DeleteObject (
          SelectObject (hdc,
               GetStockObject (BLACK_PEN))) ;
     }
