// window.h RHS 11/1/91

#if !defined(WINDOW_H)
#define WINDOW_H

#include"screen.h"

const WIN_SCROLLUP = 0;
const WIN_SCROLLDN = 1;

const DWORD WIN_DEFAULT_POSITION = 0xffffffff;
const BYTE WIN_DEFAULT_FILLCHAR = ' ';
extern BYTE WIN_DEFAULT_COLORS;

class Window : public Screen
    {
protected:
    char    far *title;
    BYTE    attributes;
    BYTE    top;
    BYTE    left;
    BYTE    height;
    BYTE    width;
    BYTE    clientheight;
    BYTE    clientwidth;
    BYTE    fillchar;
    BYTE    color;
    BYTE    curRow;
    BYTE    curCol;
    BYTE    isOpen;

// ADD DEFAULT SETTINGS HERE!
    void SetDefaults(char *title, 
        DWORD position,
//        BYTE top, BYTE left, BYTE height, BYTE width, 
        BYTE attrib, BYTE fc, BYTE clr);

    void Init(void);
public:
//    Window(void);
    Window(char *title = "", 
        DWORD position = WIN_DEFAULT_POSITION,
//        BYTE top, BYTE left, BYTE height, BYTE width, 
        BYTE attrib = 0, 
        BYTE fc = WIN_DEFAULT_FILLCHAR, 
        BYTE clr = WIN_DEFAULT_COLORS);
    void Paint(void);
    ~Window(void);
    WORD far *GotoXY(int row, int col);
    void Open(void);
    void Clear(void);
    void ClearEntireWindow(void);
    WORD ScreenChar(BYTE c) {   return MakeCell(c,params.currAttr); }
    WORD WindowChar(BYTE c) {   return MakeCell(c,color);   }
    void cdecl AtSay(int row, int col, char *fmt, ...);
    void AtSay(int row, int col, char *buffer, BYTE color);
    void Scroll(void);
    WORD Lines(void)        {   return clientheight;    }
    WORD Cols(void)         {   return clientwidth;     }
    void Scroll(int direction,int numlines = 1);
    void cdecl Printf(char *fmt, ...);
    void Puts(char *str);
    void SetTitle(char *newtitle = NULL);
    void GetTitle(char *buf);
    BYTE GetColors(void)    {   return color;           }
    static void SetDefaultColors(BYTE newcolors);
    };

class PopWin : public Window
    {
    BYTE far *saved_screen;

public:
    PopWin(char *title = "", 
        DWORD position = WIN_DEFAULT_POSITION,
        BYTE attrib = 0, 
        BYTE fc = WIN_DEFAULT_FILLCHAR, 
        BYTE clr = WIN_DEFAULT_COLORS)
        : Window(title, position, attrib, fc, clr)
        {
        saved_screen = NULL;
        }
    ~PopWin(void);
    void Open(void);
    void Close(void);
    };

#endif


