PROGRAM MathDemo;
USES math;  { this is a demo on how to use Math.TPU }

VAR
  X, Y  : Real;
  c1, c2, c3, c4 : Complex;

BEGIN
  WriteLn('Demo on using the sinh and cosh functions ');
  Write('Enter a value from -10 to 10 : ');
  ReadLn(X);
  Y := Sinh(X);
  WriteLn('sinh ', X:3:3, ' = ', Y:2:5);
  Y := Cosh(X);
  WriteLn('cosh ', X:3:3, ' = ', Y:2:5);
  Y := Sqr(Cosh(X)) - Sqr(Sinh(X));
  WriteLn('sqr(cosh ',X:3:3,') - sqr(sinh ',X:3:3,
          ') = ',Y:2:5);
  WriteLn('(should always be 1.00000)');
  WriteLn;

  WriteLn('Here we are going to test the complex ',
          'procedures. Enter complex numbers');
  WriteLn('A + Bi and C + Di.  Press ENTER after ',
          'each input.');
  Write(' Enter A : ');
  ReadLn(c1.R);
  Write(' Enter B : ');
  ReadLn(c1.I);
  Write(' Enter C : ');
  ReadLn(c2.R);
  Write(' Enter D : ');
  ReadLn(c2.I);

  c3.S := CmpAdd(c1, c2);
  WriteLn(C2S(c1, 3, 3),' + ',C2S(c2, 3, 3), ' = ',
          C2S(c3, 3, 3));

  c3.S := CmpSub(c1, c2);
  WriteLn(C2S(c1, 3, 3),' - ',C2S(c2, 3, 3), ' = ',
          C2S(c3, 3, 3));

  c3.S := RecToPol(c1);
  WriteLn(C2S(c1, 3, 3), ' in polar form : ',
          P2S(c3, 3, 3));
  c3.S := RECtoPOL(c2);
  WriteLn(C2S(c2, 3, 3),' in polar form : ',
          P2S(c3, 3, 3));

  WriteLn;
  c3.S := CmpDiv(c1, c2);
  WriteLn(C2S(c1, 3, 3),' / ',C2S(c2, 3, 3), ' = ',
          C2S(c3, 3, 3));
  c4.S := CmpMul(c3, c2);
  WriteLn('check: ',C2S(c3, 3, 3), ' * ',C2S(c2, 3, 3),
          ' = ', C2S(c4, 3, 3));

  WriteLn;
  c3.S := CmpMul(c1, c2);
  WriteLn(C2S(c1, 3, 3),' * ',C2S(c2, 3, 3), ' = ',
          C2S(c3, 3, 3));
  c4.S := CmpDiv(c3, c2);
  WriteLn('check: ',C2S(c3, 3, 3), ' / ',C2S(c2, 3, 3),
          ' = ', C2S(c4, 3, 3));

  WriteLn;
  WriteLn('Demo for complex exponential');
  WriteLn('Enter each value for A + Bi');
  Write('Enter A : ');
  ReadLn(c1.R);
  Write('Enter B : ');
  ReadLn(c1.I);
  c3.S := CmpExp(c1);
  WriteLn('EXP',C2S(c1, 3, 3), ' = ', C2S(c3, 3, 3));
  c1.R := 0;
  c1.I := 2*pi;
  c3.S := CmpExp(c1);
  WriteLn('EXP(0 + 2'#227'i) = ', C2S(c3, 3, 3));
  WriteLn('(should always be 1 + 0i)');

  WriteLn;
  WriteLn('Demo for complex sinh and cosh function ');
  WriteLn('Enter each value for A + j B ');
  Write('Enter A : ');
  ReadLn(c1.R);
  Write('Enter B : ');
  ReadLn(c1.I);

  c2.S := CmpSinh(c1);
  WriteLn('sinh',C2S(c1,3,3),' = ', C2S(c2,3,3));
  c3.S := CmpCosh(c1);
  WriteLn('cosh',C2S(c1,3,3),' = ', C2S(c3,3,3));
  c2.S := CmpMul(c2, c2);
  c3.S := CmpMul(c3, c3);
  c4.S := CmpSub(c3, c2);
  WriteLn('Sqr(cosh',C2S(c1, 3, 3), ') - Sqr(sinh',
          C2S(c1, 3, 3), ') = ', C2S(c4, 3, 3));
  WriteLn('(should always be 1 + 0i)');
END.
