Shared Interrupt Modification
-----------------------------

Purpose:
--------

This modification will allow a packet BBS using the CBBS, the W0RLI, the
KA2BQE, or WA7MBL V3.x code to install 4 ports using only one slot and
one interrupt request line (IRQ) on an IBM PC or compatible.  The change
is nondestructive since no traces are cut and can be easily removed.

Hardware:
---------

The DFI MS-400 board provides 4 ASYNC ports and is available from
several sources.  It comes in two flavors: XT and AT with the only
difference being the 8250 versus the 16450 chips.  As shipped from the
factory, the MS-400 requires one IRQ line per port.

Additional parts required are 4 small signal diodes (I used 1N914s
from Radio Shack) and a 4.7K resistor (1/8 or 1/4 watt).

JDR MicroDevices carries (or at least did so on Nov 1st, 1987) the
MS-400.  Their part number for the XT version is MCT-MS and it was priced
at $80.  Address: 110 Knowles Drive, Los Gatos, CA 95030.  Their phone
is (800)-538-5000 or (408)-866-6200 (for CA and non-US).

Another possible source is:

PINE COMPUTING, INC.
9690 Telestar Avenue
El Monte, CA 91731
(818) 575-1882

Brand Name is PINECOM
4 Serial Ports Card for AT (COM 1 to COM 8) --- $125.00
4 Serial Ports Card for XT (COM 1 to COM 8) --- $ 85.00

Planning:
---------

Unfortunately, you must plan your use of the ports since the exact
placement of the parts is dependent on the change.  First determine
how many ports will be for BBS use only and how many should be for
general use.

Some possible variations are below.  Note that the numbers must
be consecutive.

          Multipurpose ports          BBS Ports
          ------------------          ---------
                none                  COM 3,4,5,6
                COM 2                 COM 3,4,5
                COM 1,2               COM 3,4


These are not all the possible permutations.  In fact, two cards could
be used to provide 8 BBS ports if you like.  Trying to explain how to
set up all the possibilities would take many many pages of text.

The change outlined below forces all the BBS ports down IRQ2 leaving
the standard COM1 and COM2 IRQ lines alone.

Carrying out the change:
------------------------

Example will use COM2 as a multipurpose port and COM 3,4,5 for BBS.


1.  Referring to your MS-400 booklet, set the address dip switches (SW1)
    for the lowest port you want to use.  Example: COM2 (off off on).

2.  Set the dip switches that select the IRQ lines for the multipurpose
    ports ONLY!!  COM1 uses IRQ4, COM2 uses IRQ3.  Example: SW2 #2 is on
    while all the rest are off.

3.  Turn over the card to the side without the parts and locate the
    pins that correspond to the dip switches SW2 and SW3.

4.  For each BBS only port, solder a diode across the DIP switch
    position that corresponds to IRQ2.  The cathode should be away
    from the edge connector.  The diode makes the path that the switch
    would have.  One way to find the exact position is to turn on IRQ2
    for all the BBS ports and test for the proper pins with an ohm
    meter.  Solder the diodes in place and then TURN OFF the IRQ2
    switches.

5.  Run a quick ohm meter test to make sure the diodes are in the
    right spot.  The cathode ends of the diodes should all show
    continuity between each other.  The anode ends should not!

6.  Solder the 4.7K resistor between the cathode end of any diode and
    ground.  There are several nearby ground lines that can be used.
    I used pin 7 of the big 25 pin RS-232 connector for the first port.
    Warning!!!  The broad trace around the edge of the card
    is not ground.  It is +5 volts.  The ground lines will show
    continuity to pin B3 (third from the left of the edge connector).

7.  That's it.  You are ready for the smoke test.  As you can see,
    the modifications are non-destructive.  Simply unsoldering the
    diodes and the resistor will return the card to the factory state.

Software Changes:
-----------------

No changes are needed to the mailbox programs themselves but the I/O
routine must be setup.  You will need MBBIOS V2.0 or higher plus the
accompanying customizer (MBBCONFG).

1.  Execute MBBCONFG as per the instructions included with MBBIOS.

2.  Put any multipurpose ports in the first slot (and second if needed).

3.  Select the next slot.  On the port description panel, specify the
    type as "B" ("Specified exactly"), put in the desired COM number
    and hit enter.

4.  On the exact specification panel, put the actual port type as "5"
    ("Shared ASYNC Port").  Specify the address as shown below and the
    interrupt number as "2"

              COM1  --  3F8         COM5  --  2F0
              COM2  --  2F8         COM6  --  2E8
              COM3  --  3E8         COM7  --  2E0
              COM4  --  3E0         COM8  --  260

5.  Repeat steps 3 and 4 for each BBS only port.

6.  Exit the program using the "F3" key.

Running the code:
-----------------

Before running your mailbox program, MBBIOS must be initialized.  MBBIOS
should respond with an "MBBIOS ready" message.  The CBBS and W0RLI users
should now issue an MBMODE for each port the mailbox will use.

That's all folks!

Some notes:
-----------

Thanks to K4NTA, KB6IRS, and W0RLI for supporting this work.

You are not restricted to the addresses shown above or IRQ2.  I used
them to try and simplify matters for most people who won't care.

If you need some weird configuration or want to install more than one
card, drop me a note either via U.S.  Mail, packet via AA4RE BBS, or
COMPUSERV.  I can also be contacted through the IBM Radio Club.

If you are absolutely confused as to where the diodes go, send me an
SASE with your desired setup and I will return a board layout with the
pins needed marked.

Roy Engehausen
AA4RE
8660 Del Rey Court
Gilroy, CA  95020

