/*-----------------------------------------------------------------------*
 * Greg Stevens                                                   6/24/93*
 *                              NNCOMPET.C                               *
 *                                             [file 7 in a series of 7] *
 *                                                                       *
 * This file contains a function for updating activations in a layer in  *
 * an all-or-none format per groupings of nodes.  This file also defines *
 * constants for the number of clusters for each node.  The all-or-none  *
 * cluster function assumes that each cluster will be of the same size,  *
 * so it creates NUM_CLUSTERS_# for layer # each of size                 *
 * NUMNODES[#] / NUM_CLUSTERS_# -- SO IT MUST BE EVENLY DIVISIBLE!       *
 *  In the constant definitions, if a layer is not being used, the number*
 * ofclusters should be set to 0.                                        *
 *                                                                       *
 *  To implement competative learning, all you have to do is include this*
 * file in your main program instead of nnhebbln.c.                      *
 *                                                                       *
 *  For all the references to layers in this module, layers are numbered *
 * 0 - (NUM_LAYERS-1), so the input layer is layer 0.                    *
 *                                                                       *
 *-----------------------------------------------------------------------*/
#include "nnhebbln.c"

/* Definitions for the numbers of clusters in each layer */

#define NUM_CLUSTERS_0  1
#define NUM_CLUSTERS_1  0
#define NUM_CLUSTERS_2  0
#define NUM_CLUSTERS_3  0
#define NUM_CLUSTERS_4  0
#define NUM_CLUSTERS_5  0
#define NUM_CLUSTERS_6  0
#define NUM_CLUSTERS_7  0
#define NUM_CLUSTERS_8  0
#define NUM_CLUSTERS_9  0

/* Function Prototype */
NNETtype AllOrNoneLayerActs( NNETtype oldn, int l );

/* Function Definition */
NNETtype AllOrNoneLayerActs( NNETtype oldn, int l )
{
   NNETtype n;
   int u;                 /* looping variable for nodes                  */
   int c;                 /* looping variable for clusters               */
   int Winner;            /* index for winning node                      */
   int NUMCLUSTERS;       /* stores the number of clusters in this layer */

   n = oldn;

   /* initialize NUMCLUSTERS */
   if (l==1)
     NUMCLUSTERS = NUM_CLUSTERS_0;
   else if (l==2)
     NUMCLUSTERS = NUM_CLUSTERS_1;
   else if (l==3)
     NUMCLUSTERS = NUM_CLUSTERS_2;
   else if (l==4)
     NUMCLUSTERS = NUM_CLUSTERS_3;
   else if (l==5)
     NUMCLUSTERS = NUM_CLUSTERS_4;
   else if (l==6)
     NUMCLUSTERS = NUM_CLUSTERS_5;
   else if (l==7)
     NUMCLUSTERS = NUM_CLUSTERS_6;
   else if (l==8)
     NUMCLUSTERS = NUM_CLUSTERS_7;
   else if (l==9)
     NUMCLUSTERS = NUM_CLUSTERS_8;
   else if (l==10)
     NUMCLUSTERS = NUM_CLUSTERS_9;

   /* calculate winner of each cluster  */

   u = 0;
   for (c=1; (c<=NUMCLUSTERS); ++c)              /* for each cluster... */
    {
      Winner = u;                                /* reset winner to 0   */

      /* calculate winner */

      for (u=u; (u < (c * (NUMNODES[l]/NUMCLUSTERS))); ++u ) /* count units */
       {                                                     /* this cluster*/
        if (n.unit[l][u].state>n.unit[l][Winner].state)
           Winner = u;
       }

      /* reset values for winner takes all  */

      for (u=0; (u<NUMNODES[l]); ++u)
         if (u==Winner)
           n.unit[l][u].state = 1.0;
         else
           n.unit[l][u].state = 0.0;
    }

   return( n );
}
