;;*****************************************************************************
;;                      config.inc    config.inc
;;*****************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;******************************************************************************
;;
;; AUTHOR:  Vance Morrison
;; DATE  :  12/88
;; ADDRESS: morrison@accuvax.nwu.edu
;;
;;*****************************************************************************



;; types of interfaces
CONF_GENERIC    =   1       ;; interface that requires no special config data
CONF_LOCALTALK  =   2       ;; Special localtalk extentions (zone name etc)
CONF_SLIP       =   3       ;; Serial line (SLIP interface) 

CONF_ROUTE      =   10      ;; static route configuration data
CONF_BOOTP      =   20      ;; Bootp configration data (forwarding host)
CONF_ADMIN      =   21      ;; administrative data (admin host)
CONF_SYSLOG     =   22      ;; host to send syslog messages to


;;************************************************************************
;; CONFIG reads in the configuration data from pcroute.cfg, and configures 
;; all the router objects.  If it is not successful it jumps to 'fail'.
;; 'dlog' is the Disk logger object to log errors to
;;
CONFIG MACRO fail, dlog
    local config_failed, open_failed, read_failed, done

    .DATA
    DB 'CONFIG ->'              ;; flags so we can find this in the
                                ;; executable (read only)
    irp idx,<1,2,3,4,5,6,7,8>   ;; config all the Ethernets first
        CONF_DECLARE_ARP idx
    endm
    irp idx,<1,2,3,4,5,6,7,8>   ;; config the localtalks next
        CONF_DECLARE_LOCALTALK idx
    endm
    irp idx,<1,2,3,4,5,6,7,8>   ;; config the SLIPs next
        CONF_DECLARE_SLIP idx
    endm
    DB CONF_ROUTE, 1
    DB CONF_BOOTP, 1
    DB CONF_SYSLOG, 1
    DB 0, 0, '<- CONFIG'

    config_data     DW 64 dup (0)

    .CODE
    TIMER_DEFINE %mytimer

    CONFIG_OPEN_DATA open_failed, 64

    irp idx,<1,2,3,4,5,6,7,8>   ;; config the ethernets
        CONF_DEFINE_OTHER idx, dlog, fail
    endm

    ifdef bdg_1_declared
        BDG_DEFINE 1
    endif

    irp idx,<1,2,3,4,5,6,7,8>   ;; config the ethernets
        CONF_DEFINE_ARP idx, dlog, fail, read_failed, config_failed
    endm

    irp idx,<1,2,3,4,5,6,7,8>  ;; config the localtalks next
       CONF_DEFINE_LOCALTALK idx, dlog, fail, read_failed, config_failed
    endm

    irp idx,<1,2,3,4,5,6,7,8>  ;; config the SLIPs next
       CONF_DEFINE_SLIP idx, dlog, fail, read_failed, config_failed
    endm 

    RIP_DEFINE %myrip

    IP_DEFINE %myip

    CONF_DEFINE_ROUTE %myrip, dlog, fail, read_failed, config_failed

    ICMP_DEFINE %myicmp

    UDP_DEFINE %myudp

    CONF_DEFINE_BOOTP %mybootp, dlog, fail, read_failed, config_failed

    CONF_DEFINE_SYSLOG %mylog, dlog, fail, read_failed, config_failed
    jmp done

    open_failed:
        DLOG_PRINT dlog, <Could not open configuration file>
        jmp fail
    read_failed:
        DLOG_PRINT dlog, <Error reading configuration file>
        jmp fail
    config_failed:
        DLOG_PRINT dlog, <Configuration file corrupt or out of sync>
        jmp fail
    done:
ENDM

;;**************************************************************************
CONF_DEFINE_OTHER MACRO name, dlog, fail
    local around, pktfail
    .errb <name>
    .errb <dlog>
    .errb <fail>

    ifdef wd_&name&_declared
        WD_DEFINE name
    endif

    ifdef wde_&name&_declared
        WDE_DEFINE name
    endif

    ifdef pkt_&name&_declared
        PKT_DEFINE name, pktfail
		jmp around
		pktfail:
			DLOG_PRINT dlog, <ERROR Packet Driver config failed (driver not installed?)>
        jmp fail
    around:
    endif

    ifdef c507_&name&_declared
        C507_DEFINE_out_AX name, fail
    endif

    ifdef eth_&name&_declared
        ETH_DEFINE name
    endif

ENDM



;;**************************************************************************
;; If the ARP DL_IP 'name' object exists, then CONF_DECLARE_ARP defines 
;; the flag that will tell the configuration program that configuration 
;; information  for a ARP DL_IP object is needed.
;;
CONF_DECLARE_ARP MACRO name
    .errb <name>

    ifdef arp_&name&_declared
        DB CONF_GENERIC, 2          ;; type and version
    endif
ENDM

;;**************************************************************************
;; If the ARP object 'name' exists CONF_DEFINE_ARP reads in the configuration
;; data and initializes the ARP object.
;;
CONF_DEFINE_ARP MACRO name, dlog, fail, read_failed, config_failed
    .errb <config_failed>

ifdef arp_&name&_declared

    mov DX, offset config_data
    CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 4, read_failed
    cmp word ptr config_data, (CONF_GENERIC)+256*2  ;; type generic, version 2
    jnz config_failed

    CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 12, read_failed
    DLOG_PRINT dlog, <Interface name (ethernet)>
    mov AX, word ptr config_data
    mov BX, word ptr config_data+2
    DLOG_PRINT_INET_in_AX_BX dlog, <    Address >

    mov AX, word ptr config_data+4
    mov BX, word ptr config_data+6
    DLOG_PRINT_INET_in_AX_BX dlog, <    NetMask >

    mov AX, word ptr config_data+8
    DLOG_PRINT_REG_HEX dlog, <    Flags     >, AX
    mov word ptr dl_ip_&name&_flags, AX

    mov BX, word ptr config_data+10
    DLOG_PRINT_REG_HEX dlog, <    Metric    >, BX
    mov word ptr dl_ip_&name&_metric, BX

    ARP_DEFINE name, config_data, (config_data+4)

    mov SI, offset dl_ip_&name&_haddr
    lodsw
    xchg AH, AL
    DLOG_PRINT_REG_HEX dlog, <    The Ethenet Address >, AX
    lodsw
    xchg AH, AL
    DLOG_PRINT_REG_HEX dlog, <    The Ethenet Address >, AX
    lodsw
    xchg AH, AL
    DLOG_PRINT_REG_HEX dlog, <    The Ethenet Address >, AX
endif
ENDM


;;**************************************************************************
;; If the ATP DL_IP 'name' object exists, then CONF_DECLARE_LOCALTALK defines 
;; the flag that will tell the configuration program that configuration 
;; information  for a localtalk DL_IP is needed.
;;
CONF_DECLARE_LOCALTALK MACRO name
    .errb <name>
    ifdef atp_&name&_declared
        DB CONF_LOCALTALK, 2            ;; type and version
    endif
ENDM

;;**************************************************************************
;; If the ATP object 'name' exists CONF_DEFINE_LOCALTALK reads in the 
;; configuration data and initializes the ATP object.
;;
CONF_DEFINE_LOCALTALK MACRO name, dlog, fail, read_failed, config_failed
    local myfail, done
    .errb <config_failed>
ifdef atp_&name&_declared

    mov DX, offset config_data
    CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 2, read_failed
    cmp word ptr config_data, (CONF_LOCALTALK)+256*2  ;; type generic, version 2
    jnz config_failed

    CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 2, read_failed
    mov CX, config_data
    cmp CX, 128
    

    CONFIG_GET_DATA_in_CX_DX_const_CX_DX_BP_SI_DI read_failed
    DLOG_PRINT dlog, <Interface name (localtalk)>
    mov AX, word ptr config_data
    mov BX, word ptr config_data+2
    DLOG_PRINT_INET_in_AX_BX dlog, <    Address >

    mov AX, word ptr config_data+4
    mov BX, word ptr config_data+6
    DLOG_PRINT_INET_in_AX_BX dlog, <    NetMask >

    mov AX, word ptr config_data+8
    DLOG_PRINT_REG_HEX dlog, <    Flags     >, AX
    mov word ptr dl_ip_&name&_flags, AX

    mov BX, word ptr config_data+10
    DLOG_PRINT_REG_HEX dlog, <    Metric    >, BX
    mov word ptr dl_ip_&name&_metric, BX

    ATP_DEFINE name, config_data, (config_data+4), (config_data+12),myfail
    mov SI, offset dl_ip_&name&_haddr
    lodsw
    xchg AH, AL
    DLOG_PRINT_REG_HEX dlog, <    The Localtalk Network >, AX
    lodsb
    xor AH, AH
    DLOG_PRINT_REG_HEX dlog, <    The Localtalk Node ID >, AX

    jmp done
    myfail:
        DLOG_PRINT dlog, <ERROR Localtalk config failed (driver not installed?)>
        jmp fail
    done:
endif
ENDM


;;**************************************************************************
;; If the SLIP DL_IP 'name' object exists, then CONF_DECLARE_SLIP defines 
;; the flag that will tell the configuration program that configuration 
;; information  for a SLIP DL_IP is needed.
;;
CONF_DECLARE_SLIP MACRO name
    .errb <name>
    ifdef slip_&name&_declared
        DB CONF_SLIP, 1                 ;; type and version
    endif
ENDM
 
;;**************************************************************************
;; If the SLIP object 'name' exists CONF_DEFINE_SLIP reads in the 
;; configuration data and initializes the SLIP object.
;;
CONF_DEFINE_SLIP MACRO name, dlog, fail, read_failed, config_failed
    local myfail, done
    .errb <config_failed>
ifdef slip_&name&_declared
 
    mov DX, offset config_data
    CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 4, read_failed
    cmp word ptr config_data, (CONF_SLIP)+256*1     ;; type generic, version 1
    jnz config_failed
 
    CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 14, read_failed
    DLOG_PRINT dlog, <Interface name (slip)>
    mov AX, word ptr config_data
    mov BX, word ptr config_data+2
    DLOG_PRINT_INET_in_AX_BX dlog, <    Address >
 
    mov AX, word ptr config_data+4
    mov BX, word ptr config_data+6
    DLOG_PRINT_INET_in_AX_BX dlog, <    NetMask >
 
    mov AX, word ptr config_data+8
    DLOG_PRINT_REG_HEX dlog, <    Flags     >, AX
    mov word ptr dl_ip_&name&_flags, AX

    mov BX, word ptr config_data+10
    DLOG_PRINT_REG_HEX dlog, <    Metric    >, BX
    mov word ptr dl_ip_&name&_metric, BX

    BUFF_DEFINE %(name*100+1)
    QUEUE_DEFINE %(name*100+2)
    BUFF_DEFINE %(name*100+3)
    QUEUE_DEFINE %(name*100+4)
    Q_IF_DEFINE name     
    SLIP_DEFINE name     
    PP_DEFINE name, config_data, (config_data+4)
    mov BX, word ptr config_data+12
    I8250_DEFINE_in_BX name, myfail

    mov AX, word ptr config_data+12
    DLOG_PRINT_REG_HEX dlog, <    The SLIP baud divisor >, AX
 
    jmp done
    myfail:
        DLOG_PRINT dlog, <ERROR SLIP config failed (no serial port)>
        jmp fail
    done:
endif
ENDM
 

;;**************************************************************************
;; CONF_DEFINE_ROUTE reads in the routing information on the disk and 
;; initializes the static routes.
;;
CONF_DEFINE_ROUTE MACRO rip, dlog, fail, read_failed, config_failed
    local route_loop, route_done
    .errb <config_failed>

    mov DX, offset config_data
    CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 4, read_failed
    cmp word ptr config_data, (CONF_ROUTE)+256*1    ;; type rip, version 1
    jnz config_failed

    CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 2, read_failed
    mov CX, config_data
    cmp CX, 300
    ja config_failed

    mov AX, DS
    mov ES, AX
    mov DI, offset config_data+4

    DLOG_PRINT dlog, <STATIC ROUTES>
    route_loop:
        or CX, CX
        jz route_done

        mov SI, CX                  ;; save CX without changing stack
        mov DX, offset config_data
        CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 10, read_failed
        push SI                     ;; save CX on the stack

        mov AX, word ptr config_data
        mov BX, word ptr config_data+2
        DLOG_PRINT_INET_in_AX_BX dlog, <    Route to network >
        mov AX, word ptr config_data+4
        mov BX, word ptr config_data+6
        DLOG_PRINT_INET_in_AX_BX dlog, <    Through gateway  >
        xor AH, AH
        mov AL, byte ptr config_data+8
        DLOG_PRINT_REG_HEX dlog, <    Metric >, AX
        mov AL, byte ptr config_data+9
        DLOG_PRINT_REG_HEX dlog, <    Flags  >, AX
        DLOG_PRINT dlog, < >

        mov SI, offset config_data
        mov CX, word ptr config_data+8
        ROUTE_ADD_in_CX_SI_DI_ES_const_DI_ES rip
        pop CX
        dec CX
    jmp route_loop
    route_done:
ENDM


;;**************************************************************************
;; CONF_DEFINE_BOOTP reads in the bootp information on the disk and initializes
;; the BOOTP object
;;
CONF_DEFINE_BOOTP MACRO mybootp, dlog, fail, read_failed, config_failed
    .errb <config_failed>

    mov DX, offset config_data
    CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 4, read_failed
    cmp word ptr config_data, (CONF_BOOTP)+256*1    ;; type bootp, version 1
    jnz config_failed

    CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 4, read_failed
    mov AX, word ptr config_data
    mov BX, word ptr config_data+2
    DLOG_PRINT_INET_in_AX_BX dlog, <Forwarding BOOTP requests to       >
    BOOTP_DEFINE mybootp, config_data
ENDM


;;**************************************************************************
;; CONF_DEFINE_SYSLOG reads in the bootp information on the disk and initializes
;; the BOOTP object
;;
CONF_DEFINE_SYSLOG MACRO mylog, dlog, fail, read_failed, config_failed
    .errb <config_failed>

    mov DX, offset config_data
    CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 4, read_failed
    cmp word ptr config_data, (CONF_SYSLOG)+256*1    ;; type syslog, version 1
    jnz config_failed

    CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI 8, read_failed
    mov AX, word ptr config_data
    mov BX, word ptr config_data+2
    DLOG_PRINT_INET_in_AX_BX dlog, <Logging messages to SYSLOGD on host >
    mov AX, word ptr config_data+4
    mov BX, word ptr config_data+6
    DLOG_PRINT_REG_HEX dlog, <Logging level >, AX
    DLOG_PRINT_REG_HEX dlog, <Logging mask >, BX
    LOG_DEFINE_in_AX_BX mylog, config_data
ENDM


;;**************************************************************************
;; CONFIG_OPEN_DATA opens 'pcroute.cfg' for reading.  It enforces a limit
;; on a read of 'max_size'.  If the open fails it jumps to 'fail'
;;
CONFIG_OPEN_DATA MACRO fail, max_size
    .errb <max_size>

    .DATA
    config_file     db 'pcroute.cfg', 0
    config_handle   dw ?
    config_max_size = max_size

    .CODE
    mov DX, offset config_file
    mov AH, 3DH                                     ;; open the file
    mov AL, 0                                       ;; open for reading
    int 21H
    jc fail
    mov config_handle, AX                           ;; save handle
ENDM


;;**************************************************************************
;; CONFIG_GET_DATA reads in the next 'len' bytes from the file open with
;; CONFIG_OPEN_DATA.  It puts the info in the buffer DX:DS.  If there 
;; is a error it jumps to 'fail'
;;
CONFIG_GET_DATA_in_DX_const_DX_BP_SI_DI MACRO len, fail
    .errb <fail>

    if len gt config_max_size
        .err                                    ;; length to big!!
    endif

    mov CX, len
    CONFIG_GET_DATA_in_CX_DX_const_CX_DX_BP_SI_DI fail
ENDM

;;**************************************************************************
;; CONFIG_GET_DATA reads in the next 'CX' bytes from the file open with
;; CONFIG_OPEN_DATA.  It puts the info in the buffer DX:DS.  If there 
;; is a error it jumps to 'fail'
;;
CONFIG_GET_DATA_in_CX_DX_const_CX_DX_BP_SI_DI MACRO fail
    .errb <fail>

    mov AH, 3FH                                 ;; Read a block
    mov BX, config_handle
    int 21H                                     ;; read the ip info
    jc fail
    cmp AX, CX
    jnz fail
ENDM

