// Song header file (SONG.H)
//
// Written 1996, 1997 by Roland Acton - public domain.
//
// This file is part of the Game Music System 1.1 distribution.

// Things relating to the song class.

#ifndef INCLUDED_SONG
#define INCLUDED_SONG

#include "inst.h"
#include "block.h"

union overall_am_vib_union {
  unsigned char byte;
  struct {
    unsigned hi_hat : 1;
    unsigned cymbal : 1;
    unsigned tom_tom : 1;
    unsigned snare_drum : 1;
    unsigned bass_drum : 1;
    unsigned percussion_mode : 1;
    unsigned deep_vibrato: 1;
    unsigned deep_amplitude_modulation: 1;
  } bitmap;
};

struct effect_info {
  effect_info *next_effect;
  unsigned int effect_id;
  unsigned int pointers_valid;
  unsigned int effect_pattern;
  unsigned int effect_block;
  unsigned int effect_line;
  unsigned char *effect_note[MAX_TRACKS];
  int jump_pattern;
};

class song {
public:
  static char name[50 + 1];
  static char *info_page;   // Points to 14 null-terminated lines.
  static unsigned int highest_block;
  static block *block_pointer[MAX_BLOCKS];
  static unsigned int highest_pattern;
  static unsigned int pattern_list[MAX_PATTERNS];
  static instrument *instrument_pointer[MAX_INSTRUMENTS];
  static unsigned int highest_stereo_left;
  static unsigned int lowest_stereo_right;
  static unsigned int highest_track;
  static enum sound_cards {adlib, sb, sbpro1, sbpro2} soundsystem;
  static unsigned int percussion_mode;
  static overall_am_vib_union overall_am_vib;
  static unsigned int current_pattern;
  static unsigned int current_block;
  static unsigned int current_line;
  static unsigned char *current_note[MAX_TRACKS];
  static unsigned int tempo;
  static unsigned int secondary_tempo;
  static const char tracker_id_string[][20];
  static const unsigned int tracker_id_length[];
  static const unsigned int tracker_id_position[];
#ifdef EDITOR_HOOKS
  static const char inst_id_string[][20];
  static const unsigned int inst_id_length[];
#endif
  static unsigned int in_subroutine;
  static unsigned int subroutine_pattern_memory;
  static unsigned int subroutine_line_memory;
  static effect_info *effect_list;
  static unsigned int next_effect_id;

  static void set_up_class();
  static void shut_down_class();
  static void position_jump(unsigned int new_pattern,
    unsigned int new_line = 0);
  static void block_jump(unsigned int new_block, unsigned int new_line = 0);
  static void skip_note(unsigned char *&note);
  static void advance_line();
  static void start_subroutine(unsigned int subroutine_pattern,
    unsigned int restart_block_on_finish = YES);
  static void cancel_subroutine();
  static unsigned int start_effect(unsigned int effect_pattern);
  static void cancel_effect(unsigned int id_to_cancel);
  static void cancel_all_effects();
  static block *block_at_pattern(unsigned int pattern)
    {return block_pointer[pattern_list[pattern]];}
#ifdef EDITOR_HOOKS
  static void editor_reformat();
  static gms_function_return_codes autoload_module(FILE *module);
  static gms_function_return_codes load_rad(FILE *module);
  static gms_function_return_codes load_amd(FILE *module);
  static gms_function_return_codes load_midi(FILE *module);
  static unsigned int read_midi_vlq(FILE *module);
  static void save_gms(FILE *module);
  static gms_function_return_codes autoload_instrument(FILE *inst_file,
    unsigned int inst_num);
  static gms_function_return_codes load_gmi(FILE *inst_file,
    unsigned int inst_num);
  static gms_function_return_codes load_wav(FILE *inst_file,
    unsigned int inst_num);
  static gms_function_return_codes load_raw_signed_sample(FILE *inst_file,
    unsigned int inst_num);
  static gms_function_return_codes load_raw_unsigned_sample(FILE *inst_file,
    unsigned int inst_num);
  static void save_gmi(FILE *inst_file, unsigned int inst_num);
  static void do_gmi_save(FILE *inst_file, instrument *save_inst);
#endif
  static void wipe_old_song();
  static gms_function_return_codes load_gms(FILE *module);
  static gms_function_return_codes do_gmi_load(FILE *inst_file,
    instrument *load_inst, unsigned char instrument_version);
  static gms_function_return_codes prepare_all_samples();
  static void unprepare_all_samples();
};



// Skips to the next note.
inline void song::skip_note(unsigned char *&note) {

// *** change to assert(note)
  if (note)   // Don't advance an "empty" track.
    if (*(note++) & 128)
      if (*(note++) & 128) {
        while (*note & 128)
          note += 2;
        note += 2;
      }
}



#ifdef COMPILING_SONG
const char song::tracker_id_string[][20] =
  {{'G', 'M', 'S', '-', 'R', 'C', 'A', '~', '~', '~',     // GMS x.x
    '~', '~', '~', '~', '~', '~', '~', '~', '~', '~'}
#ifdef EDITOR_HOOKS
,
   {'R', 'A', 'D', ' ', 'b', 'y', ' ', 'R', 'E', 'A',     // RAD 1.0/1.1
    'L', 'i', 'T', 'Y', '!', '!', '~', '~', '~', '~'},
   {'<', 'o',0xEF, 'Q', 'U',0xEE, 'R', 'o', 'R', '~',     // AMD 1.0/1.1
    '~', '~', '~', '~', '~', '~', '~', '~', '~', '~'},
   {'M', 'T', 'h', 'd', '~', '~', '~', '~', '~', '~',     // MIDI 1.0
    '~', '~', '~', '~', '~', '~', '~', '~', '~', '~'}};
#else
};
#endif
// The magic cookies that let GMS recognize tracker datafiles.

const unsigned int song::tracker_id_length[] =
  {7      // GMS x.x
#ifdef EDITOR_HOOKS
,
   16,    // RAD 1.0/1.1
   9,     // AMD 1.0/1.1
   4};    // MIDI 1.0
#else
};
#endif
// The number of characters in each magic cookie.

const unsigned int song::tracker_id_position[] =
  {0      // GMS x.x
#ifdef EDITOR_HOOKS
,
   0,       // RAD 1.0/1.1
   0x426,   // AMD 1.0/1.1
   0};      // MIDI 1.0
#else
};
#endif
// The offset where the magic cookie can be found within the file.

  char song::name[50 + 1];
  char *song::info_page;   // Points to 14 null-terminated lines.
  unsigned int song::highest_block;
  block *song::block_pointer[MAX_BLOCKS];
  unsigned int song::highest_pattern;
  unsigned int song::pattern_list[MAX_PATTERNS];
  instrument *song::instrument_pointer[MAX_INSTRUMENTS];
  unsigned int song::highest_stereo_left;
  unsigned int song::lowest_stereo_right;
  unsigned int song::highest_track;
  enum song::sound_cards song::soundsystem;
  unsigned int song::percussion_mode;
  overall_am_vib_union song::overall_am_vib;
  unsigned int song::current_pattern;
  unsigned int song::current_block;
  unsigned int song::current_line;
  unsigned char *song::current_note[MAX_TRACKS];
  unsigned int song::tempo;
  unsigned int song::secondary_tempo;
  unsigned int song::in_subroutine;
  unsigned int song::subroutine_pattern_memory;
  unsigned int song::subroutine_line_memory;
  effect_info *song::effect_list;
  unsigned int song::next_effect_id;
#endif   // #ifdef COMPILING_SONG

#define GMS_MOD_OFFSET 0
#define RAD_MOD_OFFSET 1
#define AMD_MOD_OFFSET 2
#define MIDI_MOD_OFFSET 3
#define HIGHEST_MOD_OFFSET 3

#ifdef COMPILING_SONGEXT
const char song::inst_id_string[][20] =
  {{'G', 'M', 'I', '-', 'R', 'C', 'A', '~', '~', '~',     // GMI x.x
    '~', '~', '~', '~', '~', '~', '~', '~', '~', '~'},
   {'R', 'I', 'F', 'F', '~', '~', '~', '~', '~', '~',     // WAV x.x
    '~', '~', '~', '~', '~', '~', '~', '~', '~', '~'}};
/* Magic cookies for instruments. "Raw-sample" format does not have a magic
   cookie, of course. */

const unsigned int song::inst_id_length[] =
  {7,    // GMI x.x
   4};   // WAV x.x

#define GMS_INST_OFFSET 0
#define WAV_INST_OFFSET 1
#define HIGHEST_INST_OFFSET 1
#endif   // #ifdef COMPILING_SONGEXT

#ifdef EDITOR_HOOKS
  #ifdef COMPILING_SONG
    song song_obj;
  #else
    extern song song_obj;
  #endif
#endif

#endif   // #ifndef INCLUDED_SONG
