// Player example program code file (PLAYER.CPP)
//
// Written 1996, 1997 by Roland Acton - public domain.
//
// This file is part of the Game Music System 1.1 distribution.

// A simple program to load and play GMS modules.

#define COMPILING_PLAYER

#include "globals.h"
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#ifdef TARGET_MSDOS
  #include <conio.h>
#else
  #include "msonly.h"
#endif
#include "inst.h"
#include "block.h"
#include "song.h"
#include "musdrv.h"



int main (int argc, char *argv[]) {
  int counter;
  FILE *module;

  cout << "Game Music System 1.1 command-line player" << endl;
  cout << "Written by Roland Acton in 1996, 1997 - public domain" << endl;
  if (argc > 1) {   // Did the user type a filename?
    cout << endl;
    cout << "Press any key to stop playing." << endl;
    cout << endl;
/* NOTE: For the sake of simplicity, this is wrong. I should be asking the
   user for these values, not assuming them. */
    song::set_up_class();
    music_driver::set_up_driver(song::adlib, 0x220, 5, 1);
    counter = 1;
    while (counter < argc) {   // Loop until all files have been played.
      cout << argv[counter] << ": " << flush;
      module = fopen(argv[counter], "rb");
      if (module) {   // Check to make sure file exists.
        cout << "loading..." << flush;
        if (song::load_gms(module) == gms_function_success) {
                                   // Make sure it is a GMS module.
/* NOTE: This allows the saved song's sound system to override the adlib
   setting in the call to music_driver::set_up_driver(). */
// Start interrupt.
          if (music_driver::wedge_player() == gms_function_failure) {
            cout << "couldn't wedge player!" << flush;
            return EXIT_FAILURE;
          }
          if (song::soundsystem >= song::sb
            && music_driver::wedge_dsp_handler() == gms_function_failure) {
            cout << "couldn't wedge dsp handler!" << flush;
            music_driver::remove_player();
            return EXIT_FAILURE;
          }
          if (song::prepare_all_samples() == gms_function_failure)
            cout << "could not prepare all samples..." << flush;
          music_driver::reset_card();
          music_driver::set_up_card();
          cout << "playing..." << flush;
          song::position_jump(0);
          music_driver::start_playing();
          getch();   // Wait until user presses a key.
          music_driver::stop_playing();
          music_driver::reset_card();
          song::unprepare_all_samples();
          if (song::soundsystem >= song::sb)
            music_driver::remove_dsp_handler();
          music_driver::remove_player();   // Remove interrupt.
          cout << "done." << flush;
        }
        else {
          cout << "not a GMS 1.0/1.1 module." << flush;
        }
      }
      else {
        cout << "couldn't open file." << flush;
      }
      cout << endl;
      counter++;
    }
    song::shut_down_class();
  }
  else {
    cout << "Syntax: PLAYER <filename> [<filename>] [...]" << endl;
  }
  return EXIT_SUCCESS;
}
