Unit Assemblify;
{* S Compiler, ver 1.00.
   Copyright (C) 1994, Henri LESOURD.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This compiler is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  *}

Interface

Uses
    Crt,Errorify,Symbolize,Lexify,Writify;

Type
    COP=(
           PUSH,POP,MOV,LEA,LES,XCHG,
           CMP,JZ,JNZ,JL,JLE,JG,JGE,JMP,
                      JB,JBE,JA,JAE,
           CNOT,CAND,COR,CXOR,
           CSHL,SAL,CSHR,SAR,RCR,RCL,
           NCALL,FCALL,RETN,RETF,
           ADD,ADC,CINC,CDEC,
           SUB,SBB,NEG,
           IMUL,MUL,
           CBW,CWD,IDIV,UDIV
        )
        ;

{ ***************
  Alloc registres
  *************** }
Var
   RegContains : Array[AX..rSS] Of TypedAddressPtr;
   RegFree     : Array[AX..rSS] Of Boolean;
   ByteAddr    : Boolean;

{ *******************
  Contexte du compilo
  ******************* }
Type
    ContextCompilo=Record
                     RegContainsValues : Array[AX..rSS] Of TypedAddress;
                     RegContains : Array[AX..rSS] Of TypedAddressPtr;
                     RegFree : Array[AX..rSS] Of Boolean;
                     BPtr : Word;
                   End;
Type
    ExeFileType=(BOOT,COM,OBJ);
Var
   FT : ExeFileType;
   Imports,Exports : ConsPtr;
   SizHeadFarFuncs : Word;

Procedure SetHiWord(Var V : LongInt; C : Integer);
Procedure SetLoWord(Var V : LongInt; C : Integer);
Function  HiWord(V : LongInt) : Integer;
Function  LoWord(V : LongInt) : Integer;
Procedure SetByteCode(P : Pointer; L : Word);
Function  GetByteCode : Pointer;
Function  GetBPtr : Word;
Procedure PokeB(B : Byte);
Procedure PokeBAt(I : Word; B : Byte);
Procedure PokeW(W : Word);
Procedure PokeWAt(I,W : Word);
Procedure PokeStr(A : Word);
Function  PokeSkippedStr(A : Word) : Word;
Procedure Assemble(C : COP; Var A1,A2 : TypedAddress);
Function  IsForWard(Var L : TypedAddress) : Boolean;
Procedure NewLabel(Var R : TypedAddress);
Procedure PutLabel(Var R : TypedAddress);
Procedure PutSigma(S : SymbPtr);

Var
   CompileToDisk : Boolean;

Procedure RecordObjFile(Var H : Header; Name : Word);
Procedure StartAssemblify(S : String);
Procedure EndAssemblify;
Procedure SaveContextCompilo(Var C : ContextCompilo);
Procedure RestoreContextCompilo(Var C : ContextCompilo);

