		   ---------------------------
		   -- Prime Sieve Benchmark --
		   ---------------------------

without type_check -- makes no difference

constant BATCH = 50
constant BENCH_TIME = 15

constant SIZE = 500  -- finds primes up to SIZE*2+1
		     -- (only tests odd numbers)
constant ON = 1, OFF = 0
constant SCREEN = 1

sequence flags 

function sieve()
    integer prime, start, count, still_prime

    count = 0
    flags = repeat(ON, SIZE)
    for i = 1 to SIZE do
	still_prime = flags[i]
	if still_prime then
	    prime = i + i
	    prime = prime + 1 
	    start = prime + i
	    for k = start to SIZE by prime do
		flags[k] = OFF
	    end for 
	    count = count + 1
	end if
    end for
    return count
end function

atom t, cycles

puts(SCREEN, "prime sieve benchmark ...\n")
cycles = 0
t = time()
while time() < t + BENCH_TIME do
    for iter = 1 to BATCH do
	if sieve() != 167 then
	    puts(SCREEN, "whoops!\n")
	end if
    end for
    cycles = cycles + BATCH
end while
t = time() - t
printf(SCREEN, "%6.1f sieves per second\n", cycles / t)

-- display results
puts(SCREEN, "   2") -- 2 is also a prime
for i = 1 to SIZE do
    if flags[i] then
	printf(SCREEN, " %3d", i*2+1)
    end if
end for

