#include "../h/gsupport.h"
#include <ctype.h>

/*
 * Prototype.
 */
unsigned short	*bitvect	Params((char *image,int len));

/*
 * Within translators, csets are internally implemented as a bit vector made
 *  from an array of unsigned shorts. For portability, only the lower 16
 *  bits of these shorts are used.
 */
#define BVectIndx(c) (((unsigned char)c >> 4) & 0xf)
#define BitInShrt(c) (1 << ((unsigned char)c & 0xf))

/*
 * Macros used by escape() to advance to the next character and to
 *  test the kind of character.
 */
#define NextChar(c) {c = *(*str_ptr)++; (*nchars_ptr)--;}
#define isoctal(c) ((c)>='0'&&(c)<='7')	/* macro to test for octal digit */

#if !EBCDIC
/*
 * esctab - translates single-character escapes in string literals.
 */

static unsigned char esctab[] = {
   000,   001,	 002,	003,   004,   005,   006,   007,   /* NUL-BEL */
   010,   011,	 012,	013,   014,   015,   016,   017,   /* BS -SI */
   020,   021,	 022,	023,   024,   025,   026,   027,   /* DLE-ETB */
   030,   031,	 032,	033,   034,   035,   036,   037,   /* CAN-US */
   ' ',   '!',   '"',   '#',   '$',   '%',   '&',   '\'',  /* !"#$%&' */
   '(',   ')',   '*',   '+',   ',',   '-',   '.',   '/',   /* ()*+,-./ */
   000,   001,	 002,	003,   004,   005,   006,   007,   /* 01234567 */
   010,   011,	 ':',   ';',   '<',   '=',   '>',   '?',   /* 89:;<=>? */
   '@',   'A',   '\b',  'C',   0177,  033,   014,   'G',   /* @ABCDEFG */
   'H',   'I',   'J',   'K',   '\n',  'M',  '\n',   'O',   /* HIJKLMNO */
   'P',   'Q',   '\r',  'S',   '\t',  'U',   013,   'W',   /* PQRSTUVW */
   'X',   'Y',   'Z',   '[',   '\\',  ']',   '^',   '_',   /* XYZ[\]^_ */
   '`',   'a',   '\b',  'c',   0177,  033,   014,   'g',   /* `abcdefg */
   'h',   'i',   'j',   'k',   '\n',  'm',   '\n',  'o',   /* hijklmno */
   'p',   'q',   '\r',  's',   '\t',  'u',   013,   'w',   /* pqrstuvw */
   'x',   'y',   'z',   '{',   '|',   '}',   '~',   0177,  /* xyz{|}~ */
   0200,  0201,  0202,	0203,  0204,  0205,  0206,  0207,
   0210,  0211,  0212,	0213,  0214,  0215,  0216,  0217,
   0220,  0221,  0222,	0223,  0224,  0225,  0226,  0227,
   0230,  0231,  0232,	0233,  0234,  0235,  0236,  0237,
   0240,  0241,  0242,	0243,  0244,  0245,  0246,  0247,
   0250,  0251,  0252,	0253,  0254,  0255,  0256,  0257,
   0260,  0261,  0262,	0263,  0264,  0265,  0266,  0267,
   0270,  0271,  0272,	0273,  0274,  0275,  0276,  0277,
   0300,  0301,  0302,	0303,  0304,  0305,  0306,  0307,
   0310,  0311,  0312,	0313,  0314,  0315,  0316,  0317,
   0320,  0321,  0322,	0323,  0324,  0325,  0326,  0327,
   0330,  0331,  0332,	0333,  0334,  0335,  0336,  0337,
   0340,  0341,  0342,	0343,  0344,  0345,  0346,  0347,
   0350,  0351,  0352,	0353,  0354,  0355,  0356,  0357,
   0360,  0361,  0362,	0363,  0364,  0365,  0366,  0367,
   0370,  0371,  0372,	0373,  0374,  0375,  0376,  0377,
  };
#else					/* EBCDIC */
/*
 *  This is the EBCDIC table for handling escapes.
 */
static char esctab[] = {
   0x00,  0x01,  0x02,  0x03,  0x04,  0x05,  0x06,  0x07,
   0x08,  0x09,  0x0a,  0x0b,  0x0c,  0x0d,  0x0e,  0x0f,
   0x10,  0x11,  0x12,  0x13,  0x14,  0x15,  0x16,  0x17,
   0x18,  0x19,  0x1a,  0x1b,  0x1c,  0x1d,  0x1e,  0x1f,
   0x20,  0x21,  0x22,  0x23,  0x24,  0x25,  0x26,  0x27,
   0x28,  0x29,  0x2a,  0x2b,  0x2c,  0x2d,  0x2e,  0x2f,
   0x30,  0x31,  0x32,  0x33,  0x34,  0x35,  0x36,  0x37,
   0x38,  0x39,  0x3a,  0x3b,  0x3c,  0x3d,  0x3e,  0x3f,
   ' ',   0x41,  0x42,  0x43,  0x44,  0x45,  0x46,  0x47,
   0x48,  0x49,  0x4a,  0x4b,  0x4c,  0x4d,  0x4e,  0x4f,
   0x50,  0x51,  0x52,  0x53,  0x54,  0x55,  0x56,  0x57,
   0x58,  0x59,  0x5a,  0x5b,  0x5c,  0x5d,  0x5e,  0x5f,
   0x60,  0x61,  0x62,  0x63,  0x64,  0x65,  0x66,  0x67,
   0x68,  0x69,  0x6a,  0x6b,  0x6c,  0x6d,  0x6e,  0x6f,
   0x70,  0x71,  0x72,  0x73,  0x74,  0x75,  0x76,  0x77,
   0x78,  0x79,  0x7a,  0x7b,  0x7c,  0x7d,  0x7e,  0x7f,
   0x80,  'a',   0x16,  'c',   0x07,  0x27,  0x0c,  'g',
   'h',   'i',   0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
   0x90,  'j',   'k',   0x25,  'm',   0x15,  'o',   'p',
   'q',   0x0d,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
   0xa0,  0xa1,  's',   0x05,  'u',   0x0b,  'w',   'x',
   'y',   'z',   0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
   0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
   0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
   0xc0,  'A',   0x16,  'C',   0x07,  0x27,  0x0c,  'G',
   'H',   'I',   0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
   0xd0,  'J',   'K',   0x25,  'M',   0x15,  'O',   'P',
   'Q',   0x0d,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
   0xe0,  0xe1,  'S',   0x05,  'U',   0x0b,  'W',   'X',
   'Y',   'Z',   0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
   0,   1,   2,   3,     4,     5,     6,     7,
   8,   9,   0xfa,   0xfb,  0xfc,  0xfd,  0xfe,  0xff,
   };
#endif               /* EBCDIC */

/*
 * escape - translate the character sequence following a '\' into the
 *   single character it represents.
 */
static int escape(str_ptr, nchars_ptr)
char **str_ptr;
int *nchars_ptr;
   {
   register int c, nc, i;

   /*
    * Note, it is impossible to have a character string ending with a '\',
    *  something must be here.
    */
   NextChar(c)
   if (isoctal(c)) {
      /*
       * translate an octal escape -- backslash followed by one, two, or three
       *  octal digits.
       */
      c -= '0';
      for (i = 2; *nchars_ptr > 0 && isoctal(**str_ptr) && i <= 3; ++i) {
         NextChar(nc)
         c = (c << 3) | (nc - '0');
         }
      return (c & 0377);
      }
   else if (c == 'x') {
      /*
       * translate a hexadecimal escape -- backslash-x followed by one or
       *  two hexadecimal digits.
       */
      c = 0;
      for (i = 1; *nchars_ptr > 0 && isxdigit(**str_ptr) && i <= 2; ++i) {
         NextChar(nc)
         if (nc >= 'a' && nc <= 'f')
             nc -= 'a' - 10;
         else if (nc >= 'A' && nc <= 'F')
            nc -= 'A' - 10;
         else if (isdigit(nc))
             nc -= '0';
         c = (c << 4) | nc;
         }
      return c;
      }
   else if (c == '^') {
      /*
       * translate a control escape -- backslash followed by caret and one
       *  character.
       */
      if (*nchars_ptr <= 0)
         return 0;           /* could only happen in a keyword */
      NextChar(c)
      return (c & 037);
      }
   else
      return esctab[c];
   }


/*
 * bitvect - convert cset literal into a bitvector
 */
unsigned short *bitvect(image, len)
char *image;
int len;
   {
   register int c;
   register unsigned short *bv;
   register int i;

   bv = 
    (unsigned short *)alloc((unsigned int)((BVectSize)*sizeof(unsigned short)));
   for (i = 0; i < BVectSize; ++i)
       bv[i] = 0;
   while (len-- > 0) {
      c = *image++;
      if (c == '\\')
         c = escape(&image, &len);
      bv[BVectIndx(c)] |= BitInShrt(c);
      }
   return bv;
   }

/*
 * cset_init - use bitvector for a cset to write an initialization for
 *    a cset block.
 */
novalue cset_init(f, bv)
FILE *f;
unsigned short *bv;
   {
   int size;
   unsigned short n;
   register int j;

   size = 0;
   for (j = 0; j < BVectSize; ++j)
      for (n = bv[j]; n != 0; n >>= 1)
         size += n & 1;
   fprintf(f, "{T_Cset, %d,\n", size);
   fprintf(f, "   cset_display(0x%x", bv[0]);
   for (j = 1; j < BVectSize; ++j)
      fprintf(f, ",0x%x", bv[j]);
   fprintf(f, ")\n    };\n");
   }

/*
 * prtstr - print an Icon string literal as a C string literal.
 */
int prt_i_str(f, s, len)
FILE *f;
char *s;
int len;
   {
   int c;
   int n_chars;

   n_chars = 0;
   while (len-- > 0) {
      ++n_chars;
      c = *s++;
      if (c == '\\')
         c = escape(&s, &len);
      switch (c) {
         case '\n':
            fprintf(f, "\\n");
            break;
         case '\t':
            fprintf(f, "\\t");
            break;
         case '\v':
            fprintf(f, "\\v");
            break;
         case '\b':
            fprintf(f, "\\b");
            break;
         case '\r':
            fprintf(f, "\\r");
            break;
         case '\f':
            fprintf(f, "\\f");
            break;
         case '\\':
            fprintf(f, "\\\\");
            break;
         case '\"':
            fprintf(f, "\\\"");
            break;
         default:
            if (isprint(c))
               fprintf(f, "%c", c);
            else
               fprintf(f, "\\%03o", (int)c);
         }
      }
   return n_chars;
   }
