/*
 * File: rxwindw.r
 * System-specific portion of X-Icon (support for X11, so far).
 * This is version 5, featuring:
 *   no dependence on Xt
 *   a wide variety of X-specific graphics (no mode "g")
 *   support for multiple displays!
 *   support for fill styles and stipples
 *   separation of windows and graphics contexts
 */

#ifdef XIcon

#define RootState IconicState+1

#ifndef PresentationManager
/*
 * Global variables specific to X
 */
XSizeHints size_hints;

/*
 * function prototypes
 */
hidden novalue       setinitialstate  Params((wbp w, char *s));
hidden novalue       seticonpos       Params((wbp w, char *s));
hidden int           handle_config    Params((wbp w, XConfigureEvent *event));
hidden novalue       handle_exposures Params((wbp w, XExposeEvent *event));
hidden novalue       handle_mouse     Params((wbp w, XButtonEvent *event));
hidden novalue       handle_keypress  Params((wbp w, XKeyEvent *event));
hidden novalue    qevent  Params((wbp w, dptr e, int x, int y, uword t, int f));
hidden int           atoin            Params((char *s, int len));
hidden int           setdisplay       Params((wbp w, char *s));
novalue              makeIcon         Params((wbp w, int x, int y));
#endif					/* PresentationManager */
novalue              mystrncpy        Params((char *src, char *dest, int n));
hidden novalue       setpos           Params((wbp w, char *s));
hidden novalue       xdis             Params((wbinding *w, char *s, int n));

#ifdef PresentationManager
/* main window callback, or should I say, the only window callback */
MRESULT_N_EXPENTRY MainWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

/* PM globals */
HAB HInterpAnchorBlock;
HMQ HInterpMessageQueue;
HAB HMainAnchorBlock;
HMQ HMainMessageQueue;

/* device capabilities */
/* the resolutions used to select image fonts */
LONG FontResX;
LONG FontResY;
/* the media (screen) dimensions */
LONG ScreenWidth;
LONG ScreenHeight;
/* the number of bits per pixel for the screen */
LONG ScreenBitsPerPel;
/* the max color index in the logical color table for a PS */
LONG MaxPSColors;

/* I/O redirection flags */
SHORT StdOutRedirect;
SHORT StdErrRedirect;
SHORT StdInRedirect;


/* -----------------------------------------------------------------------
   Name - Bomb
   Purpose - temp runtime error message reporter
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
void Bomb(char *mesg)
{
  WinAlarm(HWND_DESKTOP, WA_ERROR);
  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, mesg, NULL, 1,
                MB_OK | MB_ERROR | MB_APPLMODAL);
  exit(1);
} /* End of Bomb */



/* -----------------------------------------------------------------------
   Name - PMStartup
   Purpose - This function initializes PM structures (anchor block,
             message queue, etc), starts up the secondary interpreter
             thread and locks thread 1 into retrieving messages and
             dispatching them.
             Since a window is tied to the thread that created it, window
             creation forms a request from the second (interp) thread to
             the first (main) thread.  A window is created and a handle
             to it is passed through the second (interp) thread's queue.
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
void PMStartup(void *args)
{
  QMSG qmsg;
  TID threadid;   /* interp thread id */
  ULONG frame_flags = 0;
  HWND hwnd, client;
  HDC hdc;
  wstate *ws;
  ULONG htype, flags;

  /* set the flags for I/O redirection */
  DosQueryHType(0, &htype, &flags);
  StdInRedirect = (htype != 1) ? 1 : 0;
  DosQueryHType(1, &htype, &flags);
  StdOutRedirect = (htype != 1) ? 1 : 0;
  DosQueryHType(2, &htype, &flags);
  StdErrRedirect = (htype != 1) ? 1 : 0;

  /* get the anchor block */
  HMainAnchorBlock = WinInitialize(0);

  /* build a message queue - queue up more than the default */
  HMainMessageQueue = WinCreateMsgQueue(HMainAnchorBlock, MAXMSGS);

  /* register a window class - extra bytes to store pointer to wstate */
  WinRegisterClass(HMainAnchorBlock, "XIconPM", MainWndProc,
                   CS_MOVENOTIFY, sizeof(wstate *));

  /* load some device capabilities */
  hdc = DevOpenDC(HMainAnchorBlock, OD_MEMORY, "*", 0, NULL, NULLHANDLE);
  /* get device resolutions used to select image fonts */
  DevQueryCaps(hdc, CAPS_HORIZONTAL_FONT_RES, 1, &FontResX);
  DevQueryCaps(hdc, CAPS_VERTICAL_FONT_RES, 1, &FontResY);
  /* load the display resolutions */
  DevQueryCaps(hdc, CAPS_WIDTH, 1, &ScreenWidth);
  DevQueryCaps(hdc, CAPS_HEIGHT, 1, &ScreenHeight);
  /* load the max color table index */
  DevQueryCaps(hdc, CAPS_COLOR_INDEX, 1, &MaxPSColors);
  /* bump up the max index by one to get the max number of colors */
  MaxPSColors++;
  /* load the bits per pel */
  DevQueryCaps(hdc, CAPS_COLOR_BITCOUNT, 1, &ScreenBitsPerPel);
  DevCloseDC(hdc);

  /* initialize the global color table */
  InitializeColorTable();

  /* initialize the id table */
  InitializeIdTable();

  /* start up the interpreter thread */
  threadid = _beginthread(InterpThreadStartup, NULL, THREADSTACKSIZE, args);

  /* frame flags for new window */
  frame_flags = FCF_STANDARD & ~FCF_ICON & ~FCF_MENU & ~FCF_ACCELTABLE;

  /* start processing messages */
  while (WinGetMsg(HMainAnchorBlock, &qmsg, 0, 0, 0)) {
    if (qmsg.hwnd == NULLHANDLE) {
      /* handle the message from the other thread */
      if (qmsg.msg == REQUEST_WINDOW) {
        /* XXX parameter 2 will have the special flags for the new window */
        /* build the window */
/* XXX perhaps make it synchronous paint */
        hwnd = WinCreateStdWindow(HWND_DESKTOP, 0UL,
                                  &frame_flags, "XIconPM",
                                  "",
                                  0UL, NULLHANDLE, 256,
                                  &client);
        /* message param 1 has a pointer to the window state set that now */
        WinSetWindowULong(client, QWL_USER, (ULONG)qmsg.mp1);
        /* post a reply */
        WinPostQueueMsg(HInterpMessageQueue, NEW_WINDOW, (MPARAM)client,
                        (MPARAM)hwnd);
        } /* End of if - interp thread requesting window creation */
      else if (qmsg.msg == REQUEST_DESTROY) {
        ws = (wstate *)qmsg.mp1;
        WinDestroyWindow(ws->hwndFrame);
        /* tell the secondary thread to remove the window structures */
        WinPostQueueMsg(HInterpMessageQueue, DESTROYED_WINDOW, qmsg.mp1, 0);
        } /* End of elseif - interp thread requesting window destruction */
      } /* End of if - window handle NULL */
    else WinDispatchMsg(HMainAnchorBlock, &qmsg);
    } /* End of while - get messages and work with them */

  /* destroy message queue and release anchor block */
  WinDestroyMsgQueue(HMainMessageQueue);
  /* shut us down */
  WinTerminate(HMainAnchorBlock);
  /* Exit */
  DosExit(EXIT_PROCESS, 1);
} /* End of PmStartup */


/* -----------------------------------------------------------------------
   Name - TransKeyMsg
   Purpose -
   Parameters - the broken out flags, and the two identifying words
   Returns - an icon event code equivalent or -1 if the event should
             be dropped
   Side Effects -
   ----------------------------------------------------------------------- */
int TransKeyMsg(USHORT flags, MPARAM mp, ULONG *keyval)
{
  SHORT tmp;

  if (flags & KC_VIRTUALKEY) {
    switch(tmp = SHORT2FROMMP(mp)) {
      case VK_F1: *keyval = 65470; break;
      case VK_F2: *keyval = 65471; break;
      case VK_F3: *keyval = 65472; break;
      case VK_F4: *keyval = 65473; break;
      case VK_F5: *keyval = 65474; break;
      case VK_F6: *keyval = 65475; break;
      case VK_F7: *keyval = 65476; break;
      case VK_F8: *keyval = 65477; break;
      case VK_F9: *keyval = 65478; break;
      case VK_F10: *keyval = 65479; break;
      case VK_F11: *keyval = 65480; break;
      case VK_F12: *keyval = 65481; break;
      case VK_LEFT: *keyval = 65361; break;
      case VK_UP: *keyval = 65362; break;
      case VK_RIGHT: *keyval = 65363; break;
      case VK_DOWN: *keyval = 65364; break;
      case VK_HOME: *keyval = 65496; break;
      case VK_PAGEUP: *keyval = 65498; break;
      case VK_END: *keyval = 65502; break;
      case VK_PAGEDOWN: *keyval = 65504; break;
      case VK_ALTGRAF: *keyval = 0; break;
      case VK_PAUSE: *keyval = 65490; break;
      case VK_PRINTSCRN: *keyval = 65491; break;
      case VK_SCRLLOCK: *keyval = 65492; break;
      case VK_NUMLOCK: *keyval = 65407; break;
      case VK_INSERT: *keyval = 65379; break;
      /* this is the control key going down by itself */
      case VK_CTRL: return -1;
      case VK_ESC:
        /* ASCII value for escape is 27 */
        *keyval = 0x1B;
        return ASCII_CHAR;
      default: *keyval = 0; break;
      } /* End of switch - virt key code */
    if (*keyval) return VIRT_KEY;
    } /* End of if - virtual key */

  /* make sure we don't get some garbage in the upper 8 */
  tmp = (SHORT1FROMMP(mp) & 0xFF);
  /* check for a control character */
  if (((flags & KC_CHAR) || (flags & KC_CTRL)) && tmp > 0) {
    *keyval = (flags & KC_CTRL) ? tmp % 32 : tmp;
    return ASCII_CHAR;
    } /* End of if - ascii characer */
  /* drop everything else */
  return -1;
} /* End of TransKeyMsg */


/* -----------------------------------------------------------------------
   Name - TransMouseMsg
   Purpose -
   Parameters -
   Returns - an icon event code equivalent or 0 if the event should be
             dropped
   Side Effects -
   ----------------------------------------------------------------------- */
int TransMouseMsg(ULONG msg, SHORT button_state[])
{
/* have to check this out for 3 button mice... this may or may
   not be the way things are happening.. I can't find documentation
   on the messages sent for specific buttons down.  I am guessing
   that mouse button 3 is the middle button on a 3 button mouse, leaving
   1 and 2 for the far left and far right respectively.  */
  switch(msg) {
    case WM_MOUSEMOVE:
      return (button_state[0]) ? MOUSELEFTDRAG :
             (button_state[1]) ? MOUSERIGHTDRAG :
             (button_state[2]) ? MOUSEMIDDRAG : 0;
    case WM_BUTTON1DOWN:
      button_state[0] = 1;
      return MOUSELEFT;
    case WM_BUTTON1UP:
      button_state[0] = 0;
      return MOUSELEFTUP;
    case WM_BUTTON2DOWN:
      button_state[1] = 1;
      return MOUSERIGHT;
    case WM_BUTTON2UP:
      button_state[1] = 0;
      return MOUSERIGHTUP;
    case WM_BUTTON3DOWN:
      button_state[2] = 1;
      return MOUSEMID;
    case WM_BUTTON3UP:
      button_state[2] = 0;
      return MOUSEMIDUP;
    default:;
    } /* End of switch - mouse message */
  return 0;
} /* End of TransMouseMsg */


/* -----------------------------------------------------------------------
   Name - MainWndProc
   Purpose -
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
MRESULT_N_EXPENTRY MainWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  static SHORT button_state[3] = { 0, 0, 0 };
  LONG icon_event;
  ULONG keyval;
  USHORT keyflags;
  int i;
  RECTL rect;
  HPS hps;
  POINTL pts[4];
  SHORT cx, cy;
  wstate *ws;
  HWND caphwnd = NULLHANDLE;
  SHORT flag;
  HRGN hsave, hsave2, hscrap;
  PSWP swp;
  BITMAPINFOHEADER2 bmp;

  /* All positional information will be provided by the WinPostQueueMsg
     when it fills in the QMSG structure */

  /* get a pointer to the icon window state from the pm window state */
  if (ws = (wstate *)WinQueryWindowULong(hwnd, QWL_USER)) {

/* we should probably grab the mutex here to avoid critical sections... */
/* XXXX look for all race conditions ... second thread does not request
   mutex when it changes things such as size and visibility right now -
   track down those situations and add the lock */

    switch (msg) {
      case WM_SIZE:
        /* don't handle the sizing if already an icon */
        if (ws->winState & WS_MIN) break;

        if (DosRequestMutexSem(ws->mutex, MAXWAIT) == ERROR_TIMEOUT)
            Bomb("Deadlock - waiting for mutex in WM_SIZE\n");
        cy = SHORT2FROMMP(mp2);
        /* update the current window cursor position - use the
           last descender for the positioning */
        ws->y = min(ws->y, cy - ws->lastDescender);
        /* change the cursor position */
        ws->cursInfo.y += (cy - ws->height);
        if (ISCURSORONW(ws))
          WinCreateCursor(ws->hwnd, ws->cursInfo.x, ws->cursInfo.y, 0, 0,
                          CURSOR_SETPOS, NULL);
        /* update the window state */
        ws->width = SHORT1FROMMP(mp2);
        ws->height= cy;
        /* resize the backing bitmap - will only make bigger */
        ResizeBackingBitmap(ws, ws->width, ws->height);
        DosReleaseMutexSem(ws->mutex);
        /* first time through, just clear the bit - mimic XIcon */
        if (ISINITIALW(ws)) CLRINITIALW(ws);
        else WinPostQueueMsg(HInterpMessageQueue, WINDOW_SIZED, (MPARAM)ws,
                             (MPARAM)RESIZED);
        break;

      case WM_MOVE:
        /* do the query */
        WinQueryWindowRect(ws->hwndFrame, &rect);
        /* map the points relative to us to the desktop */
        WinMapWindowPoints(ws->hwndFrame, HWND_DESKTOP, (POINTL *)&rect, 1);
        /* save 'em */
        if (DosRequestMutexSem(ws->mutex, MAXWAIT) == ERROR_TIMEOUT)
          Bomb("Deadlock - waiting for mutex in WM_MOVE\n");
        ws->posx = rect.xLeft;
        ws->posy = ScreenHeight - rect.yBottom - rect.yTop;
        DosReleaseMutexSem(ws->mutex);
        break;

      case WM_PAINT:
        if (DosRequestMutexSem(ws->mutex, MAXWAIT) == ERROR_TIMEOUT)
          Bomb("Deadlock - waiting for mutex in WM_PAINT\n");
        /* save the current clip region */
        GpiSetClipRegion(ws->hpsWin, NULLHANDLE, &hsave);
        hps = WinBeginPaint(hwnd, ws->hpsWin, &rect);
        if (ws->winState & WS_MIN) {
/* here is a wonderful hack.  After calling winsetwindowposition, 
   it seems that PM gives us a paint message even before we are 
   iconified, it then gives us another one after we are iconified.
   This results in the icon bitmap being stretched to the
   window before PM iconifies it.  For a brief moment, depending on the
   size of the window, the user can see this image.  So, when we do the
   iconization, a bit is set, the first paint message is ignored and clears
   the bit and the second draws the icon.
   Note that this problem still exists if we let winState be changed only
   by thread 1 because the WM_MINMAXFRAME is dispatched before the WM_PAINT
   message is delivered.
*/
          if (!ISMINPENDW(ws)) {
            /* if icon image is set and not just hiding, blit it */
            if (ws->hIconBitmap) {
              /* bottom left target and source */
              pts[0].x = pts[0].y = pts[2].x = pts[2].y = 0;
              bmp.cbFix = sizeof(BITMAPINFOHEADER2);
              GpiQueryBitmapInfoHeader(ws->hIconBitmap, &bmp);
              /* top right target */
              pts[1].x = rect.xRight;
              pts[1].y = rect.yTop;
              /* top right source */
              pts[3].x = bmp.cx;
              pts[3].y = bmp.cy;
              /* carry out the blit */
              GpiWCBitBlt(hps, ws->hIconBitmap, 4, pts, ROP_SRCCOPY, BBO_IGNORE);
              } /* End of if - icon bitmap defined */
            /* otherwise, blit the default */
  
          } /* End of if - minimum not pending */
          else CLRMINPENDW(ws);
          } /* End of if - minimized */
        else {    /* not minimized */
          /* copy over the affected region - taking into account that
             the backing bitmap might be larger */
          /* target lower left corner */
          pts[0].x = rect.xLeft; pts[0].y = rect.yBottom;
          /* target upper right corner */
          pts[1].x = rect.xRight; pts[1].y = rect.yTop;
          /* source lower left corner - this is the one transformed */
          pts[2].x = rect.xLeft;
          pts[2].y = rect.yBottom + ws->bitHeight - ws->height;
          GpiBitBlt(hps, ws->hpsBitmap, 3, pts, ROP_SRCCOPY, 0UL);
          } /* End of else - not iconized */
        WinEndPaint(hps);
        GpiSetClipRegion(ws->hpsWin, hsave, &hscrap);
        DosReleaseMutexSem(ws->mutex);
        return 0;

      case WM_MINMAXFRAME:
        swp = (PSWP)mp1;
        if (DosRequestMutexSem(ws->mutex, MAXWAIT) == ERROR_TIMEOUT)
          Bomb("Deadlock - waiting for mutex in WM_MINMAXFRAME\n");
        /* flip titles if needed.. */
        if (!(swp->fl & SWP_MINIMIZE)) {
          WinSetWindowText(ws->hwndFrame, ws->szTitleWhenWindow);
          /* make sure a redraw occurs on the window ps */
          WinInvalidateRect(ws->hwndFrame, NULL, TRUE);
          } /* End of if - not minimizing */
        else if (ws->szTitleWhenIcon)
           WinSetWindowText(ws->hwndFrame, ws->szTitleWhenIcon);
        /* set the new flag state */
        ws->winState = (swp->fl & SWP_MINIMIZE) ? WS_MIN : 
                       (swp->fl & SWP_MAXIMIZE) ? WS_MAX : WS_NORMAL;
        DosReleaseMutexSem(ws->mutex);
        break;

      case WM_CHAR:
        /* get the flags out of message parameter 1 */
        keyflags = SHORT1FROMMP(mp1);
        /* we will ignore key-ups */
        if (!(keyflags & KC_KEYUP) &&
            (icon_event = TransKeyMsg(keyflags, mp2, &keyval)) >= 0) {
          /* looping through repeat count - break into multiple events */
          for (i = 0; i < (int)CHAR3FROMMP(mp1); i++)
            WinPostQueueMsg(HInterpMessageQueue, icon_event, (MPARAM)ws,
                            (MPARAM)keyval);
          return (MRESULT)1;  /* return that we have processed it */
          } /* End of if - key-down press */
        return 0;

      case WM_MOUSEMOVE:
        /* translate this message into an icon event */
        if (icon_event = TransMouseMsg(msg, button_state))
          WinPostQueueMsg(HInterpMessageQueue, MOUSE_EVENT, (MPARAM)ws,
                          (MPARAM)icon_event);
        /* have to change the cursor based on selected pointer */
        if (ws && ws->hPointer)
          return (MRESULT)WinSetPointer(HWND_DESKTOP, ws->hPointer);
        break;

      case WM_BUTTON1DOWN:
      case WM_BUTTON2DOWN:
      case WM_BUTTON3DOWN:
        /* capture the mouse */
        caphwnd = hwnd;
      case WM_BUTTON1UP:
      case WM_BUTTON2UP:
      case WM_BUTTON3UP:
        /* set the capture of mouse events (either to this window or desktop) */
        WinSetCapture(HWND_DESKTOP, caphwnd);
        /* translate this message into an icon event */
        if (icon_event = TransMouseMsg(msg, button_state))
          WinPostQueueMsg(HInterpMessageQueue, MOUSE_EVENT, (MPARAM)ws,
                          (MPARAM)icon_event);
        break;

      case WM_SETFOCUS:
        if (DosRequestMutexSem(ws->mutex, MAXWAIT) == ERROR_TIMEOUT)
          Bomb("Deadlock - waiting for mutex in WM_SETFOCUS\n");
 /* XXX note, that the reference manuals say that the thread creating
    the cursor must be the one that calls WinShowCursor.  In the current
    implementation, I ignore this 'fact'.  I can see that there may
    be a critical section problem.  To alleviate this, we could send
    a focus change message to the interp thread, making it the only
    on that creates or shows.  Also above in WM_SIZE, have the
    secondary thread handle the positioning.  The problem has not
    surfaced, so I will leave it as it is (incorrect as it may be :) */

        /* we have the cursor on, do the right thing */
        if (ISCURSORONW(ws)) {
          /* receiving focus, make the cursor */
          if (SHORT1FROMMP(mp2)) {
            WinCreateCursor(ws->hwnd, ws->cursInfo.x, ws->cursInfo.y,
                            ws->cursInfo.cx, ws->cursInfo.cy,
                            CURSOR_FLASH, NULL);
            WinShowCursor(ws->hwnd, 1);
            } /* End of if - gaining focus */
          /* losing focus.. good bye cursor */
          else WinDestroyCursor(ws->hwnd);
          } /* End of if - cursor is even on for this window */
        DosReleaseMutexSem(ws->mutex);
        break;

      default:;
      } /* End of switch - message */
    } /* End of if - window state pointer valid */

  return WinDefWindowProc(hwnd, msg, mp1, mp2);
} /* End of MainWndProc */


/* -----------------------------------------------------------------------
   Name - LoadDefAttrs
   Purpose -
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
void LoadDefAttrs(wbinding *wb, wstate *ws, wcontext *wc)
{
  PLINEBUNDLE lBundle;
  PCHARBUNDLE cBundle;
  PAREABUNDLE aBundle;
  PIMAGEBUNDLE iBundle;

  /* initialize the color table for the new presentation space(s) */
  ColorInitPS(wb);

  /* set the defaults for the context attribute bundles */
  lBundle = &(wc->lineBundle);
  GpiQueryAttrs(ws->hpsBitmap, PRIM_LINE, LBB_COLOR | LBB_MIX_MODE | LBB_WIDTH |
                LBB_GEOM_WIDTH | LBB_END | LBB_TYPE | LBB_JOIN, lBundle);
  cBundle = &(wc->charBundle);
  GpiQueryAttrs(ws->hpsBitmap, PRIM_CHAR, CBB_COLOR | CBB_BACK_COLOR | CBB_MIX_MODE |
                CBB_BACK_MIX_MODE | CBB_SET | CBB_MODE | CBB_BOX | CBB_ANGLE |
                CBB_SHEAR | CBB_DIRECTION, cBundle);
  aBundle = &(wc->areaBundle);
  GpiQueryAttrs(ws->hpsBitmap, PRIM_AREA, ABB_COLOR | ABB_BACK_COLOR | ABB_MIX_MODE |
                ABB_BACK_MIX_MODE | ABB_SET | ABB_SYMBOL | ABB_REF_POINT,
                aBundle);
  iBundle = &(wc->imageBundle);
  GpiQueryAttrs(ws->hpsBitmap, PRIM_IMAGE, IBB_COLOR | IBB_MIX_MODE |
                IBB_BACK_COLOR | IBB_BACK_MIX_MODE, iBundle);

  /* set the background and foreground colors */
  setfg(wb, si_s2i(siColorNames, "black"));
  setbg(wb, si_s2i(siColorNames, "white"));
  /* set the window background color */
  ws->winbg = aBundle->lBackColor;
  /* set the default drawing mode (for XCopyArea, etc.) */
  wc->drawop = ROP_SRCCOPY;
  cBundle->usBackMixMode = aBundle->usBackMixMode = BM_OVERPAINT;
  cBundle->usMixMode = aBundle->usMixMode = lBundle->usMixMode = FM_OVERPAINT;
  /* default line attributes */
  lBundle->lGeomWidth = 0;
  lBundle->usJoin = LINEJOIN_MITRE;
  ws->height = 400;
  ws->width = 400;
  /* load the default font */
  SetFont(wc, "System Monospaced", 0, 12);
  /* set the default cursor position RC 1,1 */
  ws->y = ROWTOY(wb, 1);
  ws->x = COLTOX(wb, 1);
  return;
} /* End of LoadDefAttrs */


/* -----------------------------------------------------------------------
   Name - WinOpen
   Purpose -
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
FILE *WinOpen(char *winname, struct b_list *lp, dptr attr, int n)
{
  wbinding *wb;
  wstate *ws;
  wcontext *wc;
  char answer[128];
  ULONG frame_flags = 0, showflags;
  static HWND client;
  QMSG qmsg;
  HDC hdc;
  POINTL pt;
  HDC hdcMem;
  HPS hps, hpsMem;
  SIZEL size = { 0, 0 };
  SHORT height, width, tmp;
  int i;

  BOOL ret;

  /* build the binding */
  Protect(wb = alc_wbinding(), return NULL);
  /* grab a window state */
  Protect(wb->window = alc_winstate(), { free_binding(wb); return NULL; });
  /* grab the context */
  Protect(wb->context = alc_context(wb), { free_binding(wb); return NULL; });
  ws = wb->window;
  wc = wb->context;
  /* add the context to the window's context pointer array */
  AddContextDep(ws, wc);
  /* add the window to the context's window pointer array */
  AddWindowDep(ws, wc);

  ws->listp.dword = D_List;
  BlkLoc(ws->listp) = (union block *)lp;

  /* hold the mutex */
  MutexOn(ws);
  /* send the request for a new window to be made */
  WinPostQueueMsg(HMainMessageQueue, REQUEST_WINDOW, (MPARAM)ws, (MPARAM)0);
  /* wait for our reply */
  WinGetMsg(HInterpAnchorBlock, &qmsg, NULLHANDLE, NEW_WINDOW, NEW_WINDOW);
  /* this is the client handle */
  ws->hwnd = (HWND)qmsg.mp1;
  /* this is the frame window handle */
  ws->hwndFrame = (HWND)qmsg.mp2;
  /* set the initial flag - first size message will clear the initial */
  SETINITIAL(wb);

  /* get the device context for the window */
  hdc = ws->hdcWin = WinOpenWindowDC(ws->hwnd);
  /* build a presentation space for the window */
  ws->hpsWin = GpiCreatePS(HInterpAnchorBlock, hdc, &size,
                           PU_PELS | GPIA_ASSOC | GPIT_MICRO);
  /* setup the backing bitmap */
  hdcMem = ws->hdcBitmap = DevOpenDC(HInterpAnchorBlock, OD_MEMORY, "*", 0, NULL,
                                     NULLHANDLE);
  hpsMem = ws->hpsBitmap = GpiCreatePS(HInterpAnchorBlock, hdcMem, &size,
                                       PU_PELS | GPIA_ASSOC | GPIT_MICRO);
  /* load the default attributes into the bundles in context */
  LoadDefAttrs(wb, ws, wc);

  /* set the window title */
  ws->szTitleWhenWindow = strdup(winname);

  /* process the passed in attributes - by calling wattrib */
  for(i = 0; i < n; i++)
    if (wattrib(wb, StrLoc(attr[i]), StrLen(attr[i]), answer) != Succeeded) {
      DosReleaseMutexSem(ws->mutex);
      WinClose(wb);
      return NULL;
      } /* End of if - wattrib failed - we fail */

  /* set the title */
  WinSetWindowText(ws->hwndFrame, ((ws->winState & WS_MIN) ? ws->szTitleWhenIcon :
                                                             ws->szTitleWhenWindow));

  /* query system settings to find out size of borders and title bar -
     make the window the exact size the customer wanted (ie - size frame) */
  height = ws->height + TITLEHEIGHT + (BORDERHEIGHT << 1);
  width = ws->width + (BORDERWIDTH << 1);
  /* the window background is taken from the context background */
  ws->winbg = wc->areaBundle.lBackColor;

  /* preload our contexts - only char context is really neede for the
     cursor display, but lets load them all for the fun of it */
  SetCharContext(wb, ws, wc);
  SetLineContext(wb, ws, wc);
  SetAreaContext(wb, ws, wc);
  SetImageContext(wb, ws, wc);

  /* release mutex */
  MutexOff(ws);

  /* resize the backing bitmap  */
  ResizeBackingBitmap(ws, ws->width, ws->height);

  /* size, make visible, place and bring the window to the top  */
  showflags = SWP_SIZE | SWP_SHOW | SWP_MOVE | SWP_ACTIVATE | SWP_ZORDER;
  showflags |= (ws->winState & WS_MIN) ? SWP_MINIMIZE : 
               (ws->winState & WS_MAX) ? SWP_MAXIMIZE : 0;
  WinSetWindowPos(ws->hwndFrame, HWND_TOP,
                  ws->posx,
                  ScreenHeight - ws->posy - height,
                  width, height,
                  showflags);
  return (FILE *)wb;
} /* End of WinOpen */


/* -----------------------------------------------------------------------
   Name - DestroyWindow
   Purpose -
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
void DestroyWindow(wstate *ws)
{
  QMSG qmsg;

  /* send a message to the first thread to destroy the window - since
     he created it, he has to destroy it.  He'll send back a message
     saying that he did it. */
  if (ws->hwndFrame) {
    /* disassociate the window hps and kill it */
    GpiAssociate(ws->hpsWin, NULLHANDLE);
    GpiDestroyPS(ws->hpsWin);
    /* hdc will be wiped out by window destruction */
    WinPostQueueMsg(HMainMessageQueue, REQUEST_DESTROY, (MPARAM)ws,
                    (MPARAM)0);
    /* wait for our reply */
    WinGetMsg(HInterpAnchorBlock, &qmsg, NULLHANDLE, DESTROYED_WINDOW,
              DESTROYED_WINDOW);
    /* knock out the handles so that this can never happen again */
    ws->hdcWin = ws->hpsWin = ws->hwndFrame = ws->hwnd = NULLHANDLE;
    /* ws shoud be the same as qmsg.mp1 */
    } /* End of if - was a window and not just a bitmap */
  return;
} /* End of DestroyWindow */


/* -----------------------------------------------------------------------
   Name - WinClose
   Purpose -
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
int WinClose(wbinding *wb)
{
  /* make sure the window goes away - no questions asked */
  DestroyWindow(wb->window);
  /* get rid of state information */
  free_binding(wb);
  return 1;
} /* End of WinClose */



/* -----------------------------------------------------------------------
   Name - ResizeBackingBitmap
   Purpose - Makes the bitmap at least as big as the passed in dimensions
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
void ResizeBackingBitmap(wstate *ws, SHORT cx, SHORT cy)
{
  HPS hpsMem;
  HBITMAP hbm, hbmOld;
  LONG alData[2];
  BITMAPINFOHEADER2 bmp;
  RECTL rectl = { 0, 0, 0, 0};
  POINTL pt;
  HRGN hsave, hscrap;

  /* check if we even need to do anything */
  if (cx <= ws->bitWidth && cy <= ws->bitHeight)
    return;

  /* else - the bitmap needs to be grown ... */
  hpsMem = ws->hpsBitmap;

  /* take the clip region off */
  GpiSetClipRegion(hpsMem, NULLHANDLE, &hsave); 

  /* find out about formats  (plane/bit count) */
  GpiQueryDeviceBitmapFormats(hpsMem, 2, alData);

  /* take the old bitmap out - if there was one */
  hbmOld = GpiSetBitmap(hpsMem, NULLHANDLE);

  /* build the bitmap header */
  memset(&bmp, 0, sizeof(BITMAPINFOHEADER2));
  bmp.cbFix = sizeof(BITMAPINFOHEADER2);
  bmp.cx = max(cx, ws->bitWidth);
  bmp.cy = max(cy, ws->bitHeight);
  bmp.cPlanes = alData[0];
  bmp.cBitCount = alData[1];

  /* build the bitmap */
  ws->hBitmap = GpiCreateBitmap(hpsMem, &bmp, 0, NULL, NULL);
  /* select into the bitmap presentation space */
  GpiSetBitmap(hpsMem, ws->hBitmap);

  /* clear the background with the appropriate color */
  rectl.xRight = bmp.cx; rectl.yTop = bmp.cy;
  WinFillRect(hpsMem, &rectl, ws->winbg);

  /* if an old bitmap exists, copy over the information from it */
  if (hbmOld) {
    pt.x = 0;
    pt.y = bmp.cy - ws->bitHeight;
    WinDrawBitmap(hpsMem, hbmOld, NULL, &pt, CLR_BLACK, CLR_WHITE,
                  DBM_NORMAL);
    /* destroy the old bitmap */
    GpiDeleteBitmap(hbmOld);
    } /* End of if - have to copy over an old bitmap */
  else if (ws->hInitialBitmap) {
    pt.x = 0;
    pt.y = 0;
    WinDrawBitmap(hpsMem, ws->hInitialBitmap, NULL, &pt, CLR_BLACK, CLR_WHITE,
                  DBM_NORMAL);
    /* XXX could probably get rid of the initial bitmap here */
    } /* End of elseif - first time through, have to put out the initial bmp */
  /* update the dimensions */
  ws->bitWidth = bmp.cx;
  ws->bitHeight = bmp.cy;
  /* put the clip region back on */
  GpiSetClipRegion(hpsMem, hsave, &hscrap); 
  return;
} /* End of ResizeBackingBitmap */


/* -----------------------------------------------------------------------
   Name - wputc
   Purpose -
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
int wputc(int ci, wbinding *wb)
{
  char c = (char)ci;
  POINTL pt, pt2;
  HPS hps, hpsb;
  wstate *ws;
  POINTL pts[3];
  int diff;
  wcontext *wc;
  int scrollamt;
  FONTMETRICS *metrics;

  wc = wb->context;
  ws = wb->window;
  hps = ws->hpsWin;
  hpsb = ws->hpsBitmap;

  /* turn off the cursor */
  HideCursor(ws);
  switch (c) {
    case '\n':
      /* grab the mutex */
      MutexOn(ws);
      /* load the current character context */
      SetCharContext(wb, ws, wc);
      metrics = &(wc->font->metrics);
      /* check if we need to clear to end of line */
      if (ISCEOLON(wb)) {
        pts[0].x = 0;
        pts[0].y = ws->height - (ws->y + metrics->lMaxDescender);
        pts[1].x = ws->width;
        pts[1].y = pts[0].y - metrics->lMaxBaselineExt;
        WinFillRect(hps, (PRECTL)pts, ws->winbg);
        pts[0].y = ws->bitHeight - (ws->y + metrics->lMaxDescender);
        pts[1].y = pts[0].y + metrics->lMaxBaselineExt;
        WinFillRect(hpsb, (PRECTL)pts, ws->winbg);
        } /* End of if - clear to end of line */

      /* if at the end of the window (currpos.y - height < 0) */
      scrollamt = metrics->lMaxDescender + wc->fntLeading +
                  metrics->lMaxBaselineExt + ws->y + wc->dy - ws->height;
      if (scrollamt > 0) {
        /* common calculation done once */
        diff = ws->bitHeight - ws->height;
        /* determine the points for the region to be scrolled */
        pts[0].x = 0;
        pts[0].y = diff + scrollamt;
        pts[1].x = ws->width;
        pts[1].y = ws->bitHeight;
        pts[2].x = 0;
        pts[2].y =  diff;
        /* move a portion of the bitmap 'up' */
        GpiBitBlt(ws->hpsBitmap, ws->hpsBitmap, 3, pts, ROP_SRCCOPY, 0UL);
        /* paint over the exposed area - make point array look like rect */
        pts[1].y = pts[0].y;
        pts[0].y = diff;
        WinFillRect(hpsb, (PRECTL)pts, ws->winbg);
        /* blit to the window */
        pts[0].y = 0;
        pts[1].x = ws->width;
        pts[1].y = ws->height;
        pts[2].y = diff;
        GpiBitBlt(hps, hpsb, 3, pts, ROP_SRCCOPY, 0UL);
        ws->y += metrics->lMaxBaselineExt + wc->fntLeading - scrollamt;
        } /* End of if - have to scroll the window */
     else
       /* update the cursor position */
       ws->y += metrics->lMaxBaselineExt + wc->fntLeading;
      /* intended fall-through */
    case '\r':
      /* set the new position x position */
      ws->x = MARGIN;
      /* release mutex */
      MutexOff(ws);
      break;
   case '\t':
      xdis(wb, "        ", 8 - (XTOCOL(wb,ws->x) & 7));
      break;

   /*
    * Handle backspaces.  This implements cooked mode echo handling.
    */
   case '\177':
   case '\010': {
      int i = 0, pre_x;
      LONG cwid;
 
      MutexOn(ws);
      /* grab the current character context */
      SetCharContext(wb, ws, wc);
      MutexOff(ws);

      /*
       * Start with the last character queued up.
       */
      i--;
      /*
       * Trot back to the control-H itself.
       */
      while ((i>-EQUEUELEN) && (EVQUESUB(wb,i) != c)) i--;
      if (i == -EQUEUELEN) break;
      /*
       * Go past the control-H.
       */
      i--;
      /*
       * Go back through any number of control-H's from prior lifetimes.
       */
      while((i > -EQUEUELEN) && !isprint(EVQUESUB(wb,i))) i--;
      if (i == -EQUEUELEN) break;

      /*
       * OK, here's the character we're actually rubbing out.  Back up.
       */
      c = EVQUESUB(wb,i);
      pre_x = ws->x;

      /* get the width of the character to rub out */
      GpiQueryWidthTable(hps, (LONG)c, 1, &cwid);
      ws->x -= cwid;
      /*
       * Physically erase the character from the queue.  This results in
       * two control-H's present in the queue.
       */
      *evquesub(wb,i) = '\010';
      /*
       * Save the backed-up position, and draw spaces through the erased.
       */
      i = ws->x;
      while(ws->x < pre_x) xdis(wb, " ",1);
      ws->x = i;
      break;
      }
    default:
      xdis(wb, &c, 1);
    } /* End of switch - character value */

  /* turn the cursor back on */
  UpdateCursorPos(ws, wc);
  ShowCursor(ws);
  return 0;
} /* End of wputc */


/* -----------------------------------------------------------------------
   Name -
   Purpose - get event from pending queue
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
int wgetq(wbinding *wb, dptr res)
{
  wstate *ws;
  int first = 0;

  if (!wb || !(ws = wb->window) || !(ws->hpsWin)) return -1;
  while (1) {
    /* grab the built up queue */
    if (!EVQUEEMPTY(ws)) {
      EVQUEGET(ws, *res);
      return 1;
      } /* End of if - event queue not empty */
    ObtainEvents(ws, WAIT_EVT);
    } /* End of while - go until something happens */
  return -1;
} /* End of wgetq */
#endif					/* PresentationManager */


/*
 * write some text to both the window and the pixmap
 */
hidden novalue xdis(w,s,n)
register wbp w;
char *s;
int n;
   {
#ifndef PresentationManager
   int x, y, fh, delta_x;
   STDLOCALS(w);

   pollctr>>=1; pollctr++;
   x = ws->x;
   y = ws->y;
   delta_x = XTextWidth(wc->font->fsp,s,n);
   RENDER4(XDrawImageString,x,y,s,n);
   ws->x += delta_x;
#else 					/* PresentationManager */
  POINTL pt;
  STDLOCALS(w);

  pollctr>>=1; pollctr++;
  /* grab the mutex */
  MutexOn(ws);
  /* load the character context */
  SetCharContext(w, ws, wc);
  /* fixup the current position */
  pt.x = ws->x + wc->dx;
  /* draw to the window */
  if (stdwin && !(ws->winState & WS_MIN)) {
    /* move the position */
    pt.y = ws->height - (ws->y + wc->dy);
    /* draw the stuff on the window */
    GpiCharStringAt(stdwin, &pt, n, s);
    } /* End of if - window is there */
  /* draw to the bitmap */
  pt.y = ws->bitHeight - (ws->y + wc->dy);
  GpiCharStringAt(stdbit, &pt, n, s);
  /* update the current position */
  GpiQueryCurrentPosition(stdbit, &pt);
  ws->x = pt.x - wc->dx;
  ws->y = ws->bitHeight - pt.y + wc->dy;
  /* release the mutex */
  MutexOff(ws);
  return;
#endif					/* PresentationManager */
   }

#ifndef PresentationManager
/*
 * put a character out to a window using the current attributes
 */
int wputc(ci,w)
int ci;
wbp w;
   {
   int fh, lh, width, height, y_plus_descent;
   char c = (char)ci;
   STDLOCALS(w);

   fh = wc->font->height;
   lh = wc->font->leading;
   width = ws->width;
   height = ws->height;

   switch(c) {
   case '\r': {
      ws->x = MARGIN + wc->dx;
      break;
      }
   case '\n': {
      if (ISCEOLON(w)) {
         /*
	  * Clear the rest of the line, like a terminal would.
	  * Its arguable whether this should clear to the window
	  * background or the current context background.  If you
	  * change it to use the context background you have to
	  * change the XClearArea call to another XFillRectangle
	  * (cf. eraseArea()).
	  */
	 if (wc->drawop != GXcopy) XSetFunction(stddpy, stdgc, GXcopy);
	 XSetForeground(stddpy, stdgc, ws->winbg->c); /* or wc->bg->c ? */
	 XClearArea(stddpy, stdwin,
		    ws->x, ws->y-wc->font->fsp->max_bounds.ascent,
		    width-ws->x, lh, False);
	 XFillRectangle(stddpy, stdpix, stdgc,
			ws->x, ws->y - wc->font->fsp->max_bounds.ascent,
			width - ws->x, lh);
	 XSetForeground(stddpy, stdgc,wc->fg->c^(ISXORREVERSE(w)?wc->bg->c:0));
	 if (wc->drawop != GXcopy) XSetFunction(stddpy, stdgc, wc->drawop);
         }
      ws->y += lh + wc->dy;
      ws->x = MARGIN + wc->dx;
      /*
       * Now for the exciting part: do we scroll the window?
       * This is a grotesque copy to a new pixmap followed by
       * a complete repainting of the window
       */
      if (ws->y + wc->font->fsp->max_bounds.descent > height) {
	 ws->y -= lh;
	 y_plus_descent = ws->y + wc->font->fsp->max_bounds.descent;

	 if (wc->drawop != GXcopy) XSetFunction(stddpy, stdgc, GXcopy);
	 XCopyArea(stddpy, stdpix, stdpix, stdgc,
		   MARGIN, MARGIN + fh,				/* x, y */
		   width - MARGIN, y_plus_descent - MARGIN,	/* w, h */
		   MARGIN, MARGIN);				/* dstx,dsty */
	 XSetForeground(stddpy, stdgc, ws->winbg->c);
	 XFillRectangle(stddpy, stdpix, stdgc, 0, y_plus_descent - fh,
			width, height - (y_plus_descent - fh));
	 XSetForeground(stddpy, stdgc,wc->fg->c^(ISXORREVERSE(w)?wc->bg->c:0));
	 if (stdwin)
	    XCopyArea(stddpy, stdpix, stdwin, stdgc, 0, 0, width, height, 0,0);
	 if (wc->drawop != GXcopy) XSetFunction(stddpy, stdgc, wc->drawop);
         }
      break;
      }
   case '\t': {
      xdis(w, "        ", 8 - ((XTOCOL(w,ws->x))&7));
      break;
      }
   /*
    * Handle backspaces.  This implements cooked mode echo handling.
    */
   case '\177':
   case '\010': {
      int i = 0, pre_x;
      /*
       * Start with the last character queued up.
       */
      i--;
      /*
       * Trot back to the control-H itself.
       */
      while ((i>-EQUEUELEN) && (EVQUESUB(w,i) != c)) i--;
      if (i == -EQUEUELEN) break;
      /*
       * Go past the control-H.
       */
      i--;
      /*
       * Go back through any number of control-H's from prior lifetimes.
       */
      while((i > -EQUEUELEN) && !isprint(EVQUESUB(w,i))) i--;
      if (i == -EQUEUELEN) break;

      /*
       * OK, here's the character we're actually rubbing out.  Back up.
       */
      c = EVQUESUB(w,i);
      pre_x = ws->x;
      ws->x -= XTextWidth(wc->font->fsp, &c, 1);
      /*
       * Physically erase the character from the queue.  This results in
       * two control-H's present in the queue.
       */
      *evquesub(w,i) = '\010';
      /*
       * Save the backed-up position, and draw spaces through the erased.
       */
      i = ws->x;
      while(ws->x < pre_x) xdis(w," ",1);
      ws->x = i;
      break;
      }
   default: {
      xdis(w,&c,1);
      }
   }
   return 1;
   }
#endif					/* PresentationManager */

/*
 * put a string out to a window using the current attributes
 */
novalue wputstr(w,s,len)
wbp w;
char *s;
int len;
   {
  char *s2 = s;
#ifdef PresentationManager
  wstate *ws;

  ws = w->window;
  /* turn off the cursor */
  HideCursor(ws);
#endif					/* PresentationManager */

  while (len > 0) {
    /* find a chunk of printable text */
    while (isprint(*s2) && len > 0) { s2++; len--; }
    /* if a chunk was parsed, write it out */
    if (s2 != s) xdis(w, s, s2 - s);
    /* put the 'unprintable' character, if didn't just hit the end */
    if (len-- > 0) wputc(*s2++, w);
    s = s2;
    }

#ifdef PresentationManager
  /* show the cursor again */
  UpdateCursorPos(ws, w->context);
  ShowCursor(ws);
#endif					/* PresentationManager */
  return;
} /* End of wputstr */


#ifndef PresentationManager
/*
 * handle_misc processes pending events on display.
 * if w is non-null, block until a returnable event arrives.
 * returns 1 on success, 0 on failure, and -1 on error.
 */
int handle_misc(display, w)
wdp display;
wbp w;
   {
   XEvent event;
   Window evwin;
   int i;
   static int presscount = 0;
   wbp wb;
   wsp ws;

   while ((w != NULL) || XPending(display->display)) {

      XNextEvent(display->display, &event);
      evwin = event.xexpose.window;  /* go ahead, criticize all you like */

/* could avoid doing this search every event by handling 1 window at a time */
      for (wb = wbndngs; wb; wb=wb->next) {
	 ws = wb->window;

	 if ((ws->display == display) &&
	     ((ws->win == evwin) || (ws->iconwin == evwin) ||
	      (ws->pix == evwin) || (ws->prepix == evwin))) break;
         }
      if (!wb) continue;
      if (evwin == ws->iconwin) {
         switch (event.type) {
	    case Expose:
               if (ws->iconpix)
	          XCopyArea(display->display, ws->iconpix, ws->iconwin,
			    display->icongc, 0, 0, ws->iconw, ws->iconh, 3, 3);
	       else
	          XDrawString(display->display, evwin, display->icongc, 4,
	                      ws->display->fonts->fsp->max_bounds.ascent + 2,
		              ws->iconlabel, strlen(ws->iconlabel));
	       break;
	    case KeyPress:
	       handle_keypress(wb, (XKeyEvent *)&event);
	       break;
	    case ButtonPress:
	       if (ws->iconic == IconicState)
	          XMapWindow(ws->display->display, ws->win);
	       ws->iconic = NormalState;        /* set the current state */
	       break;
	    }
	 }
      else {
      switch (event.type) {
	 case KeyPress:
	    handle_keypress(wb, (XKeyEvent *)&event);
	    break;
	 case ButtonPress:
	    presscount++;
	    handle_mouse(wb, (XButtonEvent *)&event);
	    break;
	 case ButtonRelease:
	    if (--presscount < 0) presscount = 0;
	    handle_mouse(wb, (XButtonEvent *)&event);
	    break;
	 case MotionNotify:
	    if (presscount)
	       handle_mouse(wb, (XButtonEvent *)&event);
	    break;
         case NoExpose:
	    break;
	 case Expose:
	    handle_exposures(wb, (XExposeEvent *)&event);
	    continue;
         case UnmapNotify:
	    wb->window->iconic = IconicState;
            continue;
	 case MapNotify:
	    ws->iconic = NormalState;
	    /*
	     * if we have backing store there may be no expose events
	     */
	    if (DoesBackingStore(
		  ScreenOfDisplay(ws->display->display, ws->display->screen))
		!= NotUseful) {
	       SETEXPOSED(wb);
	     }
	    continue;
	 case ConfigureNotify:
	    if (!handle_config(wb, (XConfigureEvent *)&event)) {
	       return 0;
               }
	    break;
	 case DestroyNotify:
	    if (!ISZOMBIE(wb)) return -1; /* error #141 */

	    /*
	     * first of all, we are done with this window
	     */
	    ws->win = (Window) NULL;

	    if (ws->refcount == 0) {
	       if (wb->window->pix) {
		  Display *d = ws->display->display;
		  XSync(d, False);
		  if (ws->pix)
		     XFreePixmap(d, ws->pix);
		  ws->pix = (Pixmap) NULL;
	          }
	       if (ws->prepix != (Pixmap) NULL) {
		  Display *d = ws->display->display;
		  XSync(d, False);
		  XFreePixmap(d, ws->prepix);
		  ws->prepix = (Pixmap) NULL;
	          }

	       /*
	        * unlink the window state
	        */
	       if (ws->previous)
		  ws->previous->next = ws->next;
	       else
		  wstates = ws->next;
	       if (ws->next) ws->next->previous = ws->previous;
	       free_colors(wb);
	       free(ws);
	       }
	    break;
	 default:
	    continue;
	 }
      if ((w != NULL) &&
	  ((evwin == w->window->win) || (evwin == w->window->iconwin))) {
	 return 1;
         }
      }
   }
   return 1;
   }

/*
 * get a single item from w's pending queue
 */
int wgetq(w,res)
wbp w;
dptr res;
   {
   int first = 0, hm;
   unsigned long saved_drawop = w->context->drawop;
   while (1) {
      STDLOCALS(w);		/* leave inside loop; ws->pix can change! */
      if (!EVQUEEMPTY(w)) {
	 EVQUEGET(w,*res);
	 if (first) {
	    if (ISCURSORON(w)) {
               RENDER4(XDrawString, ws->x, ws->y, "_", 1);
	       wc->drawop = saved_drawop;
	       XSetFunction(stddpy, stdgc, wc->drawop);
	       resetfg(w);
	       }
            }
	 return 1;
         }
      if (!first++ && ISCURSORON(w)) {
	 wc->drawop = GXxor;
	 XSetFunction(stddpy, stdgc, GXxor);
	 XSetForeground(stddpy, stdgc, wc->fg->c ^ wc->bg->c);
	 RENDER4(XDrawString, ws->x, ws->y, "_", 1);
	 XSync(stddpy, False);
         }
      if ((hm = handle_misc(wd, w)) < 1) {
	 if (hm == -1) {
	    if (ISCURSORON(w)) {
               RENDER4(XDrawString, ws->x, ws->y, "_", 1);
	       wc->drawop = saved_drawop;
	       XSetFunction(stddpy, stdgc, wc->drawop);
	       resetfg(w);
	       }
	    return -1;
	    }
	 }
      }
   }
#endif					/* PresentationManager */

/*
 * Attribute manipulation
 *
 * wattrib: set a single attribute in a window, return the result attr string
 */
int wattrib(w, s, len, answer)
wbp w;
char *s;
char * answer;
long len;
   {
   char val[128], *valptr;
   char *mid;
   long lenattr, lenval;
#ifdef PresentationManager
   SHORT new_height, new_width;
#endif					/* PresentationManager */
   STDLOCALS(w);

   valptr = val;
#ifndef PresentationManager
   if (stdpix) {
      if (pollevent() == -1) fatalerr(217,NULL);
      }
#else					/* PresentationManager */
   /* catch up on any events pending - mainly to update mousex, mousey */
   pollevent();
#endif					/* PresentationManager */
   if (mid = strnchr(s, '=', len)) {
      /*
       * set an attribute
       */
      lenattr = mid - s;
      lenval  = len - lenattr - 1;
      if (lenval == 0) return Failed;
      mid++;

      mystrncpy(answer, s, lenattr);
      mystrncpy(val, mid, lenval);

      switch (si_s2i(attribs,answer)) {
      case A_LINES: {
#ifndef PresentationManager
	 int tmp = ROWTOY(w,atoi(val)) + wc->font->fsp->max_bounds.descent;
	 if (tmp < wc->font->height) return Failed;
	 if (! resizePixmap(w, ws->width, tmp)) return Failed;
	 if (stdpix && stdwin) XResizeWindow(stddpy, stdwin, ws->width, tmp);
	 ws->height = size_hints.height = tmp;
#else					/* PresentationManager */
         /* determine the new size of the client */
         if ((new_height = ROWTOY(w, atoi(val)) + wc->font->metrics.lMaxDescender) < 1) 
           return Failed;
         ws->height = new_height;
         if (!ISINITIAL(w)) {
           if (ws->hwndFrame) {
             if (ws->winState & WS_MIN)
                WinSetWindowUShort(ws->hwndFrame, QWS_CYRESTORE,
                                   new_height + TITLEHEIGHT + (BORDERHEIGHT << 1));
             else
               WinSetWindowPos(ws->hwndFrame, 0, 0, 0,
                               ws->width + (BORDERWIDTH << 1),
                               new_height + TITLEHEIGHT + (BORDERHEIGHT << 1),
                               SWP_SIZE);
             } /* End of if - we are dealing with a window */
           /* make sure the bitmap is big enough */
           if (ws->hBitmap) ResizeBackingBitmap(ws, ws->width, new_height);
           } /* End of if - not initial sizing */
 #endif					/* PresentationManager */

	 break;
         }
      case A_COLUMNS: {
#ifndef PresentationManager
	 int tmp = COLTOX(w,atoi(val)+1);
	 if (tmp < wc->font->height) return Failed;
	 if (! resizePixmap(w, tmp, ws->height)) return Failed;
	 if (stdpix && stdwin) XResizeWindow(stddpy, stdwin, tmp, ws->height);
	 ws->width = size_hints.width = tmp;
#else					/* PresentationManager */
         /* determine new size of client */
         if ((new_width = COLTOX(w, atoi(val) + 1)) < 1) return Failed;
         ws->width = new_width;
         if (!ISINITIAL(w)) {
           if (ws->hwndFrame) {
             if (ws->winState & WS_MIN) 
                 WinSetWindowUShort(ws->hwndFrame, QWS_CXRESTORE,
                                    new_width + (BORDERWIDTH << 1));
             else 
               WinSetWindowPos(ws->hwndFrame, 0, 0, 0,
                               new_width + (BORDERWIDTH << 1),
                               ws->height + TITLEHEIGHT + (BORDERHEIGHT << 1),
                               SWP_SIZE);
             } /* End of if - we are dealing with a window */
           /* make sure the bitmap is big enough */
           if (ws->hBitmap) ResizeBackingBitmap(ws, new_width, ws->height);
           } /* End of if - not initial sizing */
#endif					/* PresentationManager */
	 break;
         }
      case A_HEIGHT: {
#ifndef PresentationManager
	 int tmp = atoi(val);
	 if (! resizePixmap(w, ws->width, tmp)) return Failed;
	 if (stdpix && stdwin) XResizeWindow(stddpy, stdwin, ws->width, tmp);
	 ws->height = size_hints.height = tmp;
#else					/* PresentationManager */
         if ((new_height = atoi(val)) < 1) return Failed;
         ws->height = new_height;
         if (!ISINITIAL(w)) {
           if (ws->hwndFrame) {
             if (ws->winState & WS_MIN) 
               WinSetWindowUShort(ws->hwndFrame, QWS_CYRESTORE,
                                  new_height + TITLEHEIGHT + (BORDERHEIGHT << 1));
             else
               WinSetWindowPos(ws->hwndFrame, 0, 0, 0,
                               ws->width + (BORDERWIDTH << 1),
                               new_height + TITLEHEIGHT + (BORDERHEIGHT << 1),
                               SWP_SIZE);
             } /* End of if - we are dealing with a window */
           /* make sure the bitmap is big enough */
           if (ws->hBitmap) ResizeBackingBitmap(ws, ws->width, new_height);
           } /* End of if - not initial sizing */
#endif					/* PresentationManager */
	 break;
         }
      case A_WIDTH: {
#ifndef PresentationManager
	 int tmp = atoi(val);
	 if (! resizePixmap(w, tmp, ws->height)) return Failed;
	 if (stdpix && stdwin) XResizeWindow(stddpy, stdwin, tmp, ws->height);
	 ws->width = size_hints.width = tmp;
#else					/* PresentationManager */
         if ((new_width = atoi(val)) < 1) return Failed;
         ws->width = new_width;
         if (!ISINITIAL(w)) {
           if (ws->hwndFrame) {
             if (ws->winState & WS_MIN) 
               WinSetWindowUShort(ws->hwndFrame, QWS_CXRESTORE,
                                  new_width + (BORDERWIDTH << 1));
             else
               WinSetWindowPos(ws->hwndFrame, 0, 0, 0,
                               new_width + (BORDERWIDTH << 1),
                               ws->height + TITLEHEIGHT + (BORDERHEIGHT << 1),
                               SWP_SIZE);
             } /* End of if - we are dealing with a window */
           /* make sure the bitmap is big enough - dont bother on the initial */
           if (ws->hBitmap) ResizeBackingBitmap(ws, new_width, ws->height);
           } /* End of if - not initial sizing */
#endif					/* PresentationManager */
	 break;
         }
      case A_GEOMETRY: {
#ifndef PresentationManager
	 unsigned int width, height;
	 int x,y,status;
	 char *tmps;
	 for (tmps = val;*tmps;tmps++) if (*tmps == ',') *tmps = 'x';
	 status = XParseGeometry(val,&x,&y,&width,&height);
	 if (status & WidthValue) ws->width = size_hints.width = width;
	 if (status & HeightValue) ws->height = size_hints.height = height;
	 if ((status & (HeightValue|WidthValue)) &&
	     stdwin && ws->height && ws->width) {
	    if (! resizePixmap(w, ws->width, ws->height)) return Failed;
	    XResizeWindow(stddpy, stdwin, ws->width, ws->height);
	    }
	 if (status & (XValue|YValue)) {
	    char tmp[20];
	    if (!(status & XValue)) x = 0;
	    if (!(status & YValue)) y = 0;
	    sprintf(tmp,"%d,%d",x,y);
	    setpos(w,tmp);
	    }

	 /* insert assigns here:
	    ws->posx = ((sign > 0) ? tmp :
		    DisplayWidth(stddpy,wd->screen) - ws->width - tmp);
	    ws->posy = ((sign > 0) ? tmp :
		  DisplayHeight(stddpy,wd->screen) - wx->height - tmp);
	      */
#else					/* PresentationManager */
         ULONG stat;
         SHORT x, y, width, height;

         /* figure out what we are dealing with */
         stat = ParseGeometry(val, &x, &y, &width, &height);
         /* default out things not passed in */
         if (!(stat & GEOM_WIDTH)) width = ws->width;
         if (!(stat & GEOM_HEIGHT)) height = ws->height;
         if (!(stat & GEOM_POSX)) x = ws->posx;
         if (!(stat & GEOM_POSY)) y = ws->posy;
 
         ws->width = width;
         ws->height = height;
         ws->posx = x;
         ws->posy = y;
         if (!ISINITIAL(w)) {
           if (ws->hwndFrame) {
             if (ws->winState & WS_MIN) {
               WinSetWindowUShort(ws->hwndFrame, QWS_CXRESTORE,
                                  width + (BORDERWIDTH << 1));
               WinSetWindowUShort(ws->hwndFrame, QWS_CYRESTORE,
                                  height + TITLEHEIGHT + (BORDERWIDTH << 1));
               WinSetWindowUShort(ws->hwndFrame, QWS_XRESTORE, x);
               WinSetWindowUShort(ws->hwndFrame, QWS_YRESTORE, ScreenHeight - y);
               } /* End of if - iconic or initial */
             else
               WinSetWindowPos(ws->hwndFrame, 0, x, ScreenHeight - y,
                               width + (BORDERWIDTH << 1),
                               height + TITLEHEIGHT + (BORDERHEIGHT << 1),
                               SWP_SIZE | SWP_MOVE);
             } /* End of if - we are dealing with a window */
           /* make sure the bitmap is big enough - dont bother on the initial */
           if (ws->hBitmap) ResizeBackingBitmap(ws, width, height);
           } /* End of if - not initial sizing */
#endif					/* PresentationManager */
	 break;
         }
      case A_ROW: { ws->y = ROWTOY(w,atoi(val)) + wc->dy; break; }
      case A_COL: { ws->x = COLTOX(w,atoi(val)) + wc->dx; break; }
      case A_ICONIC: { 
#ifndef PresentationManager
        setinitialstate(w,val); 
#else					/* PresentationManager */
        int height;
        ULONG flags = SWP_SIZE | SWP_SHOW | SWP_MOVE | SWP_ACTIVATE | SWP_ZORDER;


        /* doesn't apply to bitmap */
        if (!ws->hwndFrame) return Failed;
        /* break out what we mean */
        if (!strcmp(val, "icon")) {
          ws->winState = WS_MIN;
          flags |= SWP_MINIMIZE;
          }
        else if (!strcmp(val, "window")) {
          ws->winState = WS_NORMAL;
          flags |= SWP_RESTORE;
          }
        else if (!strcmp(val, "fullscreen")) {
          ws->winState = WS_MAX;
          flags |= SWP_MAXIMIZE;
          }

        height = ws->height + TITLEHEIGHT + (BORDERHEIGHT << 1);
        if (!ISINITIAL(w))
          WinSetWindowPos(ws->hwndFrame, HWND_TOP,
                          ws->posx,
                          ScreenHeight - ws->posy - height,
                          ws->width + (BORDERWIDTH << 1), 
                          height,
                          flags);
          
#endif					/* PresentationManager */
        break; 
        }
      case A_ICONIMAGE: {
#ifndef PresentationManager
	 strcpy(ws->iconimage,val);
#else					/* PresentationManager */
        HBITMAP hbm;
        int height, width;

        /* try to load the bitmap */
        if (hbm = loadimage(w, val, &height, &width)) {
          GpiDeleteBitmap(ws->hIconBitmap);
          ws->hIconBitmap = hbm;
          /* dup the filename */
          free(ws->szIconFileName);
          ws->szIconFileName = strdup(val);
          /* if we are iconic, force a redraw */
          if (ws->winState & WS_MIN) WinInvalidateRect(ws->hwndFrame, NULL, TRUE);
          } /* End of if - could load the bitmap */
        else return Failed;
#endif					/* PresentationManager */
         break;
	 }
      case A_ICONLABEL: { 
#ifndef PresentationManager
        strcpy(ws->iconlabel,val); 
#else					/* PresentationManager */
        /* doesn't make sense for a bitmap */
        if (!ws->hpsWin) return Failed;
        /* plug in the new string */
        free(ws->szTitleWhenIcon);
        ws->szTitleWhenIcon = strdup(val);
        /* if we have to update, do it */
        if (!ISINITIAL(w) && (ws->winState & WS_MIN))
          WinSetWindowText(ws->hwndFrame, ws->szTitleWhenIcon);
#endif					/* PresentationManager */
        break; 
        }
#ifndef PresentationManager 
      case A_ICONPOS: { seticonpos(w,val); break; }
#endif					/* PresentationManager */
      case A_WINDOWLABEL: {
#ifndef PresentationManager
	 strcpy(ws->windowlabel,val); break;
#else					/* PresentationManager */
         /* doesn't make sense for a bitmap */
         if (!ws->hpsWin) return Failed;
         /* plug in the new string */
         free(ws->szTitleWhenWindow);
         ws->szTitleWhenWindow = strdup(val);
         /* if we have to update, go to it */
         if (!ISINITIAL(w) && !(ws->winState & WS_MIN))
           WinSetWindowText(ws->hwndFrame, ws->szTitleWhenWindow);
#endif					/* PresentationManager */
         }
      case A_CURSOR: {
#ifdef PresentationManager
         if (!ws->hpsWin) return Failed;
#endif					/* PresentationManager */
	 if ((val[1]=='f')||(val[1])=='F') {
           CLRCURSORON(w);
#ifdef PresentationManager
           WinDestroyCursor(ws->hwnd);
#endif					/* PresentationManager */
           } /* End of if - turn off */
	 else {
           SETCURSORON(w);
#ifdef PresentationManager
           if (WinQueryFocus(HWND_DESKTOP) == ws->hwnd) {
             WinCreateCursor(ws->hwnd, ws->cursInfo.x, ws->cursInfo.y,
                             ws->cursInfo.cx, ws->cursInfo.cy, CURSOR_FLASH,
                             NULL);
             ShowCursor(ws);
             } /* End of if - we have the focus */
#endif					/* PresentationManager */
           } /* End of else - turning on */
	 break;
         }
      case A_FONT: {
#ifndef PresentationManager
	 if (!(setfont(w, &valptr))) return Failed;
	 if (!stdpix) {
	    ws->y = MARGIN + wc->font->fsp->max_bounds.ascent;
	    ws->x = MARGIN;
	    }
#else					/* PresentationManager */
        char buf[64];
        LONG flags, size;

        /* Parse the name and size info and make the font */
        if (!ParseFontSpec(valptr, buf, &flags, &size) ||
            !SetFont(wc, buf, flags, size))
          return Failed;
#endif					/* PresentationManager */
	 break;
         }
      case A_POS: { setpos(w, val); break; }
      case A_POSX: { setpos(w, val); break; }
      case A_POSY: {
	 char tmp[20];
	 sprintf(tmp,"%d,%s",ws->posx,val);
	 setpos(w, tmp);
         break;
	 }
      case A_FG: {
#ifndef PresentationManager
	 int tmp = atoi(val);
	 (tmp<0) ? isetfg(w, tmp) : setfg(w, val);
#else					/* PresentationManager */
         LONG rgb;

         /* try to parse numerical color first, if that fails, then go for the
            name, if that fails, we fail */
         if ((rgb = ParseRGBValue(val)) < 0 && 
             (rgb = si_s2i(siColorNames, val)) < 0)
           return Failed;
         setfg(w, rgb);
#endif					/* PresentationManager */
	 break;
         }
      case A_BG: {
#ifndef PresentationManager
	 int tmp = atoi(val);
	 (tmp<0) ? isetbg(w, tmp) : setbg(w, val);
#else					/* PresentationManager */
         LONG rgb;

         /* try to parse numerical color first, if that fails, then go for the
            name, if that fails, we fail */
         if ((rgb = ParseRGBValue(val)) < 0 && 
             (rgb = si_s2i(siColorNames, val)) < 0)
           return Failed;
         setbg(w, rgb);
         /* if we are initializing, also set the window background color */
         if (ISINITIAL(w)) ws->winbg = wc->areaBundle.lBackColor;
#endif					/* PresentationManager */
	 break;
         }
      case A_FILLSTYLE: { setfillstyle(w, val); break; }
      case A_LINESTYLE: { setlinestyle(w, val); break; }
      case A_LINEWIDTH: { setlinewidth(w, val); break; }
      case A_POINTER: {
#ifndef PresentationManager
	 int i = si_s2i(cursorsyms,val);
	 ws->theCursor = i;
	 i = i>>1;
	 if (i < 0 || i >= NUMCURSORSYMS) return Failed;
	 if (!(wd->cursors[i])) {
	    wd->cursors[i] = XCreateFontCursor(stddpy,i<<1);
	    }
	 if (stdwin) {
	    XDefineCursor(stddpy, stdwin, wd->cursors[i]);
	    }
#else					/* PresentationManager */
         int i;
         HPOINTER oldPtr;

         /* if we are trying to set the pointer on a pixmap - fail */
         if (!stdwin) return Failed;

         if ((i = si_s2i(siCursorSyms, val)) >= 0) {
           ws->theCursor = i;
           /* grab the old pointer */
           oldPtr = ws->hPointer;
           /* look up the new pointer */
/* XXX later on, we may do a load instead when non-system poitners are added ... */
           ws->hPointer = WinQuerySysPointer(HWND_DESKTOP, i, TRUE);
           /* make the change effective immediately */
           WinSetPointer(HWND_DESKTOP, ws->hPointer);
           /* destroy the previous pointer */
           if (oldPtr) WinDestroyPointer(oldPtr);
           } /* End of if - found the cursor symbol */
#endif					/* PresentationManager */
	 break;
         }
      case A_DRAWOP: {
#ifndef PresentationManager
	 XSync(stddpy, False);
	 if (!strcmp(val,"reverse")) {
	    if (!ISXORREVERSE(w)) {
	       SETXORREVERSE(w);
	       wc->drawop = GXxor;
	       if (stdgc)
		  XSetForeground(stddpy, stdgc, wc->fg->c ^ wc->bg->c);
	       }
	    }
	 else {
	    if (ISXORREVERSE(w)) {
	       CLRXORREVERSE(w);
	       if (stdgc)
		  XSetForeground(stddpy, stdgc, wc->fg->c);
	       }
	    wc->drawop = si_s2i(drawops,val);
	    if (wc->drawop == -1) { wc->drawop = GXcopy; return Failed; }
	    }
	 if (stdgc) XSetFunction(stddpy, stdgc, wc->drawop);
#else					/* PresentationManager */
        int dop;
        LONG clrindex;
        USHORT foreground = FM_OVERPAINT,
               background = BM_OVERPAINT;

        if ((dop = si_s2i(siMixModes, val)) < 0)
          return Failed;

/* check if we really need to change - dop != wc->drawop */

        /* if we were in mode reverse before, change things back */
        if (ISXORREVERSE(w)) {
          /* put the color back */
          clrindex = (wc->charBundle.lColor ^ wc->charBundle.lBackColor);
          wc->charBundle.lColor = clrindex;
          wc->lineBundle.lColor = clrindex;
          wc->areaBundle.lColor = clrindex;
          /* unset the reverse mode */
          CLRXORREVERSE(w);
          } /* End of if - previous mode was mode REVERSE */

        /* set the other, drawing mix modes */
        switch(dop) {
          case ROP_USER1: /* mode reverse */
            /* find the new foreground color index and set it */
            clrindex = (wc->charBundle.lColor ^ wc->charBundle.lBackColor);
            /* ensure that some color is loaded at clrindex */
            EnsureColorAvailable(clrindex);
            /* set the flag */
            SETXORREVERSE(w);
            wc->charBundle.lColor = clrindex;
            wc->lineBundle.lColor = clrindex;
            wc->areaBundle.lColor = clrindex;
            /* foreground mix will be XOR */
            foreground = FM_XOR;
            break;
          case ROP_SRCAND:
            foreground = FM_AND;
            break;
          case ROP_ZERO:
            foreground = FM_ZERO;
            break;
          case ROP_SRCINVERT:
            foreground = FM_XOR;
            break;
          case ROP_DSTINVERT:
            foreground = FM_INVERT;
            break;
          case ROP_SRCERASE:
            foreground = FM_MASKSRCNOT;
            break;
          case ROP_ONE:
            foreground = FM_ONE;
            break;
          case ROP_MERGEPAINT:
            foreground = FM_MERGENOTSRC;
            break;
          case ROP_SRCPAINT:
            foreground = FM_OR;
            break;
          case ROP_NOTSRCCOPY:
            foreground = FM_NOTCOPYSRC;
            break;
          case ROP_SRCCOPY:
          default:;
          } /* End of switch - mix mode */

        /* bitblit mix mode */
        wc->drawop = (dop == ROP_USER1) ? ROP_SRCINVERT : dop;

        wc->areaBundle.usMixMode = foreground;
        wc->lineBundle.usMixMode = foreground;
        wc->charBundle.usMixMode = foreground;
        wc->charBundle.usBackMixMode = background;
        UnsetAllContext(wc);
#endif					/* PresentationManager */
	 break;
         }
      case A_DISPLAY: {
#ifndef PresentationManager
	 if (stdpix) {
	    /* "can't change display for mapped window!\n" */
	    return Failed;
	    }
	 if (!setdisplay(w,val)) {
	    return Failed;
	    }
	 break;
#else					/* PresentationManager */
         return Failed;
#endif					/* PresentationManager */
         }
      case A_X: { ws->x = atoi(val) + wc->dx; break; }
      case A_Y: { ws->y = atoi(val) + wc->dy; break; }
      case A_DX: { wc->dx = atoi(val); break; }
      case A_DY: { wc->dy = atoi(val); break; }
      case A_LEADING: { 
#ifndef PresentationManager
         wc->font->leading = atoi(val);
#else					/* PresentationManager */
         wc->fntLeading = wc->font->metrics.lExternalLeading + atoi(val);
#endif					/* PresentationManager */
         break;
         }
      case A_IMAGE: {
#ifndef PresentationManager
	 int status;
	 ws->prepix = loadimage(w, val, &(ws->height), &(ws->width),
				0, &status);
	 if (ws->prepix == (Pixmap) NULL) return Failed;
#else					/* PresentationManager */
         int width, height;
         HBITMAP hbm;
 
         /* ensure that we are only called at initialization */
         if (!ISINITIAL(w)) return Failed;
         /* grab the bitmap */
         if (hbm = loadimage(w, val, &height, &width)) {
           GpiDeleteBitmap(ws->hInitialBitmap);
           ws->hInitialBitmap = hbm;
           /* set the window size */
           ws->width = width;
           ws->height = height;
           } /* End of if - could load the bitmap */
         else return Failed;
#endif					/* PresentationManager */
	 break;
         }
      case A_ECHO: {
	 if ((val[1]=='f') || (val[1])=='F') CLRECHOON(w);
	 else SETECHOON(w);
	 break;
         }
      case A_CLIPX: {
	 wc->clipx = atoi(val);
	 setclip(w);
	 break;
	 }
      case A_CLIPY: {
	 wc->clipy = atoi(val);
	 setclip(w);
	 break;
	 }
      case A_CLIPW: {
	 wc->clipw = atoi(val);
	 setclip(w);
	 break;
	 }
      case A_CLIPH: {
	 wc->cliph = atoi(val);
	 setclip(w);
	 break;
	 }
      case A_REVERSE: {
	 if ((((val[1]=='f') || (val[1])=='F') && ISREVERSE(w)) ||
	     (((val[1]=='n') || (val[1])=='N') && !ISREVERSE(w))) {
#ifndef PresentationManager
	    wclrp tmp = wc->fg;
	    wc->fg = wc->bg;
	    wc->bg = tmp;
	    if (stdpix) {
	       XSetForeground(stddpy, stdgc,
			      wc->fg->c ^ (ISXORREVERSE(w)?wc->bg->c:0));
	       XSetBackground(stddpy, stdgc, wc->bg->c);
	       }
#else					/* PresentationManager */
            LONG tmp;

            /* swap the colors in the character bundle */
            tmp = wc->charBundle.lColor;
            wc->charBundle.lColor = wc->charBundle.lBackColor;
            wc->charBundle.lBackColor = tmp;
            tmp = wc->areaBundle.lColor;
            wc->areaBundle.lColor = wc->areaBundle.lBackColor;
            wc->areaBundle.lBackColor = tmp;
            tmp = wc->imageBundle.lColor;
            wc->imageBundle.lColor = wc->imageBundle.lBackColor;
            wc->imageBundle.lBackColor = tmp;
            /* unmark this context as being current (since it has to be
               reloaded with new values) */
            UnsetCharContext(wc);
            UnsetAreaContext(wc);
            UnsetImageContext(wc);
#endif					/* PresentationManager */
	    ISREVERSE(w) ? CLRREVERSE(w) : SETREVERSE(w);
	    }
	 break;
         }
      }
      mystrncpy(answer, s, len);
      }
   else {
      int a;
      /*
       * get an attribute
       */
      mystrncpy(answer, s, len);
      if (!strncmp(answer,"textwidth",9)) {
         mystrncpy(answer, s+10, len-10);
         sprintf(answer, "textwidth=%d",
#ifndef PresentationManager
		 XTextWidth(wc->font->fsp, answer, len - 10));
#else					/* PresentationManager */
                 GetTextWidth(w, answer, len - 10));
#endif					/* PresentationManager */
         }
      else
      switch (a=si_s2i(attribs, answer)) {
      case A_VISUAL: {
#ifndef PresentationManager
	 Visual * v = DefaultVisual(stddpy,wd->screen);
	 sprintf(answer, "visual=%d,%d,%d",
		 v->class, v->bits_per_rgb, v->map_entries );
#else					/* PresentationManager */
/* XXXX not yet */
        sprintf(answer, "visual=blahblah");
#endif					/* PresentationManager */
	 break;
         }
      case A_DEPTH: {
#ifndef PresentationManager
	 sprintf(answer, "depth=%d", DefaultDepth(stddpy,wd->screen));
#else					/* PresentationManager */
         sprintf(answer, "depth=%d", ScreenBitsPerPel);
#endif					/* PresentationManager */
	 break;
         }
      case A_ASCENT: {
#ifndef PresentationManager
	 sprintf(answer, "ascent=%d", wc->font->fsp->max_bounds.ascent);
#else 					/* PresentationManager */
         sprintf(answer, "ascent=%d", wc->font->metrics.lMaxAscender);
#endif					/* PresentationManager */
	 break;
	 }
      case A_DESCENT: {
#ifndef PresentationManager
	 sprintf(answer, "descent=%d", wc->font->fsp->max_bounds.descent);
#else					/* PresentationManager */
         sprintf(answer, "descent=%d", wc->font->metrics.lMaxDescender);
#endif					/* PresentationManager */
	 break;
	 }
      case A_FHEIGHT: {
#ifndef PresentationManager
	 sprintf(answer, "fheight=%d", wc->font->height);
#else					/* PresentationManager */
         sprintf(answer, "fheight=%d", wc->font->metrics.lMaxBaselineExt);
#endif					/* PresentationManager */
	 break;
	 }
      case A_FWIDTH: {
#ifndef PresentationManager
	 sprintf(answer, "fwidth=%d", wc->font->fsp->max_bounds.width);
#else					/* PresentationManager */
         sprintf(answer, "fwidth=%d", wc->font->metrics.lMaxCharInc);
#endif					/* PresentationManager */
	 break;
	 }
      case A_ROW: {
	 sprintf(answer, "row=%d",
		 YTOROW(w,w->window->y-1));
	 break;
         }
      case A_COL: {
	 sprintf(answer, "col=%d", 1 + XTOCOL(w,w->window->x));
	 break;
         }
      case A_POINTERROW: {
	 sprintf(answer, "pointerrow=%d", YTOROW(w,ws->pointery-1));
	 break;
         }
      case A_POINTERCOL: {
	 sprintf(answer, "pointercol=%d", 1 + XTOCOL(w,ws->pointerx));
	 break;
         }
      case A_LINES: {
#ifndef PresentationManager
	 sprintf(answer, "lines=%d", YTOROW(w,ws->height-wc->font->fsp->max_bounds.ascent));
#else					/* PresentationManager */
         sprintf(answer, "lines=%d", YTOROW(w, ws->height - wc->font->metrics.lMaxDescender));
#endif 					/* PresentationManager */
	 break;
         }
      case A_COLUMNS: {
	 sprintf(answer, "columns=%d", XTOCOL(w,ws->width));
	 break;
         }
      case A_POS: case A_POSX: case A_POSY: {
#ifndef PresentationManager
	 Window garbage1, garbage2;
	 int root_x, root_y, win_x, win_y;
	 unsigned int key_buttons, width, height, border_width, depth;
	 if (!stdwin) return Failed;
	 if (stdpix) {
	    /*
	     * This call is made because it is guaranteed to generate
	     * a synchronous request of the server, not just ask Xlib
	     * what the window position was last it knew.
	     */
	    if (XQueryPointer(stddpy, stdwin, &garbage1, &garbage2,
			  &root_x, &root_y, &win_x, &win_y, &key_buttons) ==
		False) {
	       return Failed;
	       }
	    ws->posx = root_x - win_x;
	    ws->posy = root_y - win_y;
#else					/* PresentationManager */
          if (!stdwin) return Failed;
#endif					/* PresentationManager */
	    switch (a) {
	    case A_POS:
	       sprintf(answer, "pos=%d,%d", ws->posx, ws->posy);
	       break;
	    case A_POSX:
	       sprintf(answer, "posx=%d", ws->posx);
	       break;
	    case A_POSY:
	       sprintf(answer, "posy=%d", ws->posy);
	       break;
	       }
#ifndef PresentationManager
	    }
#endif					/* PresentationManager */
	 break;
         }
      case A_FG: { 
#ifndef PresentationManager
        sprintf(answer, "fg=%s", wc->fg->name);
#else					/* PresentationManager */
        char buf[64];

        GetColorName(wc->charBundle.lColor, buf, 64);
        sprintf(answer, "fg=%s", buf);
#endif					/* PresentationManager */
        break; 
        }
      case A_BG: { 
#ifndef PresentationManager
         sprintf(answer, "bg=%s", wc->bg->name);
#else					/* PresentationManager */
         char buf[64];
 
         GetColorName(wc->charBundle.lBackColor, buf, 64);
         sprintf(answer, "bg=%s", buf);
#endif					/* PresentationManager */
         break; 
         }
      case A_FILLSTYLE: {
#ifndef PresentationManager
	 sprintf(answer,"fillstyle=%s",
		 (wc->fillstyle==FillSolid)?"solid":
		 ((wc->fillstyle==FillStippled)?"stippled":"opaquestippled"));
#else					/* PresentationManager */
         sprintf(answer, "fillstyle=%s",
                 (wc->fillstyle == FS_SOLID) ? "solid" :
                 (wc->fillstyle == FS_STIPPLE) ? "stippled" : "opaquestippled");
#endif					/* PresentationManager */
	 break;
	 }
      case A_LINESTYLE: {
#ifndef PresentationManager
	 sprintf(answer,"linestyle=%s",
		 (wc->linestyle==LineSolid)?"solid":
		 ((wc->linestyle==LineOnOffDash)?"onoff":"doubledash"));
#else					/* PresentationManager */
         char *ptr;
         if (ptr = si_i2s(siLineTypes, wc->lineBundle.usType))
           sprintf(answer, "linestyle=%s", ptr);
         else return Failed;
#endif					/* PresentationManager */
	 break;
	 }
      case A_LINEWIDTH: { 
#ifndef PresentationManager
        sprintf(answer, "linewidth=%d", wc->linewidth); 
#else					/* PresentationManager */
        sprintf(answer, "linewidth=%d", wc->lineBundle.lGeomWidth + 1);
#endif					/* PresentationManager */
        break;
        }
      case A_HEIGHT: { sprintf(answer, "height=%d", ws->height); break; }
      case A_WIDTH: { sprintf(answer, "width=%d", ws->width); break; }
      case A_DISPLAYHEIGHT: {
#ifndef PresentationManager
	 sprintf(answer, "displayheight=%d", DisplayHeight(stddpy,wd->screen));
#else					/* PresentationManager */
         sprintf(answer, "displayheight=%d", ScreenHeight);
#endif					/* PresentationManager */
	 break;
         }
      case A_DISPLAYWIDTH: {
#ifndef PresentationManager
	 sprintf(answer,"displaywidth=%d", DisplayWidth(stddpy,wd->screen));
#else					/* PresentationManager */
         sprintf(answer, "displaywidth=%d", ScreenWidth);
#endif					/* PresentationManager */
	 break;
         }
      case A_CURSOR: {
	 sprintf(answer,"cursor=%s",(ISCURSORON(w)?"on":"off"));
	 break;
         }
      case A_ECHO: {
	 sprintf(answer,"echo=%s",(ISECHOON(w)?"on":"off"));
	 break;
         }
      case A_REVERSE: {
	 sprintf(answer,"reverse=%s",(ISREVERSE(w)?"on":"off"));
	 break;
         }
      case A_FONT: { 
#ifndef PresentationManager
         sprintf(answer,"font=%s", wc->font->name);
#else					/* PresentationManager */
        char buf[128];

        GetFontName(wc->charBundle.usSet, buf, 128);
        sprintf(answer, "font=%s", buf);
#endif					/* PresentationManager */
        break; 
        }
      case A_X: { sprintf(answer, "x=%d", ws->x); break; }
      case A_Y: { sprintf(answer, "y=%d", ws->y); break; }
      case A_DX: { sprintf(answer,"dx=%d", wc->dx); break; }
      case A_DY: { sprintf(answer,"dy=%d", wc->dy); break; }
      case A_LEADING: { 
#ifndef PresentationManager
         sprintf(answer,"leading=%d",wc->font->leading); 
#else					/* PresentationManager */
         sprintf(answer, "leading=%d", wc->fntLeading);
#endif					/* PresentationManager */
         break;
         }
      case A_POINTERX: { sprintf(answer, "pointerx=%d", ws->pointerx); break; }
      case A_POINTERY: { sprintf(answer, "pointery=%d", ws->pointery); break; }
      case A_POINTER: {
#ifndef PresentationManager
	 char *s = si_i2s(cursorsyms,w->window->theCursor);
#else					/* PresentationManager */
         char *s = si_i2s(siCursorSyms, w->window->theCursor);
#endif					/* PresentationManager */
	 if (s) sprintf(answer, "pointer=%s", s);
	 else return Failed;
	 break;
         }
      case A_DRAWOP: {
	 char *s;
	 if (ISXORREVERSE(w)) s = "reverse";
#ifndef PresentationManager
	 else s = si_i2s(drawops,wc->drawop);
#else					/* PresentationManager */
         else s = si_i2s(siMixModes, wc->drawop);
#endif					/* PresentationManager */
	 if (s) sprintf(answer, "drawop=%s", s);
	 else return Failed;
	 break;
         }
      case A_GEOMETRY: {
#ifndef PresentationManager
	 Window garbage1, garbage2;
	 int root_x, root_y, win_x, win_y;
	 unsigned int key_buttons, width, height, border_width, depth;
	 if (!stdwin) return Failed;
	 if (stdpix) {
	    /*
	     * This call is made because it is guaranteed to generate
	     * a synchronous request of the server, not just ask Xlib
	     * what the window position was last it knew.
	     */
	    if (XQueryPointer(stddpy, stdwin, &garbage1, &garbage2,
			  &root_x, &root_y, &win_x, &win_y, &key_buttons) ==
		False) {
	       return Failed;
	       }
	    sprintf(answer, "geometry=%dx%d+%d+%d",
		    ws->width,ws->height,root_x-win_x, root_y-win_y);
	    }
	 else
	    sprintf(answer, "geometry=%dx%d", ws->width, ws->height);
#else					/* PresentationManager */
         if (stdwin)
           sprintf(answer, "geometry=%dx%d+%d+%d", ws->width, ws->height,
                   ws->posx, ws->posy);
         else
           sprintf(answer, "geometry=%dx%d", ws->width, ws->height);
#endif					/* PresentationManager */
	 break;
         }
#ifdef PresentationManager
      case A_ICONIC:
        sprintf(answer, "iconic=%s", ((ws->winState & WS_MIN) ? "icon" :
                                      (ws->winState & WS_MAX) ? "fullscreen" : "window"));
        break;
#endif					/* PresentationManager */
      }
      }
#ifndef PresentationManager
   XFlush(stddpy);
#endif					/* PresentationManager */
   return Succeeded;
   }

#ifndef PresentationManager
/*
 * wclose - close a window.  Wait for a DestroyNotify event from the server
 * before returning.
 */
int wclose(w)
wbp w;
   {
   STDLOCALS(w);

   XSync(stddpy, False);
   if (pollevent() == -1) return -1;
   if (ws->win) {
      SETZOMBIE(w);
      XDestroyWindow(stddpy,stdwin);
      XFlush(stddpy);
      }
   free_window(ws);
   while (ws->win)
      if (pollevent() == -1) return -1;
   return 0;
   }
/*
 * flush a window
 */
novalue wflush(w)
wbp w;
   {
   STDLOCALS(w);
   XFlush(stddpy);
   }

/*
 * open a window
 * This routine really just allocates a window data structure.
 * The interesting part is done in wmap, after the user preferences
 * passed to Icon have been parsed.
 */
FILE *wopen(windowname,lp,attr,n)
char *windowname; /* NOTUSED */
struct b_list *lp;
dptr attr;
int n;
   {
   wbp w;
   wsp ws;
   char dispchrs[256];
   char *display = NULL;
   int i;
   tended struct b_list *tlp;

   tlp = lp;

   for(i=0;i<n;i++) {
      if (is:string(attr[i]) &&
	  (StrLen(attr[i])>8) &&
	  !strncmp("display=",StrLoc(attr[i]),8)) {
         mystrncpy(dispchrs,StrLoc(attr[i])+8,StrLen(attr[i])-8);
	 display = dispchrs;
         }
      }

   Protect(w = alc_wbinding(), return NULL);

   Protect(w->window = alc_winstate(), { free_binding(w); return NULL; });

   if (display != NULL) {
      Protect(w->window->display = alc_display(display),
	      { free_binding(w); return NULL; });
      }
   else {
      Protect(w->window->display = alc_display(NULL),
	      { free_binding(w); return NULL; });
      }

   ws = w->window;
   ws->listp.dword = D_List;
   BlkLoc(ws->listp) = (union block *)tlp;

   /*
    * some attributes of the display and window are used in the context
    */
   Protect(w->context = alc_context(w),
	   { free_display(w->window->display); free_binding(w); return NULL;});

   /*
    * some attributes of the context determine window defaults
    */
   ws->height = w->context->font->height * 12 + (MARGIN << 1);
   ws->width  = w->context->font->fsp->max_bounds.width  * 80 + (MARGIN << 1);
   ws->y = MARGIN + w->context->font->fsp->max_bounds.ascent;
   ws->x = MARGIN;

   return (FILE *)w;
   }

/*
 * make an icon for a window
 */
novalue makeIcon(w, x, y)
wbp w;
int x, y;		/* current mouse position */
{
   char *name;
   int status;
   STDLOCALS(w);
   
   /* if a pixmap image has been specified, load it */
   if (strcmp(ws->iconimage, "")) {
      ws->iconpix = loadimage(w, ws->iconimage, &(ws->iconh), &(ws->iconw),
			      0, &status);
      ws->iconh += 6;
      ws->iconw += 6;
   }
   else {    /* determine the size of the icon window */
      ws->iconh = wd->fonts->fsp->max_bounds.ascent +
		  wd->fonts->fsp->max_bounds.descent + 5;
      ws->iconw = XTextWidth(wd->fonts->fsp, ws->iconlabel,
		  strlen(ws->iconlabel)) + 6;
   }

   /* if icon position hint exists, get it */
   if (ws->wmhintflags & IconPositionHint) {
      x = ws->iconx;
      y = ws->icony;
   }

   /* create the icon window */
   ws->iconwin = XCreateSimpleWindow(stddpy, DefaultRootWindow(stddpy), x, y,
				     ws->iconw, ws->iconh, 2, wc->fg->c,
				     wc->bg->c);

   /* select events for the icon window */
   XSelectInput(stddpy, ws->iconwin,
		ExposureMask | KeyPressMask | ButtonPressMask);
}

/*
 * Cause the window to actually become visible on the screen.
 */
int wmap(f,windowname)
FILE *f;
char *windowname;
   {
   wbp w = (wbp)f;
   XWindowAttributes attrs;
   XGCValues gcv;
   int gcmask = GCFont | GCForeground | GCBackground | GCFillStyle;
   XWMHints wmhints;
   STDLOCALS(w);

   if (!strcmp(ws->windowlabel, ""))
      mystrncpy(ws->windowlabel, windowname, MAXLABEL-1);
   /*
    * OK, the window background is whatever BG is now
    */
   ws->winbg = wc->bg;
   ws->winbg->refcount++;

   /*
    * create the X window (or use the DefaultRootWindow if requested)
    */
   ws->win = ((ws->iconic == RootState) ? DefaultRootWindow(stddpy) :
               XCreateSimpleWindow(stddpy, DefaultRootWindow(stddpy),
			           ws->posx < 0 ? 0 : ws->posx,
			           ws->posy < 0 ? 0 : ws->posy, ws->width,
				   ws->height, 4, wc->fg->c, wc->bg->c));
   stdwin = ws->win;

   /*
    * before creating the graphics context, construct a description
    * of any non-default initial graphics context values.
    */
   gcv.foreground = wc->fg->c ^ (ISXORREVERSE(w) ? wc->bg->c : 0);
   gcv.background = wc->bg->c;
   gcv.font       = wc->font->fsp->fid;
   if (wc->fillstyle)
      gcv.fill_style = wc->fillstyle;
   else
      gcv.fill_style = wc->fillstyle = FillSolid;
   if (wc->linestyle || wc->linewidth) {
      gcmask |= (GCLineWidth | GCLineStyle);
      gcv.line_width = wc->linewidth;
      gcv.line_style = wc->linestyle;
      }
   else wc->linestyle = LineSolid;

   /*
    * Create a graphics context (or change an existing one to conform
    * with initial values).
    */
   if (stdgc == NULL) {
      wc->gc = XCreateGC(stddpy, stdwin, gcmask, &gcv);
      stdgc = wc->gc;
      if (stdgc == NULL) return 0;
      }
   else
      XChangeGC(stddpy, stdgc, gcmask, &gcv);

   XClearWindow(stddpy, stdwin);

   if (ws->iconic != RootState) {
      size_hints.flags = PSize | PMinSize;
      size_hints.width = ws->width;
      size_hints.height= ws->height;
      if (ws->posx < 0) ws->posx = 0;
      else size_hints.flags |= USPosition;
      if (ws->posy < 0) ws->posy = 0;
      else size_hints.flags |= USPosition;
      size_hints.x = ws->posx;
      size_hints.y = ws->posy;
      size_hints.min_width = wc->font->fsp->max_bounds.width  + (MARGIN << 1);
      size_hints.min_height= wc->font->height + (MARGIN << 1);
      if (!strcmp(ws->iconlabel, ""))
         strcpy(ws->iconlabel, ws->windowlabel);
      XSetStandardProperties(stddpy, stdwin, ws->windowlabel, ws->iconlabel,
			     0,0,0, &size_hints);
      XSelectInput(stddpy, stdwin, ExposureMask | KeyPressMask |
		   ButtonPressMask | ButtonReleaseMask | ButtonMotionMask |
		   StructureNotifyMask);
      }

   wmhints.input = True;
   wmhints.flags = InputHint;
   if (ws->iconic != RootState) {
      if (strcmp(ws->iconimage, "")) {
	 makeIcon(w, ws->posx < 0 ? 0 : ws->posx, ws->posy < 0 ? 0 : ws->posy);
	 wmhints.icon_window = ws->iconwin;
	 ws->wmhintflags |= IconWindowHint;
         }
      wmhints.flags |= (ws->wmhintflags | StateHint);
      wmhints.initial_state = ws->iconic;
      wmhints.icon_x = ws->iconx;
      wmhints.icon_y = ws->icony;
      }
   XSetWMHints(stddpy, stdwin, &wmhints);

   if (ws->iconic != RootState)
      XMapWindow(stddpy, stdwin);

   XGetWindowAttributes(stddpy, stdwin, &attrs);
   ws->pixwidth = ws->width = attrs.width;
   ws->pixheight = ws->height = attrs.height;

   if (wc->clipx || wc->clipy || wc->clipw || wc->cliph)
      setclip(w);

   if (ws->prepix) {
      ws->pix = ws->prepix;
      ws->prepix = (Pixmap) NULL;
      }
   else {
      ws->pix = XCreatePixmap(stddpy, DefaultRootWindow(stddpy), attrs.width,
			      attrs.height, DefaultDepth(stddpy,wd->screen));
      XSetForeground(stddpy, stdgc, ws->winbg->c);
      XFillRectangle(stddpy, ws->pix, stdgc, 0, 0, ws->width, ws->height);
      XSetForeground(stddpy, stdgc, wc->fg->c ^ (ISXORREVERSE(w)?wc->bg->c:0));
      }

   if (ws->theCursor >= 0) {
      int i = ws->theCursor >> 1;
      if (i < NUMCURSORSYMS) {
	 if (stdwin)
	    XDefineCursor(stddpy, stdwin, wd->cursors[i]);
	 }
      }

   /*
    * busy loop for an expose event
    */
   if (ws->iconic == NormalState) {
      int i=0;
      while (!ISEXPOSED(w)) {
	 if (pollevent() == -1) return -1;
#define OpenMaxPoll 2000
	 if (i++ > OpenMaxPoll) break;
         }
         SETEXPOSED(w);			/* hope for the best */
      }

   XCopyArea(stddpy, ws->pix, stdwin, stdgc, 0, 0,
	     ws->width, ws->height, 0, 0);
   XSetFunction(stddpy, stdgc, wc->drawop);
   XSync(stddpy, False);
   return 1;
}
#endif					/* PresentationManager */

novalue setclip(w)
wbp w;
   {
#ifndef PresentationManager
   wcp wc = w->context;
   XRectangle rec;
   if (wc->gc) {
      rec.x = wc->clipx;
      rec.y = wc->clipy;
      rec.width = ((wc->clipw) ? wc->clipw : w->window->pixwidth);
      rec.height = ((wc->cliph) ? wc->cliph : w->window->pixheight);
      XSetClipRectangles(wc->display->display, wc->gc, 0, 0, &rec, 1,Unsorted);
      }
#else					/* PresentationManager */
   UnsetClipContext(w->context);
   MutexOn(w->window);
   SetClipContext(w, w->window, w->context);
   MutexOff(w->window);
#endif					/* PresentationManager */
   }

#ifndef PresentationManager
hidden novalue setinitialstate(w,s)
wbp w;
char *s;
   {
   wsp ws = w->window;

   if (!strcmp(s, "icon")) {
      ws->wmhintflags |= StateHint;
      ws->iconic = IconicState;
      }
   else if (!strcmp(s, "root"))
      ws->iconic = RootState;
   }

hidden novalue seticonpos(w,s)
wbp w;
char *s;
   {
   char *s2;
   wsp ws = w->window;

   ws->wmhintflags |= IconPositionHint;
   s2 = s;
   ws->iconx = atol(s2);
   while (isspace(*s2)) s2++;
   while (isdigit(*s2)) s2++;
   if (*s2++ != ',') return;
   ws->icony = atol(s2);
   }
#endif					/* PresentationManager */

hidden novalue setpos(w,s)
wbp w;
char *s;
   {
   char *s2;
#ifdef PresentationManager
   int posx, posy;
#endif					/* PresentationManager */
   STDLOCALS(w);

   s2 = s;
#ifndef PresentationManager
   ws->posx = atol(s2);
#else					/* PresentationManager */
   posx = atol(s2);
#endif					/* PresentationManager */
   while (isspace(*s2)) s2++;
   while (isdigit(*s2)) s2++;
   if (*s2++ != ',') return;
#ifndef PresentationManager
   ws->posy = atol(s2);
   if (stdpix && stdwin) {
      XMoveWindow(stddpy, stdwin, ws->posx, ws->posy);
      XFlush(stddpy);
      }
#else					/* PresentationManager */
   posy = atol(s2);
   if (stdwin && WinIsWindowVisible(ws->hwndFrame))
     WinSetWindowPos(ws->hwndFrame, 0,
                     posx,
                     ScreenHeight - posy -
                     (ws->height + (BORDERHEIGHT << 1) + TITLEHEIGHT),
                     0, 0, SWP_MOVE);
   else {
     ws->posx = posx;
     ws->posy = posy;
     } /* End of else - window not there, or not visible */
#endif					/* PresentationManager */
   return;
   }

/*
 * Set the context's fill style by name.
 */
setfillstyle(w, s)
wbp w;
char *s;
   {
   STDLOCALS(w);

#ifndef PresentationManager
   if (!strcmp(s, "solid")) {
      wc->fillstyle = FillSolid;
      }
   else if (!strcmp(s, "stippled")) {
      wc->fillstyle = FillStippled;
      }
   else if (!strcmp(s, "opaquestippled")) {
      wc->fillstyle = FillOpaqueStippled;
      }
   if (stdpix) {
      XSetFillStyle(stddpy, stdgc, wc->fillstyle);
      }
#else					/* PresentationManager */
  if (!strcmp(s, "solid")) {
    wc->fillstyle = FS_SOLID;
    wc->areaBundle.usSet = LCID_DEFAULT;
    wc->areaBundle.usSymbol = PATSYM_SOLID;
    wc->areaBundle.usBackMixMode = BM_LEAVEALONE;
    } /* End of if - solid fill pattern */
  else {
    if (!strcmp(s, "stippled")) {
      wc->fillstyle = FS_STIPPLE;
      wc->areaBundle.usBackMixMode = BM_LEAVEALONE;
      } /* End of elseif - stipple */
    else if (!strcmp(s, "opaquestippled")) {
      wc->fillstyle = FS_OPAQUESTIPPLE;
      wc->areaBundle.usBackMixMode = BM_OVERPAINT;
      } /* End of else - opaque stipple */
    /* fixup the bundle */
    if (wc->currPattern >= 0) {
      wc->areaBundle.usSet = wc->currPattern;
      wc->areaBundle.usSymbol = PATSYM_DEFAULT;
      } /* End of if - pattern currently bitmap or default */
    else {
      wc->areaBundle.usSet = LCID_DEFAULT;
      wc->areaBundle.usSymbol = abs(wc->currPattern);
      } /* End of else - pattern specifies symbol */
    } /* End of else - not solid */
  /* cause a lazy update */
  UnsetAreaContext(wc);
#endif					/* PresentationManager */
   }
/*
 * Set the context's line style by name.
 */
setlinestyle(w, s)
wbp w;
char *s;
   {
#ifndef PresentationManager
   STDLOCALS(w);

   if (!strcmp(s, "solid")) {
      wc->linestyle = LineSolid;
      }
   else if (!strcmp(s, "onoff")) {
      wc->linestyle = LineOnOffDash;
      }
   else if (!strcmp(s, "doubledash")) {
      wc->linestyle = LineDoubleDash;
      }
   if (stdpix) {
      XSetLineAttributes(stddpy, stdgc, wc->linewidth, wc->linestyle, CapButt,
			 JoinRound);
      }
#else					/* PresentationManager */
  SHORT ltype;
  STDLOCALS(w);

  if ((ltype = si_s2i(siLineTypes, s)) < 0)
    return 0;
  wc->lineBundle.usType = ltype;
  UnsetLineContext(wc);
  return 1;
#endif					/* PresentaationManager */
   }
/*
 * Set the context's line width
 */
setlinewidth(w, s)
wbp w;
char *s;
   {
#ifndef PresentationManager
   STDLOCALS(w);

   wc->linewidth = atoi(s);
   if (stdpix) {
      XSetLineAttributes(stddpy, stdgc, wc->linewidth, wc->linestyle, CapButt,
			 JoinRound);
      }
#else					/* PresentationManager */
  LONG linewid;
  STDLOCALS(w);

  if ((linewid = atoi(s)) <= 0)
    return 0;
  wc->lineBundle.lGeomWidth = linewid - 1;
  UnsetLineContext(wc);
  return 1;
#endif					/* PresentationManager */
   }

#ifndef PresentationManager
/*
 * Reset the context's foreground color to whatever it is supposed to be.
 */
int resetfg(w)
wbp w;
   {
   wcp wc = w->context;
   if (wc->gc != NULL)
      XSetForeground(wc->display->display, wc->gc,
		     wc->fg->c ^ (ISXORREVERSE(w) ? wc->bg->c : 0));
   return 1;
   }
#endif					/* PresentationManager */

/*
 * Set the context's foreground color by name.
 */
#ifndef PresentationManager
int setfg(w,s)
wbp w;
char *s;
   {
   wclrp cp;
   STDLOCALS(w);

   Protect(cp = alc_color(w,s), return 0);
   wc->fg = cp;
   return resetfg(w);
#else					/* PresentationManager */
int setfg(wbinding *w, ULONG rgb)
{
  LONG indx, tmpindx;
  STDLOCALS(w);

  if ((indx = GetRGBColorIndex(rgb)) >= 0) {
    /* if we are in mode reverse, xor the index for the new color */
    if (ISXORREVERSE(w)) {
      /* new foreground color */
      indx ^= wc->charBundle.lBackColor;
      /* make sure it is available for PS loading */
      EnsureColorAvailable(indx);
      /* release the previous foreground color */
      tmpindx = wc->charBundle.lColor ^ wc->charBundle.lBackColor;
      ReleaseColor(tmpindx);
      } /* mode reverse */
    else
      ReleaseColor(wc->charBundle.lColor);
    /* set the color attribute in the context */
    wc->areaBundle.lColor = indx;
    wc->charBundle.lColor = indx;
    wc->lineBundle.lColor = indx;
    /* this context needs to be unloaded and subsequently reload for
       change to take effect */
    UnsetAllContext(wc);
    return 1;
    } /* End of if - found a color match */
  return 0;
#endif					/* PresentationManager */
   }


#ifndef PresentationManager
/*
 * Set the context's foreground color by color cell.
 */
int isetfg(w,fg)
wbp w;
int fg;
   {
   int i;
   STDLOCALS(w);

   if (fg >= 0) return 0;
   for (i = 2; i < DMAXCOLORS; i++)
      if (wd->colors[i].type == MUTABLE && wd->colors[i].c == -fg - 1)
	 break;
   if (i == DMAXCOLORS) return 0;
   wc->fg = &(wd->colors[i]);
   return resetfg(w);
   }
#endif					/* PresentationManager */

/*
 * Set the window context's background color by name.
 */
#ifndef PresentationManager
int setbg(w,s)
wbp w;
char *s;
   {
   wclrp cp;
   STDLOCALS(w);

   Protect(cp = alc_color(w,s), return 0);
   wc->bg = cp;

   if (stdgc != NULL)
      XSetBackground(stddpy, stdgc, wc->bg->c);
   return ISXORREVERSE(w) ? resetfg(w) : 1;
#else					/* PresentationManager */
int setbg(wbinding *w, ULONG rgb)
{
   LONG indx, findx;
   STDLOCALS(w);

  if ((indx = GetRGBColorIndex(rgb)) >= 0) {
    /* release the current background color */
    ReleaseColor(wc->charBundle.lBackColor);
    /* if we are in reverse mode, have to change the foreground color */
    if (ISXORREVERSE(w)) {
      /* break the real foreground color back out */
      findx = (wc->charBundle.lColor ^ wc->charBundle.lBackColor);
      /* the new index for the foreground */
      findx ^= indx;
      /* make sure new foreground color is available */
      EnsureColorAvailable(findx);
      /* set the new foreground color */
      wc->areaBundle.lColor = findx;
      wc->lineBundle.lColor = findx;
      wc->charBundle.lColor = findx;
      /* have to unset the line bundle here too */
      UnsetLineContext(wc);
      } /* End of if - in reverse mode */
    /* set the color attribute in the context */
    wc->areaBundle.lBackColor = indx;
    wc->charBundle.lBackColor = indx;
    /* unset us */
    UnsetCharContext(wc);
    UnsetAreaContext(wc);
    return 1;
    } /* End of if - found a color match */
  return 0;
#endif					/* PresentationManager */
   }


#ifndef PresentationManager
/*
 * Set the context's background color by color cell.
 */
int isetbg(w,bg)
wbp w;
int bg;
   {
   int i;
   STDLOCALS(w);

   if (bg >= 0) return 0;
   for (i = 2; i < DMAXCOLORS; i++)
      if (wd->colors[i].type == MUTABLE && wd->colors[i].c == -bg - 1)
	 break;
   if (i == DMAXCOLORS) return 0;
   wc->bg = &(wd->colors[i]);
   if (stdgc != NULL)
      XSetBackground(stddpy, stdgc, wc->bg->c);
   return ISXORREVERSE(w) ? resetfg(w) : 1;
   }


/*
 * Set the display by name.  Really should cache answers as per fonts below;
 * for now just open a new display each time.  Note that this can only be
 * called before a window is instantiated...
 */
hidden int setdisplay(w,s)
wbp w;
char *s;
   {
   wdp d;
   Protect(d = alc_display(s), return 0);
   w->window->display = d;
   w->context->fg = &(d->colors[0]);
   w->context->bg = &(d->colors[1]);
   w->context->font = d->fonts;
   return 1;
   }

/*
 * Set the window's font by name.
 */
int setfont(w,s)
wbp w;
char **s;
   {
   wfp tmp;
   STDLOCALS(w);

   /* could free up previously allocated font here */

   Protect(tmp = alc_font(w,s), return 0);
   wc->font = tmp;

   if (stdgc != NULL)
      XSetFont(stddpy, stdgc, wc->font->fsp->fid);
   return 1;
   }

/*
 * callback procedures
 */

hidden novalue handle_exposures(w, event)
wbp w;
XExposeEvent *event;
   {
   STDLOCALS(w);

   SETEXPOSED(w);
   if (stdwin && !ISZOMBIE(w)) {
      if (wc->drawop != GXcopy)
	 XSetFunction(stddpy, stdgc, GXcopy);
      XCopyArea(stddpy, stdpix, stdwin, stdgc, event->x,event->y,
		event->width,event->height, event->x,event->y);
      if (wc->drawop != GXcopy)
	 XSetFunction(stddpy,stdgc,wc->drawop);
      }
   }
#ifndef min
#define min(x,y) (((x)<(y))?(x):(y))
#define max(x,y) (((x)>(y))?(x):(y))
#endif

/*
 * resizePixmap(w,width,height) -- ensure w's backing pixmap is at least
 * width x height pixels.
 *
 * Resizes the backing pixmap, if needed.  Called when X resize events
 * arrive, as well as when programs make explicit resize requests.
 *
 * Returns 0 on failure.
 */
int resizePixmap(w,width,height)
wbp w;
int width;
int height;
   {
   Pixmap p;
   STDLOCALS(w);
   if (ws->pix == (Pixmap) NULL) return 1;
   if ((width > ws->pixwidth) || (height > ws->pixheight)) {
      int x = ws->pixwidth, y = ws->pixheight;

      ws->pixheight = max(ws->pixheight, height);
      ws->pixwidth  = max(ws->pixwidth, width);
      p = XCreatePixmap(stddpy, DefaultRootWindow(stddpy), ws->pixwidth,
			ws->pixheight, DefaultDepth(stddpy,wd->screen));
      if (p == (Pixmap) NULL)
	 return 0;

      /*
       * This staggering amount of redudancy manages to make sure the new
       * pixmap gets initialized including areas not in the old pixmap.
       * The window is redrawn.
       */
      XSetForeground(stddpy, stdgc, ws->winbg->c);
      if (wc->drawop != GXcopy)
	 XSetFunction(stddpy, stdgc, GXcopy);
	   
      if (width > x) {
	 XFillRectangle(stddpy,p,stdgc,x,0, width-x,height);
	 if (stdwin != (Window) NULL)
	    XFillRectangle(stddpy,stdwin,stdgc,x,0, width-x,height);
         }
      if (height > y) {
	 XFillRectangle(stddpy, p, stdgc, 0, y, x, height - y);
	 if (stdwin != (Window) NULL)
	    XFillRectangle(stddpy, stdwin, stdgc, 0, y, x, height - y);
         }
      XSetForeground(stddpy, stdgc, wc->fg->c ^ (ISXORREVERSE(w)?wc->bg->c:0));
      XCopyArea(stddpy, stdpix, p, stdgc, 0, 0, x, y, 0, 0);
      if (stdwin)
	 XCopyArea(stddpy, stdpix, stdwin, stdgc, 0, 0, x, y, 0, 0);
      if (wc->drawop != GXcopy)
	 XSetFunction(stddpy,stdgc,wc->drawop);

      /*
       * Make sure previous ops on stdpix are complete, then free it.
       */
      XSync(stddpy, True);
      if (pollevent() == -1) return 0;
      XFreePixmap(stddpy, stdpix);
      ws->pix = p;
      }
   return 1;
   }

/*
 * Resize operations are made as painless as possible, but the
 * user program is informed anyhow.  The integer coordinates are
 * the new size of the window, in pixels.
 */
hidden int handle_config(w, event)
wbp w;
XConfigureEvent *event;
   {
   struct descrip d;
   STDLOCALS(w);

   /*
    * Update X-Icon's information about the window's configuration
    */
   ws->x = min(ws->x, event->width - wc->font->fsp->max_bounds.width);
   ws->y = min(ws->y, event->height);

   ws->posx = event->x;
   ws->posy = event->y;

   /*
    * If this was not a resize, then it generates no Icon-level "events"
    */
   if (!ISEXPOSED(w) ||
       (event->width == ws->width) && (event->height == ws->height)) {
      return 1;
      }

   ws->width = event->width;
   ws->height = event->height;

   if (! resizePixmap(w, event->width, event->height)) return 0;

   MakeInt(RESIZED, &d);
   qevent(w, &d, ws->width, ws->height, ~(uword)0, 0);
   return 1;
   }

/*
 * Queue up characters for keypress events.
 */
hidden novalue handle_keypress(w,event)
wbp w;
XKeyEvent *event;
   {
   int i,j;
   char s[10];
   struct descrip d;
   KeySym k;

   w->window->pointerx = event->x;
   w->window->pointery = event->y;

   switch (i=translate_key_event(event, s, &k)) {
   case -1:
      return;
   case 0:
      MakeInt(k, &d);
      qevent(w, &d, event->x, event->y, (uword)event->time, event->state);
      break;
   default:
      StrLen(d) = 1;
      for (j = 0; j < i; j++) {
	 StrLoc(d) = (char *)&allchars[FromAscii(s[j]) & 0xFF];
	 qevent(w, &d, event->x, event->y, (uword)event->time, event->state);
	 }
      }
   }

#define swap(a,b) { tmp = a; a = b; b = tmp; }
/*
 * Handle button presses and drag events.  In the case of drags, we should
 * really be looking at an XMotionEvent instead of an XButtonEvent, but
 * the structures are identical up to the button field (which we do not
 * examine for drag events).  Mouse coordinates are queued up after the event.
 */
hidden novalue handle_mouse(w,event)
wbp w;
XButtonEvent *event;
   {
   static unsigned int buttonorder[3] =
     { Button1Mask, Button2Mask, Button3Mask };
   unsigned int tmp;
   int eventcode = 0;
   struct descrip d;

   if (event->type == MotionNotify) {
      if (event->state | buttonorder[0]) {
         if (buttonorder[0] == Button1Mask)
	    eventcode = MOUSELEFTDRAG;
         else if (buttonorder[0] == Button2Mask)
            eventcode = MOUSEMIDDRAG;
         else
            eventcode = MOUSERIGHTDRAG;
         }
      else if (event->state | buttonorder[1]) {
         if (buttonorder[1] == Button1Mask)
	    eventcode = MOUSELEFTDRAG;
         else if (buttonorder[1] == Button2Mask)
            eventcode = MOUSEMIDDRAG;
         else
            eventcode = MOUSERIGHTDRAG;
         }
      else if (event->state | buttonorder[2]) {
         if (buttonorder[2] == Button1Mask)
	    eventcode = MOUSELEFTDRAG;
         else if (buttonorder[2] == Button2Mask)
            eventcode = MOUSEMIDDRAG;
         else
            eventcode = MOUSERIGHTDRAG;
         }
      }
   else switch (event->button) {
      case Button1: {
	 eventcode = MOUSELEFT;
	 if (buttonorder[2] == Button1Mask)
	    swap(buttonorder[1],buttonorder[2]);
	 if (buttonorder[1] == Button1Mask)
	    swap(buttonorder[0],buttonorder[1]);
	 break;
         }
      case Button2: {
	 eventcode = MOUSEMID;
	 if (buttonorder[2] == Button2Mask)
	    swap(buttonorder[1],buttonorder[2]);
	 if (buttonorder[1] == Button2Mask)
	    swap(buttonorder[0],buttonorder[1]);
	 break;
         }
      case Button3: {
	 eventcode = MOUSERIGHT;
	 if (buttonorder[2] == Button3Mask)
	    swap(buttonorder[1],buttonorder[2]);
	 if (buttonorder[1] == Button3Mask)
	    swap(buttonorder[0],buttonorder[1]);
	 break;
         }
      }
   if (event->type == ButtonRelease) {
      eventcode -= (MOUSELEFT - MOUSELEFTUP);
      swap(buttonorder[0],buttonorder[1]);
      swap(buttonorder[1],buttonorder[2]);
      }

   w->window->pointerx = event->x;
   w->window->pointery = event->y;
   MakeInt(eventcode,&d);
   qevent(w, &d, event->x, event->y, (uword)event->time, event->state);
   }

/*
 * Enqueue an event, encoding time interval and key state with x and y values.
 */
hidden novalue qevent(w,e,x,y,t,f)
wbp w;		/* window */
dptr e;		/* event code (descriptor pointer) */
int x, y;	/* x and y values */
uword t;	/* ms clock value */
int f;		/* modifier key flags */
   {
   struct descrip d;
   dptr q = &w->window->listp;
   uword ivl, mod;
   int expo;

   mod = 0;				/* set modifier key bits */
   if (f & ControlMask) mod |= MOD_CONTROL;
   if (f & Mod1Mask)    mod |= MOD_META;
   if (f & ShiftMask)   mod |= MOD_SHIFT;

   if (t != ~(uword)0) {		/* if clock value supplied */
      if (prevtimestamp == 0)		/* if first time */
	 prevtimestamp = t;
      if (t < prevtimestamp)		/* if clock went backwards */
	 t = prevtimestamp;
      ivl = t - prevtimestamp;		/* calc interval in milliseconds */
      prevtimestamp = t;		/* save new clock value */
      expo = 0;
      while (ivl >= 0x1000) {		/* if too big */
	 ivl >>= 4;			/* reduce significance */
	 expo += 0x1000;		/* bump exponent */
   }
      ivl += expo;			/* combine exponent with mantissa */
      }
   else
      ivl = 0;				/* report 0 if interval unknown */

   c_put(q, e);
   d.dword = D_Integer;
   IntVal(d) = mod | (x & 0xFFFF);
   c_put(q, &d);
   IntVal(d) = (ivl << 16) | (y & 0xFFFF);
   c_put(q, &d);
   }
#endif					/* PresentationManager */

/*
 * clear an area
 */
clearArea(w,x,y,width,height)
wbp w;
int x, y, width, height;
   {
#ifndef PresentationManager
   STDLOCALS(w);

   if (stdwin) {
      XClearArea(stddpy, stdwin, x, y, width, height, False);
      }
   /*
    * clear the pixmap
    */
   XSetForeground(stddpy, stdgc, ws->winbg->c);
   XFillRectangle(stddpy, stdpix, stdgc, x, y,
		  width ? width : ws->pixwidth - x,
		  height ? height : ws->pixheight - y);
   XSetForeground(stddpy, stdgc, wc->fg->c ^ (ISXORREVERSE(w)?wc->bg->c:0));

   /*
    * if the entire window is cleared, free up colors
    */
   if (!x && !y &&
      ((width  >= ws->pixwidth)  || !width) &&
      ((height >= ws->pixheight) || !height)) free_colors(w);
#else					/* PresentationManager */
   AREABUNDLE abundle;
   POINTL pts[2];
   STDLOCALS(w);

   /* clear out the bundle */
   memset(&abundle, 0, sizeof(AREABUNDLE));
   abundle.lColor = ws->winbg;
   /* set up the rectangle values */
   pts[0].x = x + wc->dx;
   pts[1].x = (width > 0) ? pts[0].x + width - 1 : ws->width - pts[0].x;
   /* Grab the mutex */
   MutexOn(ws);
   /* knock out the context currently selected */
   ws->areaContext = NULL;
   /* clear area using window background color */
   if (stdwin && !(ws->winState & WS_MIN)) {
     GpiSetAttrs(stdwin, PRIM_AREA, ABB_COLOR, ABB_SYMBOL | ABB_SET, &abundle);
     pts[1].y = ws->height - (y + wc->dy) - 1;
     pts[0].y = (height > 0) ? pts[1].y - height + 1: 0;
     GpiMove(stdwin, &pts[0]);
     GpiBox(stdwin, DRO_FILL, &pts[1], 0, 0);
     } /* End of if - have a window */
   GpiSetAttrs(stdbit, PRIM_AREA, ABB_COLOR, ABB_SYMBOL | ABB_SET, &abundle);
   pts[1].y = ws->bitHeight - (y + wc->dy) - 1;
   /* if the height is 0.. clear to the bottom of the window */
   pts[0].y = (height > 0) ? pts[1].y - height + 1 : 0;
   GpiMove(stdbit, &pts[0]);
   GpiBox(stdbit, DRO_FILL, &pts[1], 0, 0);
   /* release it .. */
   MutexOff(ws);
#endif					/* PresentationManager */
   }

/*
 * erase an area
 */
eraseArea(w,x,y,width,height)
wbp w;
int x, y, width, height;
   {
#ifndef PresentationManager
   STDLOCALS(w);

   XSetForeground(stddpy, stdgc, wc->bg->c);
   RENDER4(XFillRectangle, x, y, width ? width : ws->pixwidth - x,
	   height ? height : ws->pixheight - y);
   XSetForeground(stddpy, stdgc, wc->fg->c ^ (ISXORREVERSE(w)?wc->bg->c:0));

   /*
    * if the entire window is cleared, free up colors
    * note that pixheight>=height and pixwidth>=width avoids resize problems
    */
   if (!x && !y &&
      ((width  >= ws->pixwidth)  || !width) &&
      ((height >= ws->pixheight) || !height)) free_colors(w);
#else					/* PresentationManager */
   AREABUNDLE abundle;
   POINTL pts[2];
   STDLOCALS(w);

   /* clear out the bundle */
   memset(&abundle, 0, sizeof(AREABUNDLE));
   abundle.lColor = wc->areaBundle.lBackColor;
   /* set up the rectangle values */
   pts[0].x = x + wc->dx;
   pts[1].x = (width > 0) ? pts[0].x + width - 1 : ws->width - pts[0].x;
   /* Grab the mutex */
   MutexOn(ws);
   /* knock out the context currently selected */
   ws->areaContext = NULL;
   /* clear area using window background color */
   if (stdwin && !(ws->winState & WS_MIN)) {
     GpiSetAttrs(stdwin, PRIM_AREA, ABB_COLOR, ABB_SYMBOL | ABB_SET, &abundle);
     pts[1].y = ws->height - (y + wc->dy) - 1;
     pts[0].y = (height > 0) ? pts[1].y - height + 1: 0;
     GpiMove(stdwin, &pts[0]);
     GpiBox(stdwin, DRO_FILL, &pts[1], 0, 0);
     } /* End of if - have a window */
   GpiSetAttrs(stdbit, PRIM_AREA, ABB_COLOR, ABB_SYMBOL | ABB_SET, &abundle);
   pts[1].y = ws->bitHeight - (y + wc->dy) - 1;
   /* if the height is 0.. clear to the bottom of the window */
   pts[0].y = (height > 0) ? pts[1].y - height + 1 : 0;
   GpiMove(stdbit, &pts[0]);
   GpiBox(stdbit, DRO_FILL, &pts[1], 0, 0);
   /* release it .. */
   MutexOff(ws);
#endif					/* PresentationManager */
   }

/*
 * copy an area
 */
copyArea(w,w2,x,y,width,height,x2,y2)
wbp w, w2;
int x, y, width, height, x2, y2;
   {
#ifndef PresentationManager
   Pixmap src;
   STDLOCALS(w2);

   src = w->window->pix;
   if (stdwin)
      XCopyArea(stddpy, src, stdwin, stdgc, x, y, width, height, x2, y2);
   XCopyArea(stddpy, src, stdpix, stdgc, x, y, width, height, x2, y2);
#else					/* PresentationManager */
   POINTL pts[3];
   wstate *src_ws = w->window;
   HPS src_hps = src_ws->hpsBitmap;
   STDLOCALS(w2);

   /* grab both mutexes */
   MutexOn(ws);
   MutexOn(src_ws);
   /* fix up the points.. */
   pts[0].x = x2;                                /* lower left - target */
   pts[1].y = pts[0].y = ws->bitHeight - y2;
   pts[0].y -= height;
   pts[1].x = x2 + width;                        /* upper right - target */
   pts[2].x = x;                                 /* lower left - src */
   pts[2].y = src_ws->bitHeight - y - height;
   /* blit from src bitmap to destination bitmap */
   GpiBitBlt(stdbit, src_hps, 3, pts, wc->drawop, 0UL);
   /* if window is around, blit to it too */
   if (stdwin && !(ws->winState & WS_MIN)) {
     /* fixup the points */
     pts[1].y = pts[0].y = ws->height - y2;
     pts[0].y -= height;
     GpiBitBlt(stdwin, src_hps, 3, pts, wc->drawop, 0UL);
     } /* End of if - window is there */
   /* release the mutexes */
   MutexOff(ws);
   MutexOff(src_ws);
#endif					/* PresentationManager */
   }


#ifndef PresentationManager
wbp sprite;
int tics;
int lastx,lasty;
int animwidth, animheight;

void animHelper(w,p,n)
wbp w;
XPoint p[];
int n;
   {
   int i=0;
   STDLOCALS(w);

   for ( ; i < n; i++) {
      int j;

      /*
       * redraw that portion of the previous image that isn't overlapped
       * by the new image being drawn
       */
      if (lastx >= 0) {
	 int dx = p[i].x - lastx, dy = p[i].y - lasty;
         if (dx > 0) XCopyArea(stddpy,stdpix,stdwin,stdgc, lastx, lasty,
			       dx, animheight, lastx, lasty);
	 else if (dx < 0)
	    XCopyArea(stddpy,stdpix,stdwin,stdgc, lastx+animwidth+dx, lasty,
		      -dx, animheight, lastx+animwidth+dx, lasty);

         if (dy > 0) XCopyArea(stddpy, stdpix, stdwin, stdgc, lastx, lasty,
			       animwidth, dy, lastx, lasty);
	 else if (dy < 0)
	    XCopyArea(stddpy,stdpix,stdwin,stdgc, lastx, lasty+animheight+dy,
		      animwidth, -dy, lastx, lasty+animheight+dy);
         }

      XCopyArea(stddpy, sprite->window->pix, stdwin, stdgc,
		0, 0, animwidth, animheight, p[i].x, p[i].y);
      XFlush(stddpy);
      for (j = 0; j < tics; j++);
/*     
 * erase the whole box approach:
      XCopyArea(stddpy, stdpix, stdwin, stdgc,
		0, 0, animwidth, animheight, p[i].x, p[i].y);
*/
      lastx = p[i].x;
      lasty = p[i].y;
      }
   }

animate(w, pixs, npix, xa, ya, n, delay)
wbp w;
dptr pixs;
int npix, xa[], ya[], n, delay;
   {
   wbp w2 = (wbp)(BlkLoc(*pixs)->file.fd);
   STDLOCALS(w);

   sprite = w2;
   animheight = sprite->window->height;
   animwidth  = sprite->window->width;
   tics = delay;
   lastx = lasty = -1;
   genCurve(w, xa, ya, n, animHelper);
   XCopyArea(stddpy, stdpix, stdwin, stdgc, lastx, lasty,
	     animwidth, animheight, lastx, lasty);
   }

void curveHelper(w,thepoints,n)
wbp w;
XPoint thepoints[];
int n;
   {
   STDLOCALS(w);
   RENDER3(XDrawPoints, thepoints, n, CoordModeOrigin);
   }

/*
 * draw a smooth curve through the array of points
 */
drawCurve(w, xa, ya, n)
wbp w;
int xa[], ya[], n;
   {
   genCurve(w, xa, ya, n, curveHelper);
   }

genCurve(w, xa, ya, n, helper)
wbp w;
int xa[], ya[], n;
void (*helper)();
   {
   int    i, j, steps;
#if VMS
   int    tmp1, tmp2;
#endif						/* VMS */
   float  ax, ay, bx, by;
   float  x, dx, d2x, d3x, y, dy, d2y, d3y;
   XPoint thepoints[MAXXOBJS*5];

   for (i = 3; i < n; i++) {
      /*
       * build the coefficients ax, ay, bx and by, using:
       *                             _              _   _    _
       *   i                 i    1 | -1   3  -3   1 | | Pi-3 |
       *  Q (t) = T * M   * G   = - |  2  -5   4  -1 | | Pi-2 |
       *               CR    Bs   2 | -1   0   1   0 | | Pi-1 |
       *                            |_ 0   2   0   0_| |_Pi  _|
       */

      ax = xa[i] - 3 * xa[i-1] + 3 * xa[i-2] - xa[i-3];
      ay = ya[i] - 3 * ya[i-1] + 3 * ya[i-2] - ya[i-3];
      bx = 2 * xa[i-3] - 5 * xa[i-2] + 4 * xa[i-1] - xa[i];
      by = 2 * ya[i-3] - 5 * ya[i-2] + 4 * ya[i-1] - ya[i];

      /*
       * calculate the forward differences for the function using
       * intervals of size 0.1
       */
#define STEPS steps
#ifndef abs
#define abs(x) ((x)<0?-(x):(x))
#endif
#ifndef max
#define max(x,y) ((x>y)?x:y)
#endif
#if 1
#if VMS
      tmp1 = abs(xa[i-1] - xa[i-2]);
      tmp2 = abs(ya[i-1] - ya[i-2]);
      steps = max(tmp1, tmp2) + 10;
#else						/* VMS */
      steps = max(abs(xa[i-1] - xa[i-2]), abs(ya[i-1] - ya[i-2])) + 10;
#endif						/* VMS */
#else
      steps = abs(xa[i-1] - xa[i-2]) + abs(ya[i-1] - ya[i-2]);
#endif
#define SSIZE (1.0/STEPS)
#define SSIZE2 (SSIZE*SSIZE)
#define SSIZE3 (SSIZE*SSIZE2)

      x = thepoints[0].x = xa[i-2];
      y = thepoints[0].y = ya[i-2];
      dx = (SSIZE3*0.5)*ax + (SSIZE2*0.5)*bx + (SSIZE*0.5)*(xa[i-1] - xa[i-3]);
      dy = (SSIZE3*0.5)*ay + (SSIZE2*0.5)*by + (SSIZE*0.5)*(ya[i-1] - ya[i-3]);
      d2x = (SSIZE3*3) * ax + SSIZE2 * bx;
      d2y = (SSIZE3*3) * ay + SSIZE2 * by;
      d3x = (SSIZE3*3) * ax;
      d3y = (SSIZE3*3) * ay;

      /* calculate the points for drawing the curve */

      for (j = 0; j < STEPS; j++) {
	 x = x + dx;
	 y = y + dy;
	 dx = dx + d2x;
	 dy = dy + d2y;
	 d2x = d2x + d3x;
	 d2y = d2y + d3y;
         thepoints[j+1].x = (int)x;
         thepoints[j+1].y = (int)y;
         }
      helper(w,thepoints,STEPS+1);
      }
   }
#endif					/* PresentationManager */
#else					/* XIcon */
static char junk;		/* avoid empty module */
#endif					/* XIcon */
