; ramtest -- a memory test program
; Copyright (C) 1999  Stefan Ziegenbalg
; 
; This program is free software; you can redistribute it and/or  
; modify it under the terms of the GNU General Public License as 
; published by the Free Software Foundation; either version 2 of 
; the License, or (at your option) any later version.
;  
; This software is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;  
; You should have received a copy of the GNU General Public
; License along with this program; if not, write to the 
; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
; Boston, MA  02111-1307, USA.


; undefined jump behaviour in masm:  c...d in labels
;
; routines from numstr.inc are required
;

;********************************************************************
;************************************ gdt..., promode..., realmode...
;********************************************************************

proflag  db 0
proflag2 db 0
segreg   dd -1
gdt_addr dw 8
         dd 0
         dw 0
old_gdt db 8 dup(0)

set_gdt macro n,gdt
        push eax
         mov ax,n
         shl ax,3
         mov cs:[gdt_addr],ax
         mov ax,ds
         shl eax,4
         add eax,offset gdt
         mov dword ptr cs:[gdt_addr+2],eax
        pop eax
         endm

init_promode macro segs:vararg
local clear
        push eax
        push ecx
        push ebx
         ints off
         a20 on
         mov cs:[segreg],-1
         mov bx,8
for seg,<segs>
 if ('&seg' eq 'ds')
         mov byte ptr cs:[segreg],bl
  endif
 if ('&seg' eq 'es')
         mov byte ptr cs:[segreg+1],bl
  endif
 if ('&seg' eq 'fs')
         mov byte ptr cs:[segreg+2],bl
  endif
 if ('&seg' eq 'gs')
         mov byte ptr cs:[segreg+3],bl
  endif
         add bx,8
 endm
         sgdt fword ptr cs:[old_gdt]
         lgdt fword ptr cs:[gdt_addr]
         mov eax,cr0
         mov ecx,eax
         or eax,1
         mov cr0,eax
         jmp short clear
clear:   mov bx,8
for seg,<segs>
         mov seg,bx
         add bx,8
 endm
         mov cr0,ecx
         mov cs:[proflag],1
         mov cs:[proflag2],1
         ints on
        pop ebx
        pop ecx
        pop eax
         endm

done_promode macro
         ints off
         lgdt fword ptr cs:[old_gdt]
         mov cs:[proflag],0
         mov cs:[proflag2],0
         ints on
        push ds
        pop ds
        push es
        pop es
        push fs
        pop fs
        push gs
        pop gs
         endm

switch_promode macro
local end,j2,j3,j4,j5,clear
         cmp cs:[proflag],0
         jnz end
         cmp cs:[segreg],-1
         jz end
         cmp cs:[proflag2],0
         jz end
;         a20 on
        push eax
        push ecx
        push ebx
        push edx
         mov edx,cs:[segreg]
         sgdt fword ptr cs:[old_gdt]
         lgdt fword ptr cs:[gdt_addr]
         mov eax,cr0
         mov ecx,eax
         or eax,1
         mov cr0,eax
         jmp short clear
clear:   xor bx,bx

         mov bl,dl
         shr edx,8
         cmp bl,255
         jz j2
         mov ds,bx
j2:      mov bl,dl
         shr edx,8
         cmp bl,255
         jz j3
         mov es,bx
j3:      mov bl,dl
         shr edx,8
         cmp bl,255
         jz j4
         mov fs,bx
j4:      mov bl,dl
         cmp bl,255
         jz j5
         mov gs,bx
j5:
         mov cr0,ecx
         mov byte ptr cs:[proflag],1
        pop edx
        pop ebx
        pop ecx
        pop eax

end:
         endm

switch_realmode macro
local end
         cmp cs:[proflag],0
         jz end
         lgdt fword ptr cs:[old_gdt]
         mov cs:[proflag],0
end:
         endm

;********************************************************************
;********************************************* interrupt redirect ...
;********************************************************************

inttab:
forc ch1,<0123456789abcdef>
 forc ch2,<0123456789abcdef>
         dw int&ch1&&ch2
         dw 0
  endm
 endm

;wchar macro x,at,ch                    ; for debugging
;        push es
;        push ax
;        push bx
;         mov bl,x
;         mov bh,0
;         shl bx,1
;;         mov ah,160
;;         mov al,y
;;         mul ah
;;         add bx,ax
;         mov ax,0b800h
;         mov es,ax
;         mov al,at
;         mov byte ptr es:[bx+1],al
;         mov al,ch
;         mov byte ptr es:[bx],al
;        pop bx
;        pop ax
;        pop es
;         endm

flags    dw 0

forc ch1,<0123456789abcdef>
 forc ch2,<0123456789abcdef>
int&ch1&&ch2:
         call intp1
         int 0&ch1&&ch2&h
         jmp intp2
  endm
 endm

intp1:   ints off
         call swapvectors
         switch_realmode
         ints on
         ret

intp2:  pushf
        pushf
        pop cs:[flags]
         ints off
         call swapvectors
         switch_promode
         ints on
        popf
         iret

intf macro n
         int n
         push cs:[flags]
         popf
         endm

swapvectors proc
        push eax
        push ebx
        push cx
        push es
        push si
        push di
         mov cx,256
         xor eax,eax
         mov es,eax
         mov si,0
         mov di,offset inttab
lc1:     mov ebx,es:[si]
         mov eax,cs:[di]
         mov cs:[di],ebx
         mov es:[si],eax
         add si,4
         add di,4
         loop lc1
        pop di
        pop si
        pop es
        pop cx
        pop ebx
        pop eax
         ret
swapvectors endp


init_intredirect proc
        push cx
        push si
         mov cx,256
         mov si,offset inttab+2
ld1:     mov cs:[si],cs
         add si,4
         loop ld1
        pop si
        pop cx
         ints off
         call swapvectors
         ints on
         ret
init_intredirect endp


done_intredirect proc
         ints off
         call swapvectors
         ints on
         ret
done_intredirect endp
