/* **************************************************************
 * dltest1.c: A dynamic linking example (1). Rather trivial, since
 *            it just re-implements strtod, but it does illustrate
 *            a few points, such as how to get arguments, in
 *            particular how to deal with string arguments.
 * ************************************************************** */

#include "rlab.h"
#include "symbol.h"
#include "mem.h"
#include "list.h"
#include "btree.h"
#include "bltin.h"
#include "scop1.h"
#include "matop1.h"
#include "matop2.h"
#include "r_string.h"
#include "util.h"
#include "mathl.h"
#include "function.h"

#include <math.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

void
RStrtod (return_ptr, n_args, d_arg)
     VPTR *return_ptr;
     int n_args;
     Datum *d_arg;
{
  int i, nel;
  ListNode *SM;
  Matrix *m, *new = 0;

  /* Check n_args */
  if (n_args != 1)
    error_1 ("strtod: requires 1 argument", 0);

  SM = bltin_get_string_matrix ("strtod", d_arg, 1);
  m = (Matrix *) e_data (SM);

  switch (MTYPE (m))
  {
  case REAL:
  case COMPLEX:
    error_1 ("strtod: input must be string", matrix_GetName (m));
    break;
  case STRING:
    new = matrix_Create (MNR (m), MNC (m));
    nel = MNR (m) * MNC (m);
    for (i = 0; i < nel; i++)
      MATrv (new, i) = strtod (MATsv (m, i), (char **) 0);
    break;
  default:
    error_1 ("strtod: invalid matrix type", 0);
    break;
  }

  remove_tmp_destroy (SM);
  *return_ptr = (VPTR) new;
  return;
}
