/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWGVBAR.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       Vertical border bar function for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include "pwinc.h"                          /* Main include file */

/* [DOC] Function *********************************************
** Name:        pw_vbar                                   [API]
** SYNOPSIS:    void pw_vbar(win, col);
**              PWWIN *win          Pointer to window handle
**              int   col           Column to place bar
** Descr:       Draws a vertical bar in window.
**              The 'pw_vbar' function displays a vertical
**                double line, at column 'col', in the border
**                attribute of window 'win'.
**              It provides 'T-fork' characters at the left
**                and right border lines.
** RETURNS:     void
** SEE ALSO:    pw_vbar
**************************************************************/
void pw_vbar(PWWIN *win, int col)
{
    int row = -1;
    int i = win->nrow;
    PWCELL cell = (pwv_attrib(win->wtype, PWT_ACTIVEBORDER) << 8);

    if ((win->status & PWM_NOBORDER) == 0)
        pw_putcat(win, row++, col, _pwcf_border[PWCF_TT]);
    for (; i; i--)
    {
        if ((pw_getcellat(win, row, col) & 0xff) == _pwcf_border[PWCF_H])
             pw_putcellat(win, row, col, cell + _pwcf_border[PWCF_X]);
        else
             pw_putcellat(win, row, col, cell + _pwcf_border[PWCF_V]);
        row++;
    }
    if ((win->status & PWM_NOBORDER) == 0)
        pw_putcat(win, row, col, _pwcf_border[PWCF_BT]);
}


