/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWGHEAD.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       Header function for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include <string.h>
#include "pwinc.h"                          /* Main include file */

/* [DOC] Function *********************************************
** Name:        pw_header                                 [API]
** SYNOPSIS:    void pw_header(header)
**              char *header        ptr to Header string
** Descr:       Places a centered header on background window.
**              The 'pw_header' function reverses the top line
**                of the background window, and prints the
**                character string 'header' in the center.
** RETURNS:     void
**************************************************************/
void pw_header(char *header)
{
    int i;
    int len = strlen(header);
    char tmp = '\0';
    PWWIN *pWin = pw_win(PWID_BACKGROUND);

    if (len>_pwv_scrncol)
    {
        len = _pwv_scrncol;
        tmp = header[len];
        header[len] = '\0';
    }
    pw_block(pWin, -1, -1, 1, _pwv_scrncol, PWT_REVERSE);
    for (i=0; i<(_pwv_scrncol-len)/2; i++)
        pw_putcat(pWin, -1, i-1, ' ');
    pw_putsat(pWin, -1, i-1, header);
    i += len;
    for (; i<_pwv_scrncol; i++)
        pw_putcat(pWin, -1, i-1, ' ');
    if (tmp != '\0')
        header[len] = tmp;
}

