 /************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       pktstat.c
**     SYSTEM   NAME:       PKT
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v2.00
**     CREATION DATE:       1990/4/12
**
** DESCRIPTION: Packet status function
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   PKTSTAT.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/PKT/VCS/PKTSTAT.C_V  $
**              
**                 Rev 1.0   25 Oct 1990 14:34:30   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/C600/BEHOLDER/NPD/PKT/VCS/PKTSTAT.C_V   1.0   25 Oct 1990 14:34:30   etstjan  $";
#endif
#include <error.h>
#include "pktinc.h"                         /* main include file */


/*************************************************************************
** NAME:        PktGetStatistics                        [API]
** SYNOPSIS:    int PktGetStatistics(PktInt, ppStat)
**              int PktInt          Int number [0x60-0x80]
**              PKTSTAT **ppStat    Ptr to STAT struct ptr
** DESCRIPTION: Gets pointer to device driver's stat structure.
**              Returns the address of Stat structure of
**                device <PktInt> in <ppStat>.
** RETURNS:     PKT_OK = 0      Successfull call
**              PKT_BAD_HANDLE  Invalid handle number
*************************************************************************/
int PktGetStatistics(int PktInt, PKTSTAT **ppStat)
{
    ERR_DEB( ERR_NPD, 5, "PktGetStatistics");
    return PdsGetStatistics(PktInt, PktGetHandle(PktInt), ppStat);
}


/*************************************************************************
** NAME:        PktResetStatistics                      [API]
** SYNOPSIS:    int PktResetStatistics(PktInt)
**              int PktInt      Int number [0x60-0x80]
** DESCRIPTION: Resets the stat structure of device driver.
** RETURNS:     PKT_OK = 0      Successfull call
**              PKT_BAD_HANDLE  Invalid handle number
*************************************************************************/
int PktResetStatistics(int PktInt)
{
    ERR_DEB( ERR_NPD, 5, "PktResetStatistics");
    return PdsResetStatistics(PktInt,PktGetHandle(PktInt));
}


