/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       profile.c
**     SYSTEM   NAME:       BEHOLDER
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1
**     CREATION DATE:       1991/1/14
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   PROFIL.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/PROFIL/VCS/PROFIL.C_V  $
**              
**                 Rev 1.0   31 Jan 1991 16:47:18   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/PROFIL/VCS/PROFIL.C_V   1.0   31 Jan 1991 16:47:18   etstjan  $";
#endif

#define IPS_DOS 

#include <stdio.h>
#include <beholder.h>
#include <snmp.h>
#include <mib2.h>
#include <ml.h>
#include <dp.h>

#define CONTROLOJIFIL AgtSck.SckOjiLen + 4
#define CONTROLOJIAPS AgtSck.SckOjiLen + 4
#define CONTROLOJIEVT AgtSck.SckOjiLen + 5

#define LOADOJIDEV    AgtSck.SckOjiLen + 4
#define LOADOJIIND    AgtSck.SckOjiLen + 5
#define LOADOJILEN    AgtSck.SckOjiLen + 6 

typedef struct _LOADSIZE
{
    unsigned long       Packets;
    unsigned long       Bytes;
    unsigned long       Time;
    unsigned long       Last;
}   LOADSIZE;
typedef struct _LOADTYPE
{
    unsigned int        Type;
    unsigned long       Packets;
    unsigned long       Bytes;
    unsigned long       Time;
    unsigned long       Last;
    struct _LOADTYPE    *Next;
}   LOADTYPE;

extern DPSTAT           *LoadStat [DPMAXDEV];
extern unsigned long    LoadTime [DPMAXDEV];
extern LOADSIZE         LoadSize [DPMAXDEV][21];
extern LOADTYPE         *LoadType [DPMAXDEV];


static int          ProcessEvent (DPEVENT Event);
static void         Reset (void);
static void         Start (void);
static unsigned GetSystemDescription (pkt_obj *Obj, void *Arg);
static unsigned GetSystemBirthDay (pkt_obj *Obj, void *Arg);
static unsigned GetSystemTime (pkt_obj *Obj, void *Arg);
static unsigned GetSystemNrDevices (pkt_obj *Obj, void *Arg);
static unsigned GetSystemNrApplics (pkt_obj *Obj, void *Arg);
static unsigned SetSystemQuit (pkt_obj *Obj, void *Arg);
static unsigned GetDeviceIndex (pkt_obj *Obj, void *Arg);
static unsigned GetDeviceTime (pkt_obj *Obj, void *Arg);
static unsigned GetDeviceDescription (pkt_obj *Obj, void *Arg);
static unsigned GetDeviceClass (pkt_obj *Obj, void *Arg);
static unsigned GetDeviceType (pkt_obj *Obj, void *Arg);
static unsigned GetDevicePackets (pkt_obj *Obj, void *Arg);
static unsigned GetDeviceBytes (pkt_obj *Obj, void *Arg);
static unsigned GetDeviceTimeLast (pkt_obj *Obj, void *Arg);
static unsigned GetSizeIndexDevice (pkt_obj *Obj, void *Arg);
static unsigned GetNextSizeIndexDevice (pkt_obj *Obj, void *Arg);
static unsigned GetSizeIndexSize (pkt_obj *Obj, void *Arg);
static unsigned GetNextSizeIndexSize (pkt_obj *Obj, void *Arg);
static unsigned GetSizeTime (pkt_obj *Obj, void *Arg);
static unsigned GetNextSizeTime (pkt_obj *Obj, void *Arg);
static unsigned GetSizePackets (pkt_obj *Obj, void *Arg);
static unsigned GetNextSizePackets (pkt_obj *Obj, void *Arg);
static unsigned GetSizeBytes (pkt_obj *Obj, void *Arg);
static unsigned GetNextSizeBytes (pkt_obj *Obj, void *Arg);
static unsigned GetSizeTimeLast (pkt_obj *Obj, void *Arg);
static unsigned GetNextSizeTimeLast (pkt_obj *Obj, void *Arg);
static unsigned GetTypeIndexDevice (pkt_obj *Obj, void *Arg);
static unsigned GetNextTypeIndexDevice (pkt_obj *Obj, void *Arg);
static unsigned GetTypeIndexType (pkt_obj *Obj, void *Arg);
static unsigned GetNextTypeIndexType (pkt_obj *Obj, void *Arg);
static unsigned GetTypeTime (pkt_obj *Obj, void *Arg);
static unsigned GetNextTypeTime (pkt_obj *Obj, void *Arg);
static unsigned GetTypePackets (pkt_obj *Obj, void *Arg);
static unsigned GetNextTypePackets (pkt_obj *Obj, void *Arg);
static unsigned GetTypeBytes (pkt_obj *Obj, void *Arg);
static unsigned GetNextTypeBytes (pkt_obj *Obj, void *Arg);
static unsigned GetTypeTimeLast (pkt_obj *Obj, void *Arg);
static unsigned GetNextTypeTimeLast (pkt_obj *Obj, void *Arg);
static unsigned GetApplicIndex (pkt_obj *Obj, void *Arg);
static unsigned GetApplicDescription (pkt_obj *Obj, void *Arg);
static unsigned GetApplicStatus (pkt_obj *Obj, void *Arg);
static unsigned SetApplicEvent (pkt_obj *Obj, void *Arg);
static unsigned GetApplicIndexApplic (pkt_obj *Obj, void *Arg);
static unsigned GetApplicIndexEvent (pkt_obj *Obj, void *Arg);
static unsigned GetApplicProfile (pkt_obj *Obj, void *Arg);
static unsigned GetFilterIndex (pkt_obj *Obj, void *Arg);
static unsigned GetFilterDescription (pkt_obj *Obj, void *Arg);
static unsigned GetFilterStatus (pkt_obj *Obj, void *Arg);
static unsigned SetFilterEvent (pkt_obj *Obj, void *Arg);

static int              ControlInit = 0;


DPAPPS DpaControl = {
    "Control",
    ProcessEvent,
    0,                                     
    DPE_START | DPE_RESET,
    DPE_START,
    0,
    -1,
    0,
    0,
    0,
    0,                                      /* Count of active filters      */
    {0}                                     /* List of active Filters       */
};


static int ProcessEvent (DPEVENT Event)
{
    switch (Event)
    {
        case DPE_RESET:         Reset ();       break;
        case DPE_START:         Start ();       break;
    }
    return 0;
}

static void Reset (void)
{
    unsigned EventNr, AppsNr;

    for (AppsNr = 0; DpAppsActive [AppsNr] != NULL; AppsNr++)
    {
        for (EventNr = 0; EventNr < 11; EventNr++)
        {
            DpAppsActive [AppsNr] -> Profile [EventNr] = 0;
        }
    }
}

static void Start (void)
{
    mib_prf         *Prf;
    int             Oji [63];
    int             Len, Aps, Dev, Evt, Fil;
    unsigned long   *Pro;

    if (ControlInit == 0)
    {
        memcpy (Oji, AgtSck.SckOji, AgtSck.SckOjiLen * sizeof(int));
        Len = AgtSck.SckOjiLen;
        if ((Prf = MibAddPrf ("public", 6)) == NULL)
            return;
        Oji[Len+0]=1;
        Oji[Len+1]=1;
        Oji[Len+2]=0;
        if ((MibAddObj (Prf, Oji, Len+3, GetSystemDescription, NULL, NULL, NULL)) < 0)
            return;
        Oji[Len+1]++;
        if ((MibAddObj (Prf, Oji, Len+3, GetSystemBirthDay, NULL, NULL, NULL)) < 0)
            return;
        Oji[Len+1]++;
        if ((MibAddObj (Prf, Oji, Len+3, GetSystemTime, NULL, NULL, NULL)) < 0)
            return;
        Oji[Len+1]++;
        if ((MibAddObj (Prf, Oji, Len+3, GetSystemNrDevices, NULL, NULL, NULL)) < 0)
            return;
        Oji[Len+1]++;
        if ((MibAddObj (Prf, Oji, Len+3, GetSystemNrApplics, NULL, NULL, NULL)) < 0)
            return;
        Oji[Len+1]++;
        if ((MibAddObj (Prf, Oji, Len+3, NULL, NULL, SetSystemQuit, NULL)) < 0)
            return;
        Oji[Len+0]=2;
        Oji[Len+2]=1;
        for (Dev=0;Dev<DpDevGetCount();Dev++)
        {
            Oji[Len+1]=1;
            Oji[Len+3]=1;
            Oji[Len+4]=Dev;
            if ((MibAddObj (Prf, Oji, Len+5, GetDeviceIndex, NULL, NULL, NULL)) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetDeviceTime, NULL, NULL, NULL)) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetDeviceDescription, NULL, NULL, DpDevGetName(Dev))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetDeviceClass, NULL, NULL, (void *)DpDevGetClass(Dev))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetDeviceType, NULL, NULL, (void *)DpDevGetType(Dev))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetDevicePackets, NULL, NULL, &(LoadStat[Dev]))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetDeviceBytes, NULL, NULL, &(LoadStat[Dev]))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetDeviceTimeLast, NULL, NULL, &(LoadTime[Dev]))) < 0)
                return;
            Oji[Len+1]=2;
            Oji[Len+3]=1;
            if ((MibAddObj (Prf, Oji, Len+5, GetSizeIndexDevice, GetNextSizeIndexDevice, NULL, NULL)) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetSizeIndexSize, GetNextSizeIndexSize, NULL, NULL)) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetSizeTime, GetNextSizeTime, NULL, NULL)) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetSizePackets, GetNextSizePackets, NULL, &(LoadSize[Dev]))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetSizeBytes, GetNextSizeBytes, NULL, &(LoadSize[Dev]))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetSizeTimeLast, GetNextSizeTimeLast, NULL, &(LoadSize[Dev]))) < 0)
                return;
            Oji[Len+1]=3;
            Oji[Len+3]=1;
            if ((MibAddObj (Prf, Oji, Len+5, GetTypeIndexDevice, GetNextTypeIndexDevice, NULL, NULL)) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetTypeIndexType, GetNextTypeIndexType, NULL, NULL)) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetTypeTime, GetNextTypeTime, NULL, NULL)) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetTypePackets, GetNextTypePackets, NULL, &(LoadType[Dev]))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetTypeBytes, GetNextTypeBytes, NULL, &(LoadType[Dev]))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetTypeTimeLast, GetNextTypeTimeLast, NULL, &(LoadType[Dev]))) < 0)
                return;
        }
        Oji[Len+0]=3;
        Oji[Len+2]=1;
        for (Aps=0;Aps<DpAppsGetCount();Aps++)
        {
            Oji[Len+1]=1;
            Oji[Len+3]=1;
            Oji[Len+4]=Aps;
            if ((MibAddObj (Prf, Oji, Len+5, GetApplicIndex, NULL, NULL, NULL)) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetApplicDescription, NULL, NULL, DpAppsGetName(Aps))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetApplicStatus, NULL, NULL, DpAppsGetStatus(Aps))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, NULL, NULL, SetApplicEvent, NULL)) < 0)
                return;
            Oji[Len+1]=2;
            Pro = DpAppsGetProfile (Aps);
            for (Evt=0;Evt<11;Evt++)
            {
                Oji[Len+3]=1;
                Oji[Len+5]=Evt;
                if ((MibAddObj (Prf, Oji, Len+6, GetApplicIndexApplic, NULL, NULL, NULL)) < 0)
                    return;
                Oji[Len+3]++;
                if ((MibAddObj (Prf, Oji, Len+6, GetApplicIndexEvent, NULL, NULL, NULL)) < 0)
                    return;
                Oji[Len+3]++;
                if ((MibAddObj (Prf, Oji, Len+6, GetApplicProfile, NULL, NULL, (void *)&(Pro[Evt]))) < 0)
                    return;
            }
        }
        Oji[Len+0]=4;
        Oji[Len+2]=1;
        for (Fil=0;Fil<DpFiltGetCount();Fil++)
        {
            Oji[Len+1]=1;
            Oji[Len+3]=1;
            Oji[Len+4]=Fil;
            if ((MibAddObj (Prf, Oji, Len+5, GetFilterIndex, NULL, NULL, NULL)) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetFilterDescription, NULL, NULL, DpFiltGetName(Fil))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, GetFilterStatus, NULL, NULL, DpFiltGetStatus(Fil))) < 0)
                return;
            Oji[Len+3]++;
            if ((MibAddObj (Prf, Oji, Len+5, NULL, NULL, SetFilterEvent, NULL)) < 0)
                return;
        }
        ControlInit=1;
    }
}



static unsigned GetSystemDescription (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_OCTETSTRING;
    strcpy (Obj->ObjSyn.SynBufChr, BeholderDescription);
    Obj->ObjSynLen = strlen (BeholderDescription);
    return (PKT_NOERROR);
}

static unsigned GetSystemBirthDay (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_OCTETSTRING;
    strcpy (Obj->ObjSyn.SynBufChr, BeholderDate);
    Obj->ObjSynLen = strlen (BeholderDate);
    return (PKT_NOERROR);
}

static unsigned GetSystemTime (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_TIMETICKS;
    Obj->ObjSyn.SynLngInt = clock_ms () / 10;
    return (PKT_NOERROR);
}

static unsigned GetSystemNrDevices (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = DpDevGetCount ();
    return (PKT_NOERROR);
}


static unsigned GetSystemNrApplics (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = DpAppsGetCount ();
    return (PKT_NOERROR);
}

static unsigned SetSystemQuit (pkt_obj *Obj, void *Arg)
{
    if (Obj->ObjTag != PKT_INTEGER)
        return(PKT_BADVALUE);
    if (Obj->ObjSyn.SynLngInt != 1)
        return(PKT_BADVALUE);
    DpQuit();
    return (PKT_NOERROR);
}

static unsigned GetDeviceIndex (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_INTEGER;
	Obj->ObjSyn.SynLngInt = Obj->ObjOji[LOADOJIDEV];
    return (PKT_NOERROR);
}

static unsigned GetDeviceTime (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_TIMETICKS;
    Obj->ObjSyn.SynLngInt = clock_ms () / 10;
    return (PKT_NOERROR);
}

static unsigned GetDeviceDescription (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_OCTETSTRING;
    strcpy (Obj->ObjSyn.SynBufChr, (char *)Arg);
    Obj->ObjSynLen = strlen ((char *)Arg);
    return (PKT_NOERROR);
}

static unsigned GetDeviceClass (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = ((unsigned)Arg);
    return (PKT_NOERROR);
}

static unsigned GetDeviceType (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = ((unsigned)Arg);
    return (PKT_NOERROR);
}

static unsigned GetDevicePackets (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    
    Obj->ObjTag = PKT_COUNTER;
	Obj->ObjSyn.SynLngInt = LoadStat[Dev]->TotalPackets;
    return (PKT_NOERROR);
}

static unsigned GetDeviceBytes (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];

    Obj->ObjTag = PKT_COUNTER;
	Obj->ObjSyn.SynLngInt = LoadStat[Dev]->TotalBytes;  /* Dr.Ik 220391 Packets -> Bytes */
    return (PKT_NOERROR);
}

static unsigned GetDeviceTimeLast (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    
    Obj->ObjTag = PKT_TIMETICKS;
	Obj->ObjSyn.SynLngInt = LoadTime[Dev];
    return (PKT_NOERROR);
}

static unsigned GetSizeIndexDevice (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Ind;
    
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Ind = Obj->ObjOji [LOADOJIIND];
    if (Ind > 20)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = Dev;
    return (PKT_NOERROR);
}

static unsigned GetNextSizeIndexDevice (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Ind;

    if (Obj->ObjOjiLen < LOADOJILEN)
    {
        Obj->ObjOjiLen = LOADOJILEN;
        Obj->ObjOji [LOADOJIIND] = 0;
        Obj->ObjTag = PKT_INTEGER;
        Obj->ObjSyn.SynLngInt = Dev;
        return (PKT_NOERROR);
    }
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Ind = ++(Obj->ObjOji [LOADOJIIND]);
    if (Ind > 20)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = Dev;
    return (PKT_NOERROR);
}



static unsigned GetSizeIndexSize (pkt_obj *Obj, void *Arg)
{
    unsigned Ind;
    
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Ind = Obj->ObjOji [LOADOJIIND];
    if (Ind > 20)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = Ind;
    return (PKT_NOERROR);
}

static unsigned GetNextSizeIndexSize (pkt_obj *Obj, void *Arg)
{
    unsigned Ind;

    if (Obj->ObjOjiLen < LOADOJILEN)
    {
        Obj->ObjOjiLen = LOADOJILEN;
        Obj->ObjOji [LOADOJIIND] = 0;
        Obj->ObjTag = PKT_INTEGER;
        Obj->ObjSyn.SynLngInt = 0;
        return (PKT_NOERROR);
    }
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Ind = ++(Obj->ObjOji [LOADOJIIND]);
    if (Ind > 20)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = Ind;
    return (PKT_NOERROR);
}

static unsigned GetSizeTime (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Ind;
    
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Ind = Obj->ObjOji [LOADOJIIND];
    if (Ind > 20)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_TIMETICKS;
    Obj->ObjSyn.SynLngInt = clock_ms()/10;
    return (PKT_NOERROR);
}

static unsigned GetNextSizeTime (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Ind;

    if (Obj->ObjOjiLen < LOADOJILEN)
    {
        Obj->ObjOjiLen = LOADOJILEN;
        Obj->ObjOji [LOADOJIIND] = 0;
        Obj->ObjTag = PKT_TIMETICKS;
        Obj->ObjSyn.SynLngInt = clock_ms () /10;
        return (PKT_NOERROR);
    }
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Obj->ObjOji [LOADOJIIND] ++;
    Ind = Obj->ObjOji [LOADOJIIND];
    if (Ind > 20)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_TIMETICKS;
    Obj->ObjSyn.SynLngInt = clock_ms () /10;
    return (PKT_NOERROR);
}


static unsigned GetSizePackets (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Ind;
    
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Ind = Obj->ObjOji [LOADOJIIND];
    if (Ind > 20)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_COUNTER;
    Obj->ObjSyn.SynLngInt = LoadSize[Dev][Ind].Packets;
    return (PKT_NOERROR);
}

static unsigned GetNextSizePackets (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Ind;

    if (Obj->ObjOjiLen < LOADOJILEN)
    {
        Obj->ObjOjiLen = LOADOJILEN;
        Obj->ObjOji [LOADOJIIND] = 0;
        Obj->ObjTag = PKT_COUNTER;
        Obj->ObjSyn.SynLngInt = LoadSize[Dev][0].Packets;
        return (PKT_NOERROR);
    }
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Ind = ++(Obj->ObjOji [LOADOJIIND]);
    if (Ind > 20)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_COUNTER;
    Obj->ObjSyn.SynLngInt = LoadSize[Dev][Ind].Packets;
    return (PKT_NOERROR);
}

static unsigned GetSizeBytes (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Ind;
    
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Ind = Obj->ObjOji [LOADOJIIND];
    if (Ind > 20)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_COUNTER;
    Obj->ObjSyn.SynLngInt = LoadSize[Dev][Ind].Bytes;
    return (PKT_NOERROR);
}

static unsigned GetNextSizeBytes (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Ind;

    if (Obj->ObjOjiLen < LOADOJILEN)
    {
        Obj->ObjOjiLen = LOADOJILEN;
        Obj->ObjOji [LOADOJIIND] = 0;
        Obj->ObjTag = PKT_COUNTER;
        Obj->ObjSyn.SynLngInt = LoadSize[Dev][0].Bytes;
        return (PKT_NOERROR);
    }
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Obj->ObjOji [LOADOJIIND] ++;
    Ind = Obj->ObjOji [LOADOJIIND];
    if (Ind > 20)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_COUNTER;
    Obj->ObjSyn.SynLngInt = LoadSize[Dev][Ind].Bytes;
    return (PKT_NOERROR);
}

static unsigned GetSizeTimeLast (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Ind;
    
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Ind = Obj->ObjOji [LOADOJIIND];
    if (Ind > 20)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_TIMETICKS;
    Obj->ObjSyn.SynLngInt = LoadSize[Dev][Ind].Time;
    return (PKT_NOERROR);
}

static unsigned GetNextSizeTimeLast (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Ind;

    if (Obj->ObjOjiLen < LOADOJILEN)
    {
        Obj->ObjOjiLen = LOADOJILEN;
        Obj->ObjOji [LOADOJIIND] = 0;
        Obj->ObjTag = PKT_TIMETICKS;
        Obj->ObjSyn.SynLngInt = LoadSize[Dev][0].Time;
        return (PKT_NOERROR);
    }
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Obj->ObjOji [LOADOJIIND] ++;
    Ind = Obj->ObjOji [LOADOJIIND];
    if (Ind > 20)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_TIMETICKS;
    Obj->ObjSyn.SynLngInt = LoadSize[Dev][Ind].Time;
    return (PKT_NOERROR);
}

static unsigned GetTypeIndexDevice (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Type;
    LOADTYPE *Ptr;
    
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Type = Obj->ObjOji [LOADOJIIND];
    for (Ptr = LoadType[Dev]; Ptr != NULL && Ptr->Type < Type; Ptr = Ptr->Next);
    if (Ptr == NULL || Ptr->Type != Type)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = Dev;
    return (PKT_NOERROR);
}

static unsigned GetNextTypeIndexDevice (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Type;
    LOADTYPE *Ptr;

    if (LoadType[Dev] == NULL)
        return (PKT_NOSUCHNAME);
    if (Obj->ObjOjiLen < LOADOJILEN)
    {
        Obj->ObjOjiLen = LOADOJILEN;
        Obj->ObjOji [LOADOJIIND] = LoadType[Dev]->Type;
        Obj->ObjTag = PKT_INTEGER;
        Obj->ObjSyn.SynLngInt = Dev;
        return (PKT_NOERROR);
    }
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Type = Obj->ObjOji [LOADOJIIND];
    for (Ptr = LoadType[Dev]; Ptr != NULL && Ptr->Type < Type; Ptr = Ptr->Next);
    if (Ptr == NULL || Ptr->Type != Type)
        return (PKT_NOSUCHNAME);
    if ((Ptr = Ptr->Next) == NULL)
        return (PKT_NOSUCHNAME);
    Obj->ObjOji [LOADOJIIND] = Ptr->Type;
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = Dev;
    return (PKT_NOERROR);
}



static unsigned GetTypeIndexType (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Type;
    LOADTYPE *Ptr;
    
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Type = Obj->ObjOji [LOADOJIIND];
    for (Ptr = LoadType[Dev]; Ptr != NULL && Ptr->Type < Type; Ptr = Ptr->Next);
    if (Ptr == NULL || Ptr->Type != Type)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = Ptr->Type;
    return (PKT_NOERROR);
}

static unsigned GetNextTypeIndexType (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Type;
    LOADTYPE *Ptr;

    if (LoadType[Dev] == NULL)
        return (PKT_NOSUCHNAME);
    if (Obj->ObjOjiLen < LOADOJILEN)
    {
        Obj->ObjOjiLen = LOADOJILEN;
        Obj->ObjOji [LOADOJIIND] = LoadType[Dev]->Type;
        Obj->ObjTag = PKT_INTEGER;
        Obj->ObjSyn.SynLngInt = LoadType[Dev]->Type;
        return (PKT_NOERROR);
    }
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Type = Obj->ObjOji [LOADOJIIND];
    for (Ptr = LoadType[Dev]; Ptr != NULL && Ptr->Type < Type; Ptr = Ptr->Next);
    if (Ptr == NULL || Ptr->Type != Type)
        return (PKT_NOSUCHNAME);
    if ((Ptr = Ptr->Next) == NULL)
        return (PKT_NOSUCHNAME);
    Obj->ObjOji [LOADOJIIND] = Ptr->Type;
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = Ptr->Type;
    return (PKT_NOERROR);
}

static unsigned GetTypeTime (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Type;
    LOADTYPE *Ptr;
    
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Type = Obj->ObjOji [LOADOJIIND];
    for (Ptr = LoadType[Dev]; Ptr != NULL && Ptr->Type < Type; Ptr = Ptr->Next);
    if (Ptr == NULL || Ptr->Type != Type)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_TIMETICKS;
    Obj->ObjSyn.SynLngInt = clock_ms()/10;
    return (PKT_NOERROR);
}

static unsigned GetNextTypeTime (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Type;
    LOADTYPE *Ptr;

    if (LoadType[Dev] == NULL)
        return (PKT_NOSUCHNAME);
    if (Obj->ObjOjiLen < LOADOJILEN)
    {
        Obj->ObjOjiLen = LOADOJILEN;
        Obj->ObjOji [LOADOJIIND] = LoadType[Dev]->Type;
        Obj->ObjTag = PKT_TIMETICKS;
        Obj->ObjSyn.SynLngInt = clock_ms()/10;
        return (PKT_NOERROR);
    }
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Type = Obj->ObjOji [LOADOJIIND];
    for (Ptr = LoadType[Dev]; Ptr != NULL && Ptr->Type < Type; Ptr = Ptr->Next);
    if (Ptr == NULL || Ptr->Type != Type)
        return (PKT_NOSUCHNAME);
    if ((Ptr = Ptr->Next) == NULL)
        return (PKT_NOSUCHNAME);
    Obj->ObjOji [LOADOJIIND] = Ptr->Type;
    Obj->ObjTag = PKT_TIMETICKS;
    Obj->ObjSyn.SynLngInt = clock_ms()/10;
    return (PKT_NOERROR);
}


static unsigned GetTypePackets (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Type;
    LOADTYPE *Ptr;
    
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Type = Obj->ObjOji [LOADOJIIND];
    for (Ptr = LoadType[Dev]; Ptr != NULL && Ptr->Type < Type; Ptr = Ptr->Next);
    if (Ptr == NULL || Ptr->Type != Type)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_COUNTER;
    Obj->ObjSyn.SynLngInt = Ptr->Packets;
    return (PKT_NOERROR);
}

static unsigned GetNextTypePackets (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Type;
    LOADTYPE *Ptr;

    if (LoadType[Dev] == NULL)
        return (PKT_NOSUCHNAME);
    if (Obj->ObjOjiLen < LOADOJILEN)
    {
        Obj->ObjOjiLen = LOADOJILEN;
        Obj->ObjOji [LOADOJIIND] = LoadType[Dev]->Type;
        Obj->ObjTag = PKT_COUNTER;
        Obj->ObjSyn.SynLngInt = LoadType[Dev]->Packets;
        return (PKT_NOERROR);
    }
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Type = Obj->ObjOji [LOADOJIIND];
    for (Ptr = LoadType[Dev]; Ptr != NULL && Ptr->Type < Type; Ptr = Ptr->Next);
    if (Ptr == NULL || Ptr->Type != Type)
        return (PKT_NOSUCHNAME);
    if ((Ptr = Ptr->Next) == NULL)
        return (PKT_NOSUCHNAME);
    Obj->ObjOji [LOADOJIIND] = Ptr->Type;
    Obj->ObjTag = PKT_COUNTER;
    Obj->ObjSyn.SynLngInt = Ptr->Packets;
    return (PKT_NOERROR);
}

static unsigned GetTypeBytes (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Type;
    LOADTYPE *Ptr;
    
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Type = Obj->ObjOji [LOADOJIIND];
    for (Ptr = LoadType[Dev]; Ptr != NULL && Ptr->Type < Type; Ptr = Ptr->Next);
    if (Ptr == NULL || Ptr->Type != Type)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_COUNTER;
    Obj->ObjSyn.SynLngInt = Ptr->Bytes;
    return (PKT_NOERROR);
}

static unsigned GetNextTypeBytes (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Type;
    LOADTYPE *Ptr;

    if (LoadType[Dev] == NULL)
        return (PKT_NOSUCHNAME);
    if (Obj->ObjOjiLen < LOADOJILEN)
    {
        Obj->ObjOjiLen = LOADOJILEN;
        Obj->ObjOji [LOADOJIIND] = LoadType[Dev]->Type;
        Obj->ObjTag = PKT_COUNTER;
        Obj->ObjSyn.SynLngInt = LoadType[Dev]->Bytes;
        return (PKT_NOERROR);
    }
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Type = Obj->ObjOji [LOADOJIIND];
    for (Ptr = LoadType[Dev]; Ptr != NULL && Ptr->Type < Type; Ptr = Ptr->Next);
    if (Ptr == NULL || Ptr->Type != Type)
        return (PKT_NOSUCHNAME);
    if ((Ptr = Ptr->Next) == NULL)
        return (PKT_NOSUCHNAME);
    Obj->ObjOji [LOADOJIIND] = Ptr->Type;
    Obj->ObjTag = PKT_COUNTER;
    Obj->ObjSyn.SynLngInt = Ptr->Bytes;
    return (PKT_NOERROR);
}

static unsigned GetTypeTimeLast (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Type;
    LOADTYPE *Ptr;
    
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Type = Obj->ObjOji [LOADOJIIND];
    for (Ptr = LoadType[Dev]; Ptr != NULL && Ptr->Type < Type; Ptr = Ptr->Next);
    if (Ptr == NULL || Ptr->Type != Type)
        return (PKT_NOSUCHNAME);
    Obj->ObjTag = PKT_TIMETICKS;
    Obj->ObjSyn.SynLngInt = Ptr->Time;
    return (PKT_NOERROR);
}

static unsigned GetNextTypeTimeLast (pkt_obj *Obj, void *Arg)
{
    unsigned Dev = Obj->ObjOji[LOADOJIDEV];
    unsigned Type;
    LOADTYPE *Ptr;

    if (LoadType[Dev] == NULL)
        return (PKT_NOSUCHNAME);
    if (Obj->ObjOjiLen < LOADOJILEN)
    {
        Obj->ObjOjiLen = LOADOJILEN;
        Obj->ObjOji [LOADOJIIND] = LoadType[Dev]->Type;
        Obj->ObjTag = PKT_TIMETICKS;
        Obj->ObjSyn.SynLngInt = LoadType[Dev]->Time;
        return (PKT_NOERROR);
    }
    if (Obj->ObjOjiLen != LOADOJILEN)
        return (PKT_NOSUCHNAME);
    Type = Obj->ObjOji [LOADOJIIND];
    for (Ptr = LoadType[Dev]; Ptr != NULL && Ptr->Type < Type; Ptr = Ptr->Next);
    if (Ptr == NULL || Ptr->Type != Type)
        return (PKT_NOSUCHNAME);
    if ((Ptr = Ptr->Next) == NULL)
        return (PKT_NOSUCHNAME);
    Obj->ObjOji [LOADOJIIND] = Ptr->Type;
    Obj->ObjTag = PKT_TIMETICKS;
    Obj->ObjSyn.SynLngInt = Ptr->Time;
    return (PKT_NOERROR);
}

static unsigned GetApplicIndex (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = Obj->ObjOji[CONTROLOJIAPS];
    return (PKT_NOERROR);
}

static unsigned GetApplicDescription (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_OCTETSTRING;
    strcpy (Obj->ObjSyn.SynBufChr, (char *)Arg);
    Obj->ObjSynLen = strlen ((char *)Arg);
    return (PKT_NOERROR);
}

static unsigned GetApplicStatus (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = *((unsigned *)Arg);
    return (PKT_NOERROR);
}

static unsigned SetApplicEvent (pkt_obj *Obj, void *Arg)
{
    int Apps;
    
    if (Obj->ObjTag != PKT_INTEGER)
        return (PKT_BADVALUE);
    Apps = Obj->ObjOji[CONTROLOJIAPS];
    DpAppsEvent (Apps, (int)Obj->ObjSyn.SynLngInt); 
    return (PKT_NOERROR);
}


static unsigned GetApplicIndexApplic (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = Obj->ObjOji[CONTROLOJIAPS];
    return (PKT_NOERROR);
}

static unsigned GetApplicIndexEvent (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = Obj->ObjOji[CONTROLOJIEVT];
    return (PKT_NOERROR);
}

static unsigned GetApplicProfile (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_GAUGE;
    Obj->ObjSyn.SynLngInt = *((unsigned long *)Arg);
    return (PKT_NOERROR);
}


static unsigned GetFilterIndex (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = Obj->ObjOji[CONTROLOJIFIL];
    return (PKT_NOERROR);
}

static unsigned GetFilterDescription (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_OCTETSTRING;
    strcpy (Obj->ObjSyn.SynBufChr, (char *)Arg);
    Obj->ObjSynLen = strlen ((char *)Arg);
    return (PKT_NOERROR);
}

static unsigned GetFilterStatus (pkt_obj *Obj, void *Arg)
{
    Obj->ObjTag = PKT_INTEGER;
    Obj->ObjSyn.SynLngInt = *((unsigned *)Arg);
    return (PKT_NOERROR);
}

static unsigned SetFilterEvent (pkt_obj *Obj, void *Arg)
{
    int Filt;
    
    if (Obj->ObjTag != PKT_INTEGER)
        return (PKT_BADVALUE);
    Filt = Obj->ObjOji[CONTROLOJIFIL];
    DpFiltEvent (Filt, (int)Obj->ObjSyn.SynLngInt); 
    return (PKT_NOERROR);
}

