comment #
 KEYCTL 1.2  (C) Copyright 1996 Charon Software, All Rights Reserved
 assembled using SLR's OPTASM
    (OPTASM is wonderful, amazing and terrific.  If you use asm, GET IT!
     SLR has been utterly lousy in the area of support in recent months,
     though.  I suspect they've been somewhat overwhelmed with business...
     Nonetheless... OPTASM is magnificent, glorious and excellent!)

 If you find this source code useful, please return the favor and contribute
 source code of your own to the "BBS pool".  In recent years, it has become
 increasingly difficult to find sources for anything... this does nothing to
 advance the state of the art!  Take a moment to return just a little for all
 you've gained from BBSes in the past.
#

.286

RESLEN    equ  Start - KeyCtl + 256 + 15


Sseg          segment        byte stack 'prog'   ; dummy stack segment
Sseg          ends


Cseg          segment        byte public 'prog'
              assume         cs:Cseg, ds:Cseg, es: Cseg, ss:Sseg


              org            100h

KeyCtl        proc
              jmp            Start          ;   skip code for resident routine
KeyCtl        endp




INTRmiscSys   proc           far       ; misc. system services interrupt ------
              pushf                         ; save flags
              cmp            ah,4Fh         ; keyboard interrupt?
              je             #Start         ;   yes, go for it

#Done:        popf                          ; restore flags
              db 0EAh                       ;   pass to original kbd head
   MISCOFS    dw ?                          ; *** self-modifying code:
   MISCSEG    dw ?                          ; *** JMP FAR PTR xxxx:yyyy

#Start:       push           ds             ; save data seg
              push           0040h          ; seg of BIOS data area
              pop            ds             ;
              test byte ptr  ds:[0096h],3   ; is this an "enhanced" key?
              pop            ds             ; (restore data seg)
              jnz            #Done          ;   yep, hands off

              cmp            al,38h         ; Alt make code?
              je             mAlt           ;   yes
              cmp            al,0B8h        ; Alt break code?
              je             bAlt           ;   yes

              cmp            al,3Ah         ; CapsLock make code?
              je             mCapsLock      ;   yes
              cmp            al,0BAh        ; CapsLock break code?
              je             bCapsLock      ;   yes

              cmp            al,1Dh         ; Control make code?
              je             mControl       ;   yes
              cmp            al,9Dh         ; Control break code?
              je             bControl       ;   yes

              cmp            al,1           ; Esc make code?
              je             mEsc           ;   yes
              cmp            al,81h         ; Esc break code?
              je             bEsc           ;   yes

              cmp            al,29h         ; Tilde make code?
              je             mTilde         ;   yes
              cmp            al,0A9h        ; Tilde break code?
              jne            #Done          ;   no, give it to original handler

bTilde:       mov            al,81h         ; xlate to <ESC> "break" code
              jmp            #Done
mTilde:       mov            al,1           ; xlate to <ESC> "make" code
              jmp            #Done

mAlt:         mov            al,3Ah         ; xlate to CapsLock key "make" code
              jmp            #Done
bAlt:         mov            al,0BAh        ; xlate to CapsLock key "break" code
              jmp            #Done

mCapsLock:    mov            al,1Dh         ; xlate to control key "make" code
              jmp            #Done
bCapsLock:    mov            al,9Dh         ; xlate to control key "break" code
              jmp            #Done

mControl:     mov            al,38h         ; xlate to alt key "make" code
              jmp            #Done
bControl:     mov            al,0B8h        ; xlate to alt key "break" code
              jmp            #Done

mEsc:         mov            al,29h         ; xlate to ~` "make" code
              jmp            #Done
bEsc:         mov            al,0A9h        ; xlate to ~` "break" code
              jmp            #Done
INTRmiscSys   endp                     ; misc. system services interrupt ------




INTRmux       proc                     ; multiplex interrupt ------------------
              sti                           ; allow interrupts to occur
              cmp            ah,0DBh        ; is it for us?
              je             #OurMux        ;   yep, go process it
#NormMux:     db 0EAh                       ; *** self-modifying code
  MUXOFS      dw ?                          ; *** JMP FAR PTR xxxx:yyyy
  MUXSEG      dw ?                          ; (original INT 2Fh vector)

#OurMux:      or             al,al          ; status request?
              jnz            #OurMux1       ;   no, skip
              dec            al             ; AL=0FFh to show we're here
              iret                          ;   go directly home
#OurMux1:     cmp            al,1           ; "remove self" request?
              jne            #NormMux       ;   no, exit
              push           0              ;
              pop            es             ;
              mov            ax,cs:MUXOFS   ;
              cli                           ; interrupts off
              mov            es:[00BCh],ax  ; restore old INT 2Fh vector
              mov            ax,cs:MUXSEG   ;
              mov            es:[00BEh],ax  ; restore old INT 2Fh vector
              mov            ax,cs:MISCOFS  ;
              mov            es:[0054h],ax  ; restore old INT 15h vector
              mov            ax,cs:MISCSEG  ;
              mov            es:[0056h],ax  ; restore old INT 15h vector
              sti                           ; interrupts on
              push           cs             ;
              pop            es             ; return current segment in ES
              iret                          ;   return to sender
INTRmux       endp                     ; multiplex interrupt ------------------




Start         proc                     ; main program -------------------------
              cld                           ; set direction forward
              call           ParseCmdLine   ; parse the command line
              jc             #Done          ;   if invalid, take error exit

              cmp            KEYREPEAT,0    ; change key repeat rate?
              jz             #Start1        ;   no, skip it
              mov            ax,0305h       ; set typematic rate
              mov            bh,REPDELAY    ; delay before repeating
              mov            bl,REPRATE     ; rate at which repeat works
              int            16h            ;

#Start1:      cmp            MAP_OFF,0      ; remove remapper?
              jz             #Start2        ;   no, skip it
              mov            ax,0DB00h      ; check for remapper...
              int            2Fh            ; ...on the multiplex interrupt
              inc            al             ; is it installed?
              jnz            #Start1A       ;   no, skip
              mov            ax,0DB01h      ; tell it to remove itself
              int            2Fh            ; (returns remapper segment in ES)
              mov            ah,49h         ; free up remapper memory
              int            21h            ;
              jmp            #Start2        ;
#NotInstMsg   db "Error: KEYCTL was not resident",13,10,"$"
#Start1A:     mov            ah,9           ; display a string
              lea            dx,#NotInstMsg ; ptr to "Not installed"
              int            21h            ;
              mov            ERRCODE,1      ; set error code

#Start2:      cmp            MAP_ON,0       ; install remapper?
              jz             #Done          ;   no, skip it
              push           0040h          ; BIOS data area
              pop            es             ;
              test byte ptr  es:[0096h],10h ; do they have an "enhanced" kbd?
              jz             #Start2B       ;   no, take error exit

              and byte ptr   es:[0017h],0DFh; turn off NumLock
              mov            ax,0DB00h      ; check for remapper...
              int            2Fh            ; ...on the multiplex interrupt
              inc            al             ; is it installed?
              jz             #Start2A       ;   yep, skip out

              mov            es,ds:[002Ch]  ;
              mov            bx,1           ; one paragraph
              mov            ah,4Ah         ; shrink the environment
              int            21h            ;

              cld                           ; set direction forward
              lea            si,PROCNAME    ; install our name in mini-envirn
              xor            di,di          ;
              mov            cx,8           ; 16 bytes maximum
              rep            movsw          ;

              mov            ax,3515h       ; get misc sys svcs vect (INT 15h)
              int            21h            ;
              mov            MISCOFS,bx     ; save old misc system services
              mov            MISCSEG,es     ;
              mov            ax,2515h       ; install new misc sys svc vector
              lea            dx,INTRmiscSys ; ptr to our routine
              int            21h            ;

              mov            ax,352Fh       ; get multiplex int vect (INT 2Fh)
              int            21h            ;
              mov            MUXOFS,bx      ; save old misc system services
              mov            MUXSEG,es      ;
              mov            ax,252Fh       ; install new multiplex int vector
              lea            dx,INTRmux     ; ptr to our routine
              int            21h            ;

              mov            dx,RESLEN      ; size of our interrupt handler
              shr            dx,4           ; convert bytes to paragraphs
              mov            ax,3100h       ; terminate and stay resident
              int            21h            ;

#Done:        mov            ah,4Ch         ; terminate program w/ error code
              mov            al,ERRCODE     ; get the error code
              int            21h            ;

#Start2A:     lea            dx,#AlrInstMsg ; ptr to "Already installed"
#Start2Z:     mov            ah,9           ; display a string
              int            21h            ;
              mov            ERRCODE,1      ; set error code
              jmp            #Done          ;   go exit
#Start2B:     lea            dx,#NotEnhMsg  ; ptr to "Not 101-key keyboard"
              jmp            #Start2Z       ;   go through main error exit

#AlrInstMsg   db "Error: KEYCTL is already resident",13,10,"$"
#NotEnhMsg    db 'Error: the keyboard is not "enhanced" (101-key)',13,10,'$'

Start         endp                     ; main program -------------------------



ParseCmdLine  proc           near      ; parse the command line for parms -----
              mov            si,0080h       ; ptr to length of command line
              mov            ax,si          ; zero AH
              lodsb                         ; length of command line
              cmp            al,1           ; is it null or nearly so?
              jbe            #Help          ;   yep, go help 'em
              mov            cx,ax          ; length of command line

#ScanParms:   mov            di,si          ; update ptr to command line
              mov            al,"/"         ; switch character
              repne          scasb          ; see if we can find it
              mov            si,di          ;
              jne            #Done          ;   no, go exit
              jcxz           #Done          ;   exit if no parms left
              lodsb                         ; get option character
              dec            cx             ; account for it
              and            al,0DFh        ; convert it to uppercase
              cmp            al,"D"         ; D>einstall?
              je             #Deinstall     ;   yep, take care of it
              cmp            al,"I"         ; I>nstall?
              je             #Install       ;   yep, take care of it
              cmp            al,"R"         ; set <R>epeat rate?
              jne            #BadParm       ;   no, unknown-- take error exit
              cmp            cx,5           ; is there enough room for parms?
              jl             #BadParm       ;   no, take error exit
              lodsw                         ; get "=" & 1st parm (repeat delay)
              sub            cx,2           ; account for chars read
              cmp            al,"="         ; is it what we expect?
              jne            #BadParm       ;   no, take error exit
              sub            ah,"1"         ; convert first parm to binary
              jl             #BadParm       ;   error if out of range
              cmp            ah,3           ; is it too large?
              ja             #BadParm       ;   yep, error
              mov            REPDELAY,ah    ; save it (delay before repeat)
              lodsb                         ; get the ","
              dec            cx             ; account for it
              cmp            al,","         ; was it what we wanted?
              jne            #BadParm       ;   no, error
              lodsw                         ; get the second parm (repeat rate)
              sub            cx,2           ; account for it
              xchg           al,ah          ; put in proper order
              sub            ax,"00"        ; convert to BCD
              aad                           ; convert to binary
              cmp            ax,30          ; is it too large?
              ja             #BadParm       ;   yep, error exit
              cmp            al,2           ; is it too small?
              jb             #BadParm       ;   yep, error exit
              sub            al,2           ; base it on zero
              shl            ax,5           ; multiply by 32
              mov            bl,29          ;
              div            bl             ; divide by 29
              cmp            ah,14          ; is the remainder > 1/2 of 29?
              jbe            #R1            ;   no, skip...
              inc            al             ; round up
#R1:          sub            al,31          ; convert 0..31 to 31..0
              neg            al             ;
              mov            REPRATE,al     ; save it (repeat rate)
              mov            KEYREPEAT,1    ; set /RepeatRate flag
              jmp            #ScanParms     ;   go try for another parm

#Deinstall:   mov            MAP_OFF,1      ; set /Deinstall flag
              jmp            #ScanParms     ;   go try for another parm

#Install:     mov            MAP_ON,1       ; set /Install flag
              jmp            #ScanParms     ;   go try for another parm

#Done:        cmp            KEYREPEAT,0    ; did we get an option?
              jne            #GoodExit      ;   yep, it's good
              cmp            MAP_OFF,0      ; did we get an option?
              jne            #GoodExit      ;   yep, it's good
              cmp            MAP_ON,0       ; did we get an option?
              jne            #GoodExit      ;   yep, it's good

#Help:        lea            si,INFO        ; ptr to info about KEYCTL
#ShowInfo:    lodsb                         ; get a char
              or             al,al          ; end of text?
              jz             #BadExit       ;   yep, go exit
              cmp            al,0FFh        ; unprintable char?
              jne            #SI1           ;   no, go display it
              mov            al," "         ; convert to space
#SI1:         mov            dl,al          ; get char ready to display
              mov            ah,2           ; display a character
              int            21h            ;
              jmp            #ShowInfo      ;   go for all chars

#BadParm:     mov            ah,9           ; display a string
              lea            dx,#BadParmMsg ; ptr to "Invalid parameter"
              int            21h            ;
              mov            ERRCODE,2      ; set error code
              jmp            #BadExit       ;   go exit
#BadParmMsg   db "Error: an invalid parameter was given",13,10,"$"

#BadExit:     stc                           ; set error flag
              ret                           ;   return to sender

#GoodExit:    clc                           ; clear error flag
              ret                           ;   return to sender

ParseCmdLine  endp                     ; parse the command line for parms -----



; -------------------------- transient data area ------------------------------



INFO  db "KEYCTL v1.2  (C) Copyright 1996 Charon Software      ",13,10
      db 13,10
      db "KEYCTL may be distributed as long as it is not modified in any way, all files",13,10
      db "are included (KEYCTL.ASM, KEYCTL.COM, KEYCTL.DOC), and any fees are below $6.",13,10
      db 13,10
      db "KEYCTL is for AT-class (80286 and 80386) computers.  It allows you to improve",13,10
      db "keyboard responsiveness by altering the key repeat rate, and/or remap 101-key",13,10
      db '"enhanced" keyboards to resemble the PC keyboard.',13,10
      db 13,10
      db "If keyboard remapping is selected, Num Lock will be turned off (switching the",13,10
      db "keypad into cursor-key mode) and the keyboard will be remapped like so:",13,10
      db "   Caps Lock ---> left Ctrl      left Ctrl ---> left Alt",13,10
      db "   left Alt  ---> Caps Lock      Esc       <--> ~`",13,10
      db 13,10
      db "KEYCTL            display information on KEYCTL",13,10
      db "KEYCTL /I         install keyboard remapper in memory",13,10
      db "KEYCTL /D         deinstall keyboard remapper",13,10
      db "KEYCTL /R=x,yy    set key repeat rate",13,10
      db 13,10
      db "The /R option may be used in conjunction with the other options.  Two numeric",13,10
      db "values must be given with /R, as follows:",13,10
      db "   x   1-4     delay before repeat starts (2 suggested).",13,10
      db "  yy   02-30   two-digit repeat rate in cps (25-30 suggested).",13,10
      db 0



; These are flags set by ParseCmdLine according to the switches it finds.

KEYREPEAT  db 0      ; whether to change the key repeat rate     /R
MAP_OFF    db 0      ; whether to remove remapper from memory    /D
MAP_ON     db 0      ; whether to install remapper               /I



; The original environment will be discarded by the resident keyboard remapper,
; since it won't be needed and takes up space.  We'll install the following as
; our name in a tiny environment, though, for the benefit of MAP.

PROCNAME  db 0,0,1,0,"KEYCTL.COM",0,0



; These are temporary variables used when changing the key repeat rate.  The
; REPDELAY is the delay before a key should start repeating:
;    0     250 milliseconds
;    1     500 ms
;    2     750 ms
;    3     1 second
; REPRATE is the key repeat rate, 0-31 (from around 30 cps to around 2 cps)

REPDELAY  db ?    ; delay before repeat
REPRATE   db ?    ; repeat rate



ERRCODE   db 0    ; number to return as ErrorLevel when program exits

Cseg          ends
              end            KeyCtl
