/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
*   Module to provide the required interfact for the cagd library for the    *
* free form surfaces and curves.					     *
*****************************************************************************/

#ifndef FREEFORM_H
#define FREEFORM_H

int GetDrawCtlPt(void);
int GetFourPerFlat(void);
ObjectStruct *GenBezierSurfaceObject(ObjectStruct *LstObjList);
ObjectStruct *GenBezierCurveObject(ObjectStruct *PtObjList);
ObjectStruct *GenBsplineSurfaceObject(RealType *UOrder, RealType *VOrder,
		      ObjectStruct *LstObjList, ObjectStruct *KntObjList);
ObjectStruct *GenBsplineCurveObject(RealType *ROrder, ObjectStruct *PtObjList,
						      ObjectStruct *KntObjList);
ObjectStruct *DivideSurfaceObject(ObjectStruct *SrfObj, RealType *Dir,
							RealType *ParamVal);
ObjectStruct *RegionFromSurfaceObject(ObjectStruct *SrfObj, RealType *RDir,
				      RealType *ParamVal1, RealType *ParamVal2);
ObjectStruct *DivideCurveObject(ObjectStruct *CrvObj, RealType *ParamVal);
ObjectStruct *RegionFromCurveObject(ObjectStruct *CrvObj,
				    RealType *ParamVal1, RealType *ParamVal2);
ObjectStruct *RefineSurfaceObject(ObjectStruct *SrfObj, RealType *Dir,
				  RealType *Replace, ObjectStruct *KnotsObj);
ObjectStruct *RefineCurveObject(ObjectStruct *CrvObj, RealType *Replace,
							ObjectStruct *KnotsObj);
ObjectStruct *EvalSurfaceObject(ObjectStruct *SrfObj, RealType *u, RealType *v);
ObjectStruct *EvalCurveObject(ObjectStruct *CrvObj, RealType *t);
ObjectStruct *NormalSurfaceObject(ObjectStruct *SrfObj, RealType *u,
								  RealType *v);
ObjectStruct *TangentSurfaceObject(ObjectStruct *SrfObj, RealType *Dir,
						     RealType *u, RealType *v);
ObjectStruct *TangentCurveObject(ObjectStruct *CrvObj, RealType *t);
ObjectStruct *CurveFromSrfMesh(ObjectStruct *SrfObj, RealType *Dir,
							RealType *Index);
ObjectStruct *CurveFromSurface(ObjectStruct *SrfObj, RealType *Dir,
							    RealType *ParamVal);
ObjectStruct *CurveReverse(ObjectStruct *CrvObj);
ObjectStruct *SurfaceReverse(ObjectStruct *SrfObj);
void ComputeCurveIsoLines(ObjectStruct *PObj);
void ComputeSurfaceIsoLines(ObjectStruct *PObj);
void ComputeSurfacePolygons(ObjectStruct *PObj);
ObjectStruct *Geometry2Polygons(ObjectStruct *Obj);
ObjectStruct *Geometry2Polylines(ObjectStruct *Obj);
ObjectStruct *GenCircleCurveObject(VectorType Position, RealType *Radius);
ObjectStruct *GenArcCurveObject(VectorType Start, VectorType Center,
							VectorType End);
ObjectStruct *GenRuledSrfObject(ObjectStruct *Crv1, ObjectStruct *Crv2);
ObjectStruct *GenBoolSumSrfObject(ObjectStruct *Crv1, ObjectStruct *Crv2,
				  ObjectStruct *Crv3, ObjectStruct *Crv4);
ObjectStruct *GenSrfFromCrvsObject(ObjectStruct *CrvList);
ObjectStruct *GenSweepSrfObject(ObjectStruct *CrossSection, ObjectStruct *Axis,
				     ObjectStruct *ScalingCrv, RealType *Scale);
ObjectStruct *GenOffsetObject(ObjectStruct *Obj, RealType *Offset);
ObjectStruct *MergeCurvesAndCtlPoints(ObjectStruct *PObj1, ObjectStruct *PObj2);
ObjectStruct *EditCrvControlPoint(ObjectStruct *PObjCrv, ObjectStruct *PObjPt,
							     RealType *Index);
ObjectStruct *EditSrfControlPoint(ObjectStruct *PObjSrf, ObjectStruct *PObjPt,
					RealType *UIndex, RealType *VIndex);
ObjectStruct *RaiseCurveObject(ObjectStruct *PObjCrv, RealType *Order);
ObjectStruct *RaiseSurfaceObject(ObjectStruct *PObjSrf, RealType *RDir,
							 RealType *RNewOrder );

#endif /* FREEFORM_H */


