program porttest;


(* operates the parallel port on bit level for testing hardware *)


uses crt;


var
  p_in,                 (* parallel port address (read)  *)
  pout       : word;    (* parallel port address (write) *)
  printer_no : byte;    (* parallel port number          *)
  invert     : boolean; (* invert 'PE' display?          *)


procedure init_ports;
(* initializes print port address *)
begin
  pout := memw[$40:$8 + (printer_no - 1) * 2];
  p_in := pout+1;
end;


function in_port:byte;
(* reads byte from parallel port *)
begin
  in_port := port[p_in];
end;


procedure out_port(b:byte);
(* writes byte to parallel port *)
begin
  port[pout] := b;
end;


function read_port:byte;
(* reads byte from parallel port, inverts it if INVERT is set *)
begin
  if invert then read_port := not in_port
            else read_port :=     in_port;
end;


procedure write_port(b:byte);
(* writes byte to parallel port *)
begin
  port[pout] := b;
end;


var game_over : boolean; (* end program? *)
    w,
    i         : byte;

(* porttest *)
begin
  printer_no := 1;
  invert     := false;
  for i := 1 to paramcount do begin
    if paramstr (i) = '1' then printer_no := 1;
    if paramstr (i) = '2' then printer_no := 2;
    if paramstr (i) = '3' then printer_no := 3;
    if paramstr (i) = 'i' then invert     := true;
  end;

  writeln;
  writeln ('parallel port #', printer_no);
  if invert then writeln ('PE and Busy inverted');

  init_ports;
  game_over := false;
  repeat
    writeln;
    writeln ('  A  - read All');
    writeln ('  W  - Write port');
    writeln ('  R  - Read port');
    writeln ('  C  - read Continuous');
    writeln ('  M  - read Masked');
    writeln (' ESC - GAME OVER');
    writeln ;
    case upcase (readkey) of
      'W': begin
             write ('value to write : ');
             readln (w);
             out_port (w);
           end;
      'C': begin
             repeat
               write (in_port : 8);
             until keypressed;
             readkey;                    (* clear keyboard buffer *)
             writeln;
           end;
      'M': begin
             repeat
               w := read_port;
               write ('  ');
               if (w and $20) <> 0 then write ('P') else write ('-');
               if (w and $80)  = 0 then write ('B') else write ('-');
             until keypressed;
             readkey;                    (* clear keyboard buffer *)
             writeln;
           end;
      'R': writeln('actual value:',in_port);
      'A': begin
             clrscr;
             gotoxy (1, 2);
             for i := 0 to 15 do writeln (i : 4);
             repeat
               for i := 0 to 15 do begin
                 write_port (i);
                 w := read_port;
                 gotoxy (6, i + 2);
                 if (w and $20) <> 0 then write ('P') else write ('-');
                 if (w and $80)  = 0 then write ('B') else write ('-');
               end;
             until keypressed;
             readkey;                    (* clear keyboard buffer *)
             writeln;
           end;
      #27: game_over := TRUE;
    end;
  until game_over;
  out_port (0); (* switch off interfaces powered by the parallel port *)
end.

