{
  HRPATCH.PAS  Version 1.3
  08 March 1989
  Written by David Gwillim  

  Released to the Public Domain.

           *** Compile with Turbo Pascal version 4.0 or 5.0 ***

  The purpose of this utility fix a bug in the testing for a valid video
  mode for HR to pop-up during and to permit the alteration of the
  characters used to delimit the hypertext link fields in HyperRez files
  in the event that conflict arises out of the use of the standard '<'
  and '>'. The program is specific to a particular version of HR.EXE as
  the characters are hard coded in the program. For other versions of
  the program the typed constants VidCheck, StartPos, EndPos and
  HRfilesize would have to be appropriately altered.

  (*
  Ideas for possible character pairs for hyperlink field delimeters:

          <LINK00>        >LINK00<
          (LINK00)        )LINK00(
          [LINK00]        ]LINK00[
          LINK00        LINK00
          LINK00        LINK00
          LINK00        LINK00
          LINK00        LINK00
          LINK00        LINK00
          LINK00        LINK00
          LINK00        LINK00
          LINK00        LINK00
          LINK00        LINK00
          LINK00        LINK00
          LINK00        LINK00
          LINK00        LINK00
          LINK00        LINK00

  *)
  Byte Sequences to look for in the HR.EXE file to locate the
  offsets where the constant values for '<' and '>' are located:

                             HRCT1 (HRN.EXE  17903  3-06-89  10:40p)
  '<' (03CH)                 
      74 0E 3C [3C] 75 EA    0A43
         80 3F [3C] 75 ED    106E
      8B EC B8 [3C] 00 50    12D8
      74 2B B8 [3C] 00 50    1336
         80 3C [3C] 75 15    14D6
         80 3F [3C] 75 09    16D9
         80 38 [3C] 75 A5    173D
         80 3F [3C] 75 E2    1C5F


  '>' (03EH)
      74 34 3C [3E] 75 EA    0A1D
         80 3F [3E] 75 ED    1050
      74 2B B8 [3E] 00 50    12EE
      8B EC B8 [3E] 00 50    1320
         80 3D [3E] 75 09    14E2
         80 3F [3E] 74 07    16E2
         80 38 [3E] 75 9C    1746
         80 3F [3E] 75 E2    1C88

   FileSize                 17903

   Video mode test bug correction patch (won't pop up in modes 2, 1 or 0)
   byte sequence to look for:

                             HRCT

      3D 03 00 [74] 05       295B    code for a JE instruction

      patch to

      3D 03 00 [7E] 05               code for a JLE instruction


  }

const
   {The StartPos and EndPos arrays contain the file offsets of the
    occurrences in the HyperRez program code where the hypertext
    link delimeter characters (normally '<' and '>') occur.}
   { Current version 6 values }
   StartPos : array[1..8] of word = ($0A43,$106E,$12D8,$1336,$14D6,$16D9,$173D,$1C5F);
   EndPos   : array[1..8] of word = ($0A1D,$1050,$12EE,$1320,$14E2,$16E2,$1746,$1C88);

   { for patching error in video mode check }
   VidCheck : word = ($295B);
   Jle : byte = $7E;   { Jump Less than or equal to CPU instruction }

   {HRfilesize is the length of the HyperRez program file for
    which the above offsets are valid}
   HRfilesize : word = 17903;

var
   F : file of char;
   Ch : char;
   StartChStr,EndChStr : string[3];
   StartCh,EndCh : char;
   Fname : string[65];
   Fposn : word;

procedure ShowDelimeters(Msg : string);
begin
   write(Msg);
   for Fposn := 1 to 8 do
   begin
      seek(F,StartPos[Fposn]);
      read(F,Ch);
      write(Ch);
   end;
   for Fposn := 1 to 8 do
   begin
      seek(F,EndPos[Fposn]);
      read(F,Ch);
      write(Ch);
   end;
   writeln;
end;

procedure ShowUsage;
begin
   writeln('     Usage: HRPATCH PROGNAME.EXE START END');
   writeln('     Where START and END are the ASCII values');
   writeln('     of the characters to be used as hypertext');
   writeln('     link field delimeters for HyperRez.');
   Halt;
end;

procedure SetDelimeters;
var
   Tmp : byte;
   Err : integer;
   BadNumber : boolean;
begin
   BadNumber := False;
   if (StartChStr = '') or (EndChStr = '') then
      ShowUsage;
   Val(StartChStr,Tmp,Err);
   if (Err = 0) and (Tmp <> 0) then
      StartCh := char(Tmp)
   else
      BadNumber := True;
   Val(EndChStr,Tmp,Err);
   if (Err = 0) and (Tmp <> 0) then
      EndCh := char(Tmp)
   else
      BadNumber := True;
   if BadNumber then
   begin
      writeln('The ASCII values for Start and End characters');
      writeln('must be in the range 1..255');
      writeln('File ',Fname,' not changed.');
      Halt;
   end;
   if StartCh = EndCh then
   begin
      writeln('The starting and ending characters may not be the same.');
      writeln('File ',Fname,' not changed.');
      Halt;
   end;
   for Fposn := 1 to 8 do
   begin
      seek(F,StartPos[Fposn]);
      write(F,StartCh);
   end;
   for Fposn := 1 to 8 do
   begin
      seek(F,EndPos[Fposn]);
      write(F,EndCh);
   end;
   ShowDelimeters('    New delimeters: ');
   writeln;
   writeln('Patching video mode check so HyperRez works with');
   writeln('text video modes 0, 1 and 2 as well as 3 and 7.');
   Seek(F,VidCheck);
   write(F,char(Jle));
   close(F);
end;

procedure Initialize;
begin
   writeln('Ŀ');
   writeln(' HyperRez Patch Program Version 1.2 - 03 Mar 1989 ');
   writeln('      Written by David Gwillim for HRCT.EXE       ');
   writeln('');
   writeln;
   Fname := ParamStr(1);
   if Fname = '' then
      ShowUsage;
   assign(F,Fname);
   {$I-}
   reset(F);
   {$I+}
   if IOresult <> 0 then
   begin
      writeln('File not found: ',Fname);
      Halt;
   end;
   if FileSize(F) <> HRfilesize then
   begin
      writeln('Internal values unsuitable for configuring ',Fname,'.');
      writeln('You will need to recompile HRPATCH.PAS with updated information.');
      Halt;
   end;
   ShowDelimeters('Current delimeters: ');
   StartChStr := ParamStr(2);
   EndChStr := ParamStr(3);
end;

begin
   Initialize;
   SetDelimeters;
end.
