/*

	pickfile.hpp
	7-30-91
	Directory PickList

	Copyright 1991
	John W. Small
	All rights reserved

	Licensed users of FlexList are free to use and
	modify this tool for use in their programs.


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef PICKFILE_HPP
#define PICKFILE_HPP

#include <dos.h>
#include <dir.h>
#ifndef PICKLIST_HPP
#include <picklist.hpp>
#endif


#define MAX_ATTRIB_STR  7

typedef  struct  {
	int tag;
	char  attrib, attribStr[MAX_ATTRIB_STR];
	unsigned ftime;
	unsigned fdate;
	long  fsize;
	int fnameLen, extLen;
	char name[13];
	char entry[45];
} DirEntry, *DirE;
#define DirE0 ((DirE) 0)


#define PF_WIDTH 39
#define PF_MASK  " Pick File Mask "

class PickFile : PickListWindow {
	static char path[], auxpath[];
	static char drive[], dir[], file[], ext[];
	char mask[MAXPATH];
	int mattrib;
	static int DEcompare(const DirE DE1, const DirE DE2);
	int DEload(const char *pathname, int fattrib);
	char *DEpathname(const DirE DE);
	char *fattribStr(char *attribStr, char attrib);
	virtual int idle(int c);
	#pragma argsused
	virtual void displayLine(void * D, int lineLen,
			int cursor)
		{ cprintf("%-*.*s",lineLen,lineLen,
			((DirE)D)->entry); }
	virtual int xcursor(void * D, const char *prefix,
		int pfLen);
	virtual int  match(char *pf, void * D)
	{
		return !strncmpi(pf,((DirE)D)->name,
			strlen(pf));
	}
	virtual int doIt(void * D);
	virtual void dressWindow()
		{ putTitle(mask); }
	virtual unsigned paneWidth() { return PF_WIDTH; }
public:
	void setPalette(PalettE PLP = PalettE0,
		PalettE TWP = PalettE0)
	{
		PickList::setPalette(PLP);
		TextWindow::setPalette(TWP);
	}
	PickFile() : PickListWindow(0,PalettE0,PalettE0,
		sizeof(DirEntry),FLmaxMaxNodes,
		FLcomparE(PickFile::DEcompare)) {}
	unsigned choose(const char *pathname = (char *)0,
		int fattrib = FA_DIREC,
		const char *defaultExt = ".*");
	char * choice()
	{
		return DEpathname((DirE)PickList::choice());
	}
};
typedef PickFile * PickF;
#define PickF0 ((PickF)0)

#endif
