/*

	pcvideo.hpp
	7-30-91
	Extended text attribute control for conio.

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA
	
	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef PCVIDEO_HPP
#define PCVIDEO_HPP

#include <conio.h>

// Construct various text attributes.
#define rvideo(attr)  \
	((((attr) & 0x07) << 4) | ((attr) & 0x08) |  \
	(((attr) & 0x70) >> 4) | ((attr) & 0x80))
#define bvideo(attr)  ((attr) | 0x80)
#define ubvideo(attr) ((attr) & 0x7F)
#define lvideo(attr) ((attr) & 0xF7)
#define hvideo(attr) ((attr) | 0x08)
#define svideo(fgrd, bgrd) ((fgrd) + (bgrd) * 16)

// Set various text attributes.
#define setvideo(fgrd,bgrd) textattr(svideo(fgrd,bgrd))
extern  void reversevideo();
extern  void blinkvideo();
extern  void unblinkvideo();
extern  void savevideo();
extern  void restorevideo();
extern  void saveAsOrigVideo();
extern  void restoreOrigVideo();
extern  void putvideo(int left, int top, int right,
		int bottom, int attr, int buf[]);

// handy text mode items
extern  int  istext();
extern  int  iscolor();
extern  void toggleRes();  // C80/C4350
extern  int  forcedmonochrome;

// automatic monochrome/color palettes
typedef int Palette[];
typedef int *PalettE;
#define PalettE0 ((PalettE)0)
inline  void mappalette(PalettE P)
		{ if (P)  P[0] = iscolor(); }
inline  int  mapattr(int attr_id, PalettE P)  {
		return (P? P[(attr_id)*2-1+P[0]]
		: svideo(BLINK+WHITE,RED)); }
extern  void mapvideo(int attr_id, PalettE P);

#endif
