Unit txtutil4;
{ a collection of string-manipulation utilities }

{Copyright 1993-1996 East Carolina University, Greenville, NC, USA. }
{ Author: David Lunney, Professor of Chemistry, ECU }

(*      ADDRESS: Department of Chemistry
                 East Carolina University
                 Greenville, NC 27858-4353
                 USA


        INQUIRIES REGARDING THIS PROGRAM SHOULD BE DIRECTED
        TO DAVID LUNNEY AT chlunney@ecuvm.cis.ecu.edu OR
        LUNNEY@DELPHI.COM                                            *)


(*  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    A COPY OF THE GNU GENERAL PUBLIC SOFTWARE LICENSE HAS BEEN
    PROVIDED WITH THIS PROGRAM IN THE FILE "LICENSE.TXT"       *)

   { No Warranty.  EAST CAROLINA UNIVERSITY DISCLAIMS AND MAKES NO
   REPRESENTATIONS AND EXTENDS NO WARRANTIES, EITHER EXPRESS OR
   IMPLIED. THERE ARE NO EXPRESS OR IMPLIED WARRANTIES OF
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  The User
   shall assume all liability for all damages whatsoever that may or
   do arise from the User's use, inability to use, performance, or
   storage of TXTUTIL4.  East Carolina University shall not be
   liable to the User for any loss, claims, damages or demands
   whatsoever made by the User or made against the User by any other
   party, due to or arising from the performance of, use of, and/or
   inability to use TXTUTIL4 by the User and/or anyone else. }


Interface

Const
  SP: Char = #32;
  dot: Char = #46;
  zorro: Char = #48;
  plus: Char = #43;
  minus: Char = #45;
  colon: Char = #58;
  backslash: Char = #92;
  
  BS: Char = #08;
  CR: Char = #13;
  
Type
  byteray128 = Array[1..128] Of Byte;
  
Var
  BigText: Array[1..8] Of String[24]; { 8 lines X 24 chars }
  
Procedure AllCaps(Var instg: String);
Procedure ConvertUpperCase(Var strang: String);
Function LowCase(inchar: Char): Char;
Procedure ConvertLowerCase(Var strang: String);
Procedure EatBlanks(Var strang: String);
Procedure TrimFirstBlanks(Var instg: String);
Procedure TrimLastBlanks(Var instg: String);
Procedure EatExtraBlanks(Var strang: String);
Procedure FixName(Var strang, first: String);
Procedure FixInitials(Var strang: String; Var len: Byte);
Function AllBlanks(instg: String): Boolean;
Function IntToStg(num, L: Integer): String;
Function CopyIntNum(instg: String; Var err: Integer): Integer;

 { following routines are not in TXUTIL2 dl 9-96 }

Procedure FindSubstringLocs(strang: String; sep: Char;
          Var stringlocs, stringlens: byteray128; Var numstrings: Byte);
Function CharCount(countchar: Char; strang: String): Byte;
Procedure DeleteSubstg(delstg: String; Var instg: String);
Procedure DeleteTail(startchar: Char; Var instg: String);
Procedure KillRepeats(delchar: Char; Var instg: String);
Procedure EatChar(delchar: Char; Var instg: String);

 { following routine is not in TXUTIL3 dl 9-96 }

Procedure SplitString1(instg: String; sepchar: Char;
                  maxlen, ndx1, ndx2: Byte; Var TooLong: Boolean);

Implementation

Procedure AllCaps(Var instg: String);
  Var
    i: Byte;
    
  Begin
    For i := 1 To Length(instg) Do
      instg [i] := UpCase(instg [i] );
  End;


Procedure ConvertUpperCase(Var strang: String);
{ same as ALLCAPS, but coded differently  }
  Var
    i, len: Byte;
  Begin
    len := Ord(strang [0] );
    For i := 1 To len Do strang [i] := UpCase(strang [i] );
  End;

Function LowCase(inchar: Char): Char;
  Begin
    If inchar In ['A'..'Z'] Then
      LowCase := Chr(Ord(inchar) + $20)
    Else LowCase := inchar;
  End;

Procedure ConvertLowerCase(Var strang: String);
  Var
    i, len: Byte;
  Begin
    len := Ord(strang [0] );
    For i := 1 To len Do strang [i] := LowCase(strang [i] );
  End;

Procedure EatBlanks(Var strang: String);
  Var
    i, len: Byte;
  Begin
    Repeat
      Delete(strang, Pos(SP, strang), 1)
    Until Pos(SP, strang) = 0;
  End;

Procedure TrimFirstBlanks(Var instg: String);
  Begin
    Repeat
      If instg [1] = SP Then Delete(instg, 1, 1);
    Until instg [1] <> SP;
  End;

Procedure TrimLastBlanks(Var instg: String);
  Var
    len: Byte;
  Begin
    Repeat
      len := Length(instg);
      If instg [len] = SP Then Delete(instg, len, 1);
    Until instg [len] <> SP;
  End;

Procedure EatExtraBlanks(Var strang: String);
{ removes leading and trailing blanks and extra blanks
  between words }
  Var
    L, ncopy, i: Byte;
    letter: Char;
    blankfound: Boolean;
    copystg: Array [0..255] Of Char;
  Begin
    { no blanks? exit. }
    If Pos(SP, strang) = 0 Then Exit;
    
    { remove leading blanks }
    While Pos(SP, strang) = 1 Do Delete(strang, 1, 1);
    
    L := Length(strang);
    { nothing left? quit. }
    If L = 0 Then Exit;
    If Pos(SP, strang) = 0 Then Exit;
    
    { remove trailing blanks }
    While strang [Length(strang) ] = SP
    Do Delete(strang, Length(strang), 1);
    
    L := Length(strang);
    { nothing left? quit. }
    If L = 0 Then Exit;
    If Pos(SP, strang) = 0 Then Exit;
    
    ncopy := 0;
    i := 0;
    Repeat
      blankfound := False;
      Repeat
        i := i + 1;
        ncopy := ncopy + 1;
        copystg [ncopy] := strang [i];
        If strang [i] = SP Then blankfound := True;
      Until((blankfound) Or (i = L) );
      { find next non-SP char }
      If blankfound Then
      Begin
        While strang [i] = SP Do i := i + 1;
        i := i - 1;
      End;
    Until i = L;
    copystg [0] := Chr(ncopy);
    For i := 0 To ncopy Do strang [i] := copystg [i];
  End;

Procedure FixName(Var strang, first: String);
 { puts a name in form "Snidely Whiplash", irrespective of how
  it was entered. (Some synths spell out any word which is all caps.) }
  { also returns first name. }

  Var
    i, blankpos: Byte;

  Begin
    ConvertLowerCase(strang);
    EatExtraBlanks(strang);
    strang [1] := UpCase(strang [1] );
    For i := 2 To Length(strang) - 1 Do If strang [i] = SP
    Then strang [i + 1] := UpCase(strang [i + 1] );
    blankpos := Pos(SP, strang);
    If blankpos > 0 Then
      first := Copy(strang, 1, blankpos - 1)
    Else first := strang;
  End;

Procedure FixInitials(Var strang: String; Var len: Byte);
{ removes blanks, non-literal chars  etc. from initals, converts
  to upper case, and gets length of corrected string }
{ dl 1-13-96 }
{ modified to remove all non-literals dl 2-29-96 }

  Const
    UpperSet: Set Of Char = ['A'..'Z'];
    
  Var
    i: Byte;
    
  Begin
    EatBlanks(strang);
    AllCaps(strang);
    len := Length(strang);
    { remove non-literal chars }
    { first replace with blanks }
    For i := 1 To len Do If (Not (strang[i] In UpperSet))
    Then strang[i] := SP;
    { then remove the blanks }
    EatBlanks(strang);
    len := Length(strang);
  End;

Function AllBlanks(instg: String): Boolean;
  Begin
    EatBlanks(instg);
    If Length(instg) > 0 Then AllBlanks := False Else AllBlanks := True;
  End;

Function IntToStg(num, L: Integer): String;
  { converts an integer num to a string }
  Var
    stg: String;
  Begin
    Str(num: L, stg);
    IntToStg := stg;
  End;

Function CopyIntNum(instg: String; Var err: Integer): Integer;
  { copies a numeric substring from the beginning of a string
    and converts to an integer, which may be signed }
  Const
    numset: Set Of Char = ['0'..'9'];
  Var
    k, len: Byte;
    dumstg: String;
    num: Integer;
    
  Begin
    len := Length(instg);
    dumstg := '';
    k := 1;
    If instg[1] In ['+', '-'] Then
    Begin
      dumstg := dumstg + instg[1];
      k := 2;
    End;
    While((instg[k] In numset) And (k <= len)) Do
    Begin
      dumstg := dumstg + instg[k];
      k :=  k + 1;
    End;
    Val(dumstg, num, err);
    CopyIntNum := num;
  End;

Procedure FindSubstringLocs(strang: String; sep: Char;
              Var stringlocs, stringlens: byteray128; Var numstrings: Byte);
  { finds starting locations (stringlocs) and lengths (stringlens)
  of substrings that are delimited within a larger string by
  separators (e.g., spaces).  developed for use with BIGNUMSX.   dl 8-96 }
Var
  i, L, len, stringcount: Byte;
  bytestring: Array[1..256] Of ShortInt; { elements set to 1 for separator, }
  { 2 for other chars, 0 for nothing }
  diff: ShortInt; { diff between adjacent values of bytestring[i] }
  allsep: Boolean;  { set true if the string contains only separators }
  
Begin
  { initialize vars }
  numstrings := 0;
  stringcount := 0;
  len := 0;
  FillChar(stringlocs, SizeOf(stringlocs), 0);
  FillChar(stringlens, SizeOf(stringlens), 0);
  FillChar(bytestring, SizeOf(bytestring), 0);
  L := Length(strang);
  
  { no string at all? quit }
  If L = 0 Then Exit;
  
  { no separator at all? only one substring present; quit }
  If Pos(sep, strang) = 0 Then
  Begin
    stringlocs[1] := 1;
    stringlens[1] := L;
    numstrings := 1;
    Exit;
  End;
  
  { make bytestring }
  For i := 1 To L Do If strang[i] <> sep Then bytestring[i] := 2
  Else bytestring[i] := 1;
  
  { look for pathological case of a string with nothing but separators }
  allsep := True;
  For i := 1 To L Do If bytestring[i] > 1 Then allsep := False;
  If allsep Then Exit;
  
  For i := 1 To L + 1 Do
  Begin
    If i > 1 Then diff := bytestring[i] - bytestring[i-1] Else diff := 1;
    If bytestring[i] = 2 Then
    Begin
      Inc(len);
      If diff = 1 Then
      Begin
        Inc(stringcount);
        stringlocs[stringcount] := i;
      End;
    End;
    If ((diff < 0) And (bytestring[i-1] <> 1)) Then
    Begin
      stringlens[stringcount] := len;
      len := 0;
    End;
  End;
  numstrings := stringcount;
End;


Procedure SplitString1(instg: String; sepchar: Char;
                  maxlen, ndx1, ndx2: Byte; Var TooLong: Boolean);

  { splits a string "instg" into substrings and puts them
    into variable "BigText" for display on the screen as
    large chars. 9-96 dl }

  { "sepchar" is the character which separates the
     substrings; "ndx1" is the first available line on
     the screen and "ndx2" is the last. }

  { This version can't handle substrings longer than
    "maxlen"; it also gives up and truncates the string
    if it can't get all the text on one screen, and sets
    variable "TooLong"  to TRUE. This works fine for
    file names, because if the separator char is "\",
    the longest LEGAL substring is 12 chars long.
    (A call to FixUpFileName shortens directory names
    and file names that are too long.) It is highly
    unlikely that a valid path string will exceed about
    40 chars.  }

  Var
    lentotal, ndx, numstgs, i, LineLen, stgcnt, dy, charcount,
    numlines, k, start, lastline, maxlines, maxchars, biggest,
    len, lastlen: Byte;
    stglocs, stglens: byteray128;
    dumstg: String;
    stgperline: Array[1..8] Of Byte;
    
  Begin
    { initialize }
    For i := 1 To 8 Do stgperline[i] := 0;
    For i := ndx1 To ndx2 Do BigText[i] := '';
    lentotal := Length(instg);
    maxlines := ndx2 - ndx1 + 1;
    
    { call
    Procedure FindSubstringLocs(strang: String; sep: Char;
    Var stringlocs, stringlens: byteray128; Var numstrings: Byte); }
    FindSubstringLocs(instg, sepchar, stglocs, stglens, numstgs);
    
    { find longest substring }
    biggest := 0;
    For k := 1 To numstgs Do If stglens[k] > biggest
    Then biggest := stglens[k];
    { exit if substring is too long to fit }
    If biggest > maxlen Then
    Begin
      toolong := True;
      Exit;
    End;
    
    { intialize stuff }
    LineLen := 0;
    k := 0;
    ndx := ndx1;
    If instg[1] = sepchar Then
    Begin
      dumstg := sepchar;
      LineLen := 1;
      charcount := 1;
    End
    Else
    Begin
      dumstg := '';
      LineLen := 0;
      charcount := 0;
    End;
    
    ndx := ndx1;
    i := 0;
    stgcnt := 0;
    { split into lines of lengths <= maxlen }
    Repeat
      Repeat
        i := i + 1;
        stgcnt := stgcnt + 1;
        LineLen := LineLen + stglens[i] + 1; { + 1 for separator }
        charcount := charcount + stglens[i] + 1;
      Until ((LineLen > maxlen + 1) Or (i = numstgs));
      
      If ((i <= numstgs) And (LineLen > maxlen + 1)) Then
        { back up one }
      Begin
        charcount := charcount - stglens[i] - 1;
        i := i - 1;
        stgcnt := stgcnt - 1;
      End;
      stgperline[ndx] := stgcnt;
      LineLen := 0;
      stgcnt := 0;
      ndx := ndx + 1;
    Until ((i = numstgs) Or (ndx = ndx2 + 1));
    
    lastline := ndx - 1;
    numlines := lastline - ndx1 + 1;
    { center lines approx }
    dy := (maxlines - numlines) Div 2;
    start := 0;
    
    For k := ndx1 To lastline Do
    Begin
      For i :=  1 To stgperline[k] Do
        dumstg :=  dumstg +
        Copy(instg, stglocs[start + i], stglens[start + i])
        + sepchar;
      { delete last separator of last line }
      If k = lastline Then
      Begin
        len := Length(dumstg);
        If dumstg[len] = sepchar Then Delete(dumstg, len, 1);
        charcount := charcount - 1;
      End;
      BigText[k + dy] := dumstg;
      start := start + stgperline[k];
      dumstg := '';
    End;
    If lentotal > charcount Then TooLong := True Else TooLong := False;
  End;

Function CharCount(countchar: Char; strang: String): Byte;
 { counts occurences of char "countchar" in string "strang" }
Var
  i, L, count: Byte;
  
Begin
  If Pos(countchar, strang) = 0 Then
  Begin
    CharCount := 0;
    Exit;
  End;
  L := Length(strang);
  count := 0;
  i := 0;
  Repeat
    Inc(i);
    If strang[i] = countchar Then count := count + 1;
  Until i = L;
  CharCount := count;
End;

Procedure DeleteSubstg(delstg: String; Var instg: String);
 { deletes all occurence of substring "delstg" in string "instg" }
  Var
    L: Byte;
  Begin
    L := Length(delstg);
    Repeat Delete(instg, Pos(delstg, instg), L) Until Pos(delstg, instg) = 0;
  End;

Procedure DeleteTail(startchar: Char; Var instg: String);
 { deletes the end of a string from the first occurrence
   of "startchar", including the starting char. }
 Var
   loc: Byte;
 Begin
   loc := Pos(startchar, instg);
   Delete(instg, loc, Length(instg) -loc + 1);
 End;

Procedure KillRepeats(delchar: Char; Var instg: String);
 { deletes all repeats of char "delchar" in string "instg" }
  Var
    substg: String[2];
  Begin
    substg := delchar + delchar;
    Repeat Delete(instg, Pos(substg, instg), 1) Until Pos(substg, instg) = 0;
  End;

Procedure EatChar(delchar: Char; Var instg: String);
 { deletes ALL occurences of char "delchar" in string "instg" }
  Begin
    Repeat Delete(instg, Pos(delchar, instg), 1) Until Pos(delchar, instg) = 0;
  End;

End.
